=pod
CSVを結合

=cut

use strict;
use warnings;

use Getopt::Long;
use IO::File;
use Data::Dumper;
use utf8;
use Encode;

use Util;
use CSVAsHash;

binmode STDOUT => ":encoding(sjis)";
binmode STDERR => ":encoding(sjis)";

my %opts=(in_header=>1);
&main_proc();

sub main_proc{
    my $res=GetOptions(\%opts,'in_file_pattern=s','out_file=s','in_header=i','in_tab');
    print decode("cp932",Dumper(\%opts));
    
    my @files = glob $opts{in_file_pattern};
    if (scalar(@files) == 0) {
        printf "%s:ファイルが見つかりません\n",$opts{file_pattern};
        exit;
    }
    

    my $in_sep_char;
    if (defined($opts{in_tab})) {
        $in_sep_char="\t";
    }else{
        $in_sep_char=",";
    }
    
    my $csv_in = CSVAsHash->new(csv_header=>$opts{in_header},csv_sep_char=>$in_sep_char);
    
    my @lines=();
    my $first_header;
    for (my $i=0;$i<scalar(@files);$i++) {
        my $aoh_in=$csv_in->csv2aoh($files[$i]);
        if ($i==0){
        	$first_header=$csv_in->col_names();
        }else{
        	if (Util::is_same_array($csv_in->col_names(),$first_header,sort=>1)!=1) {
        		die("$files[$i]:ヘッダが一致しません\n");
        	}
        }
        printf "%s:%d件入力\n",decode("cp932",$files[$i]),scalar(@$aoh_in);
        push @lines,@$aoh_in;
    }
    $csv_in->aoh2csv(\@lines,$opts{out_file});
    printf "%s:%d件出力しました\n",decode("cp932",$opts{out_file}),scalar(@lines);
}

