﻿package HashLikeArray;

use strict;
use warnings;

use utf8;
use Encode;
use Data::Dumper;
use Carp;

sub new {
    #enc:
    #   列データのエンコード名を指定
    my ($class,$enc) = @_;  
    my $self = {};
    if (defined($enc)) {
        $self->{encoding} = find_encoding($enc);
    }
    return bless $self, $class;
}

#アクセサ

#データを入出力する対象列の配列
sub cols {
    my $self = shift;

    if(@_) {
        $self->{cols} = $_[0];
    }

    return $self->{cols};
}


#ヘッダの配列から列名→列インデックスのハッシュテーブルを作成
#列名はエンコードが指定されていればデコードする（列名をUTF8で持つ）
sub get_col_tbl(){
    my ($self,$cols) = @_;
    
    my %hash = ();
    for (my $i=0;$i<scalar(@$cols);$i++){
        my $col_name="";
        if (defined($self->{encoding})){
            $col_name = $self->{encoding}->decode($cols->[$i]);
            #print $self->{encoding}->encode("$col_name\n");
        }else {
            $col_name = $cols->[$i];
        }
        $hash{$col_name} = $i;
    }
    $self->{col_tbl} = \%hash;
}

#列名で指定されたデータを返す
#列名はUTF8で指定
#データはエンコードが指定されていればデコードしUTF8で返す
sub get_col_data{
    my ($self,$col_name) = @_;
    my $data="";
    
    if (!defined($self->{cols})){
        croak("array not set\n");
    }

    if (!defined($self->{col_tbl})){
        croak("colname table not set\n");
    }

    if (!defined($self->{col_tbl}->{$col_name})) {
        croak("colname[$col_name]not found\n");
    }
    my $idx = $self->{col_tbl}->{$col_name};
    $data = $self->{cols}->[$idx];
    if (!defined($data)) {
        croak($self->{encoding}->encode("col index[$idx],col name[$col_name]not found\n"));
    }
    if (defined($self->{encoding})){
        $data = $self->{encoding}->decode($data);
    }
    return $data;
}

#列名で指定された列にデータをセット
#列名はUTF8で指定
#データはエンコードが指定されていればエンコードする
sub set_col_data{
    my ($self,$col_name,$value) = @_;
    
    if (!defined($self->{cols})){
        croak("array not set\n");
    }

    if (!defined($self->{col_tbl})){
        croak("col name table not set\n");
    }

    if (!defined($self->{col_tbl}->{$col_name})) {
        croak("col name[$col_name]not found\n");        
    }
    my $idx = $self->{col_tbl}->{$col_name};
    if (!defined($self->{cols}->[$idx])) {
        #croak("col index[$idx],col name[$col_name]not found\n"));
    }
    
    if (defined($self->{encoding})){
        $value = $self->{encoding}->encode($value);
    }

    $self->{cols}->[$idx]=$value;
}

=pod
hashで指定されたデータを内部配列に設定

hash
	列名=>セットするデータ
=cut
sub set_col_data_from_hash{
	my ($self,$hash)=@_;
	
	my @cols=();
	$self->cols(\@cols);
	while (my ($col,$value) = each(%$hash)) {
		$self->set_col_data($col,$value);
	}
}


#配列をhashに変換
#hashは参照専用
#keyは列名、UTF8
#データはエンコードが指定されていればデコードしUTF8で返す
sub to_hash{
    my ($self) = @_;
    my %hash=();
    

    if (!defined($self->{cols})){
        croak("array not set\n");
    }

    if (!defined($self->{col_tbl})){
        croak("col name table not set\n");
    }

    my $col_tbl = $self->{col_tbl};
    my @col_names = keys (%$col_tbl);  #列名の配列
    for (my $i=0;$i<scalar(@col_names);$i++) {
        my $col_name = $col_names[$i];
        my $col_idx = $self->{col_tbl}->{$col_name};
        my $val = $self->{cols}->[$col_idx];
        if (defined($self->{encoding})){
           $val = $self->{encoding}->decode($val);
        }
        $hash{$col_name} = $val;
    }
    
    return \%hash;
}
1;
