/****************************************************************************
 Copyright (c) 2010-2012 cocos2d-x.org
 Copyright (c) 2008-2010 Ricardo Quesada
 Copyright (c) 2011      Zynga Inc.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var TAG_TILE_MAP = 1;
var TAG_SPRITE_BATCH_NODE = 1;
var TAG_NODE = 2;
var TAG_ANIMATION1 = 1;
var TAG_SPRITE_LEFT = 2;
var TAG_SPRITE_RIGHT = 3;

var TAG_SPRITE1 = 0;
var TAG_SPRITE2 = 1;
var TAG_SPRITE3 = 2;
var TAG_SPRITE4 = 3;
var TAG_SPRITE5 = 4;
var TAG_SPRITE6 = 5;
var TAG_SPRITE7 = 6;
var TAG_SPRITE8 = 7;

var IDC_NEXT = 100;
var IDC_BACK = 101;
var IDC_RESTART = 102;

var spriteTestIdx = -1;

var spriteFrameCache = cc.SpriteFrameCache.getInstance();

//------------------------------------------------------------------
//
// SpriteTestDemo
//
//------------------------------------------------------------------
var SpriteTestDemo = BaseTestLayer.extend({
    _title:"",
    _subtitle:"",

    ctor:function () {
        if (arguments.length === 0) {
            this._super(cc.c4b(0, 0, 0, 255), cc.c4b(98, 99, 117, 255));
        } else {
            this._super.apply(this, arguments);
        }
    },

    onRestartCallback:function (sender) {
        var s = new SpriteTestScene();
        s.addChild(restartSpriteTest());
        director.replaceScene(s);
    },

    onNextCallback:function (sender) {
        var s = new SpriteTestScene();
        s.addChild(nextSpriteTest());
        director.replaceScene(s);
    },

    onBackCallback:function (sender) {
        var s = new SpriteTestScene();
        s.addChild(previousSpriteTest());
        director.replaceScene(s);
    },

    // automation
    numberOfPendingTests:function () {
        return ( (arrayOfSpriteTest.length - 1) - spriteTestIdx );
    },

    getTestNumber:function () {
        return spriteTestIdx;
    }
});

//------------------------------------------------------------------
//
// Sprite1
//
//------------------------------------------------------------------
var Sprite1 = SpriteTestDemo.extend({
    _title:"Non Batched Sprite ",
    _subtitle:"Tap screen to add more sprites",

    ctor:function () {
        this._super();

        this.addNewSpriteWithCoords(cc.p(winSize.width / 2, winSize.height / 2));

        if ('touches' in sys.capabilities)
            this.setTouchEnabled(true);
        else if ('mouse' in sys.capabilities)
            this.setMouseEnabled(true);
    },

    addNewSpriteWithCoords:function (p) {
        var idx = 0 | (Math.random() * 14);
        var x = (idx % 5) * 85;
        var y = (0 | (idx / 5)) * 121;
        var sprite = cc.Sprite.create(s_grossini_dance_atlas, cc.rect(x, y, 85, 121));
        this.addChild(sprite);
        sprite.setPosition(p.x, p.y);

        var action;
        var random = Math.random();
        if (random < 0.20) {
            action = cc.ScaleBy.create(3, 2);
        } else if (random < 0.40) {
            action = cc.RotateBy.create(3, 360);
        } else if (random < 0.60) {
            action = cc.Blink.create(1, 3);
        } else if (random < 0.8) {
            action = cc.TintBy.create(2, 0, -255, -255);
        } else {
            action = cc.FadeOut.create(2);
        }

        var action_back = action.reverse();
        var seq = cc.Sequence.create(action, action_back);

        sprite.runAction(cc.RepeatForever.create(seq));
        this.testSprite = sprite;
    },
    onTouchesEnded:function (touches, event) {
        for (var it = 0; it < touches.length; it++) {
            var touch = touches[it];

            if (!touch)
                break;

            var location = touch.getLocation();
            //location = director.convertToGL(location);
            this.addNewSpriteWithCoords(location);
        }
    },

    onMouseDown:function (event) {
        var location = event.getLocation();
        this.addNewSpriteWithCoords(location);
        return true;
    },
    //
    // Automation
    //
    testDuration:1,
    pixel:{"0":51, "1":0, "2":51, "3":255},
    testSprite:null,
    setupAutomation:function () {
        var fun = function () {
            var sprite = cc.Sprite.create(s_grossini_dance_atlas, cc.rect(0, 0, 85, 121));
            this.addChild(sprite, 999);
            sprite.setPosition(winSize.width / 2, winSize.height / 2);
        }
        this.scheduleOnce(fun, 0.5);
    },
    getExpectedResult:function () {
        var ret = {"useBatch":false, "pixel":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 2, winSize.height / 2, 5, 5);
        var ret = {"useBatch":this.testSprite.getBatchNode() != null, "pixel":this.containsPixel(ret1, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteBatchNode1
//
//------------------------------------------------------------------
var SpriteBatchNode1 = SpriteTestDemo.extend({

    _title:"Batched Sprite ",
    _subtitle:"Tap screen to add more sprites",

    ctor:function () {
        this._super();
        if ('touches' in sys.capabilities)
            this.setTouchEnabled(true);
        else if ('mouse' in sys.capabilities)
            this.setMouseEnabled(true);

        var batchNode = cc.SpriteBatchNode.create(s_grossini_dance_atlas, 50);
        this.addChild(batchNode, 0, TAG_SPRITE_BATCH_NODE);
        this.addNewSpriteWithCoords(cc.p(winSize.width / 2, winSize.height / 2));
    },

    addNewSpriteWithCoords:function (p) {
        var batchNode = this.getChildByTag(TAG_SPRITE_BATCH_NODE);

        var idx = 0 | (Math.random() * 14);
        var x = (idx % 5) * 85;
        var y = (0 | (idx / 5)) * 121;

        var sprite = cc.Sprite.createWithTexture(batchNode.getTexture(), cc.rect(x, y, 85, 121));
        batchNode.addChild(sprite);

        sprite.setPosition(p.x, p.y);

        var action;
        var random = Math.random();

        if (random < 0.20)
            action = cc.ScaleBy.create(3, 2);
        else if (random < 0.40)
            action = cc.RotateBy.create(3, 360);
        else if (random < 0.60)
            action = cc.Blink.create(1, 3);
        else if (random < 0.8)
            action = cc.TintBy.create(2, 0, -255, -255);
        else
            action = cc.FadeOut.create(2);

        var action_back = action.reverse();
        var seq = cc.Sequence.create(action, action_back);

        sprite.runAction(cc.RepeatForever.create(seq));
        this.testSprite = sprite;
    },
    onTouchesEnded:function (touches, event) {
        for (var it = 0; it < touches.length; it++) {
            var touch = touches[it];

            if (!touch)
                break;

            var location = touch.getLocation();
            //location = director.convertToGL(location);
            this.addNewSpriteWithCoords(location);
        }
    },
    onMouseDown:function (event) {
        var location = event.getLocation();
        this.addNewSpriteWithCoords(location);
        return true;
    },
    //
    // Automation
    //
    testDuration:1,
    pixel:{"0":51, "1":0, "2":51, "3":255},
    testSprite:null,
    setupAutomation:function () {
        var fun = function () {
            var sprite = cc.Sprite.create(s_grossini_dance_atlas, cc.rect(0, 0, 85, 121));
            this.addChild(sprite, 999);
            sprite.setPosition(winSize.width / 2, winSize.height / 2);
        }
        this.scheduleOnce(fun, 0.5);
    },
    getExpectedResult:function () {
        var ret = {"useBatch":true, "pixel":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 2, winSize.height / 2, 5, 5);
        var ret = {"useBatch":this.testSprite.getBatchNode() != null, "pixel":this.containsPixel(ret1, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteColorOpacity
//
//------------------------------------------------------------------
var SpriteColorOpacity = SpriteTestDemo.extend({

    _title:"Sprite: Color & Opacity",

    ctor:function () {
        this._super();
        var sprite1 = cc.Sprite.create(s_grossini_dance_atlas, cc.rect(0, 121, 85, 121));
        var sprite2 = cc.Sprite.create(s_grossini_dance_atlas, cc.rect(85, 121, 85, 121));
        var sprite3 = cc.Sprite.create(s_grossini_dance_atlas, cc.rect(85 * 2, 121, 85, 121));
        var sprite4 = cc.Sprite.create(s_grossini_dance_atlas, cc.rect(85 * 3, 121, 85, 121));

        var sprite5 = cc.Sprite.create(s_grossini_dance_atlas, cc.rect(0, 121, 85, 121));
        var sprite6 = cc.Sprite.create(s_grossini_dance_atlas, cc.rect(85, 121, 85, 121));
        var sprite7 = cc.Sprite.create(s_grossini_dance_atlas, cc.rect(85 * 2, 121, 85, 121));
        var sprite8 = cc.Sprite.create(s_grossini_dance_atlas, cc.rect(85 * 3, 121, 85, 121));

        sprite1.setPosition((winSize.width / 5), (winSize.height / 3));
        sprite2.setPosition((winSize.width / 5) * 2, (winSize.height / 3));
        sprite3.setPosition((winSize.width / 5) * 3, (winSize.height / 3));
        sprite4.setPosition((winSize.width / 5) * 4, (winSize.height / 3));
        sprite5.setPosition((winSize.width / 5), (winSize.height / 3) * 2);
        sprite6.setPosition((winSize.width / 5) * 2, (winSize.height / 3) * 2);
        sprite7.setPosition((winSize.width / 5) * 3, (winSize.height / 3) * 2);
        sprite8.setPosition((winSize.width / 5) * 4, (winSize.height / 3) * 2);

        var delay = cc.DelayTime.create(0.25);
        var action = cc.FadeIn.create(2);
        var action_back = action.reverse();
        var fade = cc.RepeatForever.create(cc.Sequence.create(action, delay.clone(), action_back));

        var tintRed = cc.TintBy.create(2, 0, -255, -255);
        var tintRedBack = tintRed.reverse();
        var red = cc.RepeatForever.create(cc.Sequence.create(tintRed, delay.clone(), tintRedBack));

        var tintGreen = cc.TintBy.create(2, -255, 0, -255);
        var tintGreenBack = tintGreen.reverse();
        var green = cc.RepeatForever.create(cc.Sequence.create(tintGreen, delay.clone(), tintGreenBack));

        var tintBlue = cc.TintBy.create(2, -255, -255, 0);
        var tintBlueBack = tintBlue.reverse();
        var blue = cc.RepeatForever.create(cc.Sequence.create(tintBlue, delay.clone(), tintBlueBack));

        sprite5.runAction(red);
        sprite6.runAction(green);
        sprite7.runAction(blue);
        sprite8.runAction(fade);

        // late add: test dirtyColor and dirtyPosition
        this.addChild(sprite1, 0, TAG_SPRITE1);
        this.addChild(sprite2, 0, TAG_SPRITE2);
        this.addChild(sprite3, 0, TAG_SPRITE3);
        this.addChild(sprite4, 0, TAG_SPRITE4);
        this.addChild(sprite5, 0, TAG_SPRITE5);
        this.addChild(sprite6, 0, TAG_SPRITE6);
        this.addChild(sprite7, 0, TAG_SPRITE7);
        this.addChild(sprite8, 0, TAG_SPRITE8);

        this.schedule(this.removeAndAddSprite, 2);
    },
    // this function test if remove and add works as expected:
//   color array and vertex array should be reindexed
    removeAndAddSprite:function (dt) {
        var sprite = this.getChildByTag(TAG_SPRITE5);

        this.removeChild(sprite, false);
        this.addChild(sprite, 0, TAG_SPRITE5);
    },
    //
    // Automation
    //
    testDuration:2.1,
    pixel1:{"0":255, "1":0, "2":0, "3":255},
    pixel2:{"0":0, "1":204, "2":0, "3":255},
    pixel3:{"0":0, "1":0, "2":153, "3":255},
    pixel4:{"0":255, "1":204, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel3":"yes", "pixel4":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels((winSize.width / 5) * 1, (winSize.height / 3) * 2 + 40, 5, 5);
        var ret2 = this.readPixels((winSize.width / 5) * 2, (winSize.height / 3) * 2 + 40, 5, 5);
        var ret3 = this.readPixels((winSize.width / 5) * 3, (winSize.height / 3) * 2 + 40, 5, 5);
        var ret4 = this.readPixels((winSize.width / 5) * 4, (winSize.height / 3) * 2 + 40, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel1) ? "yes" : "no",
            "pixel2":this.containsPixel(ret2, this.pixel2) ? "yes" : "no",
            "pixel3":this.containsPixel(ret3, this.pixel3) ? "yes" : "no",
            "pixel4":this.containsPixel(ret4, this.pixel4) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteBatchNodeColorOpacity
//
//------------------------------------------------------------------
var SpriteBatchNodeColorOpacity = SpriteTestDemo.extend({

    _title:"SpriteBatchNode: Color & Opacity",

    ctor:function () {
        this._super();
        // small capacity. Testing resizing.
        // Don't use capacity=1 in your real game. It is expensive to resize the capacity
        var batch = cc.SpriteBatchNode.create(s_grossini_dance_atlas, 1);
        this.addChild(batch, 0, TAG_SPRITE_BATCH_NODE);

        var sprite1 = cc.Sprite.createWithTexture(batch.getTexture(), cc.rect(0, 121, 85, 121));
        var sprite2 = cc.Sprite.createWithTexture(batch.getTexture(), cc.rect(85, 121, 85, 121));
        var sprite3 = cc.Sprite.createWithTexture(batch.getTexture(), cc.rect(85 * 2, 121, 85, 121));
        var sprite4 = cc.Sprite.createWithTexture(batch.getTexture(), cc.rect(85 * 3, 121, 85, 121));

        var sprite5 = cc.Sprite.createWithTexture(batch.getTexture(), cc.rect(0, 121, 85, 121));
        var sprite6 = cc.Sprite.createWithTexture(batch.getTexture(), cc.rect(85, 121, 85, 121));
        var sprite7 = cc.Sprite.createWithTexture(batch.getTexture(), cc.rect(85 * 2, 121, 85, 121));
        var sprite8 = cc.Sprite.createWithTexture(batch.getTexture(), cc.rect(85 * 3, 121, 85, 121));


        sprite1.setPosition((winSize.width / 5) * 1, (winSize.height / 3) * 1);
        sprite2.setPosition((winSize.width / 5) * 2, (winSize.height / 3) * 1);
        sprite3.setPosition((winSize.width / 5) * 3, (winSize.height / 3) * 1);
        sprite4.setPosition((winSize.width / 5) * 4, (winSize.height / 3) * 1);
        sprite5.setPosition((winSize.width / 5) * 1, (winSize.height / 3) * 2);
        sprite6.setPosition((winSize.width / 5) * 2, (winSize.height / 3) * 2);
        sprite7.setPosition((winSize.width / 5) * 3, (winSize.height / 3) * 2);
        sprite8.setPosition((winSize.width / 5) * 4, (winSize.height / 3) * 2);

        var delay = cc.DelayTime.create(0.25);
        var action = cc.FadeIn.create(2);
        var action_back = action.reverse();
        var fade = cc.RepeatForever.create(cc.Sequence.create(action, delay.clone(), action_back));

        var tintRed = cc.TintBy.create(2, 0, -255, -255);
        var red = cc.RepeatForever.create(cc.Sequence.create(tintRed, delay.clone(), tintRed.reverse()));

        var tintGreen = cc.TintBy.create(2, -255, 0, -255);
        var tintGreenBack = tintGreen.reverse();
        var green = cc.RepeatForever.create(cc.Sequence.create(tintGreen, delay.clone(), tintGreenBack));

        var tintBlue = cc.TintBy.create(2, -255, -255, 0);
        var tintBlueBack = tintBlue.reverse();
        var blue = cc.RepeatForever.create(cc.Sequence.create(tintBlue, delay.clone(), tintBlueBack));

        sprite5.runAction(red);
        sprite6.runAction(green);
        sprite7.runAction(blue);
        sprite8.runAction(fade);

        // late add: test dirtyColor and dirtyPosition
        batch.addChild(sprite1, 0, TAG_SPRITE1);
        batch.addChild(sprite2, 0, TAG_SPRITE2);
        batch.addChild(sprite3, 0, TAG_SPRITE3);
        batch.addChild(sprite4, 0, TAG_SPRITE4);
        batch.addChild(sprite5, 0, TAG_SPRITE5);
        batch.addChild(sprite6, 0, TAG_SPRITE6);
        batch.addChild(sprite7, 0, TAG_SPRITE7);
        batch.addChild(sprite8, 0, TAG_SPRITE8);

        this.schedule(this.removeAndAddSprite, 2);
    },
    // this function test if remove and add works as expected:
    //   color array and vertex array should be reindexed
    removeAndAddSprite:function (dt) {
        var batch = this.getChildByTag(TAG_SPRITE_BATCH_NODE);
        var sprite = batch.getChildByTag(TAG_SPRITE5);

        batch.removeChild(sprite, false);
        batch.addChild(sprite, 0, TAG_SPRITE5);
    },
    //
    // Automation
    //
    testDuration:2.1,
    pixel1:{"0":255, "1":0, "2":0, "3":255},
    pixel2:{"0":0, "1":204, "2":0, "3":255},
    pixel3:{"0":0, "1":0, "2":153, "3":255},
    pixel4:{"0":255, "1":204, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel3":"yes", "pixel4":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels((winSize.width / 5) * 1, (winSize.height / 3) * 2 + 40, 5, 5);
        var ret2 = this.readPixels((winSize.width / 5) * 2, (winSize.height / 3) * 2 + 40, 5, 5);
        var ret3 = this.readPixels((winSize.width / 5) * 3, (winSize.height / 3) * 2 + 40, 5, 5);
        var ret4 = this.readPixels((winSize.width / 5) * 4, (winSize.height / 3) * 2 + 40, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel1) ? "yes" : "no",
            "pixel2":this.containsPixel(ret2, this.pixel2) ? "yes" : "no",
            "pixel3":this.containsPixel(ret3, this.pixel3) ? "yes" : "no",
            "pixel4":this.containsPixel(ret4, this.pixel4) ? "yes" : "no"};
        return JSON.stringify(ret);
    }

});

//------------------------------------------------------------------
//
// SpriteZOrder
//
//------------------------------------------------------------------
var SpriteZOrder = SpriteTestDemo.extend({
    _dir:0,
    _title:"Sprite: Z order",
    ctor:function () {
        this._super();
        this._dir = 1;

        var sprite;
        var step = winSize.width / 11;
        for (var i = 0; i < 5; i++) {
            sprite = cc.Sprite.create(s_grossini_dance_atlas, cc.rect(85 * 0, 121 * 1, 85, 121));
            sprite.setPosition((i + 1) * step, winSize.height / 2);
            this.addChild(sprite, i);
        }

        for (i = 5; i < 10; i++) {
            sprite = cc.Sprite.create(s_grossini_dance_atlas, cc.rect(85 * 1, 121 * 0, 85, 121));
            sprite.setPosition((i + 1) * step, winSize.height / 2);
            this.addChild(sprite, 14 - i);
        }

        sprite = cc.Sprite.create(s_grossini_dance_atlas, cc.rect(85 * 3, 121 * 0, 85, 121));
        this.addChild(sprite, -1, TAG_SPRITE1);
        sprite.setPosition(winSize.width / 2, winSize.height / 2 - 20);
        sprite.setScaleX(10);
        sprite.setColor(cc.red());

        this.schedule(this.reorderSprite, 1);
    },
    reorderSprite:function (dt) {
        var sprite = this.getChildByTag(TAG_SPRITE1);
        var z = sprite.getZOrder();
        if (z < -1)
            this._dir = 1;
        if (z > 10)
            this._dir = -1;
        z += this._dir * 3;
        this.reorderChild(sprite, z);
    },
    //
    // Automation
    //
    testDuration:4.2,
    pixel:{"0":255, "1":0, "2":0, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var step = winSize.width / 11;
        var ret1 = this.readPixels((6 + 1) * step, winSize.height / 2 + 10, 5, 5);
        var ret = {"pixel":this.containsPixel(ret1, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteBatchNodeZOrder
//
//------------------------------------------------------------------
var SpriteBatchNodeZOrder = SpriteTestDemo.extend({
    _dir:0,
    _title:"SpriteBatch: Z order",
    ctor:function () {
        this._super();
        this._dir = 1;

        // small capacity. Testing resizing.
        // Don't use capacity=1 in your real game. It is expensive to resize the capacity
        var batch = cc.SpriteBatchNode.create(s_grossini_dance_atlas, 1);
        this.addChild(batch, 0, TAG_SPRITE_BATCH_NODE);

        var sprite;
        var step = winSize.width / 11;
        for (var i = 0; i < 5; i++) {
            sprite = cc.Sprite.createWithTexture(batch.getTexture(), cc.rect(85 * 0, 121 * 1, 85, 121));
            sprite.setPosition((i + 1) * step, winSize.height / 2);
            batch.addChild(sprite, i);
        }

        for (i = 5; i < 10; i++) {
            sprite = cc.Sprite.createWithTexture(batch.getTexture(), cc.rect(85 * 1, 121 * 0, 85, 121));
            sprite.setPosition((i + 1) * step, winSize.height / 2);
            batch.addChild(sprite, 14 - i);
        }

        sprite = cc.Sprite.createWithTexture(batch.getTexture(), cc.rect(85 * 3, 121 * 0, 85, 121));
        batch.addChild(sprite, -1, TAG_SPRITE1);
        sprite.setPosition(winSize.width / 2, winSize.height / 2 - 20);
        sprite.setScaleX(10);
        sprite.setColor(cc.red());
        this.schedule(this.reorderSprite, 1);
    },
    reorderSprite:function (dt) {
        var batch = this.getChildByTag(TAG_SPRITE_BATCH_NODE);
        var sprite = batch.getChildByTag(TAG_SPRITE1);
        var z = sprite.getZOrder();
        if (z < -1)
            this._dir = 1;
        if (z > 10)
            this._dir = -1;
        z += this._dir * 3;
        batch.reorderChild(sprite, z);
    },
    //
    // Automation
    //
    testDuration:4.2,
    pixel:{"0":255, "1":0, "2":0, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var step = winSize.width / 11;
        var ret1 = this.readPixels((6 + 1) * step, winSize.height / 2 + 10, 5, 5);
        var ret = {"pixel":this.containsPixel(ret1, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteBatchNodeReorder
//
//------------------------------------------------------------------
var SpriteBatchNodeReorder = SpriteTestDemo.extend({

    _title:"SpriteBatchNode: reorder #1",
    _subtitle:"Should not crash",

    ctor:function () {
        this._super();
        var a = [];
        var asmtest = cc.SpriteBatchNode.create(s_ghosts);

        for (var i = 0; i < 10; i++) {
            var s1 = cc.Sprite.createWithTexture(asmtest.getTexture(), cc.rect(0, 0, 50, 50));
            a.push(s1);
            asmtest.addChild(s1, 10);
        }

        for (i = 0; i < 10; i++) {
            if (i != 5)
                asmtest.reorderChild(a[i], 9);
        }

        var prev = -1, currentIndex;
        var children = asmtest.getChildren();
        var child;
        for (i = 0; i < children.length; i++) {
            child = children[i];
            if (!child)
                break;

            //TODO need fixed
            currentIndex = child.getAtlasIndex();
            //cc.Assert(prev == currentIndex - 1, "Child order failed");
            ////----UXLog("children %x - atlasIndex:%d", child, currentIndex);
            prev = currentIndex;
        }

        prev = -1;
        var sChildren = asmtest.getDescendants();
        for (i = 0; i < sChildren.length; i++) {
            child = sChildren[i];
            if (!child)
                break;

            currentIndex = child.getAtlasIndex();
            //cc.Assert(prev == currentIndex - 1, "Child order failed");
            ////----UXLog("descendant %x - atlasIndex:%d", child, currentIndex);
            prev = currentIndex;
        }
    },
    //
    // Automation
    //
    testDuration:1.2,
    getExpectedResult:function () {
        return JSON.stringify(true);
    },
    getCurrentResult:function () {
        return JSON.stringify(true);
    }
});

//------------------------------------------------------------------
//
// SpriteBatchNodeReorderIssue744
//
//------------------------------------------------------------------
var SpriteBatchNodeReorderIssue744 = SpriteTestDemo.extend({
    _title:"SpriteBatchNode: reorder issue #744",
    _subtitle:"Should not crash",

    ctor:function () {
        this._super();

        // Testing issue #744
        // http://code.google.com/p/cocos2d-iphone/issues/detail?id=744
        var batch = cc.SpriteBatchNode.create(s_grossini_dance_atlas, 15);
        this.addChild(batch, 0, TAG_SPRITE_BATCH_NODE);

        var sprite = cc.Sprite.createWithTexture(batch.getTexture(), cc.rect(0, 0, 85, 121));
        sprite.setPosition(winSize.width / 2, winSize.height / 2);
        batch.addChild(sprite, 3);
        batch.reorderChild(sprite, 1);
    },
    //
    // Automation
    //
    testDuration:1.2,
    pixel:{"0":51, "1":0, "2":51, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 2, winSize.height / 2, 5, 5);
        var ret = {"pixel":this.containsPixel(ret1, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteBatchNodeReorderIssue766
//
//------------------------------------------------------------------
var SpriteBatchNodeReorderIssue766 = SpriteTestDemo.extend({
    _batchNode:null,
    _sprite1:null,
    _sprite2:null,
    _sprite3:null,

    _title:"SpriteBatchNode: reorder issue #766",
    _subtitle:"In 2 seconds 1 sprite will be reordered",

    ctor:function () {
        this._super();
        this._batchNode = cc.SpriteBatchNode.create(s_piece, 15);
        this.addChild(this._batchNode, 1, 0);

        this._sprite1 = this.makeSpriteZ(2);
        this._sprite1.setPosition(200, 160);

        this._sprite2 = this.makeSpriteZ(3);
        this._sprite2.setPosition(264, 160);

        this._sprite3 = this.makeSpriteZ(4);
        this._sprite3.setPosition(328, 160);

        this.schedule(this.reorderSprite, 2);
    },
    reorderSprite:function (dt) {
        this.unschedule(this.reorderSprite);

        this._batchNode.reorderChild(this._sprite1, 4);
    },
    makeSpriteZ:function (aZ) {
        var sprite = cc.Sprite.createWithTexture(this._batchNode.getTexture(), cc.rect(128, 0, 64, 64));
        this._batchNode.addChild(sprite, aZ + 1, 0);

        //children
        var spriteShadow = cc.Sprite.createWithTexture(this._batchNode.getTexture(), cc.rect(0, 0, 64, 64));
        spriteShadow.setOpacity(128);
        sprite.addChild(spriteShadow, aZ, 3);

        var spriteTop = cc.Sprite.createWithTexture(this._batchNode.getTexture(), cc.rect(64, 0, 64, 64));
        sprite.addChild(spriteTop, aZ + 2, 3);

        return sprite;
    },
    //
    // Automation
    //
    testDuration:2.2,
    pixel1:{"0":0, "1":0, "2":0, "3":255},
    pixel2:{"0":255, "1":255, "2":255, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(213, 159, 5, 5);
        var ret2 = this.readPixels(211, 108, 5, 5);
        var ret = {"pixel1":!this.containsPixel(ret1, this.pixel1) ? "yes" : "no",
            "pixel2":this.containsPixel(ret2, this.pixel2) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteBatchNodeReorderIssue767
//
//------------------------------------------------------------------
var SpriteBatchNodeReorderIssue767 = SpriteTestDemo.extend({
    _title:"SpriteBatchNode: reorder issue #767",
    _subtitle:"Should not crash",

    ctor:function () {
        this._super();

        spriteFrameCache.addSpriteFrames(s_ghostsPlist, s_ghosts);
        //
        // SpriteBatchNode: 3 levels of children
        //
        var aParent = cc.SpriteBatchNode.create(s_ghosts);
        this.addChild(aParent, 0, TAG_SPRITE1);

        // parent
        var l1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("father.gif"));
        l1.setPosition(winSize.width / 2, winSize.height / 2);
        aParent.addChild(l1, 0, TAG_SPRITE2);
        var l1Size = l1.getContentSize();

        // child left
        var l2a = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("sister1.gif"));
        l2a.setPosition(-25 + l1Size.width / 2, 0 + l1Size.height / 2);
        l1.addChild(l2a, -1, TAG_SPRITE_LEFT);
        var l2aSize = l2a.getContentSize();


        // child right
        var l2b = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("sister2.gif"));
        l2b.setPosition(25 + l1Size.width / 2, 0 + l1Size.height / 2);
        l1.addChild(l2b, 1, TAG_SPRITE_RIGHT);
        var l2bSize = l2a.getContentSize();


        // child left bottom
        var l3a1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("child1.gif"));
        l3a1.setScale(0.65);
        l3a1.setPosition(0 + l2aSize.width / 2, -50 + l2aSize.height / 2);
        l2a.addChild(l3a1, -1);

        // child left top
        var l3a2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("child1.gif"));
        l3a2.setScale(0.65);
        l3a2.setPosition(0 + l2aSize.width / 2, +50 + l2aSize.height / 2);
        l2a.addChild(l3a2, 1);

        // child right bottom
        var l3b1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("child1.gif"));
        l3b1.setScale(0.65);
        l3b1.setPosition(0 + l2bSize.width / 2, -50 + l2bSize.height / 2);
        l2b.addChild(l3b1, -1);

        // child right top
        var l3b2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("child1.gif"));
        l3b2.setScale(0.65);
        l3b2.setPosition(0 + l2bSize.width / 2, +50 + l2bSize.height / 2);
        l2b.addChild(l3b2, 1);

        this.schedule(this.reorderSprites, 1);
    },
    reorderSprites:function (dt) {
        var spritebatch = this.getChildByTag(TAG_SPRITE1);
        var father = spritebatch.getChildByTag(TAG_SPRITE2);
        var left = father.getChildByTag(TAG_SPRITE_LEFT);
        var right = father.getChildByTag(TAG_SPRITE_RIGHT);

        var newZLeft = 1;

        if (left.getZOrder() === 1)
            newZLeft = -1;

        father.reorderChild(left, newZLeft);
        father.reorderChild(right, -newZLeft);
    },
    //
    // Automation
    //
    testDuration:1.5,
    pixel1:{"0":255, "1":204, "2":153, "3":255},
    pixel2:{"0":255, "1":255, "2":255, "3":255},
    curPixel1:null,
    curPixel2:null,
    setupAutomation:function () {
        var fun = function(){
            this.curPixel1 = this.readPixels(winSize.width / 2 + 11, winSize.height / 2 - 11, 2, 2);
        }
        this.scheduleOnce(fun, 0.5);
    },
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        this.curPixel2 = this.readPixels(winSize.width / 2 + 11, winSize.height / 2 - 11, 2, 2);
        var ret = {"pixel1":this.containsPixel(this.curPixel1, this.pixel1) ? "yes" : "no",
            "pixel2":this.containsPixel(this.curPixel2, this.pixel2) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteZVertex
//
//------------------------------------------------------------------
var SpriteZVertex = SpriteTestDemo.extend({
    _dir:0,
    _time:0,
    _title:"Sprite: openGL Z vertex",
    _subtitle:"Scene should rotate",

    ctor:function () {
        this._super(cc.c4b(255, 0, 0, 80), cc.c4b(255, 98, 117, 20));


        if ("opengl" in sys.capabilities) {

            gl.enable(gl.DEPTH_TEST);
            //
            // This test tests z-order
            // If you are going to use it is better to use a 3D projection
            //
            // WARNING:
            // The developer is resposible for ordering it's sprites according to it's Z if the sprite has
            // transparent parts.
            //

            //
            // Configure shader to mimic glAlphaTest
            //
            var alphaTestShader = cc.ShaderCache.getInstance().getProgram("ShaderPositionTextureColorAlphaTest");
            var glprogram = alphaTestShader.getProgram();
            var alphaValueLocation = gl.getUniformLocation(glprogram, cc.UNIFORM_ALPHA_TEST_VALUE_S);

            // set alpha test value
            // NOTE: alpha test shader is hard-coded to use the equivalent of a glAlphaFunc(GL_GREATER) comparison
            gl.useProgram(glprogram);
            alphaTestShader.setUniformLocationF32(alphaValueLocation, 0.5);

            this._dir = 1;
            this._time = 0;

            var step = winSize.width / 12;

            var node = cc.Node.create();
            // camera uses the center of the image as the pivoting point
            node.setContentSize(winSize.width, winSize.height);
            node.setAnchorPoint(0.5, 0.5);
            node.setPosition(winSize.width / 2, winSize.height / 2);

            this.addChild(node, 0);
            var sprite;
            for (var i = 0; i < 5; i++) {
                sprite = cc.Sprite.create(s_grossini_dance_atlas, cc.rect(0, 121, 85, 121));
                sprite.setPosition((i + 1) * step, winSize.height / 2);
                sprite.setVertexZ(10 + i * 40);
                sprite.setShaderProgram(alphaTestShader);
                node.addChild(sprite, 0);
            }

            for (i = 5; i < 11; i++) {
                sprite = cc.Sprite.create(s_grossini_dance_atlas, cc.rect(85, 0, 85, 121));
                sprite.setPosition((i + 1) * step, winSize.height / 2);
                sprite.setVertexZ(10 + (10 - i) * 40);
                sprite.setShaderProgram(alphaTestShader);
                node.addChild(sprite, 0);
            }

            this.runAction(cc.OrbitCamera.create(10, 1, 0, 0, 360, 0, 0));
        } else {
            var label = cc.LabelTTF.create("Not supported on HTML5-canvas", "Times New Roman", 30);
            this.addChild(label);
            label.setPosition(winSize.width / 2, winSize.height / 2);
        }
    },
    onEnter:function () {
        this._super();
        if ("opengl" in sys.capabilities) {
            director.setProjection(cc.DIRECTOR_PROJECTION_3D);
            gl.enable(gl.DEPTH_TEST);

            // Avoid Z-fighting with menu and title
            var menu = this.getChildByTag(BASE_TEST_MENU_TAG);
            menu.setVertexZ(1);
            var title = this.getChildByTag(BASE_TEST_TITLE_TAG);
            title.setVertexZ(1);
            var subtitle = this.getChildByTag(BASE_TEST_SUBTITLE_TAG);
            subtitle.setVertexZ(1);
        }
    },
    onExit:function () {
        if ("opengl" in sys.capabilities) {
            director.setProjection(cc.DIRECTOR_PROJECTION_2D);
            gl.disable(gl.DEPTH_TEST);
        }
        this._super();
    },
    // Automation
    testDuration:2.2,
    pixel1:{"0":51, "1":0, "2":51, "3":255},
    pixel2:{"0":0, "1":0, "2":0, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel3":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 2 - 171, winSize.height / 2, 5, 5);
        var ret2 = this.readPixels(winSize.width / 2 - 189, winSize.height / 2, 5, 5);
        var ret3 = this.readPixels(winSize.width / 2 - 146, winSize.height / 2, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel1, false) ? "yes" : "no",
            "pixel2":this.containsPixel(ret2, this.pixel2, false) ? "yes" : "no",
            "pixel3":this.containsPixel(ret3, this.pixel2, false) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteBatchNodeZVertex
//
//------------------------------------------------------------------
var SpriteBatchNodeZVertex = SpriteTestDemo.extend({
    _dir:0,
    _time:0,
    _title:"SpriteBatchNode: openGL Z vertex",
    _subtitle:"Scene should rotate",

    ctor:function () {
        this._super(cc.c4b(255, 0, 0, 80), cc.c4b(255, 98, 117, 20));

        if ("opengl" in sys.capabilities) {

            //
            // This test tests z-order
            // If you are going to use it is better to use a 3D projection
            //
            // WARNING:
            // The developer is resposible for ordering it's sprites according to it's Z if the sprite has
            // transparent parts.
            //

            //
            // Configure shader to mimic glAlphaTest
            //
            var alphaTestShader = cc.ShaderCache.getInstance().getProgram("ShaderPositionTextureColorAlphaTest");
            var glprogram = alphaTestShader.getProgram();
            var alphaValueLocation = gl.getUniformLocation(glprogram, cc.UNIFORM_ALPHA_TEST_VALUE_S);

            // set alpha test value
            // NOTE: alpha test shader is hard-coded to use the equivalent of a glAlphaFunc(GL_GREATER) comparison
            gl.useProgram(glprogram);
            alphaTestShader.setUniformLocationF32(alphaValueLocation, 0.5);

            var step = winSize.width / 12;

            // small capacity. Testing resizing.
            // Don't use capacity=1 in your real game. It is expensive to resize the capacity
            var batch = cc.SpriteBatchNode.create(s_grossini_dance_atlas, 1);
            // camera uses the center of the image as the pivoting point
            batch.setContentSize(winSize.width, winSize.height);
            batch.setAnchorPoint(0.5, 0.5);
            batch.setPosition(winSize.width / 2, winSize.height / 2);
            batch.setShaderProgram(alphaTestShader);

            this.addChild(batch, 0, TAG_SPRITE_BATCH_NODE);
            var sprite;

            for (var i = 0; i < 5; i++) {
                sprite = cc.Sprite.createWithTexture(batch.getTexture(), cc.rect(0, 121, 85, 121));
                sprite.setPosition((i + 1) * step, winSize.height / 2);
                sprite.setVertexZ(10 + i * 40);
                batch.addChild(sprite, 0);

            }

            for (i = 5; i < 11; i++) {
                sprite = cc.Sprite.createWithTexture(batch.getTexture(), cc.rect(85, 0, 85, 121));
                sprite.setPosition((i + 1) * step, winSize.height / 2);
                sprite.setVertexZ(10 + (10 - i) * 40);
                batch.addChild(sprite, 0);
            }

            this.runAction(cc.OrbitCamera.create(10, 1, 0, 0, 360, 0, 0));
        } else {
            var label = cc.LabelTTF.create("Not supported on HTML5-canvas", "Times New Roman", 30);
            this.addChild(label);
            label.setPosition(winSize.width / 2, winSize.height / 2);
        }
    },
    onEnter:function () {
        this._super();

        if ("opengl" in sys.capabilities) {
            director.setProjection(cc.DIRECTOR_PROJECTION_3D);
            gl.enable(gl.DEPTH_TEST);

            // Avoid Z-fighting with menu and title
            var menu = this.getChildByTag(BASE_TEST_MENU_TAG);
            menu.setVertexZ(1);
            var title = this.getChildByTag(BASE_TEST_TITLE_TAG);
            title.setVertexZ(1);
            var subtitle = this.getChildByTag(BASE_TEST_SUBTITLE_TAG);
            subtitle.setVertexZ(1);

        }
    },
    onExit:function () {
        if ("opengl" in sys.capabilities) {
            director.setProjection(cc.DIRECTOR_PROJECTION_2D);
            gl.disable(gl.DEPTH_TEST);
        }
        this._super();
    },
    // Automation
    testDuration:2.2,
    pixel1:{"0":51, "1":0, "2":51, "3":255},
    pixel2:{"0":0, "1":0, "2":0, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel3":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 2 - 171, winSize.height / 2, 5, 5);
        var ret2 = this.readPixels(winSize.width / 2 - 189, winSize.height / 2, 5, 5);
        var ret3 = this.readPixels(winSize.width / 2 - 146, winSize.height / 2, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel1, false) ? "yes" : "no",
            "pixel2":this.containsPixel(ret2, this.pixel2, false) ? "yes" : "no",
            "pixel3":this.containsPixel(ret3, this.pixel2, false) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteAnchorPoint
//
//------------------------------------------------------------------
var SpriteAnchorPoint = SpriteTestDemo.extend({
    _title:"Sprite: anchor point",

    ctor:function () {
        this._super();

        for (var i = 0; i < 3; i++) {
            var rotate = cc.RotateBy.create(10, 360);
            var action = cc.RepeatForever.create(rotate);
            var sprite = cc.Sprite.create(s_grossini_dance_atlas, cc.rect(85 * i, 121, 85, 121));
            sprite.setPosition(winSize.width / 4 * (i + 1), winSize.height / 2);

            var point = cc.Sprite.create(s_pathR1);
            point.setScale(0.25);
            point.setPosition(sprite.getPosition());
            this.addChild(point, 10);

            switch (i) {
                case 0:
                    sprite.setAnchorPoint(0, 0);
                    break;
                case 1:
                    sprite.setAnchorPoint(0.5, 0.5);
                    break;
                case 2:
                    sprite.setAnchorPoint(1, 1);
                    break;
            }

            point.setPosition(sprite.getPosition());

            //var copy = action.clone();
            sprite.runAction(action);
            this.addChild(sprite, i);
        }
    },
    //
    // Automation
    //
    testDuration:0.15,
    pixel:{"0":255, "1":204, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel3":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 4 + 45, winSize.height / 2 + 104, 5, 5);
        var ret2 = this.readPixels(winSize.width / 4 * 2 - 3, winSize.height / 2 + 44, 5, 5);
        var ret3 = this.readPixels(winSize.width / 4 * 3 - 44, winSize.height / 2 - 16, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel) ? "yes" : "no", "pixel2":this.containsPixel(ret2, this.pixel) ? "yes" : "no", "pixel3":this.containsPixel(ret3, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteBatchNodeAnchorPoint
//
//------------------------------------------------------------------
var SpriteBatchNodeAnchorPoint = SpriteTestDemo.extend({
    _title:"SpriteBatchNode: anchor point",

    ctor:function () {
        this._super();
        // small capacity. Testing resizing.
        // Don't use capacity=1 in your real game. It is expensive to resize the capacity
        var batch = cc.SpriteBatchNode.create(s_grossini_dance_atlas, 1);
        this.addChild(batch, 0, TAG_SPRITE_BATCH_NODE);

        for (var i = 0; i < 3; i++) {
            var rotate = cc.RotateBy.create(10, 360);
            var action = cc.RepeatForever.create(rotate);
            var sprite = cc.Sprite.createWithTexture(batch.getTexture(), cc.rect(85 * i, 121, 85, 121));
            sprite.setPosition(winSize.width / 4 * (i + 1), winSize.height / 2);

            var point = cc.Sprite.create(s_pathR1);
            point.setScale(0.25);
            point.setPosition(sprite.getPosition());
            this.addChild(point, 1);

            switch (i) {
                case 0:
                    sprite.setAnchorPoint(0, 0);
                    break;
                case 1:
                    sprite.setAnchorPoint(0.5, 0.5);
                    break;
                case 2:
                    sprite.setAnchorPoint(1, 1);
                    break;
            }

            point.setPosition(sprite.getPosition());
            sprite.runAction(action);
            batch.addChild(sprite, i);
        }
    },
    //
    // Automation
    //
    testDuration:0.15,
    pixel:{"0":255, "1":204, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel3":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 4 + 45, winSize.height / 2 + 104, 5, 5);
        var ret2 = this.readPixels(winSize.width / 4 * 2 - 3, winSize.height / 2 + 44, 5, 5);
        var ret3 = this.readPixels(winSize.width / 4 * 3 - 44, winSize.height / 2 - 16, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel) ? "yes" : "no", "pixel2":this.containsPixel(ret2, this.pixel) ? "yes" : "no", "pixel3":this.containsPixel(ret3, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// Sprite6
//
//------------------------------------------------------------------
var Sprite6 = SpriteTestDemo.extend({
    _title:"SpriteBatchNode transformation",

    ctor:function () {
        this._super();
        // small capacity. Testing resizing
        // Don't use capacity=1 in your real game. It is expensive to resize the capacity
        var batch = cc.SpriteBatchNode.create(s_grossini_dance_atlas, 1);
        this.addChild(batch, 0, TAG_SPRITE_BATCH_NODE);
        batch.ignoreAnchorPointForPosition(true);

        batch.setAnchorPoint(0.5, 0.5);
        batch.setContentSize(winSize.width, winSize.height);

        // SpriteBatchNode actions
        var rotate1 = cc.RotateBy.create(5, 360);
        var rotate_back = rotate1.reverse();
        var rotate_seq = cc.Sequence.create(rotate1, rotate_back);
        var rotate_forever = cc.RepeatForever.create(rotate_seq);

        var scale = cc.ScaleBy.create(5, 1.5);
        var scale_back = scale.reverse();
        var scale_seq = cc.Sequence.create(scale, scale_back);
        var scale_forever = cc.RepeatForever.create(scale_seq);

        for (var i = 0; i < 3; i++) {
            var sprite = cc.Sprite.createWithTexture(batch.getTexture(), cc.rect(85 * i, 121, 85, 121));
            switch (i) {
                case 0:
                    sprite.setPosition(winSize.width / 2 - 100, winSize.height / 2);
                    break;
                case 1:
                    sprite.setPosition(winSize.width / 2, winSize.height / 2);
                    break;
                case 2:
                    sprite.setPosition(winSize.width / 2 + 100, winSize.height / 2);
                    break;
            }
            var rotate = cc.RotateBy.create(5, 360);
            var action = cc.RepeatForever.create(rotate);
            sprite.runAction(action.clone());
            batch.addChild(sprite, i);
        }

        batch.runAction(scale_forever);
        batch.runAction(rotate_forever);
    },
    // Automation
    testDuration:2,
    pixel:{"0":255, "1":204, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 2 + 111, winSize.height / 2 + 82, 5, 5);
        var ret2 = this.readPixels(winSize.width / 2 - 148, winSize.height / 2 - 58, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel, false) ? "yes" : "no",
            "pixel2":this.containsPixel(ret2, this.pixel, false) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteFlip
//
//------------------------------------------------------------------
var SpriteFlip = SpriteTestDemo.extend({
    _title:"Sprite Flip X & Y",

    ctor:function () {
        this._super();
        var sprite1 = cc.Sprite.create(s_grossini_dance_atlas, cc.rect(85, 121, 85, 121));
        sprite1.setPosition(winSize.width / 2 - 100, winSize.height / 2);
        this.addChild(sprite1, 0, TAG_SPRITE1);

        var sprite2 = cc.Sprite.create(s_grossini_dance_atlas, cc.rect(85, 121, 85, 121));
        sprite2.setPosition(winSize.width / 2 + 100, winSize.height / 2);
        this.addChild(sprite2, 0, TAG_SPRITE2);

        this.schedule(this.onFlipSprites, 1);
    },
    onFlipSprites:function (dt) {
        var sprite1 = this.getChildByTag(TAG_SPRITE1);
        var sprite2 = this.getChildByTag(TAG_SPRITE2);

        sprite1.setFlippedX(!sprite1.isFlippedX());
        sprite2.setFlippedY(!sprite2.isFlippedY());
    },
    //
    // Automation
    //
    testDuration:1.5,
    pixel:{"0":255, "1":204, "2":153, "3":255},
    pixel1:null,
    pixel2:null,
    pixel3:null,
    pixel4:null,
    setupAutomation:function () {
        this.scheduleOnce(this.getBeforePixel, 0.5);
    },
    getBeforePixel:function () {
        this.pixel1 = this.readPixels(winSize.width / 2 - 131, winSize.height / 2 - 11, 5, 5);
        this.pixel2 = this.readPixels(winSize.width / 2 + 100, winSize.height / 2 + 44, 5, 5);
    },
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel3":"yes", "pixel4":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        this.pixel3 = this.readPixels(winSize.width / 2 - 69, winSize.height / 2 - 11, 5, 5);
        this.pixel4 = this.readPixels(winSize.width / 2 + 100, winSize.height / 2 - 44, 5, 5);
        var ret = {"pixel1":this.containsPixel(this.pixel1, this.pixel) ? "yes" : "no",
            "pixel2":this.containsPixel(this.pixel2, this.pixel) ? "yes" : "no",
            "pixel3":this.containsPixel(this.pixel3, this.pixel) ? "yes" : "no",
            "pixel4":this.containsPixel(this.pixel4, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteBatchNodeFlip
//
//------------------------------------------------------------------
var SpriteBatchNodeFlip = SpriteTestDemo.extend({
    _title:"SpriteBatchNode Flip X & Y",

    ctor:function () {
        this._super();
        var batch = cc.SpriteBatchNode.create(s_grossini_dance_atlas, 10);
        this.addChild(batch, 0, TAG_SPRITE_BATCH_NODE);

        var sprite1 = cc.Sprite.createWithTexture(batch.getTexture(), cc.rect(85, 121, 85, 121));
        sprite1.setPosition(winSize.width / 2 - 100, winSize.height / 2);
        batch.addChild(sprite1, 0, TAG_SPRITE1);

        var sprite2 = cc.Sprite.createWithTexture(batch.getTexture(), cc.rect(85, 121, 85, 121));
        sprite2.setPosition(winSize.width / 2 + 100, winSize.height / 2);
        batch.addChild(sprite2, 0, TAG_SPRITE2);

        this.schedule(this.onFlipSprites, 1);
    },
    onFlipSprites:function (dt) {
        var batch = this.getChildByTag(TAG_SPRITE_BATCH_NODE);
        var sprite1 = batch.getChildByTag(TAG_SPRITE1);
        var sprite2 = batch.getChildByTag(TAG_SPRITE2);

        sprite1.setFlippedX(!sprite1.isFlippedX());
        sprite2.setFlippedY(!sprite2.isFlippedY());
    },
    //
    // Automation
    //
    testDuration:1.5,
    pixel:{"0":255, "1":204, "2":153, "3":255},
    pixel1:null,
    pixel2:null,
    pixel3:null,
    pixel4:null,
    setupAutomation:function () {
        this.scheduleOnce(this.getBeforePixel, 0.5);
    },
    getBeforePixel:function () {
        this.pixel1 = this.readPixels(winSize.width / 2 - 131, winSize.height / 2 - 11, 5, 5);
        this.pixel2 = this.readPixels(winSize.width / 2 + 100, winSize.height / 2 + 44, 5, 5);
    },
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel3":"yes", "pixel4":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        this.pixel3 = this.readPixels(winSize.width / 2 - 69, winSize.height / 2 - 11, 5, 5);
        this.pixel4 = this.readPixels(winSize.width / 2 + 100, winSize.height / 2 - 44, 5, 5);
        var ret = {"pixel1":this.containsPixel(this.pixel1, this.pixel) ? "yes" : "no",
            "pixel2":this.containsPixel(this.pixel2, this.pixel) ? "yes" : "no",
            "pixel3":this.containsPixel(this.pixel3, this.pixel) ? "yes" : "no",
            "pixel4":this.containsPixel(this.pixel4, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteAliased
//
//------------------------------------------------------------------
var SpriteAliased = SpriteTestDemo.extend({
    _title:"Sprite Aliased",
    _subtitle:"You should see pixelated sprites",

    ctor:function () {
        this._super();
        var sprite1 = cc.Sprite.create(s_grossini_dance_atlas, cc.rect(85, 121, 85, 121));
        sprite1.setPosition(winSize.width / 2 - 100, winSize.height / 2);
        this.addChild(sprite1, 0, TAG_SPRITE1);

        var sprite2 = cc.Sprite.create(s_grossini_dance_atlas, cc.rect(85, 121, 85, 121));
        sprite2.setPosition(winSize.width / 2 + 100, winSize.height / 2);
        this.addChild(sprite2, 0, TAG_SPRITE2);

        var scale = cc.ScaleBy.create(2, 5);
        var scale_back = scale.reverse();
        var seq = cc.Sequence.create(scale, scale_back);
        var repeat = cc.RepeatForever.create(seq);

        var scale2 = cc.ScaleBy.create(2, 5);
        var scale_back2 = scale2.reverse();
        var seq2 = cc.Sequence.create(scale2, scale_back2);
        var repeat2 = cc.RepeatForever.create(seq2);

        sprite1.runAction(repeat);
        sprite2.runAction(repeat2);
    },
    onEnter:function () {
        this._super();
        //
        // IMPORTANT:
        // This change will affect every sprite that uses the same texture
        // So sprite1 and sprite2 will be affected by this change
        //
        if (sys.platform === 'browser' && !("opengl" in sys.capabilities)) {
            var label = cc.LabelTTF.create("Not supported on HTML5-canvas", "Times New Roman", 30);
            this.addChild(label);
            label.setPosition(winSize.width / 2, winSize.height / 2);
        } else {
            var sprite = this.getChildByTag(TAG_SPRITE1);
            sprite.getTexture().setAliasTexParameters();
        }

    },
    onExit:function () {
        if (sys.platform !== 'browser' || ("opengl" in sys.capabilities)) {
            var sprite = this.getChildByTag(TAG_SPRITE1);
            sprite.getTexture().setAntiAliasTexParameters();
        }
        this._super();
    }
});

//------------------------------------------------------------------
//
// SpriteBatchNodeAliased
//
//------------------------------------------------------------------
var SpriteBatchNodeAliased = SpriteTestDemo.extend({
    _title:"SpriteBatchNode Aliased",
    _subtitle:"You should see pixelated sprites",

    ctor:function () {
        this._super();
        var batch = cc.SpriteBatchNode.create(s_grossini_dance_atlas, 10);
        this.addChild(batch, 0, TAG_SPRITE_BATCH_NODE);

        var sprite1 = cc.Sprite.createWithTexture(batch.getTexture(), cc.rect(85, 121, 85, 121));
        sprite1.setPosition(winSize.width / 2 - 100, winSize.height / 2);
        batch.addChild(sprite1, 0, TAG_SPRITE1);

        var sprite2 = cc.Sprite.createWithTexture(batch.getTexture(), cc.rect(85, 121, 85, 121));
        sprite2.setPosition(winSize.width / 2 + 100, winSize.height / 2);
        batch.addChild(sprite2, 0, TAG_SPRITE2);

        var scale = cc.ScaleBy.create(2, 5);
        var scale_back = scale.reverse();
        var seq = cc.Sequence.create(scale, scale_back);
        var repeat = cc.RepeatForever.create(seq);

        var scale2 = cc.ScaleBy.create(2, 5);
        var scale_back2 = scale2.reverse();
        var seq2 = cc.Sequence.create(scale2, scale_back2);
        var repeat2 = cc.RepeatForever.create(seq2);

        sprite1.runAction(repeat);
        sprite2.runAction(repeat2);
    },
    onEnter:function () {
        this._super();
        //
        // IMPORTANT:
        // This change will affect every sprite that uses the same texture
        // So sprite1 and sprite2 will be affected by this change
        //
        if (sys.platform == 'browser' && !("opengl" in sys.capabilities)) {
            var label = cc.LabelTTF.create("Not supported on HTML5-canvas", "Times New Roman", 30);
            this.addChild(label);
            label.setPosition(winSize.width / 2, winSize.height / 2);
        } else {
            var sprite = this.getChildByTag(TAG_SPRITE_BATCH_NODE);
            sprite.getTexture().setAliasTexParameters();
        }

    },
    onExit:function () {
        if (sys.platform !== 'browser' || ("opengl" in sys.capabilities)) {
            var sprite = this.getChildByTag(TAG_SPRITE_BATCH_NODE);
            sprite.getTexture().setAntiAliasTexParameters();
        }
        this._super();
    }
});

//------------------------------------------------------------------
//
// SpriteNewTexture
//
//------------------------------------------------------------------
var SpriteNewTexture = SpriteTestDemo.extend({
    _usingTexture1:false,
    _texture1:null,
    _texture2:null,
    _title:"Sprite New texture (tap)",

    ctor:function () {
        this._super();

        if ('touches' in sys.capabilities)
            this.setTouchEnabled(true);
        else if ('mouse' in sys.capabilities)
            this.setMouseEnabled(true);

        var node = cc.Node.create();
        this.addChild(node, 0, TAG_SPRITE_BATCH_NODE);

        this._texture1 = cc.TextureCache.getInstance().addImage(s_grossini_dance_atlas);
        this._texture2 = cc.TextureCache.getInstance().addImage(s_grossini_dance_atlas_mono);

        this._usingTexture1 = true;

        for (var i = 0; i < 30; i++) {
            this.addNewSprite();
        }
    },
    addNewSprite:function () {
        var p = cc.p(Math.random() * winSize.width, Math.random() * winSize.height);

        var idx = 0 | (Math.random() * 14);
        var x = (idx % 5) * 85;
        var y = (0 | (idx / 5)) * 121;


        var node = this.getChildByTag(TAG_SPRITE_BATCH_NODE);
        var sprite = cc.Sprite.createWithTexture(this._texture1, cc.rect(x, y, 85, 121));
        node.addChild(sprite);

        sprite.setPosition(p.x, p.y);

        var action;
        var random = Math.random();

        if (random < 0.20)
            action = cc.ScaleBy.create(3, 2);
        else if (random < 0.40)
            action = cc.RotateBy.create(3, 360);
        else if (random < 0.60)
            action = cc.Blink.create(1, 3);
        // else if (random < 0.8)
        //     action = cc.TintBy.create(2, 0, -255, -255);
        else
            action = cc.FadeOut.create(2);

        var action_back = action.reverse();
        var seq = cc.Sequence.create(action, action_back);

        sprite.runAction(cc.RepeatForever.create(seq));
    },

    onChangeTexture:function () {
        var node = this.getChildByTag(TAG_SPRITE_BATCH_NODE);

        var children = node.getChildren();
        var sprite;
        var i;

        if (this._usingTexture1) {                         //-. win32 : Let's it make just simple sentence
            for (i = 0; i < children.length; i++) {
                sprite = children[i];
                if (!sprite)
                    break;
                sprite.setTexture(this._texture2);
            }
            this._usingTexture1 = false;
        } else {
            for (i = 0; i < children.length; i++) {
                sprite = children[i];
                if (!sprite)
                    break;
                sprite.setTexture(this._texture1);
            }
            this._usingTexture1 = true;
        }
    },
    onTouchesEnded:function (touches, event) {
        this.onChangeTexture();
    },
    onMouseDown:function (event) {
        this.onChangeTexture();
        return true;
    },
    //
    // Automation
    //
    testDuration:1,
    pixel:{"0":51, "1":0, "2":51, "3":255},
    setupAutomation:function () {
        this.scheduleOnce(this.addTestSprite, 0.5);
    },
    addTestSprite:function () {
        var node = this.getChildByTag(TAG_SPRITE_BATCH_NODE);
        var sprite = cc.Sprite.createWithTexture(this._texture1, cc.rect(0, 0, 85, 121));
        sprite.setPosition(winSize.width / 2, winSize.height / 2);
        node.addChild(sprite);
    },
    getExpectedResult:function () {
        var ret = {"pixel":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 2, winSize.height / 2, 5, 5);
        var ret = {"pixel":this.containsPixel(ret1, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteBatchNodeNewTexture
//
//------------------------------------------------------------------
var SpriteBatchNodeNewTexture = SpriteTestDemo.extend({
    _texture1:null,
    _texture2:null,
    _title:"SpriteBatchNode new texture (tap)",

    ctor:function () {
        this._super();
        if ('touches' in sys.capabilities)
            this.setTouchEnabled(true);
        else if ('mouse' in sys.capabilities)
            this.setMouseEnabled(true);

        var batch = cc.SpriteBatchNode.create(s_grossini_dance_atlas, 50);
        this.addChild(batch, 0, TAG_SPRITE_BATCH_NODE);

        this._texture1 = batch.getTexture();
        this._texture2 = cc.TextureCache.getInstance().addImage(s_grossini_dance_atlas_mono);

        for (var i = 0; i < 30; i++) {
            this.addNewSprite();
        }
    },
    addNewSprite:function () {
        var s = winSize;

        var p = cc.p(Math.random() * winSize.width, Math.random() * winSize.height);

        var batch = this.getChildByTag(TAG_SPRITE_BATCH_NODE);

        var idx = 0 | (Math.random() * 14);
        var x = (idx % 5) * 85;
        var y = (0 | (idx / 5)) * 121;

        var sprite = cc.Sprite.createWithTexture(batch.getTexture(), cc.rect(x, y, 85, 121));
        batch.addChild(sprite);

        sprite.setPosition(p.x, p.y);

        var action;
        var random = Math.random();

        if (random < 0.20)
            action = cc.ScaleBy.create(3, 2);
        else if (random < 0.40)
            action = cc.RotateBy.create(3, 360);
        else if (random < 0.60)
            action = cc.Blink.create(1, 3);
        //else if (random < 0.8)
        //    action = cc.TintBy.create(2, 0, -255, -255);
        else
            action = cc.FadeOut.create(2);
        var action_back = action.reverse();
        var seq = cc.Sequence.create(action, action_back);

        sprite.runAction(cc.RepeatForever.create(seq));
    },
    onChangeTexture:function () {
        var batch = this.getChildByTag(TAG_SPRITE_BATCH_NODE);

        if (batch.getTexture() == this._texture1)
            batch.setTexture(this._texture2);
        else
            batch.setTexture(this._texture1);
    },
    onTouchesEnded:function (touches, event) {
        this.onChangeTexture();
    },
    onMouseDown:function (event) {
        this.onChangeTexture();
        return true;
    },
    //
    // Automation
    //
    testDuration:1,
    pixel:{"0":51, "1":0, "2":51, "3":255},
    setupAutomation:function () {
        this.scheduleOnce(this.addTestSprite, 0.5);
    },
    addTestSprite:function () {
        var node = this.getChildByTag(TAG_SPRITE_BATCH_NODE);
        var sprite = cc.Sprite.createWithTexture(this._texture1, cc.rect(0, 0, 85, 121));
        sprite.setPosition(winSize.width / 2, winSize.height / 2);
        node.addChild(sprite);
    },
    getExpectedResult:function () {
        var ret = {"pixel":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 2, winSize.height / 2, 5, 5);
        var ret = {"pixel":this.containsPixel(ret1, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }

});

//------------------------------------------------------------------
//
// SpriteFrameTest
//
//------------------------------------------------------------------
var SpriteFrameTest = SpriteTestDemo.extend({
    _sprite1:null,
    _sprite2:null,
    _counter:0,
    _title:"Sprite vs. SpriteBatchNode animation",
    _subtitle:"Testing issue #792",

    onEnter:function () {
        this._super();
        // IMPORTANT:
        // The sprite frames will be cached AND RETAINED, and they won't be released unless you call
        //     cc.SpriteFrameCache.getInstance().removeUnusedSpriteFrames);
        spriteFrameCache.addSpriteFrames(s_grossiniPlist);
        spriteFrameCache.addSpriteFrames(s_grossini_grayPlist, s_grossini_gray);
        spriteFrameCache.addSpriteFrames(s_grossini_bluePlist, s_grossini_blue);

        //
        // Animation using Sprite BatchNode
        //
        this._sprite1 = cc.Sprite.createWithSpriteFrameName("grossini_dance_01.png");
        this._sprite1.setPosition(winSize.width / 2 - 80, winSize.height / 2);

        var spritebatch = cc.SpriteBatchNode.create(s_grossini);
        spritebatch.addChild(this._sprite1);
        this.addChild(spritebatch);

        var animFrames = [];
        var str = "";
        var frame;
        for (var i = 1; i < 15; i++) {
            str = "grossini_dance_" + (i < 10 ? ("0" + i) : i) + ".png";
            frame = spriteFrameCache.getSpriteFrame(str);
            animFrames.push(frame);
        }

        var animation = cc.Animation.create(animFrames, 0.3);
        this._sprite1.runAction(cc.RepeatForever.create(cc.Animate.create(animation)));

        // to test issue #732, uncomment the following line
        this._sprite1.setFlippedX(false);
        this._sprite1.setFlippedY(false);

        //
        // Animation using standard Sprite
        //
        this._sprite2 = cc.Sprite.createWithSpriteFrameName("grossini_dance_01.png");
        this._sprite2.setPosition(winSize.width / 2 + 80, winSize.height / 2);
        this.addChild(this._sprite2);

        var moreFrames = [];
        for (i = 1; i < 15; i++) {
            str = "grossini_dance_gray_" + (i < 10 ? ("0" + i) : i) + ".png";
            frame = spriteFrameCache.getSpriteFrame(str);
            moreFrames.push(frame);
        }

        for (i = 1; i < 5; i++) {
            str = "grossini_blue_0" + i + ".png";
            frame = spriteFrameCache.getSpriteFrame(str);
            moreFrames.push(frame);
        }

        // append frames from another batch
        moreFrames = moreFrames.concat(animFrames);
        var animMixed = cc.Animation.create(moreFrames, 0.3);

        this._sprite2.runAction(cc.RepeatForever.create(cc.Animate.create(animMixed)));

        // to test issue #732, uncomment the following line
        this._sprite2.setFlippedX(false);
        this._sprite2.setFlippedY(false);

        this.schedule(this.onStartIn05Secs, 0.5);
        this._counter = 0;
    },
    onExit:function () {
        this._super();
        spriteFrameCache.removeSpriteFramesFromFile(s_grossiniPlist);
        spriteFrameCache.removeSpriteFramesFromFile(s_grossini_grayPlist);
        spriteFrameCache.removeSpriteFramesFromFile(s_grossini_bluePlist);
    },
    onStartIn05Secs:function () {
        this.unschedule(this.onStartIn05Secs);
        this.schedule(this.onFlipSprites, 1.0);
    },
    onFlipSprites:function (dt) {
        this._counter++;

        var fx = false;
        var fy = false;
        var i = this._counter % 4;

        switch (i) {
            case 0:
                fx = false;
                fy = false;
                break;
            case 1:
                fx = true;
                fy = false;
                break;
            case 2:
                fx = false;
                fy = true;
                break;
            case 3:
                fx = true;
                fy = true;
                break;
        }

        this._sprite1.setFlippedX(fx);
        this._sprite1.setFlippedY(fy);
        this._sprite2.setFlippedX(fx);
        this._sprite2.setFlippedY(fy);
    },
    //
    // Automation
    //
    testDuration:3.1,
    pixel1:{"0":255, "1":204, "2":153, "3":255},
    pixel2:{"0":255, "1":204, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 2 - 50, winSize.height / 2 + 8, 5, 5);
        var ret2 = this.readPixels(winSize.width / 2 - 80, winSize.height / 2 - 42, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel1) ? "yes" : "no",
            "pixel2":this.containsPixel(ret2, this.pixel2) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteFrameAliasNameTest
//
//------------------------------------------------------------------
var SpriteFrameAliasNameTest = SpriteTestDemo.extend({
    _title:"SpriteFrame Alias Name",
    _subtitle:"SpriteFrames are obtained using the alias name",
    onEnter:function () {
        this._super();
        // IMPORTANT:
        // The sprite frames will be cached AND RETAINED, and they won't be released unless you call
        //
        // cc.SpriteFrameCache is a cache of cc.SpriteFrames
        // cc.SpriteFrames each contain a texture id and a rect (frame).
        spriteFrameCache.addSpriteFrames(s_grossini_aliasesPlist, s_grossini_aliases);

        //
        // Animation using Sprite batch
        //
        // A cc.SpriteBatchNode can reference one and only one texture (one .png file)
        // Sprites that are contained in that texture can be instantiatied as cc.Sprites and then added to the cc.SpriteBatchNode
        // All cc.Sprites added to a cc.SpriteBatchNode are drawn in one OpenGL ES draw call
        // If the cc.Sprites are not added to a cc.SpriteBatchNode then an OpenGL ES draw call will be needed for each one, which is less efficient
        //
        // When you animate a sprite, CCAnimation changes the frame of the sprite using setDisplayFrame: (this is why the animation must be in the same texture)
        // When setDisplayFrame: is used in the CCAnimation it changes the frame to one specified by the cc.SpriteFrames that were added to the animation,
        // but texture id is still the same and so the sprite is still a child of the cc.SpriteBatchNode,
        // and therefore all the animation sprites are also drawn as part of the cc.SpriteBatchNode
        //
        var sprite = cc.Sprite.createWithSpriteFrameName("grossini_dance_01.png");
        sprite.setPosition(winSize.width / 2, winSize.height / 2);

        var spriteBatch = cc.SpriteBatchNode.create(s_grossini_aliases);
        spriteBatch.addChild(sprite);
        this.addChild(spriteBatch);

        var animFrames = [];
        var str = "";
        for (var i = 1; i < 15; i++) {
            // Obtain frames by alias name
            str = "dance_" + (i < 10 ? ("0" + i) : i);
            var frame = spriteFrameCache.getSpriteFrame(str);
            animFrames.push(frame);
        }

        var animation = cc.Animation.create(animFrames, 0.3);
        // 14 frames * 1sec = 14 seconds
        sprite.runAction(cc.RepeatForever.create(cc.Animate.create(animation)));
        this.testSprite = sprite;
    },
    onExit:function () {
        this._super();
        spriteFrameCache.removeSpriteFramesFromFile(s_grossini_aliasesPlist);
    },
    //
    // Automation
    //
    testDuration:0.5,
    pixel:{"0":255, "1":204, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 2 - 32, winSize.height / 2 - 10, 5, 5);
        var ret = {"pixel":this.containsPixel(ret1, this.pixel, false) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteOffsetAnchorRotation
//
//------------------------------------------------------------------
var SpriteOffsetAnchorRotation = SpriteTestDemo.extend({

    _title:"Sprite offset + anchor + rot",
    ctor:function () {
        this._super();
        spriteFrameCache.addSpriteFrames(s_grossiniPlist);
        spriteFrameCache.addSpriteFrames(s_grossini_grayPlist, s_grossini_gray);

        for (var i = 0; i < 3; i++) {
            //
            // Animation using Sprite BatchNode
            //
            var sprite = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_01.png"));
            sprite.setPosition(winSize.width / 4 * (i + 1), winSize.height / 2);

            var point = cc.Sprite.create(s_pathR1);
            point.setScale(0.25);
            point.setPosition(sprite.getPosition());
            this.addChild(point, 1);

            switch (i) {
                case 0:
                    sprite.setAnchorPoint(0, 0);
                    break;
                case 1:
                    sprite.setAnchorPoint(0.5, 0.5);
                    break;
                case 2:
                    sprite.setAnchorPoint(1, 1);
                    break;
            }

            point.setPosition(sprite.getPosition());

            var animFrames = [];
            var str = "";
            for (var j = 1; j < 15; j++) {
                str = "grossini_dance_" + (j < 10 ? ("0" + j) : j) + ".png";
                var frame = spriteFrameCache.getSpriteFrame(str);
                animFrames.push(frame);
            }

            var animation = cc.Animation.create(animFrames, 0.3);
            sprite.runAction(cc.RepeatForever.create(cc.Animate.create(animation)));
            sprite.runAction(cc.RepeatForever.create(cc.RotateBy.create(10, 360)));

            this.addChild(sprite, 0);
        }
    },
    onExit:function () {
        this._super();
        spriteFrameCache.removeSpriteFramesFromFile(s_grossiniPlist);
        spriteFrameCache.removeSpriteFramesFromFile(s_grossini_grayPlist);
    },
    //
    // Automation
    //
    testDuration:5,
    pixel:{"0":255, "1":204, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel3":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 4 - 13, winSize.height / 2 - 50, 5, 5);
        var ret2 = this.readPixels(winSize.width / 4 * 2 + 29, winSize.height / 2 + 11, 5, 5);
        var ret3 = this.readPixels(winSize.width / 4 * 3 + 71, winSize.height / 2 + 71, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel) ? "yes" : "no", "pixel2":this.containsPixel(ret2, this.pixel) ? "yes" : "no", "pixel3":this.containsPixel(ret3, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteBatchNodeOffsetAnchorRotation
//
//------------------------------------------------------------------
var SpriteBatchNodeOffsetAnchorRotation = SpriteTestDemo.extend({
    _title:"SpriteBatchNode offset + anchor + rot",

    ctor:function () {
        this._super();

        spriteFrameCache.addSpriteFrames(s_grossiniPlist);
        spriteFrameCache.addSpriteFrames(s_grossini_grayPlist, s_grossini_gray);

        var spritebatch = cc.SpriteBatchNode.create(s_grossini);
        this.addChild(spritebatch);

        for (var i = 0; i < 3; i++) {
            //
            // Animation using Sprite BatchNode
            //
            var sprite = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_01.png"));
            sprite.setPosition(winSize.width / 4 * (i + 1), winSize.height / 2);

            var point = cc.Sprite.create(s_pathR1);
            point.setScale(0.25);
            point.setPosition(sprite.getPosition());
            this.addChild(point, 200);

            switch (i) {
                case 0:
                    sprite.setAnchorPoint(0, 0);
                    break;
                case 1:
                    sprite.setAnchorPoint(0.5, 0.5);
                    break;
                case 2:
                    sprite.setAnchorPoint(1, 1);
                    break;
            }
            point.setPosition(sprite.getPosition());

            var animFrames = [];
            var str = "";
            for (var k = 1; k < 15; k++) {
                str = "grossini_dance_" + (k < 10 ? ("0" + k) : k) + ".png";
                var frame = spriteFrameCache.getSpriteFrame(str);
                animFrames.push(frame);
            }

            var animation = cc.Animation.create(animFrames, 0.3);
            sprite.runAction(cc.RepeatForever.create(cc.Animate.create(animation)));
            sprite.runAction(cc.RepeatForever.create(cc.RotateBy.create(10, 360)));

            spritebatch.addChild(sprite, i);
        }
    },
    onExit:function () {
        this._super();
        spriteFrameCache.removeSpriteFramesFromFile(s_grossiniPlist);
        spriteFrameCache.removeSpriteFramesFromFile(s_grossini_grayPlist);
    },
    //
    // Automation
    //
    testDuration:5,
    pixel:{"0":255, "1":204, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel3":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 4 - 13, winSize.height / 2 - 50, 5, 5);
        var ret2 = this.readPixels(winSize.width / 4 * 2 + 29, winSize.height / 2 + 11, 5, 5);
        var ret3 = this.readPixels(winSize.width / 4 * 3 + 71, winSize.height / 2 + 71, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel) ? "yes" : "no", "pixel2":this.containsPixel(ret2, this.pixel) ? "yes" : "no", "pixel3":this.containsPixel(ret3, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteOffsetAnchorScale
//
//------------------------------------------------------------------
var SpriteOffsetAnchorScale = SpriteTestDemo.extend({

    _title:"Sprite offset + anchor + scale",

    ctor:function () {
        this._super();
        spriteFrameCache.addSpriteFrames(s_grossiniPlist);
        spriteFrameCache.addSpriteFrames(s_grossini_grayPlist, s_grossini_gray);

        for (var i = 0; i < 3; i++) {
            //
            // Animation using Sprite BatchNode
            //
            var sprite = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_01.png"));
            sprite.setPosition(winSize.width / 4 * (i + 1), winSize.height / 2);

            var point = cc.Sprite.create(s_pathR1);
            point.setScale(0.25);
            point.setPosition(sprite.getPosition());
            this.addChild(point, 1);

            switch (i) {
                case 0:
                    sprite.setAnchorPoint(0, 0);
                    break;
                case 1:
                    sprite.setAnchorPoint(0.5, 0.5);
                    break;
                case 2:
                    sprite.setAnchorPoint(1, 1);
                    break;
            }

            point.setPosition(sprite.getPosition());

            var animFrames = [];
            var str = "";
            for (var k = 1; k <= 14; k++) {
                str = "grossini_dance_" + (k < 10 ? ("0" + k) : k) + ".png";
                var frame = spriteFrameCache.getSpriteFrame(str);
                animFrames.push(frame);
            }

            var animation = cc.Animation.create(animFrames, 0.3);
            sprite.runAction(cc.RepeatForever.create(cc.Animate.create(animation)));

            var scale = cc.ScaleBy.create(2, 2);
            var scale_back = scale.reverse();
            var delay = cc.DelayTime.create(0.25);
            var seq_scale = cc.Sequence.create(scale, delay, scale_back);
            sprite.runAction(cc.RepeatForever.create(seq_scale));

            this.addChild(sprite, 0);
        }
    },
    onExit:function () {
        this._super();
        spriteFrameCache.removeSpriteFramesFromFile(s_grossiniPlist);
        spriteFrameCache.removeSpriteFramesFromFile(s_grossini_grayPlist);
    },
    //
    // Automation
    //
    testDuration:2.1,
    pixel:{"0":153, "1":0, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel3":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 4 * 3 - 85, winSize.height / 2 - 106, 5, 5);
        var ret2 = this.readPixels(winSize.width / 4 * 2, winSize.height / 2 + 13, 5, 5);
        var ret3 = this.readPixels(winSize.width / 4 + 82, winSize.height / 2 + 133, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel) ? "yes" : "no", "pixel2":this.containsPixel(ret2, this.pixel) ? "yes" : "no", "pixel3":this.containsPixel(ret3, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});


//------------------------------------------------------------------
//
// SpriteBatchNodeOffsetAnchorScale
//
//------------------------------------------------------------------
var SpriteBatchNodeOffsetAnchorScale = SpriteTestDemo.extend({

    _title:"SpriteBatchNode offset + anchor + scale",

    ctor:function () {
        this._super();
        var batch = cc.SpriteBatchNode.create(s_grossini);
        this.addChild(batch);

        spriteFrameCache.addSpriteFrames(s_grossiniPlist);
        spriteFrameCache.addSpriteFrames(s_grossini_grayPlist, s_grossini_gray);

        for (var i = 0; i < 3; i++) {
            //
            // Animation using Sprite BatchNode
            //
            var sprite = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_01.png"));
            sprite.setPosition(winSize.width / 4 * (i + 1), winSize.height / 2);

            var point = cc.Sprite.create(s_pathR1);
            point.setScale(0.25);
            point.setPosition(sprite.getPosition());
            this.addChild(point, 200);

            switch (i) {
                case 0:
                    sprite.setAnchorPoint(0, 0);
                    break;
                case 1:
                    sprite.setAnchorPoint(0.5, 0.5);
                    break;
                case 2:
                    sprite.setAnchorPoint(1, 1);
                    break;
            }

            point.setPosition(sprite.getPosition());

            var animFrames = [];
            var str = "";
            for (var k = 1; k <= 14; k++) {
                str = "grossini_dance_" + (k < 10 ? ("0" + k) : k) + ".png";
                var frame = spriteFrameCache.getSpriteFrame(str);
                animFrames.push(frame);
            }

            var animation = cc.Animation.create(animFrames, 0.3);
            sprite.runAction(cc.RepeatForever.create(cc.Animate.create(animation)));

            var scale = cc.ScaleBy.create(2, 2);
            var scale_back = scale.reverse();
            var seq_scale = cc.Sequence.create(scale, scale_back);
            sprite.runAction(cc.RepeatForever.create(seq_scale));

            batch.addChild(sprite, i);
        }
    },
    onExit:function () {
        this._super();
        spriteFrameCache.removeSpriteFramesFromFile(s_grossiniPlist);
        spriteFrameCache.removeSpriteFramesFromFile(s_grossini_grayPlist);
    },
    //
    // Automation
    //
    testDuration:2.1,
    pixel:{"0":153, "1":0, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel3":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 4 * 3 - 85, winSize.height / 2 - 106, 5, 5);
        var ret2 = this.readPixels(winSize.width / 4 * 2, winSize.height / 2 + 13, 5, 5);
        var ret3 = this.readPixels(winSize.width / 4 + 82, winSize.height / 2 + 133, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel) ? "yes" : "no", "pixel2":this.containsPixel(ret2, this.pixel) ? "yes" : "no", "pixel3":this.containsPixel(ret3, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//
// SpriteOffsetAnchorSkew
//
var SpriteOffsetAnchorSkew = SpriteTestDemo.extend({

    _title:"Sprite offset + anchor + skew",

    ctor:function () {
        this._super();
        spriteFrameCache.addSpriteFrames(s_grossiniPlist);
        spriteFrameCache.addSpriteFrames(s_grossini_grayPlist, s_grossini_gray);

        for (var i = 0; i < 3; i++) {
            //
            // Animation using Sprite batch
            //
            var sprite = cc.Sprite.createWithSpriteFrameName("grossini_dance_01.png");
            sprite.setPosition(winSize.width / 4 * (i + 1), winSize.height / 2);

            var point = cc.Sprite.create(s_pathR1);
            point.setScale(0.25);
            point.setPosition(sprite.getPosition());
            this.addChild(point, 1);

            switch (i) {
                case 0:
                    sprite.setAnchorPoint(0, 0);
                    break;
                case 1:
                    sprite.setAnchorPoint(0.5, 0.5);
                    break;
                case 2:
                    sprite.setAnchorPoint(1, 1);
                    break;
            }

            point.setPosition(sprite.getPosition());

            var animFrames = [];
            var tmp = "";
            for (var j = 1; j <= 14; j++) {
                tmp = "grossini_dance_" + (j < 10 ? ("0" + j) : j) + ".png";
                var frame = spriteFrameCache.getSpriteFrame(tmp);
                animFrames.push(frame);
            }

            var animation = cc.Animation.create(animFrames, 0.3);
            sprite.runAction(cc.RepeatForever.create(cc.Animate.create(animation)));

            var skewX = cc.SkewBy.create(2, 45, 0);
            var skewX_back = skewX.reverse();
            var skewY = cc.SkewBy.create(2, 0, 45);
            var skewY_back = skewY.reverse();

            var seq_skew = cc.Sequence.create(skewX, skewX_back, skewY, skewY_back);
            sprite.runAction(cc.RepeatForever.create(seq_skew));

            this.addChild(sprite, 0);
        }
    },
    //
    // Automation
    //
    testDuration:2,
    pixel:{"0":255, "1":204, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 4 + 142, winSize.height / 2 + 98, 5, 5);
        var ret2 = this.readPixels(winSize.width / 4 * 2 + 50, winSize.height / 2 + 43, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel) ? "yes" : "no",
            "pixel2":this.containsPixel(ret2, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//
// SpriteBatchNodeOffsetAnchorSkew
//
var SpriteBatchNodeOffsetAnchorSkew = SpriteTestDemo.extend({

    _title:"SpriteBatchNode offset + anchor + skew",

    ctor:function () {
        this._super();
        spriteFrameCache.addSpriteFrames(s_grossiniPlist);
        spriteFrameCache.addSpriteFrames(s_grossini_grayPlist, s_grossini_gray);

        var spritebatch = cc.SpriteBatchNode.create(s_grossini);
        this.addChild(spritebatch);

        for (var i = 0; i < 3; i++) {
            //
            // Animation using Sprite batch
            //
            var sprite = cc.Sprite.createWithSpriteFrameName("grossini_dance_01.png");
            sprite.setPosition(winSize.width / 4 * (i + 1), winSize.height / 2);

            var point = cc.Sprite.create(s_pathR1);
            point.setScale(0.25);
            point.setPosition(sprite.getPosition());
            this.addChild(point, 200);

            switch (i) {
                case 0:
                    sprite.setAnchorPoint(0, 0);
                    break;
                case 1:
                    sprite.setAnchorPoint(0.5, 0.5);
                    break;
                case 2:
                    sprite.setAnchorPoint(1, 1);
                    break;
            }

            point.setPosition(sprite.getPosition());

            var animFrames = [];
            var tmp = "";
            for (var j = 1; j <= 14; j++) {
                tmp = "grossini_dance_" + (j < 10 ? ("0" + j) : j) + ".png";
                var frame = spriteFrameCache.getSpriteFrame(tmp);
                animFrames.push(frame);
            }

            var animation = cc.Animation.create(animFrames, 0.3);
            sprite.runAction(cc.RepeatForever.create(cc.Animate.create(animation)));

            animFrames = null;

            var skewX = cc.SkewBy.create(2, 45, 0);
            var skewX_back = skewX.reverse();
            var skewY = cc.SkewBy.create(2, 0, 45);
            var skewY_back = skewY.reverse();

            var seq_skew = cc.Sequence.create(skewX, skewX_back, skewY, skewY_back);
            sprite.runAction(cc.RepeatForever.create(seq_skew));

            spritebatch.addChild(sprite, i);
        }
    },
    //
    // Automation
    //
    testDuration:2,
    pixel:{"0":255, "1":204, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 4 + 142, winSize.height / 2 + 98, 5, 5);
        var ret2 = this.readPixels(winSize.width / 4 * 2 + 50, winSize.height / 2 + 43, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel) ? "yes" : "no",
            "pixel2":this.containsPixel(ret2, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//
// SpriteOffsetAnchorSkewScale
//
var SpriteOffsetAnchorSkewScale = SpriteTestDemo.extend({

    _title:"Sprite anchor + skew + scale",
    ctor:function () {
        this._super();
        spriteFrameCache.addSpriteFrames(s_grossiniPlist);
        spriteFrameCache.addSpriteFrames(s_grossini_grayPlist, s_grossini_gray);

        for (var i = 0; i < 3; i++) {
            //
            // Animation using Sprite batch
            //
            var sprite = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_01.png"));
            sprite.setPosition(winSize.width / 4 * (i + 1), winSize.height / 2);

            var point = cc.Sprite.create(s_pathR1);
            point.setScale(0.25);
            point.setPosition(sprite.getPosition());
            this.addChild(point, 1);

            switch (i) {
                case 0:
                    sprite.setAnchorPoint(0, 0);
                    break;
                case 1:
                    sprite.setAnchorPoint(0.5, 0.5);
                    break;
                case 2:
                    sprite.setAnchorPoint(1, 1);
                    break;
            }

            point.setPosition(sprite.getPosition());

            var animFrames = [];
            var tmp = "";
            for (var j = 1; j <= 14; j++) {
                tmp = "grossini_dance_" + (j < 10 ? ("0" + j) : j) + ".png";
                var frame = spriteFrameCache.getSpriteFrame(tmp);
                animFrames.push(frame);
            }

            var animation = cc.Animation.create(animFrames, 0.3);
            sprite.runAction(cc.RepeatForever.create(cc.Animate.create(animation)));

            animFrames = null;

            // Skew
            var skewX = cc.SkewBy.create(2, 45, 0);
            var skewX_back = skewX.reverse();
            var skewY = cc.SkewBy.create(2, 0, 45);
            var skewY_back = skewY.reverse();

            var seq_skew = cc.Sequence.create(skewX, skewX_back, skewY, skewY_back);
            sprite.runAction(cc.RepeatForever.create(seq_skew));

            // Scale
            var scale = cc.ScaleBy.create(2, 2);
            var scale_back = scale.reverse();
            var seq_scale = cc.Sequence.create(scale, scale_back);
            sprite.runAction(cc.RepeatForever.create(seq_scale));

            this.addChild(sprite, 0);
        }
    },
    //
    // Automation
    //
    testDuration:2,
    pixel:{"0":255, "1":204, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel3":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 4 + 121, winSize.height / 2 + 99, 5, 5);
        var ret2 = this.readPixels(winSize.width / 4 * 2 - 83, winSize.height / 2 - 21, 5, 5);
        var ret3 = this.readPixels(winSize.width / 4 * 3 - 286, winSize.height / 2 - 140, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel) ? "yes" : "no",
            "pixel2":this.containsPixel(ret2, this.pixel) ? "yes" : "no",
            "pixel3":this.containsPixel(ret3, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//
// SpriteBatchNodeOffsetAnchorSkewScale
//
var SpriteBatchNodeOffsetAnchorSkewScale = SpriteTestDemo.extend({

    _title:"SpriteBatchNode anchor + skew + scale",

    ctor:function () {
        this._super();

        spriteFrameCache.addSpriteFrames(s_grossiniPlist);
        spriteFrameCache.addSpriteFrames(s_grossini_grayPlist, s_grossini_gray);

        var spritebatch = cc.SpriteBatchNode.create(s_grossini);
        this.addChild(spritebatch);

        for (var i = 0; i < 3; i++) {
            //
            // Animation using Sprite batch
            //
            var sprite = cc.Sprite.createWithSpriteFrameName("grossini_dance_01.png");
            sprite.setPosition(winSize.width / 4 * (i + 1), winSize.height / 2);

            var point = cc.Sprite.create(s_pathR1);
            point.setScale(0.25);
            point.setPosition(sprite.getPosition());
            this.addChild(point, 200);

            switch (i) {
                case 0:
                    sprite.setAnchorPoint(0, 0);
                    break;
                case 1:
                    sprite.setAnchorPoint(0.5, 0.5);
                    break;
                case 2:
                    sprite.setAnchorPoint(1, 1);
                    break;
            }

            point.setPosition(sprite.getPosition());

            var animFrames = [];
            var tmp = "";
            for (var j = 1; j <= 14; j++) {
                tmp = "grossini_dance_" + (j < 10 ? ("0" + j) : j) + ".png";
                var frame = spriteFrameCache.getSpriteFrame(tmp);
                animFrames.push(frame);
            }

            var animation = cc.Animation.create(animFrames, 0.3);
            sprite.runAction(cc.RepeatForever.create(cc.Animate.create(animation)));

            animFrames = null;

            // skew
            var skewX = cc.SkewBy.create(2, 45, 0);
            var skewX_back = skewX.reverse();
            var skewY = cc.SkewBy.create(2, 0, 45);
            var skewY_back = skewY.reverse();

            var seq_skew = cc.Sequence.create(skewX, skewX_back, skewY, skewY_back);
            sprite.runAction(cc.RepeatForever.create(seq_skew));

            // scale
            var scale = cc.ScaleBy.create(2, 2);
            var scale_back = scale.reverse();
            var seq_scale = cc.Sequence.create(scale, scale_back);
            sprite.runAction(cc.RepeatForever.create(seq_scale));

            spritebatch.addChild(sprite, i);
        }
    },
    //
    // Automation
    //
    testDuration:2,
    pixel:{"0":255, "1":204, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel3":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 4 + 121, winSize.height / 2 + 99, 5, 5);
        var ret2 = this.readPixels(winSize.width / 4 * 2 - 83, winSize.height / 2 - 21, 5, 5);
        var ret3 = this.readPixels(winSize.width / 4 * 3 - 286, winSize.height / 2 - 140, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel) ? "yes" : "no",
            "pixel2":this.containsPixel(ret2, this.pixel) ? "yes" : "no",
            "pixel3":this.containsPixel(ret3, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//
// SpriteOffsetAnchorFlip
//
var SpriteOffsetAnchorFlip = SpriteTestDemo.extend({

    _title:"Sprite offset + anchor + flip",
    _subtitle:"issue #1078",

    ctor:function () {
        this._super();
        spriteFrameCache.addSpriteFrames(s_grossiniPlist);
        spriteFrameCache.addSpriteFrames(s_grossini_grayPlist, s_grossini_gray);

        for (var i = 0; i < 3; i++) {
            //
            // Animation using Sprite batch
            //
            var sprite = cc.Sprite.createWithSpriteFrameName("grossini_dance_01.png");
            sprite.setPosition(winSize.width / 4 * (i + 1), winSize.height / 2);

            var point = cc.Sprite.create(s_pathR1);
            point.setScale(0.25);
            point.setPosition(sprite.getPosition());
            this.addChild(point, 1);

            switch (i) {
                case 0:
                    sprite.setAnchorPoint(0, 0);
                    break;
                case 1:
                    sprite.setAnchorPoint(0.5, 0.5);
                    break;
                case 2:
                    sprite.setAnchorPoint(1, 1);
                    break;
            }

            point.setPosition(sprite.getPosition());

            var animFrames = [];
            var tmp = "";
            for (var j = 1; j <= 14; j++) {
                tmp = "grossini_dance_" + (j < 10 ? ("0" + j) : j) + ".png";
                var frame = spriteFrameCache.getSpriteFrame(tmp);
                animFrames.push(frame);
            }

            var animation = cc.Animation.create(animFrames, 0.3);
            sprite.runAction(cc.RepeatForever.create(cc.Animate.create(animation)));

            animFrames = null;

            var flip = cc.FlipY.create(true);
            var flip_back = cc.FlipY.create(false);
            var delay = cc.DelayTime.create(1);
            var delay1 = cc.DelayTime.create(1);
            var seq = cc.Sequence.create(delay, flip, delay1, flip_back);
            sprite.runAction(cc.RepeatForever.create(seq));

            this.addChild(sprite, 0);
        }
    },
    //
    // Automation
    //
    testDuration:1.5,
    pixel:{"0":255, "1":204, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel3":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 4 + 40, winSize.height / 2 + 18, 5, 5);
        var ret2 = this.readPixels(winSize.width / 4 * 2, winSize.height / 2 - 44, 5, 5);
        var ret3 = this.readPixels(winSize.width / 4 * 3 - 45, winSize.height / 2 - 105, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel) ? "yes" : "no", "pixel2":this.containsPixel(ret2, this.pixel) ? "yes" : "no", "pixel3":this.containsPixel(ret3, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//
// SpriteBatchNodeOffsetAnchorFlip
//
var SpriteBatchNodeOffsetAnchorFlip = SpriteTestDemo.extend({

    _title:"SpriteBatchNode offset + anchor + flip",
    _subtitle:"issue #1078",

    ctor:function () {
        this._super();
        spriteFrameCache.addSpriteFrames(s_grossiniPlist);
        spriteFrameCache.addSpriteFrames(s_grossini_grayPlist, s_grossini_gray);

        var spritebatch = cc.SpriteBatchNode.create(s_grossini);
        this.addChild(spritebatch);

        for (var i = 0; i < 3; i++) {
            //
            // Animation using Sprite batch
            //
            var sprite = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_01.png"));
            sprite.setPosition(winSize.width / 4 * (i + 1), winSize.height / 2);

            var point = cc.Sprite.create(s_pathR1);
            point.setScale(0.25);
            point.setPosition(sprite.getPosition());
            this.addChild(point, 200);

            switch (i) {
                case 0:
                    sprite.setAnchorPoint(0, 0);
                    break;
                case 1:
                    sprite.setAnchorPoint(0.5, 0.5);
                    break;
                case 2:
                    sprite.setAnchorPoint(1, 1);
                    break;
            }

            point.setPosition(sprite.getPosition());

            var animFrames = [];
            var tmp = "";
            for (var j = 1; j <= 14; j++) {
                tmp = "grossini_dance_" + (j < 10 ? ("0" + j) : j) + ".png";
                var frame = spriteFrameCache.getSpriteFrame(tmp);
                animFrames.push(frame);
            }

            var animation = cc.Animation.create(animFrames, 0.3);
            sprite.runAction(cc.RepeatForever.create(cc.Animate.create(animation)));

            animFrames = null;

            var flip = cc.FlipY.create(true);
            var flip_back = cc.FlipY.create(false);
            var delay = cc.DelayTime.create(1);
            var seq = cc.Sequence.create(delay, flip, delay.clone(), flip_back);
            sprite.runAction(cc.RepeatForever.create(seq));

            spritebatch.addChild(sprite, i);
        }
    },
    //
    // Automation
    //
    testDuration:1.5,
    pixel:{"0":255, "1":204, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel3":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 4 + 40, winSize.height / 2 + 18, 5, 5);
        var ret2 = this.readPixels(winSize.width / 4 * 2, winSize.height / 2 - 44, 5, 5);
        var ret3 = this.readPixels(winSize.width / 4 * 3 - 45, winSize.height / 2 - 105, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel) ? "yes" : "no", "pixel2":this.containsPixel(ret2, this.pixel) ? "yes" : "no", "pixel3":this.containsPixel(ret3, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteAnimationSplit
//
//------------------------------------------------------------------
var SpriteAnimationSplit = SpriteTestDemo.extend({

    _title:"Sprite: Animation + flip",
    ctor:function () {
        this._super();
        var texture = cc.TextureCache.getInstance().addImage(s_dragon_animation);

        // manually add frames to the frame cache
        var frame0 = cc.SpriteFrame.createWithTexture(texture, cc.rect(132 * 0, 132 * 0, 132, 132));
        var frame1 = cc.SpriteFrame.createWithTexture(texture, cc.rect(132 * 1, 132 * 0, 132, 132));
        var frame2 = cc.SpriteFrame.createWithTexture(texture, cc.rect(132 * 2, 132 * 0, 132, 132));
        var frame3 = cc.SpriteFrame.createWithTexture(texture, cc.rect(132 * 3, 132 * 0, 132, 132));
        var frame4 = cc.SpriteFrame.createWithTexture(texture, cc.rect(132 * 0, 132 * 1, 132, 132));
        var frame5 = cc.SpriteFrame.createWithTexture(texture, cc.rect(132 * 1, 132 * 1, 132, 132));

        //
        // Animation using Sprite BatchNode
        //
        var sprite = cc.Sprite.createWithSpriteFrame(frame0);
        sprite.setPosition(winSize.width / 2, winSize.height / 2);
        this.addChild(sprite);

        var animFrames = [];
        animFrames.push(frame0);
        animFrames.push(frame1);
        animFrames.push(frame2);
        animFrames.push(frame3);
        animFrames.push(frame4);
        animFrames.push(frame5);

        var animation = cc.Animation.create(animFrames, 0.2);
        var animate = cc.Animate.create(animation);
        var delay = cc.DelayTime.create(0.5);
        var seq = cc.Sequence.create(animate,
            cc.FlipX.create(true),
            animate.clone(),
            delay,
            cc.FlipX.create(false));

        sprite.runAction(cc.RepeatForever.create(seq));
    },
    onExit:function () {
        this._super();
    },
    //
    // Automation
    //
    testDuration:2.8,
    pixel1:{"0":208, "1":208, "2":208, "3":255},
    pixel2:{"0":0, "1":0, "2":0, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 2 + 52, winSize.height / 2 - 29, 5, 5);
        var ret2 = this.readPixels(winSize.width / 2, winSize.height / 2 - 22, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel1, true, 3) ? "yes" : "no",
            "pixel2":this.containsPixel(ret2, this.pixel2, false) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteHybrid
//
//------------------------------------------------------------------
var SpriteHybrid = SpriteTestDemo.extend({
    _usingSpriteBatchNode:false,
    _title:"Hybrid.Sprite* sprite Test",

    ctor:function () {
        this._super();
        // parents
        var parent1 = cc.Node.create();
        var parent2 = cc.SpriteBatchNode.create(s_grossini, 50);

        this.addChild(parent1, 0, TAG_NODE);
        this.addChild(parent2, 0, TAG_SPRITE_BATCH_NODE);

        // IMPORTANT:
        // The sprite frames will be cached AND RETAINED, and they won't be released unless you call
        spriteFrameCache.addSpriteFrames(s_grossiniPlist);

        // create 250 sprites
        // only show 80% of them
        for (var i = 1; i <= 250; i++) {
            var spriteIdx = Math.round(Math.random() * 14);
            if (spriteIdx === 0)
                spriteIdx = 1;
            var str = "grossini_dance_" + (spriteIdx < 10 ? ("0" + spriteIdx) : spriteIdx) + ".png";

            var frame = spriteFrameCache.getSpriteFrame(str);
            var sprite = cc.Sprite.createWithSpriteFrame(frame);
            parent1.addChild(sprite, i, i);

            var x = -1000;
            var y = -1000;
            if (Math.random() < 0.2) {
                x = Math.random() * winSize.width;
                y = Math.random() * winSize.height;
            }
            sprite.setPosition(x, y);

            var action = cc.RotateBy.create(4, 360);
            sprite.runAction(cc.RepeatForever.create(action));
        }

        this._usingSpriteBatchNode = false;

        this.schedule(this.reparentSprite, 2);
    },
    onExit:function () {
        this._super();
        spriteFrameCache.removeSpriteFramesFromFile(s_grossiniPlist);
    },
    reparentSprite:function () {
        var p1 = this.getChildByTag(TAG_NODE);
        var p2 = this.getChildByTag(TAG_SPRITE_BATCH_NODE);

        var retArray = [];
        var node;

        if (this._usingSpriteBatchNode) {
            var tempNode = p2;
            p2 = p1;
            p1 = tempNode;
        }
        ////----UXLog("New parent is: %x", p2);

        var children = p1.getChildren();
        for (var i = 0; i < children.length; i++) {
            node = children[i];
            if (!node)
                break;

            retArray.push(node);
        }

        p1.removeAllChildren(false);
        for (i = 0; i < retArray.length; i++) {
            node = retArray[i];
            if (!node)
                break;

            p2.addChild(node, i, i);
        }

        this._usingSpriteBatchNode = !this._usingSpriteBatchNode;
    },
    //
    // Automation
    //
    testDuration:2.5,
    pixel:{"0":51, "1":0, "2":51, "3":255},
    firstPixel1:false,
    firstPixel2:false,
    setupAutomation:function () {
        this.scheduleOnce(this.addTestSprite, 1);
        this.scheduleOnce(this.checkFirstPixel, 1.5);
    },
    addTestSprite:function () {
        var p = this.getChildByTag(TAG_NODE);
        var frame = spriteFrameCache.getSpriteFrame("grossini_dance_01.png");
        var sprite1 = cc.Sprite.createWithSpriteFrame(frame);
        sprite1.retain();
        p.addChild(sprite1, 1000);
        sprite1.setPosition(winSize.width / 4, winSize.height / 2);
        var sprite2 = cc.Sprite.createWithSpriteFrame(frame);
        sprite2.retain();
        p.addChild(sprite2, 1000);
        sprite2.setPosition(winSize.width / 2, winSize.height / 2);
    },
    checkFirstPixel:function () {
        var ret1 = this.readPixels(winSize.width / 4, winSize.height / 2, 5, 5);
        var ret2 = this.readPixels(winSize.width / 2, winSize.height / 2, 5, 5);
        this.firstPixel1 = this.containsPixel(ret1, this.pixel);
        this.firstPixel2 = this.containsPixel(ret2, this.pixel);
    },
    getExpectedResult:function () {
        var ret = {"firstPixel1":true, "firstPixel2":true, "secondPixel1":true, "pixel2":true};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var pixel1 = this.readPixels(winSize.width / 4, winSize.height / 2, 5, 5);
        var pixel2 = this.readPixels(winSize.width / 2, winSize.height / 2, 5, 5);
        var secondPixel1 = this.containsPixel(pixel1, this.pixel);
        var secondPixel2 = this.containsPixel(pixel2, this.pixel);
        var ret = {"firstPixel1":this.firstPixel1, "firstPixel2":this.firstPixel2, "secondPixel1":secondPixel1, "pixel2":secondPixel2};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteBatchNodeChildren
//
//------------------------------------------------------------------
var SpriteBatchNodeChildren = SpriteTestDemo.extend({

    _title:"SpriteBatchNode Grand Children",

    ctor:function () {
        this._super();
        // parents
        var batch = cc.SpriteBatchNode.create(s_grossini, 50);
        this.addChild(batch, 0, TAG_SPRITE_BATCH_NODE);

        spriteFrameCache.addSpriteFrames(s_grossiniPlist);

        var sprite1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_01.png"));
        sprite1.setPosition(winSize.width / 3, winSize.height / 2);

        var sprite2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_02.png"));
        sprite2.setPosition(50, 50);

        var sprite3 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_03.png"));
        sprite3.setPosition(-50, -50);

        batch.addChild(sprite1);
        sprite1.addChild(sprite2);
        sprite1.addChild(sprite3);

        // BEGIN NEW CODE
        var animFrames = [];
        var str = "";
        for (var i = 1; i < 15; i++) {
            str = "grossini_dance_" + (i < 10 ? ("0" + i) : i) + ".png";
            var frame = spriteFrameCache.getSpriteFrame(str);
            animFrames.push(frame);
        }

        var animation = cc.Animation.create(animFrames, 0.2);
        sprite1.runAction(cc.RepeatForever.create(cc.Animate.create(animation)));
        // END NEW CODE

        var action = cc.MoveBy.create(2, cc.p(200, 0));
        var action_back = action.reverse();
        var action_rot = cc.RotateBy.create(2, 360);
        var action_s = cc.ScaleBy.create(2, 2);
        var action_s_back = action_s.reverse();

        var seq2 = action_rot.reverse();
        sprite2.runAction(cc.RepeatForever.create(seq2));

        sprite1.runAction(cc.RepeatForever.create(action_rot));
        sprite1.runAction(cc.RepeatForever.create(cc.Sequence.create(action, action_back)));
        sprite1.runAction(cc.RepeatForever.create(cc.Sequence.create(action_s, action_s_back)));
    },
    //
    // Automation
    //
    testDuration:0.5,
    pixel:{"0":255, "1":204, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 3 - 47, winSize.height / 2 + 107, 5, 5);
        var ret2 = this.readPixels(winSize.width / 3 + 95, winSize.height / 2 - 5, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel) ? "yes" : "no", "pixel2":this.containsPixel(ret2, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteBatchNodeChildrenZ
//
//------------------------------------------------------------------
var SpriteBatchNodeChildrenZ = SpriteTestDemo.extend({

    _title:"SpriteBatchNode Children Z",

    ctor:function () {
        this._super();
        // parents
        var batch;
        var sprite1, sprite2, sprite3;
        spriteFrameCache.addSpriteFrames(s_grossiniPlist);

        // test 1
        batch = cc.SpriteBatchNode.create(s_grossini, 50);
        this.addChild(batch, 0, TAG_SPRITE_BATCH_NODE);

        sprite1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_01.png"));
        sprite1.setPosition(winSize.width / 3, winSize.height / 2);

        sprite2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_02.png"));
        sprite2.setPosition(20, 30);

        sprite3 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_03.png"));
        sprite3.setPosition(-20, 30);

        batch.addChild(sprite1);
        sprite1.addChild(sprite2, 2);
        sprite1.addChild(sprite3, -2);

        // test 2
        batch = cc.SpriteBatchNode.create(s_grossini, 50);
        this.addChild(batch, 0, TAG_SPRITE_BATCH_NODE);

        sprite1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_01.png"));
        sprite1.setPosition(2 * winSize.width / 3, winSize.height / 2);

        sprite2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_02.png"));
        sprite2.setPosition(20, 30);

        sprite3 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_03.png"));
        sprite3.setPosition(-20, 30);

        batch.addChild(sprite1);
        sprite1.addChild(sprite2, -2);
        sprite1.addChild(sprite3, 2);

        // test 3
        batch = cc.SpriteBatchNode.create(s_grossini, 50);
        this.addChild(batch, 0, TAG_SPRITE_BATCH_NODE);

        sprite1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_01.png"));
        sprite1.setPosition(winSize.width / 2 - 90, winSize.height / 4);

        sprite2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_02.png"));
        sprite2.setPosition(winSize.width / 2 - 60, winSize.height / 4);

        sprite3 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_03.png"));
        sprite3.setPosition(winSize.width / 2 - 30, winSize.height / 4);

        batch.addChild(sprite1, 10);
        batch.addChild(sprite2, -10);
        batch.addChild(sprite3, -5);

        // test 4
        batch = cc.SpriteBatchNode.create(s_grossini, 50);
        this.addChild(batch, 0, TAG_SPRITE_BATCH_NODE);

        sprite1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_01.png"));
        sprite1.setPosition(winSize.width / 2 + 30, winSize.height / 4);

        sprite2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_02.png"));
        sprite2.setPosition(winSize.width / 2 + 60, winSize.height / 4);

        sprite3 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_03.png"));
        sprite3.setPosition(winSize.width / 2 + 90, winSize.height / 4);

        batch.addChild(sprite1, -10);
        batch.addChild(sprite2, -5);
        batch.addChild(sprite3, -2);
    },
    //
    // Automation
    //
    testDuration:1,
    pixel1:{"0":51, "1":0, "2":51, "3":255},
    pixel2:{"0":51, "1":0, "2":51, "3":255},
    pixel3:{"0":255, "1":204, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel3":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(2 * winSize.width / 3 - 20, winSize.height / 2, 5, 5);
        var ret2 = this.readPixels(winSize.width / 3 - 20, winSize.height / 2 + 115, 5, 5);
        var ret3 = this.readPixels(winSize.width / 2 + 30, winSize.height / 4 - 10, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel1) ? "yes" : "no",
            "pixel2":!this.containsPixel(ret2, this.pixel2) ? "yes" : "no",
            "pixel3":this.containsPixel(ret3, this.pixel3) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteChildrenVisibility
//
//------------------------------------------------------------------
var SpriteChildrenVisibility = SpriteTestDemo.extend({
    _title:"Sprite & SpriteBatchNode Visibility",

    ctor:function () {
        this._super();

        spriteFrameCache.addSpriteFrames(s_grossiniPlist);
        //
        // SpriteBatchNode
        //
        // parents
        var aParent = cc.SpriteBatchNode.create(s_grossini, 50);
        aParent.setPosition(winSize.width / 3, winSize.height / 2);
        this.addChild(aParent, 0);

        var sprite1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_01.png"));
        sprite1.setPosition(0, 0);

        var sprite2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_02.png"));
        sprite2.setPosition(20, 30);

        var sprite3 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_03.png"));
        sprite3.setPosition(-20, 30);

        aParent.addChild(sprite1);
        sprite1.addChild(sprite2, -2);
        sprite1.addChild(sprite3, 2);

        sprite1.runAction(cc.Blink.create(5, 10));

        //
        // Sprite
        //
        aParent = cc.Node.create();
        aParent.setPosition(2 * winSize.width / 3, winSize.height / 2);
        this.addChild(aParent, 0);

        sprite1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_01.png"));
        sprite1.setPosition(0, 0);

        sprite2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_02.png"));
        sprite2.setPosition(20, 30);

        sprite3 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_03.png"));
        sprite3.setPosition(-20, 30);

        aParent.addChild(sprite1);
        sprite1.addChild(sprite2, -2);
        sprite1.addChild(sprite3, 2);

        sprite1.runAction(cc.Blink.create(5, 10));
    },
    //
    // Automation
    //
    testDuration:1.7,
    pixel1:{"0":0, "1":0, "2":0, "3":255},
    pixel2:{"0":255, "1":204, "2":153, "3":255},
    visible1:null,
    visible2:null,
    setupAutomation:function () {
        this.scheduleOnce(this.getSpriteVisible, 1.2);
    },
    getSpriteVisible:function () {
        var ret1 = this.readPixels(winSize.width / 3, winSize.height / 2 + 38, 5, 5);
        var ret2 = this.readPixels(2 * winSize.width / 3, winSize.height / 2 + 38, 5, 5);
        this.visible1 = this.containsPixel(ret1, this.pixel1) ? "true" : "false";
        this.visible2 = this.containsPixel(ret2, this.pixel1) ? "true" : "false";
    },
    getExpectedResult:function () {
        var ret = {"visible1":"true", "visible2":"true", "visible3":"false", "visible4":"false"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 3, winSize.height / 2 + 38, 5, 5);
        var ret2 = this.readPixels(2 * winSize.width / 3, winSize.height / 2 + 38, 5, 5);
        this.visible3 = this.containsPixel(ret1, this.pixel2) ? "true" : "false";
        this.visible4 = this.containsPixel(ret2, this.pixel2) ? "true" : "false";
        var ret = {"visible1":this.visible1, "visible2":this.visible2, "visible3":this.visible3, "visible4":this.visible4};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteChildrenVisibilityIssue665
//
//------------------------------------------------------------------
var SpriteChildrenVisibilityIssue665 = SpriteTestDemo.extend({

    _title:"Sprite & SpriteBatchNode Visibility",
    _subtitle:"No sprites should be visible",

    ctor:function () {
        this._super();
        spriteFrameCache.addSpriteFrames(s_grossiniPlist);
        //
        // SpriteBatchNode
        //
        // parents
        var aParent = cc.SpriteBatchNode.create(s_grossini, 50);
        aParent.setPosition(winSize.width / 3, winSize.height / 2);
        this.addChild(aParent, 0);

        var sprite1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_01.png"));
        sprite1.setPosition(0, 0);

        var sprite2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_02.png"));
        sprite2.setPosition(20, 30);

        var sprite3 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_03.png"));
        sprite3.setPosition(-20, 30);

        // test issue #665
        sprite1.setVisible(false);

        aParent.addChild(sprite1);
        sprite1.addChild(sprite2, -2);
        sprite1.addChild(sprite3, 2);

        //
        // Sprite
        //
        aParent = cc.Node.create();
        aParent.setPosition(2 * winSize.width / 3, winSize.height / 2);
        this.addChild(aParent, 0);

        sprite1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_01.png"));
        sprite1.setPosition(0, 0);

        sprite2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_02.png"));
        sprite2.setPosition(20, 30);

        sprite3 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_03.png"));
        sprite3.setPosition(-20, 30);

        // test issue #665
        sprite1.setVisible(false);

        aParent.addChild(sprite1);
        sprite1.addChild(sprite2, -2);
        sprite1.addChild(sprite3, 2);
    },
    //
    // Automation
    //
    testDuration:1,
    pixel:{"0":0, "1":0, "2":0, "3":255},
    getExpectedResult:function () {
        var ret = {"visible1":"false", "visible2":"false"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 3, winSize.height / 2 + 38, 5, 5);
        var ret2 = this.readPixels(2 * winSize.width / 3, winSize.height / 2 + 38, 5, 5);
        var ret = {"visible1":this.containsPixel(ret1, this.pixel) ? "false" : "true", "visible2":this.containsPixel(ret2, this.pixel) ? "false" : "true"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteChildrenAnchorPoint
//
//------------------------------------------------------------------
var SpriteChildrenAnchorPoint = SpriteTestDemo.extend({

    _title:"Sprite: children + anchor",

    ctor:function () {
        this._super();
        spriteFrameCache.addSpriteFrames(s_grossiniPlist);

        var aParent = cc.Node.create();
        this.addChild(aParent, 0);

        // anchor (0,0)
        var sprite1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_08.png"));
        sprite1.setPosition(winSize.width / 4, winSize.height / 2);
        sprite1.setAnchorPoint(0, 0);

        var sprite2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_02.png"));
        sprite2.setPosition(20, 30);

        var sprite3 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_03.png"));
        sprite3.setPosition(-20, 30);

        var sprite4 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_04.png"));
        sprite4.setPosition(0, 0);
        sprite4.setScale(0.5);

        aParent.addChild(sprite1);
        sprite1.addChild(sprite2, -2);
        sprite1.addChild(sprite3, -2);
        sprite1.addChild(sprite4, 3);

        var point = cc.Sprite.create(s_pathR1);
        point.setScale(0.25);
        point.setPosition(sprite1.getPosition());
        this.addChild(point, 10);

        // anchor (0.5, 0.5)
        sprite1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_08.png"));
        sprite1.setPosition(winSize.width / 2, winSize.height / 2);
        sprite1.setAnchorPoint(0.5, 0.5);

        sprite2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_02.png"));
        sprite2.setPosition(20, 30);

        sprite3 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_03.png"));
        sprite3.setPosition(-20, 30);

        sprite4 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_04.png"));
        sprite4.setPosition(0, 0);
        sprite4.setScale(0.5);

        aParent.addChild(sprite1);
        sprite1.addChild(sprite2, -2);
        sprite1.addChild(sprite3, -2);
        sprite1.addChild(sprite4, 3);

        point = cc.Sprite.create(s_pathR1);
        point.setScale(0.25);
        point.setPosition(sprite1.getPosition());
        this.addChild(point, 10);

        // anchor (1,1)
        sprite1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_08.png"));
        sprite1.setPosition(winSize.width / 2 + winSize.width / 4, winSize.height / 2);
        sprite1.setAnchorPoint(1, 1);

        sprite2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_02.png"));
        sprite2.setPosition(20, 30);

        sprite3 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_03.png"));
        sprite3.setPosition(-20, 30);

        sprite4 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_04.png"));
        sprite4.setPosition(0, 0);
        sprite4.setScale(0.5);

        aParent.addChild(sprite1);
        sprite1.addChild(sprite2, -2);
        sprite1.addChild(sprite3, -2);
        sprite1.addChild(sprite4, 3);

        point = cc.Sprite.create(s_pathR1);
        point.setScale(0.25);
        point.setPosition(sprite1.getPosition());
        this.addChild(point, 10);
    },
    //
    // Automation
    //
    testDuration:1,
    pixel:{"0":255, "1":204, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel2":"yes", "pixel3":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(3 * winSize.width / 4 - 87, winSize.height / 2 - 99, 5, 5);
        var ret2 = this.readPixels(2 * winSize.width / 4 - 59, winSize.height / 2 - 66, 5, 5);
        var ret3 = this.readPixels(winSize.width / 4 - 15, winSize.height / 2 - 6, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel) ? "yes" : "no", "pixel2":this.containsPixel(ret2, this.pixel) ? "yes" : "no", "pixel3":this.containsPixel(ret3, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteBatchNodeChildrenAnchorPoint
//
//------------------------------------------------------------------
var SpriteBatchNodeChildrenAnchorPoint = SpriteTestDemo.extend({

    _title:"SpriteBatchNode: children + anchor",

    ctor:function () {
        this._super();

        spriteFrameCache.addSpriteFrames(s_grossiniPlist);
        //
        // SpriteBatchNode
        //
        // parents
        var aParent = cc.SpriteBatchNode.create(s_grossini, 50);
        this.addChild(aParent, 0);

        // anchor (0,0)
        var sprite1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_08.png"));
        sprite1.setPosition(winSize.width / 4, winSize.height / 2);
        sprite1.setAnchorPoint(0, 0);

        var sprite2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_02.png"));
        sprite2.setPosition(20, 30);

        var sprite3 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_03.png"));
        sprite3.setPosition(-20, 30);

        var sprite4 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_04.png"));
        sprite4.setPosition(0, 0);
        sprite4.setScale(0.5);

        aParent.addChild(sprite1);
        sprite1.addChild(sprite2, -2);
        sprite1.addChild(sprite3, -2);
        sprite1.addChild(sprite4, 3);

        var point = cc.Sprite.create(s_pathR1);
        point.setScale(0.25);
        point.setPosition(sprite1.getPosition());
        this.addChild(point, 10);

        // anchor (0.5, 0.5)
        sprite1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_08.png"));
        sprite1.setPosition(winSize.width / 2, winSize.height / 2);
        sprite1.setAnchorPoint(0.5, 0.5);

        sprite2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_02.png"));
        sprite2.setPosition(20, 30);

        sprite3 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_03.png"));
        sprite3.setPosition(-20, 30);

        sprite4 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_04.png"));
        sprite4.setPosition(0, 0);
        sprite4.setScale(0.5);

        aParent.addChild(sprite1);
        sprite1.addChild(sprite2, -2);
        sprite1.addChild(sprite3, -2);
        sprite1.addChild(sprite4, 3);

        point = cc.Sprite.create(s_pathR1);
        point.setScale(0.25);
        point.setPosition(sprite1.getPosition());
        this.addChild(point, 10);


        // anchor (1,1)
        sprite1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_08.png"));
        sprite1.setPosition(winSize.width / 2 + winSize.width / 4, winSize.height / 2);
        sprite1.setAnchorPoint(1, 1);

        sprite2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_02.png"));
        sprite2.setPosition(20, 30);

        sprite3 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_03.png"));
        sprite3.setPosition(-20, 30);

        sprite4 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossini_dance_04.png"));
        sprite4.setPosition(0, 0);
        sprite4.setScale(0.5);

        aParent.addChild(sprite1);
        sprite1.addChild(sprite2, -2);
        sprite1.addChild(sprite3, -2);
        sprite1.addChild(sprite4, 3);

        point = cc.Sprite.create(s_pathR1);
        point.setScale(0.25);
        point.setPosition(sprite1.getPosition());
        this.addChild(point, 10);
    },
    //
    // Automation
    //
    testDuration:1,
    pixel:{"0":255, "1":204, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel2":"yes", "pixel3":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(3 * winSize.width / 4 - 87, winSize.height / 2 - 99, 5, 5);
        var ret2 = this.readPixels(2 * winSize.width / 4 - 59, winSize.height / 2 - 66, 5, 5);
        var ret3 = this.readPixels(winSize.width / 4 - 15, winSize.height / 2 - 6, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel) ? "yes" : "no", "pixel2":this.containsPixel(ret2, this.pixel) ? "yes" : "no", "pixel3":this.containsPixel(ret3, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteBatchNodeChildrenScale
//
//------------------------------------------------------------------
var SpriteBatchNodeChildrenScale = SpriteTestDemo.extend({

    _title:"Sprite/BatchNode + child + scale + rot",

    ctor:function () {
        this._super();
        spriteFrameCache.addSpriteFrames(s_grossini_familyPlist);

        var rot = cc.RotateBy.create(10, 360);
        var seq = cc.RepeatForever.create(rot);

        //
        // Children + Scale using Sprite
        // Test 1
        //
        var aParent = cc.Node.create();
        var sprite1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossinis_sister1.png"));
        sprite1.setPosition(winSize.width / 4, winSize.height / 4);
        sprite1.setScaleX(0.5);
        sprite1.setScaleY(2.0);
        sprite1.runAction(seq);


        var sprite2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossinis_sister2.png"));
        sprite2.setPosition(50, 0);

        this.addChild(aParent);
        aParent.addChild(sprite1);
        sprite1.addChild(sprite2);

        rot = cc.RotateBy.create(10, 360);
        seq = cc.RepeatForever.create(rot);
        //
        // Children + Scale using SpriteBatchNode
        // Test 2
        //
        aParent = cc.SpriteBatchNode.create(s_grossini_family);
        sprite1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossinis_sister1.png"));
        sprite1.setPosition(3 * winSize.width / 4, winSize.height / 4);
        sprite1.setScaleX(0.5);
        sprite1.setScaleY(2.0);
        sprite1.runAction(seq);

        sprite2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossinis_sister2.png"));
        sprite2.setPosition(50, 0);

        this.addChild(aParent);
        aParent.addChild(sprite1);
        sprite1.addChild(sprite2);

        rot = cc.RotateBy.create(10, 360);
        seq = cc.RepeatForever.create(rot);
        //
        // Children + Scale using Sprite
        // Test 3
        //
        aParent = cc.Node.create();
        sprite1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossinis_sister1.png"));
        sprite1.setPosition(winSize.width / 4, 2 * winSize.height / 3);
        sprite1.setScaleX(1.5);
        sprite1.setScaleY(0.5);
        sprite1.runAction(seq);

        sprite2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossinis_sister2.png"));
        sprite2.setPosition(50, 0);

        this.addChild(aParent);
        aParent.addChild(sprite1);
        sprite1.addChild(sprite2);

        rot = cc.RotateBy.create(10, 360);
        seq = cc.RepeatForever.create(rot);
        //
        // Children + Scale using Sprite
        // Test 4
        //
        aParent = cc.SpriteBatchNode.create(s_grossini_family);
        sprite1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossinis_sister1.png"));
        sprite1.setPosition(3 * winSize.width / 4, 2 * winSize.height / 3);
        sprite1.setScaleX(1.5);
        sprite1.setScaleY(0.5);
        sprite1.runAction(seq);

        sprite2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("grossinis_sister2.png"));
        sprite2.setPosition(50, 0);

        this.addChild(aParent);
        aParent.addChild(sprite1);
        sprite1.addChild(sprite2);
    },
    //
    // Automation
    //
    testDuration:2.5,
    pixel1:{"0":56, "1":116, "2":142, "3":255},
    pixel2:{"0":0, "1":0, "2":0, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel3":"yes", "pixel4":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 4 - 31, 2 * winSize.height / 3 + 16, 5, 5);
        var ret2 = this.readPixels(winSize.width / 4 - 38, 2 * winSize.height / 3 + 16, 3, 3);
        var ret3 = this.readPixels(3 * winSize.width / 4 - 31, 2 * winSize.height / 3 + 16, 5, 5);
        var ret4 = this.readPixels(3 * winSize.width / 4 - 38, 2 * winSize.height / 3 + 16, 3, 3);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel1) ? "yes" : "no",
            "pixel2":this.containsPixel(ret2, this.pixel2) ? "yes" : "no",
            "pixel3":this.containsPixel(ret3, this.pixel1) ? "yes" : "no",
            "pixel4":this.containsPixel(ret4, this.pixel2) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteChildrenChildren
//
//------------------------------------------------------------------
var SpriteChildrenChildren = SpriteTestDemo.extend({
    _title:"Sprite multiple levels of children",

    ctor:function () {
        this._super();

        spriteFrameCache.addSpriteFrames(s_ghostsPlist);

        var rot = cc.RotateBy.create(10, 360);
        var seq = cc.RepeatForever.create(rot);

        var rot_back = rot.reverse();
        var rot_back_fe = cc.RepeatForever.create(rot_back);

        //
        // SpriteBatchNode: 3 levels of children
        //
        var aParent = cc.Node.create();
        this.addChild(aParent);

        // parent
        var l1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("father.gif"));
        l1.setPosition(winSize.width / 2, winSize.height / 2);
        l1.runAction(seq.clone());
        aParent.addChild(l1);
        var l1Size = l1.getContentSize();

        // child left
        var l2a = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("sister1.gif"));
        l2a.setPosition(-50 + l1Size.width / 2, 0 + l1Size.height / 2);
        l2a.runAction(rot_back_fe.clone());
        l1.addChild(l2a);
        var l2aSize = l2a.getContentSize();


        // child right
        var l2b = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("sister2.gif"));
        l2b.setPosition(+50 + l1Size.width / 2, 0 + l1Size.height / 2);
        l2b.runAction(rot_back_fe.clone());
        l1.addChild(l2b);
        var l2bSize = l2a.getContentSize();


        // child left bottom
        var l3a1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("child1.gif"));
        l3a1.setScale(0.45);
        l3a1.setPosition(0 + l2aSize.width / 2, -100 + l2aSize.height / 2);
        l2a.addChild(l3a1);

        // child left top
        var l3a2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("child1.gif"));
        l3a2.setScale(0.45);
        l3a2.setPosition(0 + l2aSize.width / 2, +100 + l2aSize.height / 2);
        l2a.addChild(l3a2);

        // child right bottom
        var l3b1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("child1.gif"));
        l3b1.setScale(0.45);
        l3b1.setFlippedY(true);
        l3b1.setPosition(0 + l2bSize.width / 2, -100 + l2bSize.height / 2);
        l2b.addChild(l3b1);

        // child right top
        var l3b2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("child1.gif"));
        l3b2.setScale(0.45);
        l3b2.setFlippedY(true);
        l3b2.setPosition(0 + l2bSize.width / 2, +100 + l2bSize.height / 2);
        l2b.addChild(l3b2);
    },
    //
    // Automation
    //
    testDuration:4,
    pixel:{"0":153, "1":204, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel3":"yes", "pixel4":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 2 + 42, winSize.height / 2 + 145, 5, 5);
        var ret2 = this.readPixels(winSize.width / 2 - 39, winSize.height / 2 + 55, 5, 5);
        var ret3 = this.readPixels(winSize.width / 2 - 39, winSize.height / 2 - 146, 5, 5);
        var ret4 = this.readPixels(winSize.width / 2 + 42, winSize.height / 2 - 56, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel) ? "yes" : "no",
            "pixel2":this.containsPixel(ret2, this.pixel) ? "yes" : "no",
            "pixel3":this.containsPixel(ret3, this.pixel) ? "yes" : "no",
            "pixel4":this.containsPixel(ret4, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteBatchNodeChildrenChildren
//
//------------------------------------------------------------------
var SpriteBatchNodeChildrenChildren = SpriteTestDemo.extend({

    _title:"SpriteBatchNode multiple levels of children",

    ctor:function () {
        this._super();

        spriteFrameCache.addSpriteFrames(s_ghostsPlist);

        var rot = cc.RotateBy.create(10, 360);
        var seq = cc.RepeatForever.create(rot);

        var rot_back = rot.reverse();
        var rot_back_fe = cc.RepeatForever.create(rot_back);

        //
        // SpriteBatchNode: 3 levels of children
        //
        var aParent = cc.SpriteBatchNode.create(s_ghosts);
        if ("opengl" in sys.capabilities)
            aParent.getTexture().generateMipmap();
        this.addChild(aParent);

        // parent
        var l1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("father.gif"));
        l1.setPosition(winSize.width / 2, winSize.height / 2);
        l1.runAction(seq.clone());
        aParent.addChild(l1);
        var l1Size = l1.getContentSize();

        // child left
        var l2a = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("sister1.gif"));
        l2a.setPosition(-50 + l1Size.width / 2, 0 + l1Size.height / 2);
        l2a.runAction(rot_back_fe.clone());
        l1.addChild(l2a);
        var l2aSize = l2a.getContentSize();


        // child right
        var l2b = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("sister2.gif"));
        l2b.setPosition(50 + l1Size.width / 2, 0 + l1Size.height / 2);
        l2b.runAction(rot_back_fe.clone());
        l1.addChild(l2b);
        var l2bSize = l2a.getContentSize();


        // child left bottom
        var l3a1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("child1.gif"));
        l3a1.setScale(0.45);
        l3a1.setPosition(0 + l2aSize.width / 2, -100 + l2aSize.height / 2);
        l2a.addChild(l3a1);

        // child left top
        var l3a2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("child1.gif"));
        l3a2.setScale(0.45);
        l3a2.setPosition(0 + l2aSize.width / 2, +100 + l2aSize.height / 2);
        l2a.addChild(l3a2);

        // child right bottom
        var l3b1 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("child1.gif"));
        l3b1.setScale(0.45);
        l3b1.setFlippedY(true);
        l3b1.setPosition(0 + l2bSize.width / 2, -100 + l2bSize.height / 2);
        l2b.addChild(l3b1);

        // child right top
        var l3b2 = cc.Sprite.createWithSpriteFrame(spriteFrameCache.getSpriteFrame("child1.gif"));
        l3b2.setScale(0.45);
        l3b2.setFlippedY(true);
        l3b2.setPosition(0 + l2bSize.width / 2, +100 + l2bSize.height / 2);
        l2b.addChild(l3b2);
    },
    //
    // Automation
    //
    testDuration:4,
    pixel:{"0":153, "1":204, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel3":"yes", "pixel4":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 2 + 42, winSize.height / 2 + 145, 5, 5);
        var ret2 = this.readPixels(winSize.width / 2 - 39, winSize.height / 2 + 55, 5, 5);
        var ret3 = this.readPixels(winSize.width / 2 - 39, winSize.height / 2 - 146, 5, 5);
        var ret4 = this.readPixels(winSize.width / 2 + 42, winSize.height / 2 - 56, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel) ? "yes" : "no",
            "pixel2":this.containsPixel(ret2, this.pixel) ? "yes" : "no",
            "pixel3":this.containsPixel(ret3, this.pixel) ? "yes" : "no",
            "pixel4":this.containsPixel(ret4, this.pixel) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteNilTexture
//
//------------------------------------------------------------------
var SpriteNilTexture = SpriteTestDemo.extend({

    _title:"Sprite without texture",
    _subtitle:"opacity and color should work",

    ctor:function () {
        this._super();

        // TEST: If no texture is given, then Opacity + Color should work.
        var sprite = cc.Sprite.create();
        sprite.setTextureRect(cc.rect(0, 0, 300, 300));
        // sprite.setColor(cc.red());
        sprite.setColor(cc.c3b(255, 0, 0));
        sprite.setOpacity(128);
        sprite.setPosition(3 * winSize.width / 4, winSize.height / 2);
        this.addChild(sprite, 100);

        sprite = cc.Sprite.create();
        sprite.setTextureRect(cc.rect(0, 0, 300, 300));
        //sprite.setColor(cc.blue());
        sprite.setColor(cc.c3b(0, 0, 255));
        sprite.setOpacity(128);
        sprite.setPosition(winSize.width / 4, winSize.height / 2);
        this.addChild(sprite, 100);
    },
    //
    // Automation
    //
    testDuration:1,
    pixel1:{"0":0, "1":0, "2":128, "3":255},
    pixel2:{"0":128, "1":0, "2":0, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 4, winSize.height / 2, 5, 5);
        var ret2 = this.readPixels(3 * winSize.width / 4, winSize.height / 2, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel1) ? "yes" : "no", "pixel2":this.containsPixel(ret2, this.pixel2) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// SpriteSubclass
//
//------------------------------------------------------------------
var MySprite1 = cc.Sprite.extend({
    _ivar:0
});

MySprite1.spriteWithSpriteFrameName = function (spriteFrameName) {
    var pFrame = spriteFrameCache.getSpriteFrame(spriteFrameName);
    var sprite = new MySprite1();
    sprite.initWithSpriteFrame(pFrame);

    return sprite;
};

var MySprite2 = cc.Sprite.extend({
    _ivar:0
});

MySprite2.spriteWithFile = function (name) {
    var sprite = new MySprite2();
    sprite.init(name);
    return sprite;
};

var SpriteSubclass = SpriteTestDemo.extend({
    _title:"Sprite subclass",
    _subtitle:"Testing initWithTexture:rect method",

    ctor:function () {
        this._super();

        spriteFrameCache.addSpriteFrames(s_ghostsPlist);
        var aParent = cc.SpriteBatchNode.create(s_ghosts);

        // MySprite1
        var sprite = MySprite1.spriteWithSpriteFrameName("father.gif");
        sprite.setPosition(winSize.width / 4, winSize.height / 2);
        aParent.addChild(sprite);
        this.addChild(aParent);

        // MySprite2
        var sprite2 = MySprite2.spriteWithFile(s_pathGrossini);
        this.addChild(sprite2);
        sprite2.setPosition(winSize.width / 4 * 3, winSize.height / 2);
    },
    //
    // Automation
    //
    testDuration:1,
    pixel1:{"0":249, "1":30, "2":20, "3":255},
    pixel2:{"0":255, "1":204, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 4, winSize.height / 2 - 15, 5, 5);
        var ret2 = this.readPixels(winSize.width / 4 * 3, winSize.height / 2 + 44, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel1) ? "yes" : "no", "pixel2":this.containsPixel(ret2, this.pixel2) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

//------------------------------------------------------------------
//
// AnimationCache
//
//------------------------------------------------------------------
var AnimationCacheTest = SpriteTestDemo.extend({

    _title:"AnimationCache",
    _subtitle:"Sprite should be animated",

    ctor:function () {
        this._super();
        spriteFrameCache.addSpriteFrames(s_grossiniPlist);
        spriteFrameCache.addSpriteFrames(s_grossini_grayPlist);
        spriteFrameCache.addSpriteFrames(s_grossini_bluePlist);

        //
        // create animation "dance"
        //
        var animFrames = [];
        var frame;
        var str = "";
        for (var i = 1; i < 15; i++) {
            str = "grossini_dance_" + (i < 10 ? ("0" + i) : i) + ".png";
            frame = spriteFrameCache.getSpriteFrame(str);
            animFrames.push(frame);
        }

        var animation = cc.Animation.create(animFrames, 0.2);

        // Add an animation to the Cache
        cc.AnimationCache.getInstance().addAnimation(animation, "dance");

        //
        // create animation "dance gray"
        //
        animFrames = [];
        for (i = 1; i < 15; i++) {
            str = "grossini_dance_gray_" + (i < 10 ? ("0" + i) : i) + ".png";
            frame = spriteFrameCache.getSpriteFrame(str);
            animFrames.push(frame);
        }

        animation = cc.Animation.create(animFrames, 0.2);

        // Add an animation to the Cache
        cc.AnimationCache.getInstance().addAnimation(animation, "dance_gray");

        //
        // create animation "dance blue"
        //
        animFrames = [];
        for (i = 1; i < 4; i++) {
            str = "grossini_blue_0" + i + ".png";
            frame = spriteFrameCache.getSpriteFrame(str);
            animFrames.push(frame);
        }

        animation = cc.Animation.create(animFrames, 0.2);

        // Add an animation to the Cache
        cc.AnimationCache.getInstance().addAnimation(animation, "dance_blue");

        var animCache = cc.AnimationCache.getInstance();

        var normal = animCache.getAnimation("dance");
        normal.setRestoreOriginalFrame(true);
        var dance_grey = animCache.getAnimation("dance_gray");
        dance_grey.setRestoreOriginalFrame(true);
        var dance_blue = animCache.getAnimation("dance_blue");
        dance_blue.setRestoreOriginalFrame(true);

        var animN = cc.Animate.create(normal);
        var animG = cc.Animate.create(dance_grey);
        var animB = cc.Animate.create(dance_blue);

        var seq = cc.Sequence.create(animN, animG, animB);

        frame = spriteFrameCache.getSpriteFrame("grossini_dance_01.png");
        var grossini = cc.Sprite.createWithSpriteFrame(frame);

        grossini.setPosition(winSize.width / 2, winSize.height / 2);
        this.addChild(grossini);

        // run the animation
        grossini.runAction(seq);
    },
    //
    // Automation
    //
    testDuration:6.5,
    ePixel1:{"0":51, "1":0, "2":51, "3":255},
    ePixel2:{"0":15, "1":15, "2":15, "3":255},
    ePixel3:{"0":0, "1":38, "2":0, "3":255},
    cPixel1:null,
    cPixel2:null,
    cPixel3:null,
    setupAutomation:function () {
        var fun1 = function () {
            this.cPixel1 = this.readPixels(winSize.width / 2, winSize.height / 2, 5, 5);
        }
        this.scheduleOnce(fun1, 0.4);

        var fun2 = function () {
            this.cPixel2 = this.readPixels(winSize.width / 2, winSize.height / 2, 5, 5);
        }
        this.scheduleOnce(fun2, 3.2);

        var fun3 = function () {
            this.cPixel3 = this.readPixels(winSize.width / 2, winSize.height / 2, 5, 5);
        }
        this.scheduleOnce(fun3, 6);
    },
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel3":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret = {"pixel1":this.containsPixel(this.cPixel1, this.ePixel1) ? "yes" : "no", "pixel2":this.containsPixel(this.cPixel2, this.ePixel2) ? "yes" : "no", "pixel3":this.containsPixel(this.cPixel3, this.ePixel3, true, 5) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

var NodeSort = SpriteTestDemo.extend({
    _node:null,
    _sprite1:null,
    _sprite2:null,
    _sprite3:null,
    _sprite4:null,
    _sprite5:null,

    _title:"node sort same index",
    _subtitle:"tag order in console should be 2,1,3,4,5",

    ctor:function () {
        this._super();
        this._node = cc.Node.create();
        this.addChild(this._node, 0, 0);

        this._sprite1 = cc.Sprite.create(s_piece, cc.rect(128, 0, 64, 64));
        this._sprite1.setPosition(100, 160);
        this._node.addChild(this._sprite1, -6, 1);

        this._sprite2 = cc.Sprite.create(s_piece, cc.rect(128, 0, 64, 64));
        this._sprite2.setPosition(164, 160);
        this._node.addChild(this._sprite2, -6, 2);

        this._sprite4 = cc.Sprite.create(s_piece, cc.rect(128, 0, 64, 64));
        this._sprite4.setPosition(292, 160);
        this._node.addChild(this._sprite4, -3, 4);

        this._sprite3 = cc.Sprite.create(s_piece, cc.rect(128, 0, 64, 64));
        this._sprite3.setPosition(228, 160);
        this._node.addChild(this._sprite3, -4, 3);

        this._sprite5 = cc.Sprite.create(s_piece, cc.rect(128, 0, 64, 64));
        this._sprite5.setPosition(356, 160);
        this._node.addChild(this._sprite5, -3, 5);

        this.schedule(this.reorderSprite);
    },

    reorderSprite:function (dt) {
        this.unschedule(this.reorderSprite);

        cc.log("Before reorder--");

        var i = 0;
        var child;
        var nodeChildren = this._node.getChildren();
        for (i = 0; i < nodeChildren.length; i++) {
            child = nodeChildren[i];
            cc.log("tag:" + child.getTag() + "  z: " + child.getZOrder());
        }

        //z-4
        this._node.reorderChild(this._node.getChildren()[0], -6);
        this._node.sortAllChildren();

        cc.log("After reorder--");
        nodeChildren = this._node.getChildren();
        for (i = 0; i < nodeChildren.length; i++) {
            child = nodeChildren[i];
            cc.log("tag:" + child.getTag() + "  z: " +
                child.getZOrder());
            this.testOrders.push(child.getTag());
        }
    },
    //
    // Automation
    //
    testDuration:1,
    testOrders:[],
    getExpectedResult:function () {
        return JSON.stringify([2, 1, 3, 4, 5]);
    },
    getCurrentResult:function () {
        return JSON.stringify(this.testOrders);
    }
});

var SpriteBatchNodeReorderSameIndex = SpriteTestDemo.extend({
    _batchNode:null,
    _sprite1:null,
    _sprite2:null,
    _sprite3:null,
    _sprite4:null,
    _sprite5:null,

    _title:"SpriteBatchNodeReorder same index",
    _subtitle:"tag order in console should be 2,3,4,5,1",

    ctor:function () {
        this._super();
        this._batchNode = cc.SpriteBatchNode.create(s_piece, 15);
        this.addChild(this._batchNode, 1, 0);

        this._sprite1 = cc.Sprite.createWithTexture(this._batchNode.getTexture(), cc.rect(128, 0, 64, 64));
        this._sprite1.setPosition(100, 160);
        this._batchNode.addChild(this._sprite1, 3, 1);

        this._sprite2 = cc.Sprite.createWithTexture(this._batchNode.getTexture(), cc.rect(128, 0, 64, 64));
        this._sprite2.setPosition(164, 160);
        this._batchNode.addChild(this._sprite2, 4, 2);

        this._sprite3 = cc.Sprite.createWithTexture(this._batchNode.getTexture(), cc.rect(128, 0, 64, 64));
        this._sprite3.setPosition(228, 160);
        this._batchNode.addChild(this._sprite3, 4, 3);

        this._sprite4 = cc.Sprite.createWithTexture(this._batchNode.getTexture(), cc.rect(128, 0, 64, 64));
        this._sprite4.setPosition(292, 160);
        this._batchNode.addChild(this._sprite4, 5, 4);

        this._sprite5 = cc.Sprite.createWithTexture(this._batchNode.getTexture(), cc.rect(128, 0, 64, 64));
        this._sprite5.setPosition(356, 160);
        this._batchNode.addChild(this._sprite5, 6, 5);

        this.scheduleOnce(this.reorderSprite, 2);
    },

    reorderSprite:function (dt) {
        this._batchNode.reorderChild(this._sprite4, 4);
        this._batchNode.reorderChild(this._sprite5, 4);
        this._batchNode.reorderChild(this._sprite1, 4);

        this._batchNode.sortAllChildren();

        var descendants = this._batchNode.getDescendants();

        for (var i = 0; i < descendants.length; i++) {
            var child = descendants[i];
            cc.log("tag:" + child.getTag());
            this.testDescendants.push(child.getTag());
        }
    },
    //
    // Automation
    //
    testDuration:2.2,
    testDescendants:[],
    getExpectedResult:function () {
        return JSON.stringify([2, 3, 4, 5, 1]);
    },
    getCurrentResult:function () {
        return JSON.stringify(this.testDescendants);
    }
});

var SpriteBatchNodeReorderOneChild = SpriteTestDemo.extend({
    _batchNode:null,
    _reoderSprite:null,

    _title:"SpriteBatchNode reorder 1 child",
    ctor:function () {
        this._super();

        spriteFrameCache.addSpriteFrames(s_ghostsPlist);
        //
        // SpriteBatchNode: 3 levels of children
        //
        var aParent = cc.SpriteBatchNode.create(s_ghosts);

        this._batchNode = aParent;
        //[[aParent texture] generateMipmap];
        if ("opengl" in sys.capabilities)
            aParent.getTexture().generateMipmap();
        this.addChild(aParent);

        // parent
        var l1 = cc.Sprite.createWithSpriteFrameName("father.gif");
        l1.setPosition(winSize.width / 2, winSize.height / 2);

        aParent.addChild(l1);
        var l1Size = l1.getContentSize();

        // child left
        var l2a = cc.Sprite.createWithSpriteFrameName("sister1.gif");
        l2a.setPosition(-10 + l1Size.width / 2, 0 + l1Size.height / 2);

        l1.addChild(l2a, 1);
        var l2aSize = l2a.getContentSize();

        // child right
        var l2b = cc.Sprite.createWithSpriteFrameName("sister2.gif");
        l2b.setPosition(+50 + l1Size.width / 2, 0 + l1Size.height / 2);

        l1.addChild(l2b, 2);
        var l2bSize = l2a.getContentSize();

        // child left bottom
        var l3a1 = cc.Sprite.createWithSpriteFrameName("child1.gif");
        l3a1.setScale(0.45);
        l3a1.setPosition(0 + l2aSize.width / 2, -50 + l2aSize.height / 2);
        l2a.addChild(l3a1, 1);

        // child left top
        var l3a2 = cc.Sprite.createWithSpriteFrameName("child1.gif");
        l3a2.setScale(0.45);
        l3a2.setPosition(0 + l2aSize.width / 2, +50 + l2aSize.height / 2);
        l2a.addChild(l3a2, 2);

        this._reoderSprite = l2a;

        // child right bottom
        var l3b1 = cc.Sprite.createWithSpriteFrameName("child1.gif");
        l3b1.setScale(0.45);
        l3b1.setFlippedY(true);
        l3b1.setPosition(0 + l2bSize.width / 2, -50 + l2bSize.height / 2);
        l2b.addChild(l3b1);

        // child right top
        var l3b2 = cc.Sprite.createWithSpriteFrameName("child1.gif");
        l3b2.setScale(0.45);
        l3b2.setFlippedY(true);
        l3b2.setPosition(0 + l2bSize.width / 2, 50 + l2bSize.height / 2);
        l2b.addChild(l3b2);

        this.scheduleOnce(this.reorderSprite, 2.0);
    },

    reorderSprite:function (dt) {
        this._reoderSprite.getParent().reorderChild(this._reoderSprite, -1);
        this._batchNode.sortAllChildren();
        //cc.Sprite* child;
        //CCARRAY_FOREACH(batchNode.descendants,child) NSLog(@"tag %i",child.tag);
    },
    //
    // Automation
    //
    testDuration:2.5,
    pixel:{"0":0, "1":102, "2":255, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 2 - 11, winSize.height / 2 + 33, 3, 3);
        var ret = {"pixel":this.containsPixel(ret1, this.pixel, false) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

var SpriteBatchNodeSkewNegativeScaleChildren = SpriteTestDemo.extend({
    _title:"SpriteBatchNode + children + skew",
    _subtitle:"SpriteBatchNode skew + negative scale with children",

    ctor:function () {
        this._super();

        var cache = spriteFrameCache;
        cache.addSpriteFrames(s_grossiniPlist);
        cache.addSpriteFrames(s_grossini_grayPlist, s_grossini_gray);

        var spritebatch = cc.SpriteBatchNode.create(s_grossini);
        this.addChild(spritebatch);

        for (var i = 0; i < 2; i++) {
            var sprite = cc.Sprite.createWithSpriteFrameName("grossini_dance_01.png");
            sprite.setPosition(winSize.width / 4 * (i + 1), winSize.height / 2);

            // Skew
            var skewX = cc.SkewBy.create(2, 45, 0);
            var skewX_back = skewX.reverse();
            var skewY = cc.SkewBy.create(2, 0, 45);
            var skewY_back = skewY.reverse();

            if (i === 1)
                sprite.setScale(-1.0);

            var seq_skew = cc.Sequence.create(skewX, skewX_back, skewY, skewY_back);
            sprite.runAction(cc.RepeatForever.create(seq_skew));

            var child1 = cc.Sprite.createWithSpriteFrameName("grossini_dance_01.png");
            child1.setPosition(sprite.getContentSize().width / 2.0, sprite.getContentSize().height / 2.0);

            child1.setScale(0.8);
            sprite.addChild(child1);
            spritebatch.addChild(sprite, i);
        }
    },
    //
    // Automation
    //
    testDuration:6,
    pixel1:{"0":51, "1":0, "2":51, "3":255},
    pixel2:{"0":0, "1":0, "2":0, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 4 + 21, winSize.height / 2 + 22, 5, 5);
        var ret2 = this.readPixels(winSize.width / 4 + 11, winSize.height / 2 + 14, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel1) ? "yes" : "no",
            "pixel2":!this.containsPixel(ret2, this.pixel2) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

var SpriteSkewNegativeScaleChildren = SpriteTestDemo.extend({
    _title:"Sprite + children + skew",
    _subtitle:"Sprite skew + negative scale with children",

    ctor:function () {
        this._super();

        var cache = spriteFrameCache;
        cache.addSpriteFrames(s_grossiniPlist);
        cache.addSpriteFrames(s_grossini_grayPlist, s_grossini_gray);

        var parent = cc.Node.create();
        this.addChild(parent);

        for (var i = 0; i < 2; i++) {
            var sprite = cc.Sprite.createWithSpriteFrameName("grossini_dance_01.png");
            sprite.setPosition(winSize.width / 4 * (i + 1), winSize.height / 2);

            // Skew
            var skewX = cc.SkewBy.create(2, 45, 0);
            var skewX_back = skewX.reverse();
            var skewY = cc.SkewBy.create(2, 0, 45);
            var skewY_back = skewY.reverse();

            if (i === 1)
                sprite.setScale(-1.0);

            var seq_skew = cc.Sequence.create(skewX, skewX_back, skewY, skewY_back);
            sprite.runAction(cc.RepeatForever.create(seq_skew));

            var child1 = cc.Sprite.createWithSpriteFrameName("grossini_dance_01.png");
            child1.setPosition(sprite.getContentSize().width / 2.0, sprite.getContentSize().height / 2.0);

            sprite.addChild(child1);
            child1.setScale(0.8);
            parent.addChild(sprite, i);
        }
    },
    //
    // Automation
    //
    testDuration:6,
    pixel1:{"0":51, "1":0, "2":51, "3":255},
    pixel2:{"0":0, "1":0, "2":0, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 4 + 21, winSize.height / 2 + 22, 5, 5);
        var ret2 = this.readPixels(winSize.width / 4 + 11, winSize.height / 2 + 14, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel1, false) ? "yes" : "no",
            "pixel2":!this.containsPixel(ret2, this.pixel2, false) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

var DoubleSprite = cc.Sprite.extend({
    HD:false,

    initWithTexture:function (texture, rect) {
        if (this._super(texture, rect)) {
            //var resolutionType = texture.getResolutionType();
            //this.HD = ( resolutionType == cc.kCCResolutioniPhoneRetinaDisplay || resolutionType == kCCResolutioniPadRetinaDisplay );
            return true;
        }
        return false;
    },

    setContentSize:function (size) {
        var newSize = cc.size(size.width, size.height);
        // If Retina Display and Texture is in HD then scale the vertex rect
        if (cc.CONTENT_SCALE_FACTOR() == 2 && !this.HD) {
            newSize.width *= 2;
            newSize.height *= 2;
        }
        this._super(newSize);
    },

    setVertexRect:function (rect) {
        // If Retina Display and Texture is in HD then scale the vertex rect
        if (cc.CONTENT_SCALE_FACTOR() == 2 && !this.HD) {
            rect.width *= 2;
            rect.height *= 2;
        }
        this._super(rect);
    }
});

DoubleSprite.create = function (fileName) {
    var pSp = new DoubleSprite();
    pSp.init(fileName);
    return pSp;
};

var SpriteDoubleResolution = SpriteTestDemo.extend({

    _title:"Sprite Double resolution",
    _subtitle:"Retina Display. SD (left) should be equal to HD (right)",

    ctor:function () {
        this._super();

        //
        // LEFT: SD sprite
        //
        // there is no HD resolution file of grossini_dance_08.
        var spriteSD = DoubleSprite.create(s_grossiniDance08);
        this.addChild(spriteSD);
        spriteSD.setPosition(winSize.width / 4, winSize.height / 2);

        var child1_left = DoubleSprite.create(s_grossiniDance08);
        spriteSD.addChild(child1_left);
        child1_left.setPosition(-30, 0);

        var child1_right = cc.Sprite.create(s_pathGrossini);
        spriteSD.addChild(child1_right);
        child1_left.setPosition(spriteSD.getContentSize().height, 0);

        //
        // RIGHT: HD sprite
        //
        // there is an HD version of grossini.png
        var spriteHD = cc.Sprite.create(s_pathGrossini);
        this.addChild(spriteHD);
        spriteHD.setPosition(winSize.width / 4 * 3, winSize.height / 2);

        var child2_left = DoubleSprite.create(s_grossiniDance08);
        spriteHD.addChild(child2_left);
        child2_left.setPosition(-30, 0);

        var child2_right = cc.Sprite.create(s_pathGrossini);
        spriteHD.addChild(child2_right);
        child2_left.setPosition(spriteHD.getContentSize().height, 0);


        // Actions
        var scale = cc.ScaleBy.create(2, 0.5);
        var scale_back = scale.reverse();
        var seq = cc.Sequence.create(scale, scale_back);

        var seq_copy = seq.clone();

        spriteSD.runAction(seq);
        spriteHD.runAction(seq_copy);
    }
});

var AnimationCacheFile = SpriteTestDemo.extend({

    _title:"AnimationCache - Load file",
    _subtitle:"Sprite should be animated",

    ctor:function () {
        this._super();
        var frameCache = spriteFrameCache;
        frameCache.addSpriteFrames(s_grossiniPlist);
        frameCache.addSpriteFrames(s_grossini_grayPlist);
        frameCache.addSpriteFrames(s_grossini_bluePlist);

        // Purge previously loaded animation
        cc.AnimationCache.purgeSharedAnimationCache();
        var animCache = cc.AnimationCache.getInstance();

        // Add an animation to the Cache
        // XXX API-FIX XXX
        // renamed from addAnimationsWithFile to addAnimations
        animCache.addAnimations(s_animationsPlist);

        var normal = animCache.getAnimation("dance_1");
        normal.setRestoreOriginalFrame(true);
        var dance_grey = animCache.getAnimation("dance_2");
        dance_grey.setRestoreOriginalFrame(true);
        var dance_blue = animCache.getAnimation("dance_3");
        dance_blue.setRestoreOriginalFrame(true);

        var animN = cc.Animate.create(normal);
        var animG = cc.Animate.create(dance_grey);
        var animB = cc.Animate.create(dance_blue);

        var seq = cc.Sequence.create(animN, animG, animB);

        // create an sprite with frame name
        // texture-less sprites are not supported
        var grossini = cc.Sprite.createWithSpriteFrameName("grossini_dance_01.png");

        grossini.setPosition(winSize.width / 2, winSize.height / 2);
        this.addChild(grossini);

        // run the animation
        grossini.runAction(seq);
    },
    //
    // Automation
    //
    testDuration:6.5,
    ePixel1:{"0":51, "1":0, "2":51, "3":255},
    ePixel2:{"0":15, "1":15, "2":15, "3":255},
    ePixel3:{"0":0, "1":38, "2":0, "3":255},
    cPixel1:null,
    cPixel2:null,
    cPixel3:null,
    setupAutomation:function () {
        this.scheduleOnce(this.getPixel1, 0.4);
        this.scheduleOnce(this.getPixel2, 3.2);
        this.scheduleOnce(this.getPixel3, 6);
    },
    getPixel1:function () {
        this.cPixel1 = this.readPixels(winSize.width / 2, winSize.height / 2, 5, 5);
    },
    getPixel2:function () {
        this.cPixel2 = this.readPixels(winSize.width / 2, winSize.height / 2, 5, 5);
    },
    getPixel3:function () {
        this.cPixel3 = this.readPixels(winSize.width / 2, winSize.height / 2, 5, 5);
    },
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel3":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret = {"pixel1":this.containsPixel(this.cPixel1, this.ePixel1) ? "yes" : "no", "pixel2":this.containsPixel(this.cPixel2, this.ePixel2) ? "yes" : "no", "pixel3":this.containsPixel(this.cPixel3, this.ePixel3, true, 5) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

var SpriteBatchBug1217 = SpriteTestDemo.extend({

    _title:"SpriteBatch - Bug 1217",
    _subtitle:"Adding big family to spritebatch. You shall see 3 heads",

    ctor:function () {
        this._super();
        var bn = cc.SpriteBatchNode.create(s_grossini_dance_atlas, 15);

        var s1 = cc.Sprite.createWithTexture(bn.getTexture(), cc.rect(0, 0, 57, 57));
        var s2 = cc.Sprite.createWithTexture(bn.getTexture(), cc.rect(0, 0, 57, 57));
        var s3 = cc.Sprite.createWithTexture(bn.getTexture(), cc.rect(0, 0, 57, 57));

        s1.setColor(cc.c3b(255, 0, 0));
        s2.setColor(cc.c3b(0, 255, 0));
        s3.setColor(cc.c3b(0, 0, 255));

        s1.setPosition(20, 200);
        s2.setPosition(100, 0);
        s3.setPosition(100, 0);

        bn.setPosition(0, 0);

        //!!!!!
        s1.addChild(s2);
        s2.addChild(s3);
        bn.addChild(s1);

        this.addChild(bn);
    },
    // Automation
    testDuration:2.1,
    pixel1:{"0":51, "1":0, "2":0, "3":255},
    pixel2:{"0":0, "1":0, "2":0, "3":255},
    pixel3:{"0":0, "1":0, "2":51, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes", "pixel3":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(20, 174, 3, 3);
        var ret2 = this.readPixels(90, 145, 3, 3);
        var ret3 = this.readPixels(163, 116, 3, 3);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel1, false) ? "yes" : "no",
            "pixel2":this.containsPixel(ret2, this.pixel2, false) ? "yes" : "no",
            "pixel3":this.containsPixel(ret3, this.pixel3, false) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

var TextureColorCacheIssue = SpriteTestDemo.extend({

    _title:"Texture Color Cache Issue Test",
    _subtitle:"You should see two different sprites colored green and blue",

    ctor:function () {
        this._super();

        var spriteFrameCache = cc.SpriteFrameCache.getInstance();
        spriteFrameCache.addSpriteFrames(s_tcc_issue_1_plist, s_tcc_issue_1);
        spriteFrameCache.addSpriteFrames(s_tcc_issue_2_plist, s_tcc_issue_2);

        var grossini = cc.Sprite.createWithSpriteFrameName('tcc_grossini_dance_01.png');
        grossini.setPosition(winSize.width / 3, winSize.height / 2);

        var sister = cc.Sprite.createWithSpriteFrameName('tcc_grossinis_sister1.png');
        sister.setPosition(winSize.width / 3 * 2, winSize.height / 2);

        this.addChild(grossini);
        this.addChild(sister);

        grossini.setColor(cc.c3b(1, 255, 1));
        sister.setColor(cc.c3b(1, 1, 255));
    },
    onExit:function () {
        spriteFrameCache.removeSpriteFramesFromFile(s_tcc_issue_1_plist);
        spriteFrameCache.removeSpriteFramesFromFile(s_tcc_issue_2_plist);
        this._super();
    },
    // Automation
    pixel1:{"0":0, "1":204, "2":0, "3":255},
    pixel2:{"0":0, "1":0, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 3, winSize.height / 2 + 43, 5, 5);
        var ret2 = this.readPixels(winSize.width / 3 * 2, winSize.height / 2 - 6, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel1, true, 3) ? "yes" : "no",
            "pixel2":this.containsPixel(ret2, this.pixel2, true, 3) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

var TextureColorCacheIssue2 = SpriteTestDemo.extend({

    _title:"Texture Color Cache Issue Test #2",
    _subtitle:"You should see two different sprites magenta and yellow",

    ctor:function () {
        this._super();

        var spriteFrameCache = cc.SpriteFrameCache.getInstance();
        spriteFrameCache.addSpriteFrames(s_tcc_issue_1_plist, s_tcc_issue_1);
        spriteFrameCache.addSpriteFrames(s_tcc_issue_2_plist, s_tcc_issue_2);

        var grossini = cc.Sprite.createWithSpriteFrameName('tcc_grossini_dance_01.png');
        grossini.setPosition(winSize.width / 3, winSize.height / 2);

        var sister = cc.Sprite.createWithSpriteFrameName('tcc_grossinis_sister1.png');
        sister.setPosition(winSize.width / 3 * 2, winSize.height / 2);

        this.addChild(grossini);
        this.addChild(sister);

//        for (var i = 0; i < 10; ++i) {
//            sister.setColor(cc.c3b(128, 128, 128 + i));
//            grossini.setColor(cc.c3b(128, 128, 128 + i));
//        }
        grossini.setColor(cc.c3b(255, 255, 0));
        sister.setColor(cc.c3b(255, 0, 255));
    },
    onExit:function () {
        spriteFrameCache.removeSpriteFramesFromFile(s_tcc_issue_1_plist);
        spriteFrameCache.removeSpriteFramesFromFile(s_tcc_issue_2_plist);
        this._super();
    },
    // Automation
    pixel1:{"0":255, "1":204, "2":0, "3":255},
    pixel2:{"0":255, "1":0, "2":153, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 3, winSize.height / 2 + 43, 5, 5);
        var ret2 = this.readPixels(winSize.width / 3 * 2, winSize.height / 2 - 3, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel1, true, 5) ? "yes" : "no",
            "pixel2":this.containsPixel(ret2, this.pixel2, true, 5) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

var TextureRotatedSpriteFrame = SpriteTestDemo.extend({

    _title:"Sub Sprite (rotated source)",
    _subtitle:"createWithSpriteFrameName(); sub sprite",

    ctor:function () {
        this._super();

        cc.SpriteFrameCache.getInstance().addSpriteFrames(s_s9s_blocks9_plist);

        var block = cc.Sprite.createWithSpriteFrameName('blocks9r.png');

        var x = winSize.width / 2;
        var y = 0 + (winSize.height / 2);

        block.setTextureRect(cc.rect(32, 32, 32, 32), true, cc.rect(32, 32, 32, 32));

        block.setPosition(x, y);
        this.addChild(block);
    },
    // Automation
    pixel1:{"0":255, "1":204, "2":153, "3":255},
    pixel2:{"0":51, "1":0, "2":51, "3":255},
    getExpectedResult:function () {
        var ret = {"pixel1":"yes", "pixel2":"yes"};
        return JSON.stringify(ret);
    },
    getCurrentResult:function () {
        var ret1 = this.readPixels(winSize.width / 2 - 14, winSize.height / 2 - 8, 5, 5);
        var ret2 = this.readPixels(winSize.width / 2 + 12, winSize.height / 2, 5, 5);
        var ret = {"pixel1":this.containsPixel(ret1, this.pixel1, true, 5) ? "yes" : "no",
            "pixel2":this.containsPixel(ret2, this.pixel2, true, 5) ? "yes" : "no"};
        return JSON.stringify(ret);
    }
});

var SpriteTestScene = TestScene.extend({
    runThisTest:function () {
        spriteTestIdx = -1;
        var layer = nextSpriteTest();
        this.addChild(layer);

        director.replaceScene(this);
    }
});

//
// Flow control
//
var arrayOfSpriteTest = [
    Sprite1,
    SpriteBatchNode1,
    SpriteFrameTest,
    SpriteFrameAliasNameTest,
    SpriteAnchorPoint,
    SpriteBatchNodeAnchorPoint,
    SpriteOffsetAnchorRotation,
    SpriteBatchNodeOffsetAnchorRotation,
    SpriteOffsetAnchorScale,
    SpriteBatchNodeOffsetAnchorScale,
    SpriteAnimationSplit,
    SpriteColorOpacity,
    SpriteBatchNodeColorOpacity,
    SpriteZOrder,
    SpriteBatchNodeZOrder,
    SpriteBatchNodeReorder,
    SpriteBatchNodeReorderIssue744,
    SpriteBatchNodeReorderIssue766,
    SpriteBatchNodeReorderIssue767,
    SpriteZVertex,
    SpriteBatchNodeZVertex,
    Sprite6,
    SpriteFlip,
    SpriteBatchNodeFlip,
    SpriteAliased,
    SpriteBatchNodeAliased,
    SpriteNewTexture,
    SpriteBatchNodeNewTexture,
    SpriteHybrid,
    SpriteBatchNodeChildren,
    SpriteBatchNodeChildrenZ,
    SpriteChildrenVisibility,
    SpriteChildrenVisibilityIssue665,
    SpriteChildrenAnchorPoint,
    SpriteBatchNodeChildrenAnchorPoint,
    SpriteBatchNodeChildrenScale,
    SpriteChildrenChildren,
    SpriteBatchNodeChildrenChildren,
    SpriteNilTexture,
    SpriteSubclass,
    AnimationCacheTest,
    SpriteOffsetAnchorSkew,
    SpriteBatchNodeOffsetAnchorSkew,
    SpriteOffsetAnchorSkewScale,
    SpriteBatchNodeOffsetAnchorSkewScale,
    SpriteOffsetAnchorFlip,
    SpriteBatchNodeOffsetAnchorFlip,
    SpriteBatchNodeReorderSameIndex,
    SpriteBatchNodeReorderOneChild,
    NodeSort,
    SpriteSkewNegativeScaleChildren,
    SpriteBatchNodeSkewNegativeScaleChildren,
    SpriteDoubleResolution,
    SpriteBatchBug1217,
    AnimationCacheFile,
    TextureColorCacheIssue,
    TextureColorCacheIssue2,
    TextureRotatedSpriteFrame
];

var nextSpriteTest = function () {
    spriteTestIdx++;
    spriteTestIdx = spriteTestIdx % arrayOfSpriteTest.length;

    return new arrayOfSpriteTest[spriteTestIdx ]();
};
var previousSpriteTest = function () {
    spriteTestIdx--;
    if (spriteTestIdx < 0)
        spriteTestIdx += arrayOfSpriteTest.length;

    return new arrayOfSpriteTest[spriteTestIdx ]();
};
var restartSpriteTest = function () {
    return new arrayOfSpriteTest[spriteTestIdx ]();
};

