//
//  Parent.h
//  DaDaDaDungeon
//
//  Created by 坂本 寿樹 on 2014/03/29.
//
//

#ifndef __DaDaDaDungeon__Parent__
#define __DaDaDaDungeon__Parent__


//=============================================================================
//
//	Sequence::Parent
//
//	ここが一番初めにロードされます。
//	シーンの管理者であり、自分自身もシーンです。
//	run...はこのシーンに行い、追加シーンはこのクラスの上に載せるようにします。
//
//	大元のParentは一体しかいないことを保証するためにシングルトンにします。
//
//=============================================================================

#include "cocos2d.h"


namespace Sequence
{
	class Child;
	
	
	//
	//	class Parent
	//
	
	class Parent : public cocos2d::CCScene
	{
	public:
		
		/**
		 *	最初に呼び出すシーンを渡してあげます。
		 *	@usage Parent( Child* pFirstScene )
		 *	@param arg1 最初に遷移するシーンの実態
		 */
		Parent( Child* pFirstScene );
		virtual ~Parent();
		
		/**
		 *	自動的に毎フレームごと呼び出されます。
		 *	@usage void update( float delta )
		 *	@param arg1 前回からの経過時間
		 */
		virtual void update( float delta );
		
		
	private:
		
		/* 処理すべき子供( シーン ) */
		Child* mpChild;
	};
	
} // namespace Sequence



#endif /* defined(__DaDaDaDungeon__Parent__) */
