//
//  Parent.cpp
//  DaDaDaDungeon
//
//  Created by 坂本 寿樹 on 2014/03/29.
//
//

#include "Parent.h"
#include "Child.h"

using namespace cocos2d;



namespace Sequence
{
	/**
	 *	最初に呼び出すシーンを渡してあげます。
	 *	@usage Parent( Child* pFirstScene )
	 *	@param arg1 最初に遷移するシーンの実態
	 */
	Parent::Parent( Child* pFirstScene )
	: mpChild( NULL )
	{
		// 自動的に update を読んでもらうよう設定します。
		scheduleUpdate();
		
		
		//
		// 最初に作成する物
		mpChild = pFirstScene;
		CCDirector::sharedDirector()->pushScene( pFirstScene );
	}
	Parent::~Parent()
	{
	}
	
	
	/**
	 *	自動的に毎フレームごと呼び出されます。
	 *	@usage void update( float delta )
	 *	@param arg1 前回からの経過時間
	 */
	void Parent::update( float delta )
	{
		//
		// もし入れ替わっていたら次のシーンを更新し始めます。
		Base* pNextChild = mpChild->update( this );
		if ( pNextChild == mpChild )
			return;
		
		// 遷移
		Child* pCasted = dynamic_cast< Child* >( pNextChild );
		CCAssert( pCasted, "基底Scene : 失敗はありえない！" );
		
		// シーンをポップして消してから、プッシュします。
		CCDirector::sharedDirector()->popScene();
		CCDirector::sharedDirector()->pushScene( pCasted );
		
		mpChild = pCasted;
	}
}
