//
//  Parent.h
//  DaDaDaDungeon
//
//  Created by 坂本 寿樹 on 2014/03/30.
//
//

#ifndef __DaDaDaDungeon__Parent__
#define __DaDaDaDungeon__Parent__

//=============================================================================
//
//	Sequence::Game
//
//=============================================================================

#include "../Child.h"


namespace Sequence
{
	class Parent;	// Sequence::Parent
	
	namespace Game
	{
		class Child;	// Sequence::Game の Child
		
		
		//
		//	class Parent -> Sequence::Child
		//
		//	Gameシーンを管理する親になります。
		//
		
		class Parent : public Sequence::Child
		{
		public:
			
			// Sequence::Parent を分かりやすく..
			typedef Sequence::Parent GrandParent;
			
			Parent();
			virtual ~Parent();
			
			
			/**
			 *	Sequence::Parent( 親 )を受け撮ります。
			 *	親の更新時に親自身を引数に渡してきます。
			 *	@usage Base* update( GrandParent* pParent );
			 *	@param arg1 Sequence::Parentのポインタ
			 *	@return 自分のポインタ or シーン変更時のポインタ
			 */
			Base* update( GrandParent* pParent );

			
		private:
			
			/* Gameシーンの子供 */
			Game::Child* mpChild;
		};
		
	} // namespace Game
	
} // namespace Sequence

#endif /* defined(__DaDaDaDungeon__Parent__) */
