//
//  Child.h
//  DaDaDaDungeon
//
//  Created by 坂本 寿樹 on 2014/03/29.
//
//

#ifndef __DaDaDaDungeon__Child__
#define __DaDaDaDungeon__Child__


//=============================================================================
//
//	Sequence::Base -> Child
//
//	Sequenceフォルダ下、つまり一番最初に来るべきシーン達の基底クラスとなります。
//	Baseを継承し一貫性をもたせます。
//
//	updateはBaseが持っている物と、Sequence:: のシーン専用の２つが存在します。
//	継承元のupdateは中で dynamic_castを使用し、本当に自分の管理する子供かどうか判断します。
//	違った場合は更に親に渡す。　ということを行うことで様々な方向へシーンを伝播することが出来ます。
//
//=============================================================================

#include "Base.h"


namespace Sequence
{
	class Parent;
	
	
	//
	// class Child -> Base
	//
	
	class Child : public Base
	{
	public:
		
		virtual ~Child();
		
		
		/**
		 *	継承元のBaseが持っている更新関数。
		 *	この関数が毎回呼ばれます。
		 *	@usage Base* update( Base* )
		 *	@param arg1 シーンのポインタ。 引数に渡ってきたシーンを判定します。
		 *	@return 親に返します。
		 */
		virtual Base* update( Base* );
		
		/**
		 *	Sequence::Parent と親とする自分たちの更新関数です。
		 *	自分たちより上の階層は無いので、必ずdynamic_castは成功しています。
		 *	@usage Base* update( Parent* pParent ) = 0
		 *	@param arg1 Sequence::Parent を引数に受け取ります。
		 *	@return 現在のシーン or 新しいシーン が帰ってきます。
		 */
		virtual Base* update( Parent* pParent ) = 0;
	};

} // namespace Sequence



#endif /* defined(__DaDaDaDungeon__Child__) */
