//
//  Child.cpp
//  DaDaDaDungeon
//
//  Created by 坂本 寿樹 on 2014/03/29.
//
//

#include "Child.h"
#include "Parent.h"



namespace Sequence
{
	Child::~Child()
	{
	}
	
	
	/**
	 *	継承元のBaseが持っている更新関数。
	 *	この関数が毎回呼ばれます。
	 *	@usage Base* update( Base* )
	 *	@param arg1 シーンのポインタ。 引数に渡ってきたシーンを判定します。
	 *	@return 親に返します。
	 */
	Base* Child::update( Base* pScene )
	{
		//
		// pScene に dynamic_cast を効かせ、Sequence::Parentかどうか判定します。
		// しかしこの上の階層は無いので必ず成功しないとおかしい訳ですが..
		Parent* pParent = dynamic_cast< Parent* >( pScene );
		CCAssert( pParent, "Sequence::Parent への キャストが失敗しました！" );
		
		return update( pParent );
	}
	
} // namespace Sequence