//
//  Base.h
//  DaDaDaDungeon
//
//  Created by 坂本 寿樹 on 2014/03/29.
//
//

#ifndef DaDaDaDungeon_Base_h
#define DaDaDaDungeon_Base_h



//=============================================================================
//
//	Sequence::Base
//
//	シーン遷移を行う基底クラス
//	これを各階層のChildが継承します。
//
//	(例)
//		Sequence:Child : public Base
//		Sequence::Game::Child : public Base
//
//	シーンの入れ替え処理は子供が行います。
//	親は帰ってきた子供を確認し、変更があればシーンを変更します。
//	もし自分が管理する子供以外が帰ってくれば、
//	それは違う親が管理するシーンなので、さらに親に伝播させます。
//	これは全て Base を継承しているから大丈夫になります。
//
//=============================================================================

#include "cocos2d.h"


namespace Sequence
{
	
	//
	// class Base
	//
	
	class Base : public cocos2d::CCScene
	{
	public:
		
		Base() {
		}
		virtual ~Base(){}
		
		/**
		 *	シーンには必ずupdateがあります！
		 *	update時に dynamic_castをし、実際に自分で処理するシーンか判断します。
		 *	@usage Base* update( Base* )
		 *	@param arg1
		 */
		virtual Base* update( Base* ) = 0;
	};
	
} // namespace Sequence

#endif
