/*
 * Decompiled with CFR 0.152.
 */
package com.nd.commplatform.entry;

import android.text.TextUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NdThirdPlatformConfig {
    private String mLoginUrl;
    private String mBackupUrl;
    private String mRedirectUrl;

    public NdThirdPlatformConfig(String aUrl, String backupUrl, String aRedirectUrl) {
        this.mLoginUrl = aUrl;
        this.mBackupUrl = backupUrl;
        this.mRedirectUrl = aRedirectUrl;
    }

    public String getUrl(String thirdplatformType, String thirdplatformId) {
        if (!TextUtils.isEmpty((CharSequence)this.mLoginUrl)) {
            return this.mLoginUrl;
        }
        return this.makeUrl(this.mBackupUrl, thirdplatformId, thirdplatformType);
    }

    public String getRedirectUrl() {
        return this.mRedirectUrl;
    }

    private String makeUrl(String url, String thirdplatformId, String thirdplatformType) {
        StringBuilder stringBuilder = new StringBuilder(128);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ThirdplatformId", thirdplatformId);
        hashMap.put("ThirdplatformType", thirdplatformType);
        stringBuilder.append(url);
        String string2 = NdThirdPlatformConfig.getParamString(hashMap);
        if (url.indexOf(63) >= 0) {
            stringBuilder.append("&");
        } else {
            stringBuilder.append("?");
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private static String getParamString(Map<String, String> urlParams) {
        return URLEncodedUtils.format(NdThirdPlatformConfig.getParamsList(urlParams), (String)"utf-8");
    }

    private static List<BasicNameValuePair> getParamsList(Map<String, String> urlParams) {
        LinkedList<BasicNameValuePair> linkedList = new LinkedList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : urlParams.entrySet()) {
            linkedList.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        return linkedList;
    }
}

