/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.sdk.android;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.net.http.SslError;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Xml;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.weibo.sdk.android.R;
import com.weibo.sdk.android.Weibo;
import com.weibo.sdk.android.WeiboAuthListener;
import com.weibo.sdk.android.WeiboDialogError;
import com.weibo.sdk.android.WeiboException;
import com.weibo.sdk.android.util.Utility;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class WeiboDialog
extends Dialog {
    static FrameLayout.LayoutParams FILL = new FrameLayout.LayoutParams(-1, -1);
    private String mUrl;
    private WeiboAuthListener mListener;
    private ProgressDialog mSpinner;
    private WebView mWebView;
    private RelativeLayout webViewContainer;
    private RelativeLayout mContent;
    private static final String TAG = "Weibo-WebView";
    private static int theme = 0x1030010;
    private static int left_margin = 0;
    private static int top_margin = 0;
    private static int right_margin = 0;
    private static int bottom_margin = 0;

    public WeiboDialog(Context context, String url, WeiboAuthListener listener) {
        super(context, theme);
        this.mUrl = url;
        this.mListener = listener;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mSpinner = new ProgressDialog(this.getContext());
        this.mSpinner.requestWindowFeature(1);
        this.mSpinner.setMessage((CharSequence)"Loading...");
        this.mSpinner.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                WeiboDialog.this.onBack();
                return false;
            }
        });
        this.requestWindowFeature(1);
        this.getWindow().setFeatureDrawableAlpha(0, 0);
        this.mContent = new RelativeLayout(this.getContext());
        this.setUpWebView();
        this.addContentView((View)this.mContent, new ViewGroup.LayoutParams(-1, -1));
    }

    protected void onBack() {
        try {
            this.mSpinner.dismiss();
            if (this.mWebView != null) {
                this.mWebView.stopLoading();
                this.mWebView.destroy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dismiss();
    }

    private void setUpWebView() {
        RelativeLayout.LayoutParams lp0;
        RelativeLayout.LayoutParams lp;
        block20: {
            this.webViewContainer = new RelativeLayout(this.getContext());
            this.mWebView = new WebView(this.getContext());
            this.mWebView.setVerticalScrollBarEnabled(false);
            this.mWebView.setHorizontalScrollBarEnabled(false);
            this.mWebView.getSettings().setJavaScriptEnabled(true);
            this.mWebView.setWebViewClient((WebViewClient)new WeiboWebViewClient());
            this.mWebView.loadUrl(this.mUrl);
            this.mWebView.setLayoutParams((ViewGroup.LayoutParams)FILL);
            this.mWebView.setVisibility(4);
            lp = new RelativeLayout.LayoutParams(-1, -1);
            lp0 = new RelativeLayout.LayoutParams(-1, -1);
            this.mContent.setBackgroundColor(0);
            AssetManager asseets = this.getContext().getAssets();
            InputStream is = null;
            try {
                try {
                    try {
                        is = asseets.open("weibosdk_dialog_bg.9.png");
                        DisplayMetrics dm = this.getContext().getResources().getDisplayMetrics();
                        float density = dm.density;
                        lp0.leftMargin = (int)(10.0f * density);
                        lp0.topMargin = (int)(10.0f * density);
                        lp0.rightMargin = (int)(10.0f * density);
                        lp0.bottomMargin = (int)(10.0f * density);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (is == null) {
                        this.webViewContainer.setBackgroundResource(R.drawable.weibosdk_dialog_bg);
                    } else {
                        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is);
                        NinePatchDrawable npd = new NinePatchDrawable(bitmap, bitmap.getNinePatchChunk(), new Rect(0, 0, 0, 0), null);
                        this.webViewContainer.setBackgroundDrawable((Drawable)npd);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.webViewContainer.addView((View)this.mWebView, (ViewGroup.LayoutParams)lp0);
        this.webViewContainer.setGravity(17);
        if (this.parseDimens()) {
            lp.leftMargin = left_margin;
            lp.topMargin = top_margin;
            lp.rightMargin = right_margin;
            lp.bottomMargin = bottom_margin;
        } else {
            Resources resources = this.getContext().getResources();
            lp.leftMargin = resources.getDimensionPixelSize(R.dimen.weibosdk_dialog_left_margin);
            lp.rightMargin = resources.getDimensionPixelSize(R.dimen.weibosdk_dialog_right_margin);
            lp.topMargin = resources.getDimensionPixelSize(R.dimen.weibosdk_dialog_top_margin);
            lp.bottomMargin = resources.getDimensionPixelSize(R.dimen.weibosdk_dialog_bottom_margin);
        }
        this.mContent.addView((View)this.webViewContainer, (ViewGroup.LayoutParams)lp);
    }

    private void handleRedirectUrl(WebView view, String url) {
        Bundle values = Utility.parseUrl(url);
        String error = values.getString("error");
        String error_code = values.getString("error_code");
        if (error == null && error_code == null) {
            this.mListener.onComplete(values);
        } else if (error.equals("access_denied")) {
            this.mListener.onCancel();
        } else if (error_code == null) {
            this.mListener.onWeiboException(new WeiboException(error, 0));
        } else {
            this.mListener.onWeiboException(new WeiboException(error, Integer.parseInt(error_code)));
        }
    }

    private boolean parseDimens() {
        boolean ret;
        block21: {
            ret = false;
            AssetManager asseets = this.getContext().getAssets();
            DisplayMetrics dm = this.getContext().getResources().getDisplayMetrics();
            float density = dm.density;
            InputStream is = null;
            try {
                try {
                    is = asseets.open("values/dimens.xml");
                    XmlPullParser xmlpull = Xml.newPullParser();
                    try {
                        xmlpull.setInput(is, "utf-8");
                        int eventCode = xmlpull.getEventType();
                        ret = true;
                        while (eventCode != 1) {
                            switch (eventCode) {
                                case 2: {
                                    String value;
                                    if (!xmlpull.getName().equals("dimen")) break;
                                    String name = xmlpull.getAttributeValue(null, "name");
                                    if ("weibosdk_dialog_left_margin".equals(name)) {
                                        value = xmlpull.nextText();
                                        left_margin = (int)((float)Integer.parseInt(value) * density);
                                        break;
                                    }
                                    if ("weibosdk_dialog_top_margin".equals(name)) {
                                        value = xmlpull.nextText();
                                        top_margin = (int)((float)Integer.parseInt(value) * density);
                                        break;
                                    }
                                    if ("weibosdk_dialog_right_margin".equals(name)) {
                                        value = xmlpull.nextText();
                                        right_margin = (int)((float)Integer.parseInt(value) * density);
                                        break;
                                    }
                                    if (!"weibosdk_dialog_bottom_margin".equals(name)) break;
                                    value = xmlpull.nextText();
                                    bottom_margin = (int)((float)Integer.parseInt(value) * density);
                                }
                            }
                            eventCode = xmlpull.next();
                        }
                    }
                    catch (XmlPullParserException e) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (is == null) break block21;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return ret;
    }

    private class WeiboWebViewClient
    extends WebViewClient {
        private WeiboWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            Log.d((String)WeiboDialog.TAG, (String)("Redirect URL: " + url));
            if (url.startsWith("sms:")) {
                Intent sendIntent = new Intent("android.intent.action.VIEW");
                sendIntent.putExtra("address", url.replace("sms:", ""));
                sendIntent.setType("vnd.android-dir/mms-sms");
                WeiboDialog.this.getContext().startActivity(sendIntent);
                return true;
            }
            return super.shouldOverrideUrlLoading(view, url);
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            WeiboDialog.this.mListener.onError(new WeiboDialogError(description, errorCode, failingUrl));
            WeiboDialog.this.dismiss();
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            Log.d((String)WeiboDialog.TAG, (String)("onPageStarted URL: " + url));
            if (url.startsWith(Weibo.redirecturl)) {
                WeiboDialog.this.handleRedirectUrl(view, url);
                view.stopLoading();
                WeiboDialog.this.dismiss();
                return;
            }
            super.onPageStarted(view, url, favicon);
            WeiboDialog.this.mSpinner.show();
        }

        public void onPageFinished(WebView view, String url) {
            Log.d((String)WeiboDialog.TAG, (String)("onPageFinished URL: " + url));
            super.onPageFinished(view, url);
            if (WeiboDialog.this.mSpinner.isShowing()) {
                WeiboDialog.this.mSpinner.dismiss();
            }
            WeiboDialog.this.mWebView.setVisibility(0);
        }

        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            handler.proceed();
        }
    }
}

