/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.sdk.android;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.webkit.CookieSyncManager;
import com.weibo.sdk.android.Oauth2AccessToken;
import com.weibo.sdk.android.WeiboAuthListener;
import com.weibo.sdk.android.WeiboDialog;
import com.weibo.sdk.android.WeiboDialogError;
import com.weibo.sdk.android.WeiboException;
import com.weibo.sdk.android.WeiboParameters;
import com.weibo.sdk.android.util.Utility;

public class Weibo {
    private static final String WEIBO_SDK_VERSION = "2.0";
    public static String URL_OAUTH2_ACCESS_AUTHORIZE = "https://open.weibo.cn/oauth2/authorize";
    private static Weibo mWeiboInstance = null;
    public static String app_key = "";
    public static String redirecturl = "";
    public Oauth2AccessToken accessToken = null;
    public static final String KEY_TOKEN = "access_token";
    public static final String KEY_EXPIRES = "expires_in";
    public static final String KEY_REFRESHTOKEN = "refresh_token";
    public static boolean isWifi = false;

    public static synchronized Weibo getInstance(String appKey, String redirectUrl) {
        if (mWeiboInstance == null) {
            mWeiboInstance = new Weibo();
        }
        app_key = appKey;
        redirecturl = redirectUrl;
        return mWeiboInstance;
    }

    public void setupConsumerConfig(String appKey, String redirectUrl) {
        app_key = appKey;
        redirecturl = redirectUrl;
    }

    public void authorize(Context context, WeiboAuthListener listener) {
        isWifi = Utility.isWifi(context);
        this.startAuthDialog(context, listener);
    }

    public void startAuthDialog(Context context, final WeiboAuthListener listener) {
        WeiboParameters params = new WeiboParameters();
        this.startDialog(context, params, new WeiboAuthListener(){

            @Override
            public void onComplete(Bundle values) {
                CookieSyncManager.getInstance().sync();
                if (Weibo.this.accessToken == null) {
                    Weibo.this.accessToken = new Oauth2AccessToken();
                }
                Weibo.this.accessToken.setToken(values.getString(Weibo.KEY_TOKEN));
                Weibo.this.accessToken.setExpiresIn(values.getString(Weibo.KEY_EXPIRES));
                Weibo.this.accessToken.setRefreshToken(values.getString(Weibo.KEY_REFRESHTOKEN));
                if (Weibo.this.accessToken.isSessionValid()) {
                    Log.d((String)"Weibo-authorize", (String)("Login Success! access_token=" + Weibo.this.accessToken.getToken() + " expires=" + Weibo.this.accessToken.getExpiresTime() + " refresh_token=" + Weibo.this.accessToken.getRefreshToken()));
                    listener.onComplete(values);
                } else {
                    Log.d((String)"Weibo-authorize", (String)"Failed to receive access token");
                    listener.onWeiboException(new WeiboException("Failed to receive access token."));
                }
            }

            @Override
            public void onError(WeiboDialogError error) {
                Log.d((String)"Weibo-authorize", (String)("Login failed: " + error));
                listener.onError(error);
            }

            @Override
            public void onWeiboException(WeiboException error) {
                Log.d((String)"Weibo-authorize", (String)("Login failed: " + error));
                listener.onWeiboException(error);
            }

            @Override
            public void onCancel() {
                Log.d((String)"Weibo-authorize", (String)"Login canceled");
                listener.onCancel();
            }
        });
    }

    public void startDialog(Context context, WeiboParameters parameters, WeiboAuthListener listener) {
        parameters.add("client_id", app_key);
        parameters.add("response_type", "token");
        parameters.add("redirect_uri", redirecturl);
        parameters.add("display", "mobile");
        if (this.accessToken != null && this.accessToken.isSessionValid()) {
            parameters.add(KEY_TOKEN, this.accessToken.getToken());
        }
        String url = String.valueOf(URL_OAUTH2_ACCESS_AUTHORIZE) + "?" + Utility.encodeUrl(parameters);
        if (context.checkCallingOrSelfPermission("android.permission.INTERNET") != 0) {
            Utility.showAlert(context, "Error", "Application requires permission to access the Internet");
        } else {
            new WeiboDialog(context, url, listener).show();
        }
    }
}

