/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import twitter4j.PagableResponseList;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.TwitterException;
import twitter4j.User;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.json.PagableResponseListImpl;
import twitter4j.internal.json.ResponseListImpl;
import twitter4j.internal.json.StatusJSONImpl;
import twitter4j.internal.json.TwitterResponseImpl;
import twitter4j.internal.json.z_T4JInternalParseUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UserJSONImpl
extends TwitterResponseImpl
implements User,
Serializable {
    private long id;
    private String name;
    private String screenName;
    private String location;
    private String description;
    private boolean isContributorsEnabled;
    private String profileImageUrl;
    private String profileImageUrlHttps;
    private String url;
    private boolean isProtected;
    private int followersCount;
    private Status status;
    private String profileBackgroundColor;
    private String profileTextColor;
    private String profileLinkColor;
    private String profileSidebarFillColor;
    private String profileSidebarBorderColor;
    private boolean profileUseBackgroundImage;
    private boolean showAllInlineMedia;
    private int friendsCount;
    private Date createdAt;
    private int favouritesCount;
    private int utcOffset;
    private String timeZone;
    private String profileBackgroundImageUrl;
    private String profileBackgroundImageUrlHttps;
    private String profileBannerImageUrl;
    private boolean profileBackgroundTiled;
    private String lang;
    private int statusesCount;
    private boolean isGeoEnabled;
    private boolean isVerified;
    private boolean translator;
    private int listedCount;
    private boolean isFollowRequestSent;
    private static final long serialVersionUID = -6345893237975349030L;

    UserJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        super(res);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
        }
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    UserJSONImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    UserJSONImpl() {
    }

    private void init(JSONObject json) throws TwitterException {
        try {
            this.id = z_T4JInternalParseUtil.getLong("id", json);
            this.name = z_T4JInternalParseUtil.getRawString("name", json);
            this.screenName = z_T4JInternalParseUtil.getRawString("screen_name", json);
            this.location = z_T4JInternalParseUtil.getRawString("location", json);
            this.description = z_T4JInternalParseUtil.getRawString("description", json);
            this.isContributorsEnabled = z_T4JInternalParseUtil.getBoolean("contributors_enabled", json);
            this.profileImageUrl = z_T4JInternalParseUtil.getRawString("profile_image_url", json);
            this.profileImageUrlHttps = z_T4JInternalParseUtil.getRawString("profile_image_url_https", json);
            this.url = z_T4JInternalParseUtil.getRawString("url", json);
            this.isProtected = z_T4JInternalParseUtil.getBoolean("protected", json);
            this.isGeoEnabled = z_T4JInternalParseUtil.getBoolean("geo_enabled", json);
            this.isVerified = z_T4JInternalParseUtil.getBoolean("verified", json);
            this.translator = z_T4JInternalParseUtil.getBoolean("is_translator", json);
            this.followersCount = z_T4JInternalParseUtil.getInt("followers_count", json);
            this.profileBackgroundColor = z_T4JInternalParseUtil.getRawString("profile_background_color", json);
            this.profileTextColor = z_T4JInternalParseUtil.getRawString("profile_text_color", json);
            this.profileLinkColor = z_T4JInternalParseUtil.getRawString("profile_link_color", json);
            this.profileSidebarFillColor = z_T4JInternalParseUtil.getRawString("profile_sidebar_fill_color", json);
            this.profileSidebarBorderColor = z_T4JInternalParseUtil.getRawString("profile_sidebar_border_color", json);
            this.profileUseBackgroundImage = z_T4JInternalParseUtil.getBoolean("profile_use_background_image", json);
            this.showAllInlineMedia = z_T4JInternalParseUtil.getBoolean("show_all_inline_media", json);
            this.friendsCount = z_T4JInternalParseUtil.getInt("friends_count", json);
            this.createdAt = z_T4JInternalParseUtil.getDate("created_at", json, "EEE MMM dd HH:mm:ss z yyyy");
            this.favouritesCount = z_T4JInternalParseUtil.getInt("favourites_count", json);
            this.utcOffset = z_T4JInternalParseUtil.getInt("utc_offset", json);
            this.timeZone = z_T4JInternalParseUtil.getRawString("time_zone", json);
            this.profileBackgroundImageUrl = z_T4JInternalParseUtil.getRawString("profile_background_image_url", json);
            this.profileBackgroundImageUrlHttps = z_T4JInternalParseUtil.getRawString("profile_background_image_url_https", json);
            this.profileBannerImageUrl = z_T4JInternalParseUtil.getRawString("profile_banner_url", json);
            this.profileBackgroundTiled = z_T4JInternalParseUtil.getBoolean("profile_background_tile", json);
            this.lang = z_T4JInternalParseUtil.getRawString("lang", json);
            this.statusesCount = z_T4JInternalParseUtil.getInt("statuses_count", json);
            this.listedCount = z_T4JInternalParseUtil.getInt("listed_count", json);
            this.isFollowRequestSent = z_T4JInternalParseUtil.getBoolean("follow_request_sent", json);
            if (!json.isNull("status")) {
                JSONObject statusJSON = json.getJSONObject("status");
                this.status = new StatusJSONImpl(statusJSON);
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone.getMessage() + ":" + json.toString(), jsone);
        }
    }

    @Override
    public int compareTo(User that) {
        return (int)(this.id - that.getId());
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getScreenName() {
        return this.screenName;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isContributorsEnabled() {
        return this.isContributorsEnabled;
    }

    @Override
    public String getProfileImageURL() {
        return this.profileImageUrl;
    }

    @Override
    public String getBiggerProfileImageURL() {
        return this.toResizedURL(this.profileImageUrl, "_bigger");
    }

    @Override
    public String getMiniProfileImageURL() {
        return this.toResizedURL(this.profileImageUrl, "_mini");
    }

    @Override
    public String getOriginalProfileImageURL() {
        return this.toResizedURL(this.profileImageUrl, "");
    }

    private String toResizedURL(String originalURL, String sizeSuffix) {
        if (null != originalURL) {
            int index = originalURL.lastIndexOf("_");
            int suffixIndex = originalURL.lastIndexOf(".");
            return originalURL.substring(0, index) + sizeSuffix + originalURL.substring(suffixIndex);
        }
        return null;
    }

    @Override
    public URL getProfileImageUrlHttps() {
        try {
            return new URL(this.profileImageUrlHttps);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public String getProfileImageURLHttps() {
        return this.profileImageUrlHttps;
    }

    @Override
    public String getBiggerProfileImageURLHttps() {
        return this.toResizedURL(this.profileImageUrlHttps, "_bigger");
    }

    @Override
    public String getMiniProfileImageURLHttps() {
        return this.toResizedURL(this.profileImageUrlHttps, "_mini");
    }

    @Override
    public String getOriginalProfileImageURLHttps() {
        return this.toResizedURL(this.profileImageUrlHttps, "");
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public boolean isProtected() {
        return this.isProtected;
    }

    @Override
    public int getFollowersCount() {
        return this.followersCount;
    }

    @Override
    public String getProfileBackgroundColor() {
        return this.profileBackgroundColor;
    }

    @Override
    public String getProfileTextColor() {
        return this.profileTextColor;
    }

    @Override
    public String getProfileLinkColor() {
        return this.profileLinkColor;
    }

    @Override
    public String getProfileSidebarFillColor() {
        return this.profileSidebarFillColor;
    }

    @Override
    public String getProfileSidebarBorderColor() {
        return this.profileSidebarBorderColor;
    }

    @Override
    public boolean isProfileUseBackgroundImage() {
        return this.profileUseBackgroundImage;
    }

    @Override
    public boolean isShowAllInlineMedia() {
        return this.showAllInlineMedia;
    }

    @Override
    public int getFriendsCount() {
        return this.friendsCount;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public int getFavouritesCount() {
        return this.favouritesCount;
    }

    @Override
    public int getUtcOffset() {
        return this.utcOffset;
    }

    @Override
    public String getTimeZone() {
        return this.timeZone;
    }

    @Override
    public String getProfileBackgroundImageUrl() {
        return this.getProfileBackgroundImageURL();
    }

    @Override
    public String getProfileBackgroundImageURL() {
        return this.profileBackgroundImageUrl;
    }

    @Override
    public String getProfileBackgroundImageUrlHttps() {
        return this.profileBackgroundImageUrlHttps;
    }

    @Override
    public String getProfileBannerURL() {
        return this.profileBannerImageUrl != null ? this.profileBannerImageUrl + "/web" : null;
    }

    @Override
    public String getProfileBannerRetinaURL() {
        return this.profileBannerImageUrl != null ? this.profileBannerImageUrl + "/web_retina" : null;
    }

    @Override
    public String getProfileBannerIPadURL() {
        return this.profileBannerImageUrl != null ? this.profileBannerImageUrl + "/ipad" : null;
    }

    @Override
    public String getProfileBannerIPadRetinaURL() {
        return this.profileBannerImageUrl != null ? this.profileBannerImageUrl + "/ipad_retina" : null;
    }

    @Override
    public String getProfileBannerMobileURL() {
        return this.profileBannerImageUrl != null ? this.profileBannerImageUrl + "/mobile" : null;
    }

    @Override
    public String getProfileBannerMobileRetinaURL() {
        return this.profileBannerImageUrl != null ? this.profileBannerImageUrl + "/ipad_retina" : null;
    }

    @Override
    public boolean isProfileBackgroundTiled() {
        return this.profileBackgroundTiled;
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    @Override
    public int getStatusesCount() {
        return this.statusesCount;
    }

    @Override
    public boolean isGeoEnabled() {
        return this.isGeoEnabled;
    }

    @Override
    public boolean isVerified() {
        return this.isVerified;
    }

    @Override
    public boolean isTranslator() {
        return this.translator;
    }

    @Override
    public int getListedCount() {
        return this.listedCount;
    }

    @Override
    public boolean isFollowRequestSent() {
        return this.isFollowRequestSent;
    }

    static PagableResponseList<User> createPagableUserList(HttpResponse res, Configuration conf) throws TwitterException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("users");
            int size = list.length();
            PagableResponseListImpl users = new PagableResponseListImpl(size, json, res);
            for (int i = 0; i < size; ++i) {
                JSONObject userJson = list.getJSONObject(i);
                UserJSONImpl user = new UserJSONImpl(userJson);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(user, userJson);
                }
                users.add(user);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(users, json);
            }
            return users;
        }
        catch (JSONException jsone) {
            throw new TwitterException((Exception)((Object)jsone));
        }
        catch (TwitterException te) {
            throw te;
        }
    }

    static ResponseList<User> createUserList(HttpResponse res, Configuration conf) throws TwitterException {
        return UserJSONImpl.createUserList(res.asJSONArray(), res, conf);
    }

    static ResponseList<User> createUserList(JSONArray list, HttpResponse res, Configuration conf) throws TwitterException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            int size = list.length();
            ResponseListImpl<User> users = new ResponseListImpl<User>(size, res);
            for (int i = 0; i < size; ++i) {
                JSONObject json = list.getJSONObject(i);
                UserJSONImpl user = new UserJSONImpl(json);
                users.add(user);
                if (!conf.isJSONStoreEnabled()) continue;
                DataObjectFactoryUtil.registerJSONObject(user, json);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(users, list);
            }
            return users;
        }
        catch (JSONException jsone) {
            throw new TwitterException((Exception)((Object)jsone));
        }
        catch (TwitterException te) {
            throw te;
        }
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof User && ((User)obj).getId() == this.id;
    }

    public String toString() {
        return "UserJSONImpl{id=" + this.id + ", name='" + this.name + '\'' + ", screenName='" + this.screenName + '\'' + ", location='" + this.location + '\'' + ", description='" + this.description + '\'' + ", isContributorsEnabled=" + this.isContributorsEnabled + ", profileImageUrl='" + this.profileImageUrl + '\'' + ", profileImageUrlHttps='" + this.profileImageUrlHttps + '\'' + ", url='" + this.url + '\'' + ", isProtected=" + this.isProtected + ", followersCount=" + this.followersCount + ", status=" + this.status + ", profileBackgroundColor='" + this.profileBackgroundColor + '\'' + ", profileTextColor='" + this.profileTextColor + '\'' + ", profileLinkColor='" + this.profileLinkColor + '\'' + ", profileSidebarFillColor='" + this.profileSidebarFillColor + '\'' + ", profileSidebarBorderColor='" + this.profileSidebarBorderColor + '\'' + ", profileUseBackgroundImage=" + this.profileUseBackgroundImage + ", showAllInlineMedia=" + this.showAllInlineMedia + ", friendsCount=" + this.friendsCount + ", createdAt=" + this.createdAt + ", favouritesCount=" + this.favouritesCount + ", utcOffset=" + this.utcOffset + ", timeZone='" + this.timeZone + '\'' + ", profileBackgroundImageUrl='" + this.profileBackgroundImageUrl + '\'' + ", profileBackgroundImageUrlHttps='" + this.profileBackgroundImageUrlHttps + '\'' + ", profileBackgroundTiled=" + this.profileBackgroundTiled + ", lang='" + this.lang + '\'' + ", statusesCount=" + this.statusesCount + ", isGeoEnabled=" + this.isGeoEnabled + ", isVerified=" + this.isVerified + ", translator=" + this.translator + ", listedCount=" + this.listedCount + ", isFollowRequestSent=" + this.isFollowRequestSent + '}';
    }
}

