/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import twitter4j.GeoLocation;
import twitter4j.HashtagEntity;
import twitter4j.MediaEntity;
import twitter4j.Place;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.TwitterException;
import twitter4j.URLEntity;
import twitter4j.User;
import twitter4j.UserMentionEntity;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.json.EntityIndex;
import twitter4j.internal.json.HTMLEntity;
import twitter4j.internal.json.HashtagEntityJSONImpl;
import twitter4j.internal.json.MediaEntityJSONImpl;
import twitter4j.internal.json.PlaceJSONImpl;
import twitter4j.internal.json.ResponseListImpl;
import twitter4j.internal.json.TwitterResponseImpl;
import twitter4j.internal.json.URLEntityJSONImpl;
import twitter4j.internal.json.UserJSONImpl;
import twitter4j.internal.json.UserMentionEntityJSONImpl;
import twitter4j.internal.json.z_T4JInternalJSONImplFactory;
import twitter4j.internal.json.z_T4JInternalParseUtil;
import twitter4j.internal.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StatusJSONImpl
extends TwitterResponseImpl
implements Status,
Serializable {
    private static final Logger logger = Logger.getLogger(StatusJSONImpl.class);
    private static final long serialVersionUID = 7548618898682727465L;
    private Date createdAt;
    private long id;
    private String text;
    private String source;
    private boolean isTruncated;
    private long inReplyToStatusId;
    private long inReplyToUserId;
    private boolean isFavorited;
    private String inReplyToScreenName;
    private GeoLocation geoLocation = null;
    private Place place = null;
    private long retweetCount;
    private boolean isPossiblySensitive;
    private long[] contributorsIDs;
    private Status retweetedStatus;
    private UserMentionEntity[] userMentionEntities;
    private URLEntity[] urlEntities;
    private HashtagEntity[] hashtagEntities;
    private MediaEntity[] mediaEntities;
    private long currentUserRetweetId = -1L;
    private User user = null;

    StatusJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    StatusJSONImpl(JSONObject json, Configuration conf) throws TwitterException {
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    StatusJSONImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    StatusJSONImpl() {
    }

    private void init(JSONObject json) throws TwitterException {
        this.id = z_T4JInternalParseUtil.getLong("id", json);
        this.source = z_T4JInternalParseUtil.getUnescapedString("source", json);
        this.createdAt = z_T4JInternalParseUtil.getDate("created_at", json);
        this.isTruncated = z_T4JInternalParseUtil.getBoolean("truncated", json);
        this.inReplyToStatusId = z_T4JInternalParseUtil.getLong("in_reply_to_status_id", json);
        this.inReplyToUserId = z_T4JInternalParseUtil.getLong("in_reply_to_user_id", json);
        this.isFavorited = z_T4JInternalParseUtil.getBoolean("favorited", json);
        this.inReplyToScreenName = z_T4JInternalParseUtil.getUnescapedString("in_reply_to_screen_name", json);
        this.retweetCount = z_T4JInternalParseUtil.getLong("retweet_count", json);
        this.isPossiblySensitive = z_T4JInternalParseUtil.getBoolean("possibly_sensitive", json);
        try {
            if (!json.isNull("user")) {
                this.user = new UserJSONImpl(json.getJSONObject("user"));
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException((Exception)((Object)jsone));
        }
        this.geoLocation = z_T4JInternalJSONImplFactory.createGeoLocation(json);
        if (!json.isNull("place")) {
            try {
                this.place = new PlaceJSONImpl(json.getJSONObject("place"));
            }
            catch (JSONException ignore) {
                ignore.printStackTrace();
                logger.warn("failed to parse place:" + json);
            }
        }
        if (!json.isNull("retweeted_status")) {
            try {
                this.retweetedStatus = new StatusJSONImpl(json.getJSONObject("retweeted_status"));
            }
            catch (JSONException ignore) {
                ignore.printStackTrace();
                logger.warn("failed to parse retweeted_status:" + json);
            }
        }
        if (!json.isNull("contributors")) {
            try {
                JSONArray contributorsArray = json.getJSONArray("contributors");
                this.contributorsIDs = new long[contributorsArray.length()];
                for (int i = 0; i < contributorsArray.length(); ++i) {
                    this.contributorsIDs[i] = Long.parseLong(contributorsArray.getString(i));
                }
            }
            catch (NumberFormatException ignore) {
                ignore.printStackTrace();
                logger.warn("failed to parse contributors:" + json);
            }
            catch (JSONException ignore) {
                ignore.printStackTrace();
                logger.warn("failed to parse contributors:" + json);
            }
        } else {
            this.contributorsIDs = new long[0];
        }
        if (!json.isNull("entities")) {
            try {
                int i;
                int len;
                JSONObject entities = json.getJSONObject("entities");
                if (!entities.isNull("user_mentions")) {
                    JSONArray userMentionsArray = entities.getJSONArray("user_mentions");
                    len = userMentionsArray.length();
                    this.userMentionEntities = new UserMentionEntity[len];
                    for (i = 0; i < len; ++i) {
                        this.userMentionEntities[i] = new UserMentionEntityJSONImpl(userMentionsArray.getJSONObject(i));
                    }
                }
                if (!entities.isNull("urls")) {
                    JSONArray urlsArray = entities.getJSONArray("urls");
                    len = urlsArray.length();
                    this.urlEntities = new URLEntity[len];
                    for (i = 0; i < len; ++i) {
                        this.urlEntities[i] = new URLEntityJSONImpl(urlsArray.getJSONObject(i));
                    }
                }
                if (!entities.isNull("hashtags")) {
                    JSONArray hashtagsArray = entities.getJSONArray("hashtags");
                    len = hashtagsArray.length();
                    this.hashtagEntities = new HashtagEntity[len];
                    for (i = 0; i < len; ++i) {
                        this.hashtagEntities[i] = new HashtagEntityJSONImpl(hashtagsArray.getJSONObject(i));
                    }
                }
                if (!entities.isNull("media")) {
                    JSONArray mediaArray = entities.getJSONArray("media");
                    len = mediaArray.length();
                    this.mediaEntities = new MediaEntity[len];
                    for (i = 0; i < len; ++i) {
                        this.mediaEntities[i] = new MediaEntityJSONImpl(mediaArray.getJSONObject(i));
                    }
                }
            }
            catch (JSONException jsone) {
                throw new TwitterException((Exception)((Object)jsone));
            }
        }
        if (this.userMentionEntities == null) {
            this.userMentionEntities = new UserMentionEntity[0];
        }
        if (this.urlEntities == null) {
            this.urlEntities = new URLEntity[0];
        }
        if (this.hashtagEntities == null) {
            this.hashtagEntities = new HashtagEntity[0];
        }
        if (this.mediaEntities == null) {
            this.mediaEntities = new MediaEntity[0];
        }
        EntityIndex[] entityIndexes = new EntityIndex[this.userMentionEntities.length + this.urlEntities.length + this.hashtagEntities.length + this.mediaEntities.length];
        System.arraycopy(this.userMentionEntities, 0, entityIndexes, 0, this.userMentionEntities.length);
        System.arraycopy(this.urlEntities, 0, entityIndexes, this.userMentionEntities.length, this.urlEntities.length);
        System.arraycopy(this.hashtagEntities, 0, entityIndexes, this.userMentionEntities.length + this.urlEntities.length, this.hashtagEntities.length);
        System.arraycopy(this.mediaEntities, 0, entityIndexes, this.userMentionEntities.length + this.urlEntities.length + this.hashtagEntities.length, this.mediaEntities.length);
        try {
            this.text = HTMLEntity.unescapeAndSlideEntityIncdices(json.getString("text"), entityIndexes);
        }
        catch (JSONException jsone) {
            throw new TwitterException((Exception)((Object)jsone));
        }
        if (!json.isNull("current_user_retweet")) {
            try {
                this.currentUserRetweetId = json.getJSONObject("current_user_retweet").getLong("id");
            }
            catch (JSONException ignore) {
                ignore.printStackTrace();
                logger.warn("failed to parse current_user_retweet:" + json);
            }
        }
    }

    @Override
    public int compareTo(Status that) {
        long delta = this.id - that.getId();
        if (delta < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (delta > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)delta;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public boolean isTruncated() {
        return this.isTruncated;
    }

    @Override
    public long getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    @Override
    public long getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    @Override
    public String getInReplyToScreenName() {
        return this.inReplyToScreenName;
    }

    @Override
    public GeoLocation getGeoLocation() {
        return this.geoLocation;
    }

    @Override
    public Place getPlace() {
        return this.place;
    }

    @Override
    public long[] getContributors() {
        return this.contributorsIDs;
    }

    @Override
    public boolean isFavorited() {
        return this.isFavorited;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public boolean isRetweet() {
        return this.retweetedStatus != null;
    }

    @Override
    public Status getRetweetedStatus() {
        return this.retweetedStatus;
    }

    @Override
    public long getRetweetCount() {
        return this.retweetCount;
    }

    @Override
    public boolean isRetweetedByMe() {
        return this.currentUserRetweetId != -1L;
    }

    @Override
    public long getCurrentUserRetweetId() {
        return this.currentUserRetweetId;
    }

    @Override
    public boolean isPossiblySensitive() {
        return this.isPossiblySensitive;
    }

    @Override
    public UserMentionEntity[] getUserMentionEntities() {
        return this.userMentionEntities;
    }

    @Override
    public URLEntity[] getURLEntities() {
        return this.urlEntities;
    }

    @Override
    public HashtagEntity[] getHashtagEntities() {
        return this.hashtagEntities;
    }

    @Override
    public MediaEntity[] getMediaEntities() {
        return this.mediaEntities;
    }

    static ResponseList<Status> createStatusList(HttpResponse res, Configuration conf) throws TwitterException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ResponseListImpl<Status> statuses = new ResponseListImpl<Status>(size, res);
            for (int i = 0; i < size; ++i) {
                JSONObject json = list.getJSONObject(i);
                StatusJSONImpl status = new StatusJSONImpl(json);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(status, json);
                }
                statuses.add(status);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(statuses, list);
            }
            return statuses;
        }
        catch (JSONException jsone) {
            throw new TwitterException((Exception)((Object)jsone));
        }
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof Status && ((Status)obj).getId() == this.id;
    }

    public String toString() {
        return "StatusJSONImpl{createdAt=" + this.createdAt + ", id=" + this.id + ", text='" + this.text + '\'' + ", source='" + this.source + '\'' + ", isTruncated=" + this.isTruncated + ", inReplyToStatusId=" + this.inReplyToStatusId + ", inReplyToUserId=" + this.inReplyToUserId + ", isFavorited=" + this.isFavorited + ", inReplyToScreenName='" + this.inReplyToScreenName + '\'' + ", geoLocation=" + this.geoLocation + ", place=" + this.place + ", retweetCount=" + this.retweetCount + ", isPossiblySensitive=" + this.isPossiblySensitive + ", contributorsIDs=" + this.contributorsIDs + ", retweetedStatus=" + this.retweetedStatus + ", userMentionEntities=" + (this.userMentionEntities == null ? null : Arrays.asList(this.userMentionEntities)) + ", urlEntities=" + (this.urlEntities == null ? null : Arrays.asList(this.urlEntities)) + ", hashtagEntities=" + (this.hashtagEntities == null ? null : Arrays.asList(this.hashtagEntities)) + ", mediaEntities=" + (this.mediaEntities == null ? null : Arrays.asList(this.mediaEntities)) + ", currentUserRetweetId=" + this.currentUserRetweetId + ", user=" + this.user + '}';
    }
}

