/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.org.codehaus.jackson.map.introspect;

import com.flurry.org.codehaus.jackson.annotate.JacksonAnnotation;
import com.flurry.org.codehaus.jackson.annotate.JsonAnyGetter;
import com.flurry.org.codehaus.jackson.annotate.JsonAnySetter;
import com.flurry.org.codehaus.jackson.annotate.JsonAutoDetect;
import com.flurry.org.codehaus.jackson.annotate.JsonBackReference;
import com.flurry.org.codehaus.jackson.annotate.JsonCreator;
import com.flurry.org.codehaus.jackson.annotate.JsonGetter;
import com.flurry.org.codehaus.jackson.annotate.JsonIgnore;
import com.flurry.org.codehaus.jackson.annotate.JsonIgnoreProperties;
import com.flurry.org.codehaus.jackson.annotate.JsonIgnoreType;
import com.flurry.org.codehaus.jackson.annotate.JsonManagedReference;
import com.flurry.org.codehaus.jackson.annotate.JsonProperty;
import com.flurry.org.codehaus.jackson.annotate.JsonPropertyOrder;
import com.flurry.org.codehaus.jackson.annotate.JsonRawValue;
import com.flurry.org.codehaus.jackson.annotate.JsonSetter;
import com.flurry.org.codehaus.jackson.annotate.JsonSubTypes;
import com.flurry.org.codehaus.jackson.annotate.JsonTypeInfo;
import com.flurry.org.codehaus.jackson.annotate.JsonTypeName;
import com.flurry.org.codehaus.jackson.annotate.JsonUnwrapped;
import com.flurry.org.codehaus.jackson.annotate.JsonValue;
import com.flurry.org.codehaus.jackson.annotate.JsonWriteNullProperties;
import com.flurry.org.codehaus.jackson.map.AnnotationIntrospector;
import com.flurry.org.codehaus.jackson.map.JsonDeserializer;
import com.flurry.org.codehaus.jackson.map.JsonSerializer;
import com.flurry.org.codehaus.jackson.map.KeyDeserializer;
import com.flurry.org.codehaus.jackson.map.MapperConfig;
import com.flurry.org.codehaus.jackson.map.annotate.JacksonInject;
import com.flurry.org.codehaus.jackson.map.annotate.JsonCachable;
import com.flurry.org.codehaus.jackson.map.annotate.JsonDeserialize;
import com.flurry.org.codehaus.jackson.map.annotate.JsonFilter;
import com.flurry.org.codehaus.jackson.map.annotate.JsonRootName;
import com.flurry.org.codehaus.jackson.map.annotate.JsonSerialize;
import com.flurry.org.codehaus.jackson.map.annotate.JsonTypeIdResolver;
import com.flurry.org.codehaus.jackson.map.annotate.JsonTypeResolver;
import com.flurry.org.codehaus.jackson.map.annotate.JsonValueInstantiator;
import com.flurry.org.codehaus.jackson.map.annotate.JsonView;
import com.flurry.org.codehaus.jackson.map.annotate.NoClass;
import com.flurry.org.codehaus.jackson.map.introspect.Annotated;
import com.flurry.org.codehaus.jackson.map.introspect.AnnotatedClass;
import com.flurry.org.codehaus.jackson.map.introspect.AnnotatedConstructor;
import com.flurry.org.codehaus.jackson.map.introspect.AnnotatedField;
import com.flurry.org.codehaus.jackson.map.introspect.AnnotatedMember;
import com.flurry.org.codehaus.jackson.map.introspect.AnnotatedMethod;
import com.flurry.org.codehaus.jackson.map.introspect.AnnotatedParameter;
import com.flurry.org.codehaus.jackson.map.introspect.VisibilityChecker;
import com.flurry.org.codehaus.jackson.map.jsontype.NamedType;
import com.flurry.org.codehaus.jackson.map.jsontype.TypeIdResolver;
import com.flurry.org.codehaus.jackson.map.jsontype.TypeResolverBuilder;
import com.flurry.org.codehaus.jackson.map.jsontype.impl.StdTypeResolverBuilder;
import com.flurry.org.codehaus.jackson.map.ser.std.RawSerializer;
import com.flurry.org.codehaus.jackson.type.JavaType;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JacksonAnnotationIntrospector
extends AnnotationIntrospector {
    @Override
    public boolean isHandled(Annotation ann) {
        Class<? extends Annotation> acls = ann.annotationType();
        return acls.getAnnotation(JacksonAnnotation.class) != null;
    }

    @Override
    public String findEnumValue(Enum<?> value) {
        return value.name();
    }

    @Override
    public Boolean findCachability(AnnotatedClass ac2) {
        JsonCachable ann = ac2.getAnnotation(JsonCachable.class);
        if (ann == null) {
            return null;
        }
        return ann.value() ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public String findRootName(AnnotatedClass ac2) {
        JsonRootName ann = ac2.getAnnotation(JsonRootName.class);
        return ann == null ? null : ann.value();
    }

    @Override
    public String[] findPropertiesToIgnore(AnnotatedClass ac2) {
        JsonIgnoreProperties ignore = ac2.getAnnotation(JsonIgnoreProperties.class);
        return ignore == null ? null : ignore.value();
    }

    @Override
    public Boolean findIgnoreUnknownProperties(AnnotatedClass ac2) {
        JsonIgnoreProperties ignore = ac2.getAnnotation(JsonIgnoreProperties.class);
        return ignore == null ? null : Boolean.valueOf(ignore.ignoreUnknown());
    }

    @Override
    public Boolean isIgnorableType(AnnotatedClass ac2) {
        JsonIgnoreType ignore = ac2.getAnnotation(JsonIgnoreType.class);
        return ignore == null ? null : Boolean.valueOf(ignore.value());
    }

    @Override
    public Object findFilterId(AnnotatedClass ac2) {
        String id;
        JsonFilter ann = ac2.getAnnotation(JsonFilter.class);
        if (ann != null && (id = ann.value()).length() > 0) {
            return id;
        }
        return null;
    }

    @Override
    public VisibilityChecker<?> findAutoDetectVisibility(AnnotatedClass ac2, VisibilityChecker<?> checker) {
        JsonAutoDetect ann = ac2.getAnnotation(JsonAutoDetect.class);
        return ann == null ? checker : checker.with(ann);
    }

    @Override
    public AnnotationIntrospector.ReferenceProperty findReferenceType(AnnotatedMember member) {
        JsonManagedReference ref1 = member.getAnnotation(JsonManagedReference.class);
        if (ref1 != null) {
            return AnnotationIntrospector.ReferenceProperty.managed(ref1.value());
        }
        JsonBackReference ref2 = member.getAnnotation(JsonBackReference.class);
        if (ref2 != null) {
            return AnnotationIntrospector.ReferenceProperty.back(ref2.value());
        }
        return null;
    }

    @Override
    public Boolean shouldUnwrapProperty(AnnotatedMember member) {
        JsonUnwrapped ann = member.getAnnotation(JsonUnwrapped.class);
        return ann != null && ann.enabled() ? Boolean.TRUE : null;
    }

    @Override
    public boolean hasIgnoreMarker(AnnotatedMember m2) {
        return this._isIgnorable(m2);
    }

    @Override
    public Object findInjectableValueId(AnnotatedMember m2) {
        JacksonInject ann = m2.getAnnotation(JacksonInject.class);
        if (ann == null) {
            return null;
        }
        String id = ann.value();
        if (id.length() == 0) {
            if (!(m2 instanceof AnnotatedMethod)) {
                return m2.getRawType().getName();
            }
            AnnotatedMethod am2 = (AnnotatedMethod)m2;
            if (am2.getParameterCount() == 0) {
                return m2.getRawType().getName();
            }
            return am2.getParameterClass(0).getName();
        }
        return id;
    }

    @Override
    public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> config, AnnotatedClass ac2, JavaType baseType) {
        return this._findTypeResolver(config, ac2, baseType);
    }

    @Override
    public TypeResolverBuilder<?> findPropertyTypeResolver(MapperConfig<?> config, AnnotatedMember am2, JavaType baseType) {
        if (baseType.isContainerType()) {
            return null;
        }
        return this._findTypeResolver(config, am2, baseType);
    }

    @Override
    public TypeResolverBuilder<?> findPropertyContentTypeResolver(MapperConfig<?> config, AnnotatedMember am2, JavaType containerType) {
        if (!containerType.isContainerType()) {
            throw new IllegalArgumentException("Must call method with a container type (got " + containerType + ")");
        }
        return this._findTypeResolver(config, am2, containerType);
    }

    @Override
    public List<NamedType> findSubtypes(Annotated a2) {
        JsonSubTypes t2 = a2.getAnnotation(JsonSubTypes.class);
        if (t2 == null) {
            return null;
        }
        JsonSubTypes.Type[] types = t2.value();
        ArrayList<NamedType> result = new ArrayList<NamedType>(types.length);
        for (JsonSubTypes.Type type : types) {
            result.add(new NamedType(type.value(), type.name()));
        }
        return result;
    }

    @Override
    public String findTypeName(AnnotatedClass ac2) {
        JsonTypeName tn = ac2.getAnnotation(JsonTypeName.class);
        return tn == null ? null : tn.value();
    }

    @Override
    public boolean isIgnorableMethod(AnnotatedMethod m2) {
        return this._isIgnorable(m2);
    }

    @Override
    public boolean isIgnorableConstructor(AnnotatedConstructor c2) {
        return this._isIgnorable(c2);
    }

    @Override
    public boolean isIgnorableField(AnnotatedField f2) {
        return this._isIgnorable(f2);
    }

    @Override
    public Object findSerializer(Annotated a2) {
        Class<? extends JsonSerializer<?>> serClass;
        JsonSerialize ann = a2.getAnnotation(JsonSerialize.class);
        if (ann != null && (serClass = ann.using()) != JsonSerializer.None.class) {
            return serClass;
        }
        JsonRawValue annRaw = a2.getAnnotation(JsonRawValue.class);
        if (annRaw != null && annRaw.value()) {
            Class<?> cls = a2.getRawType();
            return new RawSerializer(cls);
        }
        return null;
    }

    @Override
    public Class<? extends JsonSerializer<?>> findKeySerializer(Annotated a2) {
        Class<? extends JsonSerializer<?>> serClass;
        JsonSerialize ann = a2.getAnnotation(JsonSerialize.class);
        if (ann != null && (serClass = ann.keyUsing()) != JsonSerializer.None.class) {
            return serClass;
        }
        return null;
    }

    @Override
    public Class<? extends JsonSerializer<?>> findContentSerializer(Annotated a2) {
        Class<? extends JsonSerializer<?>> serClass;
        JsonSerialize ann = a2.getAnnotation(JsonSerialize.class);
        if (ann != null && (serClass = ann.contentUsing()) != JsonSerializer.None.class) {
            return serClass;
        }
        return null;
    }

    @Override
    public JsonSerialize.Inclusion findSerializationInclusion(Annotated a2, JsonSerialize.Inclusion defValue) {
        JsonSerialize ann = a2.getAnnotation(JsonSerialize.class);
        if (ann != null) {
            return ann.include();
        }
        JsonWriteNullProperties oldAnn = a2.getAnnotation(JsonWriteNullProperties.class);
        if (oldAnn != null) {
            boolean writeNulls = oldAnn.value();
            return writeNulls ? JsonSerialize.Inclusion.ALWAYS : JsonSerialize.Inclusion.NON_NULL;
        }
        return defValue;
    }

    @Override
    public Class<?> findSerializationType(Annotated am2) {
        Class<?> cls;
        JsonSerialize ann = am2.getAnnotation(JsonSerialize.class);
        if (ann != null && (cls = ann.as()) != NoClass.class) {
            return cls;
        }
        return null;
    }

    @Override
    public Class<?> findSerializationKeyType(Annotated am2, JavaType baseType) {
        Class<?> cls;
        JsonSerialize ann = am2.getAnnotation(JsonSerialize.class);
        if (ann != null && (cls = ann.keyAs()) != NoClass.class) {
            return cls;
        }
        return null;
    }

    @Override
    public Class<?> findSerializationContentType(Annotated am2, JavaType baseType) {
        Class<?> cls;
        JsonSerialize ann = am2.getAnnotation(JsonSerialize.class);
        if (ann != null && (cls = ann.contentAs()) != NoClass.class) {
            return cls;
        }
        return null;
    }

    @Override
    public JsonSerialize.Typing findSerializationTyping(Annotated a2) {
        JsonSerialize ann = a2.getAnnotation(JsonSerialize.class);
        return ann == null ? null : ann.typing();
    }

    @Override
    public Class<?>[] findSerializationViews(Annotated a2) {
        JsonView ann = a2.getAnnotation(JsonView.class);
        return ann == null ? null : ann.value();
    }

    @Override
    public String[] findSerializationPropertyOrder(AnnotatedClass ac2) {
        JsonPropertyOrder order = ac2.getAnnotation(JsonPropertyOrder.class);
        return order == null ? null : order.value();
    }

    @Override
    public Boolean findSerializationSortAlphabetically(AnnotatedClass ac2) {
        JsonPropertyOrder order = ac2.getAnnotation(JsonPropertyOrder.class);
        return order == null ? null : Boolean.valueOf(order.alphabetic());
    }

    @Override
    public String findGettablePropertyName(AnnotatedMethod am2) {
        JsonProperty pann = am2.getAnnotation(JsonProperty.class);
        if (pann != null) {
            return pann.value();
        }
        JsonGetter ann = am2.getAnnotation(JsonGetter.class);
        if (ann != null) {
            return ann.value();
        }
        if (am2.hasAnnotation(JsonSerialize.class) || am2.hasAnnotation(JsonView.class)) {
            return "";
        }
        return null;
    }

    @Override
    public boolean hasAsValueAnnotation(AnnotatedMethod am2) {
        JsonValue ann = am2.getAnnotation(JsonValue.class);
        return ann != null && ann.value();
    }

    @Override
    public String findSerializablePropertyName(AnnotatedField af2) {
        JsonProperty pann = af2.getAnnotation(JsonProperty.class);
        if (pann != null) {
            return pann.value();
        }
        if (af2.hasAnnotation(JsonSerialize.class) || af2.hasAnnotation(JsonView.class)) {
            return "";
        }
        return null;
    }

    @Override
    public Class<? extends JsonDeserializer<?>> findDeserializer(Annotated a2) {
        Class<? extends JsonDeserializer<?>> deserClass;
        JsonDeserialize ann = a2.getAnnotation(JsonDeserialize.class);
        if (ann != null && (deserClass = ann.using()) != JsonDeserializer.None.class) {
            return deserClass;
        }
        return null;
    }

    @Override
    public Class<? extends KeyDeserializer> findKeyDeserializer(Annotated a2) {
        Class<? extends KeyDeserializer> deserClass;
        JsonDeserialize ann = a2.getAnnotation(JsonDeserialize.class);
        if (ann != null && (deserClass = ann.keyUsing()) != KeyDeserializer.None.class) {
            return deserClass;
        }
        return null;
    }

    @Override
    public Class<? extends JsonDeserializer<?>> findContentDeserializer(Annotated a2) {
        Class<? extends JsonDeserializer<?>> deserClass;
        JsonDeserialize ann = a2.getAnnotation(JsonDeserialize.class);
        if (ann != null && (deserClass = ann.contentUsing()) != JsonDeserializer.None.class) {
            return deserClass;
        }
        return null;
    }

    @Override
    public Class<?> findDeserializationType(Annotated am2, JavaType baseType, String propName) {
        Class<?> cls;
        JsonDeserialize ann = am2.getAnnotation(JsonDeserialize.class);
        if (ann != null && (cls = ann.as()) != NoClass.class) {
            return cls;
        }
        return null;
    }

    @Override
    public Class<?> findDeserializationKeyType(Annotated am2, JavaType baseKeyType, String propName) {
        Class<?> cls;
        JsonDeserialize ann = am2.getAnnotation(JsonDeserialize.class);
        if (ann != null && (cls = ann.keyAs()) != NoClass.class) {
            return cls;
        }
        return null;
    }

    @Override
    public Class<?> findDeserializationContentType(Annotated am2, JavaType baseContentType, String propName) {
        Class<?> cls;
        JsonDeserialize ann = am2.getAnnotation(JsonDeserialize.class);
        if (ann != null && (cls = ann.contentAs()) != NoClass.class) {
            return cls;
        }
        return null;
    }

    @Override
    public Object findValueInstantiator(AnnotatedClass ac2) {
        JsonValueInstantiator ann = ac2.getAnnotation(JsonValueInstantiator.class);
        return ann == null ? null : ann.value();
    }

    @Override
    public String findSettablePropertyName(AnnotatedMethod am2) {
        JsonProperty pann = am2.getAnnotation(JsonProperty.class);
        if (pann != null) {
            return pann.value();
        }
        JsonSetter ann = am2.getAnnotation(JsonSetter.class);
        if (ann != null) {
            return ann.value();
        }
        if (am2.hasAnnotation(JsonDeserialize.class) || am2.hasAnnotation(JsonView.class) || am2.hasAnnotation(JsonBackReference.class) || am2.hasAnnotation(JsonManagedReference.class)) {
            return "";
        }
        return null;
    }

    @Override
    public boolean hasAnySetterAnnotation(AnnotatedMethod am2) {
        return am2.hasAnnotation(JsonAnySetter.class);
    }

    @Override
    public boolean hasAnyGetterAnnotation(AnnotatedMethod am2) {
        return am2.hasAnnotation(JsonAnyGetter.class);
    }

    @Override
    public boolean hasCreatorAnnotation(Annotated a2) {
        return a2.hasAnnotation(JsonCreator.class);
    }

    @Override
    public String findDeserializablePropertyName(AnnotatedField af2) {
        JsonProperty pann = af2.getAnnotation(JsonProperty.class);
        if (pann != null) {
            return pann.value();
        }
        if (af2.hasAnnotation(JsonDeserialize.class) || af2.hasAnnotation(JsonView.class) || af2.hasAnnotation(JsonBackReference.class) || af2.hasAnnotation(JsonManagedReference.class)) {
            return "";
        }
        return null;
    }

    @Override
    public String findPropertyNameForParam(AnnotatedParameter param) {
        JsonProperty pann;
        if (param != null && (pann = param.getAnnotation(JsonProperty.class)) != null) {
            return pann.value();
        }
        return null;
    }

    protected boolean _isIgnorable(Annotated a2) {
        JsonIgnore ann = a2.getAnnotation(JsonIgnore.class);
        return ann != null && ann.value();
    }

    protected TypeResolverBuilder<?> _findTypeResolver(MapperConfig<?> config, Annotated ann, JavaType baseType) {
        TypeIdResolver idRes;
        StdTypeResolverBuilder b2;
        JsonTypeInfo info = ann.getAnnotation(JsonTypeInfo.class);
        JsonTypeResolver resAnn = ann.getAnnotation(JsonTypeResolver.class);
        if (resAnn != null) {
            if (info == null) {
                return null;
            }
            b2 = config.typeResolverBuilderInstance(ann, resAnn.value());
        } else {
            if (info == null) {
                return null;
            }
            if (info.use() == JsonTypeInfo.Id.NONE) {
                return this._constructNoTypeResolverBuilder();
            }
            b2 = this._constructStdTypeResolverBuilder();
        }
        JsonTypeIdResolver idResInfo = ann.getAnnotation(JsonTypeIdResolver.class);
        TypeIdResolver typeIdResolver = idRes = idResInfo == null ? null : config.typeIdResolverInstance(ann, idResInfo.value());
        if (idRes != null) {
            idRes.init(baseType);
        }
        b2 = b2.init(info.use(), idRes);
        JsonTypeInfo.As inclusion = info.include();
        if (inclusion == JsonTypeInfo.As.EXTERNAL_PROPERTY && ann instanceof AnnotatedClass) {
            inclusion = JsonTypeInfo.As.PROPERTY;
        }
        b2 = b2.inclusion(inclusion);
        b2 = b2.typeProperty(info.property());
        Class<?> defaultImpl = info.defaultImpl();
        if (defaultImpl != JsonTypeInfo.None.class) {
            b2 = b2.defaultImpl(defaultImpl);
        }
        return b2;
    }

    protected StdTypeResolverBuilder _constructStdTypeResolverBuilder() {
        return new StdTypeResolverBuilder();
    }

    protected StdTypeResolverBuilder _constructNoTypeResolverBuilder() {
        return StdTypeResolverBuilder.noTypeInfoBuilder();
    }
}

