/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.org.codehaus.jackson.map.deser.impl;

import com.flurry.org.codehaus.jackson.JsonParser;
import com.flurry.org.codehaus.jackson.map.DeserializationContext;
import com.flurry.org.codehaus.jackson.map.JsonDeserializer;
import com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty;
import com.flurry.org.codehaus.jackson.map.deser.ValueInstantiator;
import com.flurry.org.codehaus.jackson.map.deser.impl.PropertyValue;
import com.flurry.org.codehaus.jackson.map.deser.impl.PropertyValueBuffer;
import com.flurry.org.codehaus.jackson.map.util.ClassUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyBasedCreator {
    protected final ValueInstantiator _valueInstantiator;
    protected final HashMap<String, SettableBeanProperty> _properties;
    protected Object[] _defaultValues;
    protected final SettableBeanProperty[] _propertiesWithInjectables;

    public PropertyBasedCreator(ValueInstantiator valueInstantiator) {
        this._valueInstantiator = valueInstantiator;
        this._properties = new HashMap();
        Object[] defValues = null;
        SettableBeanProperty[] creatorProps = valueInstantiator.getFromObjectArguments();
        SettableBeanProperty[] propertiesWithInjectables = null;
        int len = creatorProps.length;
        for (int i2 = 0; i2 < len; ++i2) {
            Object injectableValueId;
            SettableBeanProperty prop = creatorProps[i2];
            this._properties.put(prop.getName(), prop);
            if (prop.getType().isPrimitive()) {
                if (defValues == null) {
                    defValues = new Object[len];
                }
                defValues[i2] = ClassUtil.defaultValue(prop.getType().getRawClass());
            }
            if ((injectableValueId = prop.getInjectableValueId()) == null) continue;
            if (propertiesWithInjectables == null) {
                propertiesWithInjectables = new SettableBeanProperty[len];
            }
            propertiesWithInjectables[i2] = prop;
        }
        this._defaultValues = defValues;
        this._propertiesWithInjectables = propertiesWithInjectables;
    }

    public Collection<SettableBeanProperty> getCreatorProperties() {
        return this._properties.values();
    }

    public SettableBeanProperty findCreatorProperty(String name) {
        return this._properties.get(name);
    }

    public void assignDeserializer(SettableBeanProperty prop, JsonDeserializer<Object> deser) {
        prop = prop.withValueDeserializer(deser);
        this._properties.put(prop.getName(), prop);
        Object nullValue = deser.getNullValue();
        if (nullValue != null) {
            if (this._defaultValues == null) {
                this._defaultValues = new Object[this._properties.size()];
            }
            this._defaultValues[prop.getPropertyIndex()] = nullValue;
        }
    }

    public PropertyValueBuffer startBuilding(JsonParser jp, DeserializationContext ctxt) {
        PropertyValueBuffer buffer = new PropertyValueBuffer(jp, ctxt, this._properties.size());
        if (this._propertiesWithInjectables != null) {
            buffer.inject(this._propertiesWithInjectables);
        }
        return buffer;
    }

    public Object build(PropertyValueBuffer buffer) throws IOException {
        Object bean = this._valueInstantiator.createFromObjectWith(buffer.getParameters(this._defaultValues));
        PropertyValue pv = buffer.buffered();
        while (pv != null) {
            pv.assign(bean);
            pv = pv.next;
        }
        return bean;
    }
}

