/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.org.codehaus.jackson.io;

public final class NumberInput {
    public static final String NASTY_SMALL_DOUBLE = "2.2250738585072012e-308";
    static final long L_BILLION = 1000000000L;
    static final String MIN_LONG_STR_NO_SIGN = String.valueOf(Long.MIN_VALUE).substring(1);
    static final String MAX_LONG_STR = String.valueOf(Long.MAX_VALUE);

    public static final int parseInt(char[] digitChars, int offset, int len) {
        int num = digitChars[offset] - 48;
        if (++offset < (len += offset)) {
            num = num * 10 + (digitChars[offset] - 48);
            if (++offset < len) {
                num = num * 10 + (digitChars[offset] - 48);
                if (++offset < len) {
                    num = num * 10 + (digitChars[offset] - 48);
                    if (++offset < len) {
                        num = num * 10 + (digitChars[offset] - 48);
                        if (++offset < len) {
                            num = num * 10 + (digitChars[offset] - 48);
                            if (++offset < len) {
                                num = num * 10 + (digitChars[offset] - 48);
                                if (++offset < len) {
                                    num = num * 10 + (digitChars[offset] - 48);
                                    if (++offset < len) {
                                        num = num * 10 + (digitChars[offset] - 48);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return num;
    }

    public static final int parseInt(String str) {
        char c2 = str.charAt(0);
        int length = str.length();
        boolean negative = c2 == '-';
        int offset = 1;
        if (negative) {
            if (length == 1 || length > 10) {
                return Integer.parseInt(str);
            }
            c2 = str.charAt(offset++);
        } else if (length > 9) {
            return Integer.parseInt(str);
        }
        if (c2 > '9' || c2 < '0') {
            return Integer.parseInt(str);
        }
        int num = c2 - 48;
        if (offset < length) {
            if ((c2 = str.charAt(offset++)) > '9' || c2 < '0') {
                return Integer.parseInt(str);
            }
            num = num * 10 + (c2 - 48);
            if (offset < length) {
                if ((c2 = str.charAt(offset++)) > '9' || c2 < '0') {
                    return Integer.parseInt(str);
                }
                num = num * 10 + (c2 - 48);
                if (offset < length) {
                    do {
                        if ((c2 = str.charAt(offset++)) > '9' || c2 < '0') {
                            return Integer.parseInt(str);
                        }
                        num = num * 10 + (c2 - 48);
                    } while (offset < length);
                }
            }
        }
        return negative ? -num : num;
    }

    public static final long parseLong(char[] digitChars, int offset, int len) {
        int len1 = len - 9;
        long val = (long)NumberInput.parseInt(digitChars, offset, len1) * 1000000000L;
        return val + (long)NumberInput.parseInt(digitChars, offset + len1, 9);
    }

    public static final long parseLong(String str) {
        int length = str.length();
        if (length <= 9) {
            return NumberInput.parseInt(str);
        }
        return Long.parseLong(str);
    }

    public static final boolean inLongRange(char[] digitChars, int offset, int len, boolean negative) {
        String cmpStr = negative ? MIN_LONG_STR_NO_SIGN : MAX_LONG_STR;
        int cmpLen = cmpStr.length();
        if (len < cmpLen) {
            return true;
        }
        if (len > cmpLen) {
            return false;
        }
        for (int i2 = 0; i2 < cmpLen; ++i2) {
            int diff = digitChars[offset + i2] - cmpStr.charAt(i2);
            if (diff == 0) continue;
            return diff < 0;
        }
        return true;
    }

    public static final boolean inLongRange(String numberStr, boolean negative) {
        String cmpStr = negative ? MIN_LONG_STR_NO_SIGN : MAX_LONG_STR;
        int cmpLen = cmpStr.length();
        int actualLen = numberStr.length();
        if (actualLen < cmpLen) {
            return true;
        }
        if (actualLen > cmpLen) {
            return false;
        }
        for (int i2 = 0; i2 < cmpLen; ++i2) {
            int diff = numberStr.charAt(i2) - cmpStr.charAt(i2);
            if (diff == 0) continue;
            return diff < 0;
        }
        return true;
    }

    public static int parseAsInt(String input, int defaultValue) {
        char c2;
        if (input == null) {
            return defaultValue;
        }
        int len = (input = input.trim()).length();
        if (len == 0) {
            return defaultValue;
        }
        int i2 = 0;
        if (i2 < len) {
            c2 = input.charAt(0);
            if (c2 == '+') {
                input = input.substring(1);
                len = input.length();
            } else if (c2 == '-') {
                ++i2;
            }
        }
        while (i2 < len) {
            c2 = input.charAt(i2);
            if (c2 > '9' || c2 < '0') {
                try {
                    return (int)NumberInput.parseDouble(input);
                }
                catch (NumberFormatException e2) {
                    return defaultValue;
                }
            }
            ++i2;
        }
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException e3) {
            return defaultValue;
        }
    }

    public static long parseAsLong(String input, long defaultValue) {
        char c2;
        if (input == null) {
            return defaultValue;
        }
        int len = (input = input.trim()).length();
        if (len == 0) {
            return defaultValue;
        }
        int i2 = 0;
        if (i2 < len) {
            c2 = input.charAt(0);
            if (c2 == '+') {
                input = input.substring(1);
                len = input.length();
            } else if (c2 == '-') {
                ++i2;
            }
        }
        while (i2 < len) {
            c2 = input.charAt(i2);
            if (c2 > '9' || c2 < '0') {
                try {
                    return (long)NumberInput.parseDouble(input);
                }
                catch (NumberFormatException e2) {
                    return defaultValue;
                }
            }
            ++i2;
        }
        try {
            return Long.parseLong(input);
        }
        catch (NumberFormatException e3) {
            return defaultValue;
        }
    }

    public static double parseAsDouble(String input, double defaultValue) {
        if (input == null) {
            return defaultValue;
        }
        int len = (input = input.trim()).length();
        if (len == 0) {
            return defaultValue;
        }
        try {
            return NumberInput.parseDouble(input);
        }
        catch (NumberFormatException e2) {
            return defaultValue;
        }
    }

    public static final double parseDouble(String numStr) throws NumberFormatException {
        if (NASTY_SMALL_DOUBLE.equals(numStr)) {
            return Double.MIN_NORMAL;
        }
        return Double.parseDouble(numStr);
    }
}

