/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.org.apache.avro.io.parsing;

import com.flurry.org.apache.avro.AvroTypeException;
import com.flurry.org.apache.avro.Schema;
import com.flurry.org.apache.avro.io.BinaryEncoder;
import com.flurry.org.apache.avro.io.Encoder;
import com.flurry.org.apache.avro.io.EncoderFactory;
import com.flurry.org.apache.avro.io.parsing.Symbol;
import com.flurry.org.apache.avro.io.parsing.ValidatingGrammarGenerator;
import com.flurry.org.codehaus.jackson.JsonNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ResolvingGrammarGenerator
extends ValidatingGrammarGenerator {
    private static EncoderFactory factory = new EncoderFactory().configureBufferSize(32);

    public final Symbol generate(Schema writer, Schema reader) throws IOException {
        return Symbol.root(this.generate(writer, reader, new HashMap<ValidatingGrammarGenerator.LitS, Symbol>()));
    }

    public Symbol generate(Schema writer, Schema reader, Map<ValidatingGrammarGenerator.LitS, Symbol> seen) throws IOException {
        block36: {
            Schema.Type readerType;
            Schema.Type writerType;
            block35: {
                writerType = writer.getType();
                if (writerType != (readerType = reader.getType())) break block35;
                switch (writerType) {
                    case NULL: {
                        return Symbol.NULL;
                    }
                    case BOOLEAN: {
                        return Symbol.BOOLEAN;
                    }
                    case INT: {
                        return Symbol.INT;
                    }
                    case LONG: {
                        return Symbol.LONG;
                    }
                    case FLOAT: {
                        return Symbol.FLOAT;
                    }
                    case DOUBLE: {
                        return Symbol.DOUBLE;
                    }
                    case STRING: {
                        return Symbol.STRING;
                    }
                    case BYTES: {
                        return Symbol.BYTES;
                    }
                    case FIXED: {
                        if (writer.getFullName().equals(reader.getFullName()) && writer.getFixedSize() == reader.getFixedSize()) {
                            return Symbol.seq(new Symbol.IntCheckAction(writer.getFixedSize()), Symbol.FIXED);
                        }
                        break block36;
                    }
                    case ENUM: {
                        if (writer.getFullName() == null || writer.getFullName().equals(reader.getFullName())) {
                            return Symbol.seq(ResolvingGrammarGenerator.mkEnumAdjust(writer.getEnumSymbols(), reader.getEnumSymbols()), Symbol.ENUM);
                        }
                        break block36;
                    }
                    case ARRAY: {
                        return Symbol.seq(Symbol.repeat(Symbol.ARRAY_END, this.generate(writer.getElementType(), reader.getElementType(), seen)), Symbol.ARRAY_START);
                    }
                    case MAP: {
                        return Symbol.seq(Symbol.repeat(Symbol.MAP_END, this.generate(writer.getValueType(), reader.getValueType(), seen), Symbol.STRING), Symbol.MAP_START);
                    }
                    case RECORD: {
                        return this.resolveRecords(writer, reader, seen);
                    }
                    case UNION: {
                        return this.resolveUnion(writer, reader, seen);
                    }
                    default: {
                        throw new AvroTypeException("Unkown type for schema: " + (Object)((Object)writerType));
                    }
                }
            }
            if (writerType == Schema.Type.UNION) {
                return this.resolveUnion(writer, reader, seen);
            }
            switch (readerType) {
                case LONG: {
                    switch (writerType) {
                        case INT: {
                            return Symbol.resolve(super.generate(writer, seen), Symbol.LONG);
                        }
                    }
                    break;
                }
                case FLOAT: {
                    switch (writerType) {
                        case INT: 
                        case LONG: {
                            return Symbol.resolve(super.generate(writer, seen), Symbol.FLOAT);
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    switch (writerType) {
                        case INT: 
                        case LONG: 
                        case FLOAT: {
                            return Symbol.resolve(super.generate(writer, seen), Symbol.DOUBLE);
                        }
                    }
                    break;
                }
                case UNION: {
                    int j2 = ResolvingGrammarGenerator.bestBranch(reader, writer);
                    if (j2 < 0) break;
                    Symbol s2 = this.generate(writer, reader.getTypes().get(j2), seen);
                    return Symbol.seq(new Symbol.UnionAdjustAction(j2, s2), Symbol.UNION);
                }
                case RECORD: 
                case ENUM: 
                case ARRAY: 
                case MAP: 
                case STRING: 
                case BYTES: 
                case INT: 
                case BOOLEAN: 
                case NULL: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected schema type: " + (Object)((Object)readerType));
                }
            }
        }
        return Symbol.error("Found " + writer.toString(true) + ", expecting " + reader.toString(true));
    }

    private Symbol resolveUnion(Schema writer, Schema reader, Map<ValidatingGrammarGenerator.LitS, Symbol> seen) throws IOException {
        List<Schema> alts = writer.getTypes();
        int size = alts.size();
        Symbol[] symbols = new Symbol[size];
        String[] labels = new String[size];
        int i2 = 0;
        for (Schema w2 : alts) {
            symbols[i2] = this.generate(w2, reader, seen);
            labels[i2] = w2.getFullName();
            ++i2;
        }
        return Symbol.seq(Symbol.alt(symbols, labels), new Symbol.WriterUnionAction());
    }

    private Symbol resolveRecords(Schema writer, Schema reader, Map<ValidatingGrammarGenerator.LitS, Symbol> seen) throws IOException {
        LitS2 wsc = new LitS2(writer, reader);
        Symbol result = seen.get(wsc);
        if (result == null) {
            String fname;
            List<Schema.Field> wfields = writer.getFields();
            List<Schema.Field> rfields = reader.getFields();
            Schema.Field[] reordered = new Schema.Field[rfields.size()];
            int ridx = 0;
            int count = 1 + wfields.size();
            for (Schema.Field f2 : wfields) {
                Schema.Field rdrField = reader.getField(f2.name());
                if (rdrField == null) continue;
                reordered[ridx++] = rdrField;
            }
            for (Schema.Field rf : rfields) {
                String fname2 = rf.name();
                if (writer.getField(fname2) != null) continue;
                if (rf.defaultValue() == null) {
                    result = Symbol.error("Found " + writer.toString(true) + ", expecting " + reader.toString(true));
                    seen.put(wsc, result);
                    return result;
                }
                reordered[ridx++] = rf;
                count += 3;
            }
            Symbol[] production = new Symbol[count];
            production[--count] = new Symbol.FieldOrderAction(reordered);
            result = Symbol.seq(production);
            seen.put(wsc, result);
            for (Schema.Field wf : wfields) {
                fname = wf.name();
                Schema.Field rf = reader.getField(fname);
                production[--count] = rf == null ? new Symbol.SkipAction(this.generate(wf.schema(), wf.schema(), seen)) : this.generate(wf.schema(), rf.schema(), seen);
            }
            for (Schema.Field rf : rfields) {
                fname = rf.name();
                Schema.Field wf = writer.getField(fname);
                if (wf != null) continue;
                byte[] bb2 = ResolvingGrammarGenerator.getBinary(rf.schema(), rf.defaultValue());
                production[--count] = new Symbol.DefaultStartAction(bb2);
                production[--count] = this.generate(rf.schema(), rf.schema(), seen);
                production[--count] = Symbol.DEFAULT_END_ACTION;
            }
        }
        return result;
    }

    private static byte[] getBinary(Schema s2, JsonNode n2) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder e2 = factory.binaryEncoder(out, null);
        ResolvingGrammarGenerator.encode(e2, s2, n2);
        e2.flush();
        return out.toByteArray();
    }

    public static void encode(Encoder e2, Schema s2, JsonNode n2) throws IOException {
        switch (s2.getType()) {
            case RECORD: {
                for (Schema.Field f2 : s2.getFields()) {
                    String name = f2.name();
                    JsonNode v2 = n2.get(name);
                    if (v2 == null) {
                        v2 = f2.defaultValue();
                    }
                    if (v2 == null) {
                        throw new AvroTypeException("No default value for: " + name);
                    }
                    ResolvingGrammarGenerator.encode(e2, f2.schema(), v2);
                }
                break;
            }
            case ENUM: {
                e2.writeEnum(s2.getEnumOrdinal(n2.getTextValue()));
                break;
            }
            case ARRAY: {
                e2.writeArrayStart();
                e2.setItemCount(n2.size());
                Schema i2 = s2.getElementType();
                for (JsonNode node : n2) {
                    e2.startItem();
                    ResolvingGrammarGenerator.encode(e2, i2, node);
                }
                e2.writeArrayEnd();
                break;
            }
            case MAP: {
                e2.writeMapStart();
                e2.setItemCount(n2.size());
                Schema v3 = s2.getValueType();
                Iterator<String> it = n2.getFieldNames();
                while (it.hasNext()) {
                    e2.startItem();
                    String key = it.next();
                    e2.writeString(key);
                    ResolvingGrammarGenerator.encode(e2, v3, n2.get(key));
                }
                e2.writeMapEnd();
                break;
            }
            case UNION: {
                e2.writeIndex(0);
                ResolvingGrammarGenerator.encode(e2, s2.getTypes().get(0), n2);
                break;
            }
            case FIXED: {
                if (!n2.isTextual()) {
                    throw new AvroTypeException("Non-string default value for fixed: " + n2);
                }
                byte[] bb2 = n2.getTextValue().getBytes("ISO-8859-1");
                if (bb2.length != s2.getFixedSize()) {
                    byte[] newBb = new byte[s2.getFixedSize()];
                    System.arraycopy(bb2, 0, newBb, 0, s2.getFixedSize() > bb2.length ? bb2.length : s2.getFixedSize());
                    bb2 = newBb;
                }
                e2.writeFixed(bb2);
                break;
            }
            case STRING: {
                if (!n2.isTextual()) {
                    throw new AvroTypeException("Non-string default value for string: " + n2);
                }
                e2.writeString(n2.getTextValue());
                break;
            }
            case BYTES: {
                if (!n2.isTextual()) {
                    throw new AvroTypeException("Non-string default value for bytes: " + n2);
                }
                e2.writeBytes(n2.getTextValue().getBytes("ISO-8859-1"));
                break;
            }
            case INT: {
                if (!n2.isNumber()) {
                    throw new AvroTypeException("Non-numeric default value for int: " + n2);
                }
                e2.writeInt(n2.getIntValue());
                break;
            }
            case LONG: {
                if (!n2.isNumber()) {
                    throw new AvroTypeException("Non-numeric default value for long: " + n2);
                }
                e2.writeLong(n2.getLongValue());
                break;
            }
            case FLOAT: {
                if (!n2.isNumber()) {
                    throw new AvroTypeException("Non-numeric default value for float: " + n2);
                }
                e2.writeFloat((float)n2.getDoubleValue());
                break;
            }
            case DOUBLE: {
                if (!n2.isNumber()) {
                    throw new AvroTypeException("Non-numeric default value for double: " + n2);
                }
                e2.writeDouble(n2.getDoubleValue());
                break;
            }
            case BOOLEAN: {
                if (!n2.isBoolean()) {
                    throw new AvroTypeException("Non-boolean default for boolean: " + n2);
                }
                e2.writeBoolean(n2.getBooleanValue());
                break;
            }
            case NULL: {
                if (!n2.isNull()) {
                    throw new AvroTypeException("Non-null default value for null type: " + n2);
                }
                e2.writeNull();
            }
        }
    }

    private static Symbol mkEnumAdjust(List<String> wsymbols, List<String> rsymbols) {
        Object[] adjustments = new Object[wsymbols.size()];
        int i2 = 0;
        while (i2 < adjustments.length) {
            int j2 = rsymbols.indexOf(wsymbols.get(i2));
            adjustments[i2] = j2 == -1 ? "No match for " + wsymbols.get(i2) : new Integer(j2);
            ++i2;
        }
        return new Symbol.EnumAdjustAction(rsymbols.size(), adjustments);
    }

    private static int bestBranch(Schema r2, Schema w2) {
        Schema.Type vt = w2.getType();
        int j2 = 0;
        for (Schema b2 : r2.getTypes()) {
            if (vt == b2.getType()) {
                if (vt == Schema.Type.RECORD || vt == Schema.Type.ENUM || vt == Schema.Type.FIXED) {
                    String vname = w2.getFullName();
                    String bname = b2.getFullName();
                    if (vname != null && vname.equals(bname) || vname == bname && vt == Schema.Type.RECORD) {
                        return j2;
                    }
                } else {
                    return j2;
                }
            }
            ++j2;
        }
        j2 = 0;
        for (Schema b2 : r2.getTypes()) {
            switch (vt) {
                case INT: {
                    switch (b2.getType()) {
                        case LONG: 
                        case DOUBLE: {
                            return j2;
                        }
                    }
                    break;
                }
                case LONG: 
                case FLOAT: {
                    switch (b2.getType()) {
                        case DOUBLE: {
                            return j2;
                        }
                    }
                }
            }
            ++j2;
        }
        return -1;
    }

    static class LitS2
    extends ValidatingGrammarGenerator.LitS {
        public Schema expected;

        public LitS2(Schema actual, Schema expected) {
            super(actual);
            this.expected = expected;
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof LitS2)) {
                return false;
            }
            LitS2 other = (LitS2)o2;
            return this.actual == other.actual && this.expected == other.expected;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.expected.hashCode();
        }
    }
}

