package com.komasan.komainu;

//import android.os.Vibrator;
import android.annotation.TargetApi;
import android.os.Build;
import android.os.Looper;
import android.service.notification.NotificationListenerService;
import android.service.notification.StatusBarNotification;
import android.util.Log;
import android.widget.Toast;

import java.util.List;


//アンドロイドバージョン4.3以上＝TargetAPI JELLY_BEAN_MR2=18(F4で参照先を確認)
@TargetApi(Build.VERSION_CODES.JELLY_BEAN_MR2)
public class NotificationService extends NotificationListenerService {

    private FileWriterKomasan fwk, fwk_sms;
    private String TAG = "Notification";
    public static final String IZIMEDB  = "IZIMEWORD.csv";//いじめワードデータ保存DBファイルの名前
    public static final String SMS  = "SMS.csv";//いじめワードデータ保存DBファイルの名前

    //MorseMaker mm;

    @Override
    public void onCreate() {
        super.onCreate();

        //ファイル処理クラス初期化
        fwk = new FileWriterKomasan(IZIMEDB);
        fwk_sms = new FileWriterKomasan(SMS);

        //mm = new MorseMaker();
        Toast.makeText(this, "StartService", Toast.LENGTH_LONG).show();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    @Override
    public void onNotificationPosted(StatusBarNotification sbn) {
        // ステータスバーに通知があった場合
        Log.d(TAG, (String) sbn.getNotification().tickerText);

        //lineのメッセージを受信したとき
        if(sbn.getPackageName().equals("jp.naver.line.android")) {

            //ユーザー名を除き、メッセージを取り出す
            String meg = CommonUtil.getMessage((String) sbn.getNotification().tickerText);
//        String head = meg.substring(0, 2);
            //本文の取出し
//        String body = meg.substring(2);
            //コマンドの判定。半角と全角パターン
            //mm.morse(body);

            Log.d(TAG, "Before FileWriterKomasan");
            // いじめ検知処理
            List<String> list = fwk.readCsvKomasan();
            list = CommonUtil.countUpList(meg, list);
            if (CommonUtil.isOverCount(list)) {
                list = CommonUtil.initList(list);
                List<String> smslist = fwk_sms.readCsvKomasan();
                CommonUtil.sendMessage(smslist.get(0).toString(), "いじめを検知しました。");
                Log.d(TAG, "SMS sent:" + smslist.get(0).toString());
            }
            fwk.writeCsvKomasan(list, IZIMEDB);

            Log.d("KOMAINU", "success");//とりあえずログ表示
        }
    }

    @Override
    public void onNotificationRemoved(StatusBarNotification sbn) {
        // ステータスバーから通知が消された場合
        Log.d(TAG, "onNotificationRemoved");
    }


    //TODO:AndroidVer.4.3以前の場合は、以下のようなコードが必要
    //?Q??Fhttps://teratail.com/questions/982
//    public static void setNotification(Context context, String title, String message, PendingIntent contentIntent){
//        Notification notification;
//        if(android.os.Build.VERSION.SDK_INT > 10){
//            Notification.Builder mBuilder = new Notification.Builder(context)
//                    .setContentIntent(contentIntent).setSmallIcon(R.drawable.ic_launcher)
//                    .setContentTitle(title)
//                    .setTicker(message)
//                    .setContentText(message)
//                    .setWhen(System.currentTimeMillis());
//            notification = android.os.Build.VERSION.SDK_INT > 15 ? mBuilder.build() : mBuilder.getNotification();
//        }else{
//            notification = new Notification(R.drawable.ic_launcher, message, System.currentTimeMillis());
//            notification.setLatestEventInfo(context, title, message, contentIntent);
//        }
//        NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
//        notificationManager.notify(R.string.app_id, notification);
//    }

}



