/*
* org.openmicroscopy.shoola.agents.measurement.actions.CreateWorkflowAction
*
*------------------------------------------------------------------------------
*  Copyright (C) 2006-2009 University of Dundee. All rights reserved.
*
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License along
*  with this program; if not, write to the Free Software Foundation, Inc.,
*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
*------------------------------------------------------------------------------
*/
package org.openmicroscopy.shoola.agents.measurement.actions;



//Java imports
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;

//Third-party libraries

//Application-internal dependencies
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;

/**
 * Creates or selects an existing workflow.
 *
 * @author  Jean-Marie Burel &nbsp;&nbsp;&nbsp;&nbsp;
 * <a href="mailto:j.burel@dundee.ac.uk">j.burel@dundee.ac.uk</a>
 * @author	Donald MacDonald &nbsp;&nbsp;&nbsp;&nbsp;
 * <a href="mailto:donald@lifesci.dundee.ac.uk">donald@lifesci.dundee.ac.uk</a>
 * @version 3.0
 * <small>
 * (<b>Internal version:</b> $Revision: $Date: $)
 * </small>
 * @since 3.0-Beta4
 */
public class WorkflowAction
	extends MeasurementViewerAction
{

	/** Create a new workflow string. */
	private String CREATEWORKFLOW = "Create Workflow";
	
	/** Create a new workflow string. */
	private String COMBOBOX_CHANGED = "comboBoxChanged";
	
	/** If <code>true</code> create a new workflow when activated. */
	private boolean createWorkflow;
		
	/** 
	 * Creates a new instance.
	 * This will either allow the user to select the
	 * current workflow or create a new one.
	 * 
	 * @param model Reference to the model. Mustn't be <code>null</code>.
	 * @param createWorkflow Pass <code>true</code> to create a workflow, 
	 * 						 <code>false</code> otherwise.
	 */
	public WorkflowAction(MeasurementViewer model, boolean createWorkflow)
	{
		super(model);
		this.createWorkflow = createWorkflow;
		if (createWorkflow)
			name = CREATEWORKFLOW;
	}

	/** 
     * Implemented by sub-classes.
     * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
     */
	public void actionPerformed(ActionEvent e) 
	{
		if (CREATEWORKFLOW.equals(e.getActionCommand()))
			model.createWorkflow();
		else
		{
			if (COMBOBOX_CHANGED.equals(e.getActionCommand()))
			{
				JComboBox comboBox = (JComboBox)e.getSource();
				model.setWorkflow((String) comboBox.getSelectedItem());
				
			}
			else 			
				model.setWorkflow(e.getActionCommand());
		}
	}

}
