package tainavi;

/**
 * <P>ツールバーの検索キーワードを保持するクラスです。
 * @since 3.22.18β+1.10
 * @see SearchWordList
 */
public class SearchWordItem implements Cloneable {
	@Override
	public Object clone() {
		try {
			return super.clone();
		} catch (CloneNotSupportedException e) {
			throw new InternalError(e.toString());
		}
	}

	private String keyword;
	private int count;
	private String last_used_time;

	public SearchWordItem(){
		this.keyword = null;
		this.count = 0;
		this.last_used_time = null;
	}

	public SearchWordItem(String s) {
		this.keyword = s;
		this.count = 1;
		this.last_used_time = CommonUtils.getDateTimeYMD(0);
	}

	public void notifyUse(){
		this.count++;
		this.last_used_time = CommonUtils.getDateTimeYMD(0);
	}

	public void setKeyword(String s){ this.keyword = s; }
	public String getKeyword() { return this.keyword; }

	public void setCount(int n){ this.count = n; }
	public int getCount(){ return this.count; }

	public void setLastUsedTime(String s){ this.last_used_time = s; }
	public String getLastUsedTime(){ return this.last_used_time; }
}
