// == LICENSE INFORMATION ==
/*
 * First author tiritomato 2013.
 * This program is distributed under the GNU General Public License(GPL).
 * support blog (Japanese only) http://d.hatena.ne.jp/tiri_tomato/
 */
// == LICENSE INFORMATION ==

#pragma once

namespace UVTexIntegra {
	namespace CustomControls {
	
		using namespace OpenTK::Graphics;
		using namespace OpenTK::Graphics::OpenGL;

		// pre define
		struct UVTransformedBuffer;
		ref class MainEditForm;

		//! @addtogroup UVTexIntegra-CustomControlsO
		//! @{

		public ref class Plugin : MQCLI::CommandPlugin {
		public:
			Plugin();
			virtual BOOL Activate(MQDocument doc, BOOL flag) override;
			virtual void Exit() override;
			virtual BOOL IsActivated(MQDocument doc) override;
			virtual void OnEndDocument(MQDocument doc) override;
			virtual void OnMaterialModified(MQDocument doc) override;
			virtual void OnNewDocument(MQDocument doc, const char *filename, MQStationPlugin::NEW_DOCUMENT_PARAM& param) override;
			virtual void OnUpdateMaterialList(MQDocument doc) override;
			virtual void OnUpdateObjectList(MQDocument doc) override;
			virtual void OnSaveDocument(MQDocument doc, const char *filename, MQStationPlugin::SAVE_DOCUMENT_PARAM& param) override;
			virtual bool OnException(System::Exception^ ex);
		private:
			MainEditForm^ m_dlg;
		};

		//! @brief MainEditForm_BasepACʂ̎񋟂NXłB
		public ref class MainEditForm : MainEditForm_Base {
		private:
			//! @brief MainEditFormɁAIConfigC^[tF[XivOCݒ񂨂ѕƂ̃f[^tH[}bgIDocumentFormatZbgŌJC^[tF[XjɕϊA_v^[NXłB
			ref class ConfigAdapter : IConfig {
			public:
				//! @brief eNX`Ăݎ̉nF擾܂B
				virtual property System::Int32 BakeTextureBaseColor
				{
					System::Int32 get() { return m_dlg->BakeTextureBaseColor; }
					void set(System::Int32 value) { m_dlg->BakeTextureBaseColor = value; }
				}
		
				//! @brief eNX`Ăݎ̗֊s̑擾܂B
				virtual property float BakeTextureBorder
				{
					float get() { return m_dlg->BakeTextureBorder; }
					void set(float value) { m_dlg->BakeTextureBorder = value; }
				}
		
				//! @brief eNX`Ăݎ̃TCYsNZPʂŎ擾܂B
				virtual property System::Drawing::Size BakeTextureImageSize
				{
					System::Drawing::Size get() { return System::Drawing::Size(m_dlg->BakeTextureW, m_dlg->BakeTextureH); }
					void set(System::Drawing::Size value)
					{
						m_dlg->BakeTextureW = value.Width;
						m_dlg->BakeTextureH = value.Height;
					}
				}

				//! @brief eNX`Ăݎ̃t@CpX擾,ݒ肵܂B
				virtual property System::String^ BakeTextureLastFilePath {
					System::String^ get() { return m_dlg->BakeTextureLastFilePath; }
					void set(System::String^ value) { m_dlg->BakeTextureLastFilePath = value; }
				}
		
				//! @brief JoX[h擾܂B
				virtual property UVTexIntegra::CanvasMode CanvasMode
				{
					UVTexIntegra::CanvasMode get()
					{
						if ( m_dlg->rdbDisplayVColorPreview->Checked ) return UVTexIntegra::CanvasMode::VertexColorPreview;
						return UVTexIntegra::CanvasMode::Normal;
					}
				}
		
				//! @brief ǂݎp̃hLg擾܂B
				//! ̃f[^ConfigAdapterɃN[jOfB[vRs[f[^ŁÃhLgĂIWiɂ͔f܂B
				virtual property IDocumentFormat^ Document { IDocumentFormat^ get() { return m_doc; } }

				//! @brief CEBhETCY擾܂
				virtual property System::Drawing::Size FormSize { System::Drawing::Size get() { return m_dlg->Size; } }

				//! @brief Obh𑜓x擾܂B
				virtual property int GridResolution { int get() { return m_dlg->GridResolution; } }

				//! @brief eNX`ݒ_CAÕTCYݒ/擾܂B
				virtual property System::Drawing::Size TextureSetFormSize
				{
					System::Drawing::Size get() { return m_dlg->TexSetFormSize; }
					void set(System::Drawing::Size value) { m_dlg->TexSetFormSize = value; }
				}

				ConfigAdapter( MainEditForm^ dlg );

			private:
				MainEditForm^ m_dlg;
				IDocumentFormat^ m_doc;
			};

		public:
			
			//! @brief Ƃ̏ǂݏ\ɕێNXłB܂AǂݎpłIDocumentFormat܂B
			ref class Document : IDocumentFormat {
			public:
				virtual property bool IsCloneTrans {
					bool get() { return m_payload->IsCloneTrans; }
					private: void set(bool value) sealed { m_payload->IsCloneTrans = value; }
				}
				virtual property bool IsRecursiveTrans {
					bool get() { return m_payload->IsRecursiveTrans; }
					private: void set(bool value) sealed { m_payload->IsRecursiveTrans = value; }
				}
				virtual property bool IsIntegrateTexture {
					bool get() { return m_payload->IsIntegrateTexture; }
					private: void set(bool value) sealed { m_payload->IsIntegrateTexture = value; }
				}
				virtual property bool IsClrTextureOnIntegrate {
					bool get() { return m_payload->IsClrTextureOnIntegrate; }
					private: void set(bool value) sealed { m_payload->IsClrTextureOnIntegrate = value; }
				}
				virtual property bool IsIntegrateAlpha {
					bool get() { return m_payload->IsIntegrateAlpha; }
					private: void set(bool value) sealed { m_payload->IsIntegrateAlpha = value; }
				}
				virtual property bool IsClrAlphaOnIntegrate {
					bool get() { return m_payload->IsClrAlphaOnIntegrate; }
					private: void set(bool value) sealed { m_payload->IsClrAlphaOnIntegrate = value; }
				}
				virtual property bool IsIntegrateBump {
					bool get() { return m_payload->IsIntegrateBump; }
					private: void set(bool value) sealed { m_payload->IsIntegrateBump = value; }
				}
				virtual property bool IsClrBumpOnIntegrate {
					bool get() { return m_payload->IsClrBumpOnIntegrate; }
					private: void set(bool value) sealed { m_payload->IsClrBumpOnIntegrate = value; }
				}
				virtual property System::Int32 TextureClearColor {
					System::Int32 get() { return m_payload->TextureClearColor; }
					private: void set(System::Int32 value) sealed { m_payload->TextureClearColor = value; }
				}
				virtual property System::Int32 AlphaClearColor {
					System::Int32 get() { return m_payload->AlphaClearColor; }
					private: void set(System::Int32 value) sealed { m_payload->AlphaClearColor = value; }
				}
				virtual property System::Int32 BumpClearColor {
					System::Int32 get() { return m_payload->BumpClearColor; }
					private: void set(System::Int32 value) sealed { m_payload->BumpClearColor = value; }
				}
				//! @brief ݃R{{bNX̑I󂯕tĂ̂A^ZȒI𔽉fׂ擾,ݒ肵܂B
				bool IsComboboxIndexSelecting;
				property bool IsEmpty { bool get(){ return m_payload->EditDataItems->Count < 1; } }
				virtual property ::MQDocument MQDocument {
					::MQDocument get() { return m_payload->MQDocument; }
					void set( ::MQDocument value ) { m_payload->MQDocument = value; }
				}
				virtual property System::Collections::ObjectModel::ReadOnlyCollection<EditData^>^ EditDataItems {
					System::Collections::ObjectModel::ReadOnlyCollection<EditData^>^ get() { return m_payload->ReadonlyEditDataItems; }
				}

				/// @brief ftHgRXgN^
				Document() :
				m_payload(gcnew DocumentFormat()),
				m_refreshingLock(DotNetEx::CounterKey::UsingKey()),
				IsComboboxIndexSelecting(false)
				{
				}

				void BakeTexturePaint(MainEditForm^ dlg, System::Drawing::Graphics^ g, System::Drawing::Size size);

				//! @brief }eAݒG[n܂B
				//! @return G[鎞trueԂ܂BG[Ƃ͈ȉ̏̂ꂩ𖞂ݒ肪鎞łB
				//! - ToMaterialIDsi݂MQDocument猩邱ƂoȂj
				//! - MaterialID == ToMaterialID鎞
				bool IsIncludeNotChangeMaterialSetting();
				
				//! @brief j[NIDw肵EditDataACe܂BȂꍇnullԂ܂B
				virtual EditData^ ItemFromID( const UINT UniqueID ) { return m_payload->ItemFromID(UniqueID); }
				//! @brief }eAw肵EditDataACe܂BȂꍇnullԂ܂B
				virtual EditData^ ItemFromName( System::String^ matName ) { return m_payload->ItemFromName(matName); }
				//! @brief CfbNXw肵EditDataACe܂BȂꍇnullԂ܂B
				virtual EditData^ ItemFromIndex( const int index ) { return m_payload->ItemFromIndex(index); }
				//! @brief j[NIDw肵āAEditDataACẽCfbNX܂BȂꍇ͖ȕ̃CfbNXԂ܂B
				virtual int ItemIndexFromID( const UINT UniqueID ) { return m_payload->ItemIndexFromID(UniqueID); }
				//! @brief ۗLEditDataz̒ŁAȂMQDocumentŌ݃}eAIĂEditDatãRNVԂ܂B
				//! @details MQDocumentNULL̎͋̔z񂪕Ԃ܂B擪̃Jg}eAȊÕ}eȀ͕słB
				virtual EditData::SelectedCollection^ ItemsOnSelected() { return ItemsOnSelected(-1); }
				//! @brief ۗLEditDataz̒ŁAȂMQDocumentŌ݃}eAIĂEditDatãRNVԂ܂B
				//! @details MQDocumentNULL̎͋̔z񂪕Ԃ܂B擪̃Jg}eAȊÕ}eȀ͕słB
				//! @param [in] index -1ȂItemFromIndex()ɓnEditData擾s\ȃCfbNXw肷ƉN܂񂪁AItemFromIndex()ɓnEditData擾\ȃCfbNXw肷ƁAJg}eAɂEditData}܂B
				//! ̂ƂAEditData}eAݑIĂ邩ǂ͔肳܂BȌ͒ʏʂJg}eAł炻̑̕I𒆂̃}eA܂B
				virtual EditData::SelectedCollection^ ItemsOnSelected(const int index) { return m_payload->ItemsOnSelected(index); }
				
				//! @brief JX^xCNJn܂B
				//! @details JX^xCN̓[_Xɕʃ_CAOĂяoɂȂĂA
				//! ̃\bȟĂяo̓^ZRCAуC_CAOA[_X̐eEBhEƂđłȂȂ܂B
				void OnCustomBake(MainEditForm^ dlg);
				
				//!	@brief _CAOɍXVɌĂяoāAf[^XV܂B
				void OnInputChanged(MainEditForm^ dlg);
				//!	@brief mqoǂݍ܂ꂽƂɁAf[^V鏈B܂RefreshDialog()s܂B
				void OnMQOLoaded(MainEditForm^ dlg, MQXmlElement elem);
				//!	@brief mqoύXꂽƂȂǁAf[^MQO̐܂i\Ȍf[^c݂MQOf[^ōč\zjB
				void OnMQOModified(MainEditForm^ dlg, bool isCreateOnEmptyList);
				//!	@brief mqoۑ̏	s܂
				void OnMQOSave(MainEditForm^ dlg, MQXmlElement elem);
				void Paint(MainEditForm^ dlg, System::Drawing::Graphics^ g, System::Drawing::Size size, bool isDraging, bool isBorderHighLight);
				//! @brief ۂ̃f[^̃fB[vRs[N[擾܂
				DocumentFormat^ PayloadClone() { return m_payload->Clone(); }
				// OnMQOLoaded		f[^IɈV 	f[^MQO̐ 	f[^ʂɔf
				// OnMQOModified							f[^MQO̐ 	f[^ʂɔf
				// RefreshDialog													f[^ʂɔf
				//!	@brief ݂̓f[^ʂɔf鏈łB
				//! @param materialIndex }eAIɑIꍇA0ȏ̃CfbNXw肵ĂB}CiX△ȃCfbNXw肳ƁÃp[^͖܂B
				//! @details }eAIȂAĂяo_dlg̃}eAIێ܂B
				//! }eAIԂŁA}eAȏ゠΍ŏ̃}eAI܂B
				void RefreshDialog(MainEditForm^ dlg, int materialIndex);
				
				//! @brief I𒆂̃}eAԂɃNA܂
				void SelectedMaterialsReset(MainEditForm^ dlg);

				//! @brief I𒆂̃}eA̕ύX}eA-1(ݒ)ɃNA܂
				void SelectedMaterialsToMatClear(MainEditForm^ dlg);

				//! @brief ϊs܂
				void TryTrans(MainEditForm^ dlg);

			private:
				DotNetEx::CounterKey^ m_refreshingLock;
				DocumentFormat^ m_payload;
				void PaintDefault(MainEditForm^ dlg, System::Drawing::Graphics^ g, bool isDraging, bool isBorderHighLight);
				int RecursiveTrans(const MQObject obj, const int depth, std::vector<char>* const buf);
			};

			static property System::Collections::ObjectModel::ReadOnlyCollection<unsigned int>^ GridResolutions {
				System::Collections::ObjectModel::ReadOnlyCollection<unsigned int>^ get();
			}
			static property System::Drawing::Point EmptyPosition { System::Drawing::Point get(){ return System::Drawing::Point(-1,-1); } }
			static property System::Drawing::RectangleF EmptyRectangleF { System::Drawing::RectangleF get(){ return System::Drawing::RectangleF(float::NaN,float::NaN,float::NaN,float::NaN); } }
			static bool IsEmptyRectangleF( System::Drawing::RectangleF rc ) { return float::IsNaN(rc.Left) || float::IsNaN(rc.Top) || float::IsNaN(rc.Width) || float::IsNaN(rc.Height); }

			MainEditForm(Plugin^ plugin);
			~MainEditForm() { this->!MainEditForm(); }
			!MainEditForm();

			BOOL Activate(MQDocument doc, BOOL value);
			BOOL Activate(BOOL value) { return Activate( m_docData->MQDocument, value ); }
			void Exit();
			BOOL IsActivated() { MQCLI::Lock lock( m_lock ); if ( m_isFirstActivate ) return FALSE; return Form::Visible; }

			void OnEndDocument() {
				m_docData->MQDocument = NULL;
				m_docData->OnMQOLoaded(this,NULL);
			}

			void OnMaterialModified(MQDocument doc) {
				m_docData->MQDocument = doc;
				m_docData->OnMQOModified(this, false);
			}

			void OnNewDocument( MQDocument doc, const char *filename, MQStationPlugin::NEW_DOCUMENT_PARAM& param );

			void OnSaveDocument( MQDocument doc, const char *filename, MQStationPlugin::SAVE_DOCUMENT_PARAM& param ) {
				m_docData->MQDocument = doc;
				if ( param.elem != NULL ) m_docData->OnMQOSave( this, param.elem );
			}

		protected:
			virtual System::Void OnFormClosing(System::Windows::Forms::FormClosingEventArgs^ e) override;

		private:
			static System::Collections::ObjectModel::ReadOnlyCollection<unsigned int>^ m_gridResolutions;
			Plugin^ m_ownerPlugin;
			bool m_isGLRepaintRequested;
			bool m_isFirstActivate;
			bool m_isMouseRangeSelecting;
			bool m_isMouseCanceled;
		
			System::Object^ m_drawLock;
			System::Object^ m_lock;

			Document^ m_docData;
			System::Drawing::Point m_mousePosition;
			System::Drawing::Point m_mouseDragStartPosition;

			System::Int32 BakeTextureBaseColor;
			float BakeTextureBorder;
			System::String^ BakeTextureLastFilePath;
			int BakeTextureW;
			int BakeTextureH;

			/// @brief ݑI𒆂̃Obh𑜓x
			/// @return Obh𑜓xBR{{bNX̐l擾Ɏs0B
			property int GridResolution { int get(); }
			/// @brief ݂̃}EXWiObhPʁj
			/// @return }EXWBR{{bNX̉𑜓x擾s܂̓JoX͈͊OɃJ[\ꍇEmptyPositionB
			property System::Drawing::Point mousePosition { System::Drawing::Point get(); }
			/// @brief eNX`ݒʂ̃TCYi[vpeB
			System::Drawing::Size TexSetFormSize; // privatable
			/// @brief w肳ꂽJoXW̋`̈擾
			/// @return W̋`BJoXWJoXɂȂꍇAR{{bNX𑜓x擾ɎsꍇEmptyRectangleB
			System::Drawing::RectangleF GetGridCursorRectangle( System::Drawing::Point pt );
			/// @brief w肳ꂽJoXW͂`̈擾
			/// @return W̋`Bǂ炩̃JoXWJoXɂȂꍇAR{{bNX𑜓x擾ɎsꍇEmptyRectangleB
			System::Drawing::RectangleF GetGridCursorRectangle( System::Drawing::Point ptA, System::Drawing::Point ptB );

			System::Int32 m_glShaderProgram;

			UVTransformedBuffer* m_pUVBuffer;

			System::String^ m_customBakeScriptDirectory;
			int m_customBakeScriptFileFilterIndex;
			int m_buildResultWinX, m_buildResultWinY;

			System::Void pnlPaint_CallInvalidate(System::Object^, System::EventArgs^) { pnlGL->Invalidate(); }
			System::Void btnPilotSwitch_Click			( System::Object^, System::EventArgs^ );
			System::Void btnMatClr_Click				( System::Object^, System::EventArgs^ );
			System::Void btnToMatClr_Click				( System::Object^, System::EventArgs^ );
			System::Void btnTrans_Click					( System::Object^, System::EventArgs^ );
			System::Void btnBakeVColor_Click			( System::Object^, System::EventArgs^ );
			System::Void btnCustomBake_Click			( System::Object^, System::EventArgs^ );
			System::Void cmbSelMat_SelectedIndexChanged	( System::Object^, System::EventArgs^ );
		
			System::Void pnlGL_GLPrePaintOnce(System::Object^, System::ComponentModel::CancelEventArgs^);
			System::Void pnlGL_GLPaint(System::Object^, System::Windows::Forms::PaintEventArgs^);

			System::Void txt_KeyUp( System::Object^, System::Windows::Forms::KeyEventArgs^ );
			System::Void txt_FloatValidating( System::Object^, System::ComponentModel::CancelEventArgs^ );
			System::Void txt_AbsIntValidating( System::Object^, System::ComponentModel::CancelEventArgs^ );
			System::Void txt_ColorValidating( System::Object^, System::ComponentModel::CancelEventArgs^ );
			System::Void chkSelMatTrans_CheckedChanged( System::Object^, System::EventArgs^ );
			System::Void pluginData_InputChanged( System::Object^, System::EventArgs^ );

			System::Void cmbResolution_SelectedIndexChanged( Object^ sender, System::EventArgs^ e );
			System::Void pnlGL_GLMouseMove(System::Object^  sender, System::Windows::Forms::MouseEventArgs^  e);
		};

		//! @}
	}
}