// == LICENSE INFORMATION ==
/*
 * First author tiritomato 2013.
 * This program is distributed under the GNU General Public License(GPL).
 * support blog (Japanese only) http://d.hatena.ne.jp/tiri_tomato/
 */
// == LICENSE INFORMATION ==

#pragma once

#include "../UVTexIntegra.hpp"

namespace UVTexIntegra {
	namespace CustomControls {

		private ref struct MaterialDrawData {
		public:
			bool isCurrent;
			System::Drawing::RectangleF rect;
			System::Drawing::Brush^ matBrush;
			System::Drawing::Pen^ matPen;
			MaterialDrawData( System::Drawing::RectangleF rc, System::Drawing::Brush^ brush, System::Drawing::Pen^ pen  ) :
				rect(rc), matBrush(brush), matPen(pen) {}
			~MaterialDrawData() { this->!MaterialDrawData(); }
			!MaterialDrawData() {
				if ( matBrush != nullptr ) { delete matBrush; matBrush = nullptr; }
				if ( matPen != nullptr ) { delete matPen; matPen = nullptr; }
			}
		};

	}
}

#include "TextureSetForm.hpp"
#include "VertexColorCustomBakeForm.hpp"
#include "MainEditForm.hpp"

namespace UVTexIntegra
{
	namespace CustomControls
	{
		//! @addtogroup UVTexIntegra-CustomControlsO
		//! @{

		//! @brief ϊ̒`ƕϊς݂MQ0x::Polygon::UVFaceBufferۗLNXłB
		//! @details MQ0x::Polygon::UVFaceBuffer::Functors::BasicUVTransformFunctor^Cṽt@N^ĂAMQ0x::Polygon::UVFaceBuffer::AddObject()Ɏgn܂B
		struct UVTransformedBuffer
		{
			//! @brief UVTransformedBuffer̍\zɎgpϊt@N^łB
			struct TransformFunctor
			{
				//! @brief RXgN^
				TransformFunctor( IDocumentFormat^ doc ) : m_doc(doc)
				{
				}

				//! @brief MQ0x::Polygon::UVFaceBuffer::Functors::BasicUVTransformFunctor^Cṽt@N^
				bool operator()( MQCoordinate* const uv_coorinates, DWORD* const colors,
					const MQObject obj, const int count_of_points, const int face_index, const UINT face_uid ) const
				{
					IDocumentFormat^ docData = static_cast<IDocumentFormat^>(m_doc);
					if ( docData == nullptr ) return false;
					const MQDocument mqdoc = docData->MQDocument;
					if ( mqdoc == NULL ) return false;

					const MQMaterial mat = mqdoc->GetMaterial( obj->GetFaceMaterial( face_index ) );
					EditData^ data = nullptr; if ( mat != NULL ) data = docData->ItemFromID( mat->GetUniqueID() );
					if ( data == nullptr ) return false;
			
					const double pad = std::abs(data->Padding);
					const UVCoordinate vMul((data->ScaleU - pad * 2.0) * 2.0, (data->ScaleV - pad * 2.0) * 2.0 );
					const UVCoordinate vAdd((data->MoveU + pad) * 2.0 - 1.0, (data->MoveV + pad) * 2.0 - 1.0 );
					for ( int ct = 0; ct < count_of_points; ct++ )
					{
						uv_coorinates[ct].u = float( double(uv_coorinates[ct].u) * vMul.u + vAdd.u );
						uv_coorinates[ct].v = float( double(uv_coorinates[ct].v) * vMul.v + vAdd.v );
					}
					return true;
				}
			private:
				const gcroot<IDocumentFormat^> m_doc;
			};
			
			//! @brief ftHgRXgN^
			UVTransformedBuffer() : m_uvBuffer(), m_doc(nullptr) {}
			
			//! @brief ^ZRCAIuWFNgobt@ɒǉ܂BǉUVTransformedBuffer::TransformFunctorUVWϊs܂B 
			void AddObject(const MQObject obj, bool isRecursive)
			{
				IDocumentFormat^ doc = Document();
				if (doc == nullptr) return;
				AddObject(obj, isRecursive, TransformFunctor(static_cast<IDocumentFormat^>(m_doc)));
			}
			
			//! @brief IDocumentFormatw肵āAMQ0x::Polygon::UVFaceBufferNA܂B
			void Clear( IDocumentFormat^ doc, const bool isCompact = false )
			{
				m_doc = doc;
				m_uvBuffer.Clear(isCompact);
			}
			
			//! @brief MQ0x::Polygon::UVFaceBuffer̎QƂǂݎpŎ擾܂B
			const MQ0x::Polygon::UVFaceBuffer& UVFaceBuffer() const
			{
				return m_uvBuffer;
			}

		protected:

			//! @brief ^ZRCAIuWFNgobt@ɒǉ܂BǉUVWϊt@N^w肵܂B
			//! @tparam FUNCTOR MQ0x::Polygon::UVFaceBuffer::Functors::BasicUVTransformFunctor^Cṽt@N^w肵ĂB
			template <class FUNCTOR> void AddObject(const MQObject obj, bool isRecursive, FUNCTOR& functor)
			{
				if (obj != NULL)
				{
					if (isRecursive) {
						IDocumentFormat^ doc = Document();
						if (doc == nullptr) return;
						m_uvBuffer.AddObjectRecursive(doc->MQDocument, obj, functor);
					}
					else m_uvBuffer.AddObject(obj, functor);
				}
			}
			
			//! @brief ݒ肳ꂽDocumentCX^X擾܂BȂADocument̎wClear()\bhōs܂B
			IDocumentFormat^ Document() const
			{
				return static_cast<IDocumentFormat^>(m_doc);
			}

		private:
			MQ0x::Polygon::UVFaceBuffer m_uvBuffer;
			//gcroot<MainEditForm::Document^> m_doc;
			gcroot<IDocumentFormat^> m_doc;
		};

		//! @brief ϊ̒`ƕϊς݂MQ0x::Polygon::UVFaceBufferۗLNXłB
		//! @details MQ0x::Polygon::UVFaceBuffer::Functors::BasicUVTransformFunctor^Cṽt@N^ĂAMQ0x::Polygon::UVFaceBuffer::AddObject()Ɏgn܂B
		struct UVNormalTransformedBuffer : public UVTransformedBuffer
		{
			//! @brief UVNormalTransformedBuffer̍\zɎgpϊt@N^łB
			struct TransformFunctor : private UVTransformedBuffer::TransformFunctor
			{
				//! @brief RXgN^
				TransformFunctor(UVNormalTransformedBuffer& owner)
					: UVTransformedBuffer::TransformFunctor(owner.Document()), m_owner(owner)
				{
				}

				//! @brief MQ0x::Polygon::UVFaceBuffer::Functors::BasicUVTransformFunctor^Cṽt@N^
				//! @details I[i[UVNormalTransformedBuffer̓C#`obt@ɏĂ܂B
				bool operator()( MQCoordinate* const uv_coorinates, DWORD* const colors,
					const MQObject obj, const int count_of_points, const int face_index, const UINT face_uid ) const
				{
					bool ret = UVTransformedBuffer::TransformFunctor::operator()(uv_coorinates,colors,obj,count_of_points,face_index,face_uid);
					if (ret)
					{
						array<Scripting::ScriptMain::Face::Point^>^ points = gcnew array<Scripting::ScriptMain::Face::Point^>(count_of_points);
						if (obj != m_owner.m_normal_buffer.MQObject()) m_owner.m_normal_buffer.Clear(obj);
						int v_index_buffer[4];
						obj->GetFacePointArray( face_index, v_index_buffer );
						for ( int ctFacePoint = 0; ctFacePoint < count_of_points; ctFacePoint++ )
						{
							const MQPoint& vertexNormal = m_owner.m_normal_buffer.VertexNormal( MQ0x::Polygon::VertexNormalBuffer::size_type(v_index_buffer[ctFacePoint]) );
							points[ctFacePoint] = gcnew Scripting::ScriptMain::Face::Point(
								uv_coorinates[ctFacePoint].u, uv_coorinates[ctFacePoint].v,
								MQCLIEX::FromMQVertexColor( colors[ctFacePoint] ),
								vertexNormal.x, vertexNormal.y, vertexNormal.z
							);
						}
						const MQPoint& faceNormal = m_owner.m_normal_buffer.FaceNormal( MQ0x::Polygon::FaceNormalBuffer::size_type(face_index) );
						m_owner.m_faces->Add( gcnew Scripting::ScriptMain::Face( face_uid, faceNormal.x, faceNormal.y, faceNormal.z, points ) );
					}
					return ret;
				}

				/*
				//! @brief MQ0x::Polygon::UVFaceBuffer::Functors::BasicUVTransformFunctor^Cṽt@N^
				bool operator()( MQCoordinate* const uv_coorinates, DWORD* const colors,
					const MQObject obj, const int count_of_points, const int face_index, const UINT face_uid ) const
				{
					bool ret = UVTransformedBuffer::TransformFunctor::operator()(uv_coorinates,colors,obj,count_of_points,face_index,face_uid);
					if (ret)
					{
						Scripting::ScriptMain^ scriptMain = static_cast<Scripting::ScriptMain^>(m_owner.m_scriptMain);
						if (scriptMain != nullptr)
						{
							array<OpenTK::Vector2>^ coordinates = gcnew array<OpenTK::Vector2>(count_of_points);
							array<System::Drawing::Color>^ coordinateColors = gcnew array<System::Drawing::Color>(count_of_points);
							array<OpenTK::Vector3>^ normals = gcnew array<OpenTK::Vector3>(count_of_points);

							if (obj != m_owner.m_normal_buffer.MQObject()) m_owner.m_normal_buffer.Clear(obj);

							int v_index_buffer[4];
							obj->GetFacePointArray( face_index, v_index_buffer );
							for ( int ctFacePoint = 0; ctFacePoint < count_of_points; ctFacePoint++ )
							{
								const MQPoint& vertexNormal = m_owner.m_normal_buffer.VertexNormal( MQ0x::Polygon::VertexNormalBuffer::size_type(v_index_buffer[ctFacePoint]) );
								coordinates[ctFacePoint] = OpenTK::Vector2( uv_coorinates[ctFacePoint].u, uv_coorinates[ctFacePoint].v );
								coordinateColors[ctFacePoint] = MQCLIEX::FromMQVertexColor( colors[ctFacePoint] );
								normals[ctFacePoint] = OpenTK::Vector3( vertexNormal.x, vertexNormal.y, vertexNormal.z );
							}
							const MQPoint& faceNormal = m_owner.m_normal_buffer.FaceNormal( MQ0x::Polygon::FaceNormalBuffer::size_type(face_index) );

							//if ( scriptMain->CustomUVOperation(coordinates, coordinateColors, OpenTK::Vector3(faceNormal.x, faceNormal.y, faceNormal.z), normals ) )
							//{
							//	for ( int ctFacePoint = 0; ctFacePoint < count_of_points; ctFacePoint++ )
							//	{
							//		uv_coorinates[ctFacePoint].u = coordinates[ctFacePoint].X;
							//		uv_coorinates[ctFacePoint].v = coordinates[ctFacePoint].Y;
							//		colors[ctFacePoint] = MQCLIEX::ArgbToMQVertexColor(
							//			coordinateColors[ctFacePoint].A,
							//			coordinateColors[ctFacePoint].R,
							//			coordinateColors[ctFacePoint].G,
							//			coordinateColors[ctFacePoint].B );
							//	}
							//}
						}
					}
					return ret;
				}
				*/
			private:
				UVNormalTransformedBuffer& m_owner;
			};
			
			//! @cond
			friend struct TransformFunctor;
			//! @endcond

			//! @brief ^ZRCAIuWFNgobt@ɒǉ܂B
			//! @details ǉUVNormalTransformedBuffer::TransformFunctorĊ{IUVWϊsAC#`̖ʏobt@Ƀvϊς݂̏ǉ܂B
			void AddObject(const MQObject obj, bool isRecursive)
			{
				IDocumentFormat^ doc = Document();
				if (doc == nullptr) return;
				UVTransformedBuffer::AddObject(obj, isRecursive, TransformFunctor(*this));
			}

			//! @brief IDocumentFormatw肵āAMQ0x::Polygon::UVFaceBufferNA܂B
			void Clear( IDocumentFormat^ doc, Scripting::ScriptMain^ script, const bool isCompact = false )
			{
				//m_scriptMain = script;
				m_normal_buffer.Clear(NULL, isCompact);
				if (static_cast<System::Collections::Generic::List<Scripting::ScriptMain::Face^>^>(m_faces) != nullptr) m_faces->Clear();
				else m_faces = gcnew System::Collections::Generic::List<Scripting::ScriptMain::Face^>();
				UVTransformedBuffer::Clear(doc, isCompact);
			}

			//! @brief C#`̖ʏobt@AScriptMainCX^Xɑĕϊdグ܂B
			//! @details ScriptMainCX^Xɓnf[^̓fB[vRs[AScriptMainԂl܂A߂ɃfB[vRs[܂B
			//! @return ϊς݂FacezԂ܂BnꂽscriptMainnull܂͓C#`obt@ClearԂnullłꍇAnullԂ܂B
			CustomControls::Drawing::FaceBuffer^ GetUVOperationed( Scripting::ScriptMain^ scriptMain )
			{
				if (static_cast<System::Collections::Generic::List<Scripting::ScriptMain::Face^>^>(m_faces) == nullptr) return nullptr;
				if (scriptMain == nullptr) return nullptr;
				array<Scripting::ScriptMain::Face^>^ ary = m_faces->ToArray();
				scriptMain->OnUVOperation(ary);
				return gcnew CustomControls::Drawing::FaceBuffer(ary);
			}

			//! @brief MQ0x::Polygon::VertexNormalBuffer̎QƂǂݎpŎ擾܂B
			const MQ0x::Polygon::VertexNormalBuffer& VertexNormalBuffer() const { return m_normal_buffer; }

		private:
			void Clear( IDocumentFormat^ doc, const bool isCompact = false ); // kill
			MQ0x::Polygon::VertexNormalBuffer m_normal_buffer;
			//gcroot<Scripting::ScriptMain^> m_scriptMain;
			gcroot<System::Collections::Generic::List<Scripting::ScriptMain::Face^>^> m_faces;
		};
	
		//! @}
	}
}
