﻿// == LICENSE INFORMATION ==
/*
 * First author tiritomato 2013.
 * This program is distributed under the GNU General Public License(GPL).
 * support blog (Japanese only) http://d.hatena.ne.jp/tiri_tomato/
 */
// == LICENSE INFORMATION ==

namespace UVTexIntegra.Scripting
{
    //! @addtogroup UVTexIntegra-Scripting名前空間
    //! @{

    public partial class ScriptMain
    {
        public partial class Face
        {
            //! 面情報で使用する頂点情報を定義します。
            public class Point : System.ICloneable
            {
                /// @cond <summary>UV座標を取得/設定します。</summary> @endcond
                //! @brief UV座標を取得/設定します。
                public OpenTK.Vector2 Coordinate;

                /// @cond <summary>頂点色を取得/設定します。</summary> @endcond
                //! @brief 頂点色を取得/設定します。
                public System.Drawing.Color Color;

                /// @cond <summary>モデル座標上での頂点法線（頂点を共有する面法線の平均）を取得します。法線は正規化済みです。</summary> @endcond
                //! @brief モデル座標上での頂点法線（頂点を共有する面法線の平均）を取得します。法線は正規化済みです。
                public readonly OpenTK.Vector3 Normal;

                /// @cond <summary>コンストラクタ</summary> @endcond
                //! @brief コンストラクタ
                public Point(float u, float v, System.Drawing.Color color, float nx, float ny, float nz)
                {
                    Coordinate = new OpenTK.Vector2(u, v);
                    this.Color = color;
                    Normal = new OpenTK.Vector3(nx, ny, nz);
                }

                /// @cond <summary>コピーコンストラクタ（ディープコピー）</summary> @endcond
                //! @brief コピーコンストラクタ（ディープコピー）
                //! @details @exception System.NullReferenceException srcがnullです。
                public Point(Point src)
                {
                    Coordinate = src.Coordinate;
                    Color = src.Color;
                    Normal = src.Normal;
                }

                /// @cond <summary>クローンメソッド</summary> @endcond
                //! @brief クローンメソッド
                public Point Clone() { return new Point(this); }

                /// @cond <summary>クローンメソッド</summary> @endcond
                //! @brief クローンメソッド
                //! @return 全ての要素が個別にディープコピーされたクローン配列。srcがnullの時は空の配列が返ります。
                public static Point[] Clone(Point[] src)
                {
                    if (src == null) return new Point[0];
                    Point[] ret = new Point[src.LongLength];
                    for (long index = 0; index < src.LongLength; index++) ret[index] = src[index].Clone();
                    return ret;
                }

                /// @cond <summary>クローンメソッド（System.ICloneable）</summary> @endcond
                //! @brief クローンメソッド（System.ICloneable）
                object System.ICloneable.Clone() { return Clone(); }
            }
        }
    }
    //! @}
}
