﻿// == LICENSE INFORMATION ==
/*
 * First author tiritomato 2013.
 * This program is distributed under the GNU General Public License(GPL).
 * support blog (Japanese only) http://d.hatena.ne.jp/tiri_tomato/
 */
// == LICENSE INFORMATION ==

using System;

namespace UVTexIntegra.CustomControls
{
    //! @addtogroup UVTexIntegra-CustomControls名前空間
    //! @{

    //! @brief 別フォームの子ウィンドウとして、モードレスに表示されるテキストログダイアログクラスです。
    public class TextLogForm : DotNetEx.CustomControls.TextForm
    {
        //! @brief コンストラクタ。
        //! @param owner オーナーウィンドウを指定します。nullで省略するとただの独立ウィンドウとして振舞います。
        public TextLogForm(System.Windows.Forms.Form owner)
            : base()
        {
            if ((m_owner = owner) != null) m_owner.AddOwnedForm(this);
        }

        //! @brief 終了時に親フォームに対してRemoveOwnedFormします。
        protected override void OnClosed(EventArgs e)
        {
            if (m_owner != null) {
                m_owner.RemoveOwnedForm(this);
                m_owner = null;
            }
            base.OnClosed(e);
        }

        private System.Windows.Forms.Form m_owner;
    }

    //! @}
}
