﻿// == LICENSE INFORMATION ==
/*
 * First author tiritomato 2013.
 * This program is distributed under the GNU General Public License(GPL).
 * support blog (Japanese only) http://d.hatena.ne.jp/tiri_tomato/
 */
// == LICENSE INFORMATION ==

namespace UVTexIntegra.CustomControls
{
    //! @addtogroup UVTexIntegra-CustomControls名前空間
    //! @{

    //! @brief CustomControls用に拡張機能を提供する静的クラスです。
    public static class Extention
    {
     	//! @brief タブ入力による順繰りのフォーカス移動をエミュレーションします。
		//! @param [in] e キー入力イベントのパラメーター
		//! @param [in] controls フォーカス移動順に並んだコントロールのリスト
		//! @attention なんらかの理由でタブ機能が使えない場合に使用してください。
		public static void TabFocusMoveProxy( this System.Windows.Forms.KeyEventArgs e, System.Collections.Generic.IList<System.Windows.Forms.Control> controls )
		{
			if ( (e!=null) && (controls!=null) && (e.KeyCode==System.Windows.Forms.Keys.Tab) && (e.Control==false) ) {
				for ( int index = 0; index < controls.Count; index++ ) {
					System.Windows.Forms.Control ctrl = controls[index];
					if ( (ctrl == null) || (ctrl.Focused==false) ) continue;
					int selectIndex = index;
					System.Windows.Forms.Control nextCtrl = null;
					do {
						if ( e.Shift ) selectIndex = (selectIndex <= 0 ? controls.Count : selectIndex) - 1;
						else selectIndex = selectIndex < (controls.Count-1) ? selectIndex + 1 : 0;
						nextCtrl = controls[selectIndex];
						if ( nextCtrl.CanFocus ) { nextCtrl.Select(); break; }
					} while ( (nextCtrl!=null) && (selectIndex!=index) );
					break;
				}
			}
		}
    }

    //! @}
}
