﻿// == LICENSE INFORMATION ==
/*
 * First author tiritomato 2013.
 * This program is distributed under the GNU General Public License(GPL).
 * support blog (Japanese only) http://d.hatena.ne.jp/tiri_tomato/
 */
// == LICENSE INFORMATION ==

using System;
using DotNetEx.String;

namespace UVTexIntegra.CustomControls
{
    //! @addtogroup UVTexIntegra-CustomControls名前空間
    //! @{

    //! @brief コンパイル結果を表示するダイアログをMDI子ウィンドウとして表示します。
    public class CompileResultForm : DotNetEx.CustomControls.TextForm
    {
        //! @brief CompileResultFormが親ウィンドウに要求するインターフェースです。
        //! @details CompileResultWindowSizeプロパティを介して、フォームを最後に閉じた時のウィンドウサイズを報告します。
        public interface ICompileResultOwner : System.Windows.Forms.IWin32Window
        {
            System.Drawing.Size CompileResultWindowSize { get; set; }
        }

        //! @brief コンストラクタ。必ずICompileResultOwnerを指定する必要があります。
        //! @details @exception System.NullReferenceException ownerがnullです。
        public CompileResultForm(ICompileResultOwner owner) : base()
        {
            m_owner = owner;
            System.Drawing.Size sz = owner.CompileResultWindowSize;
            if ((0 < sz.Width) && (0 < sz.Height)) Size = sz;
            else System.Windows.Forms.MessageBox.Show("size is " + sz.ToString());
            System.Windows.Forms.Form owner_form = owner as System.Windows.Forms.Form;
            if (owner_form != null) owner_form.AddOwnedForm(this);
        }

        //! @brief コンパイル結果を転写したフォームを表示します。
        public void Show(Scripting.CompileException ex)
        {
            AppendLine(ex.ToNestedMultilineString());
            if (ex.Results != null)
            {
                AppendLine();
                AppendLine("Output:");
                foreach (System.String str in ex.Results.Output) AppendLine(str);
            }
            Show(m_owner);
        }

        //! @brief クローズイベントをオーバーライドして、フォームが通常（非最小/最大）であればオーナーウィンドウにサイズを報告してから閉じます。
        protected override void OnClosed(EventArgs e)
        {
            if ((WindowState == System.Windows.Forms.FormWindowState.Normal) && (m_owner != null))
            {
                System.Windows.Forms.Form owner_form = m_owner as System.Windows.Forms.Form;
                if (owner_form != null) owner_form.RemoveOwnedForm(this);
                m_owner.CompileResultWindowSize = Size;
                m_owner = null;
            }
            base.OnClosed(e);
        }

        private ICompileResultOwner m_owner;
    }

    //! @}
}
