﻿// == LICENSE INFORMATION ==
/*
 * First author tiritomato 2013.
 * This program is distributed under the GNU Lesser General Public License(LGPL ver3).
 * support blog (Japanese only) http://d.hatena.ne.jp/tiri_tomato/
 */
// == LICENSE INFORMATION ==

namespace DotNetEx
{
    //! @addtogroup DotNetEx名前空間
    //! @{

    //! @brief DotNetEx名前空間で使用する、各種の静的な拡張メソッド。
    public static class Extention
    {
        //! @brief オブジェクトをBinaryFormatter経由でディープクローンします。
        //! @attention クローニングする時、型にはSerializable属性が必要です。ない場合は実行時エラーを生じます。
        public static System.Object BinaryFormatClone(this System.Object src)
        {
            if (src == null) return null;
            using (System.IO.MemoryStream stream = new System.IO.MemoryStream())
            {
                System.Runtime.Serialization.Formatters.Binary.BinaryFormatter bf = new System.Runtime.Serialization.Formatters.Binary.BinaryFormatter();
                bf.Serialize(stream, src);
                stream.Position = 0;
                return bf.Deserialize(stream);
            }
        }

        //! @brief コントロールをCustomControls.TagHandler<>として振舞わせます。
        public static CustomControls.TagHandler<ValueType> ToTagHandlerAs<ValueType>(this System.Windows.Forms.Control ctrl)
        {
            return new CustomControls.TagHandler<ValueType>(ctrl);
        }
    }

    //! @}
}
