/* -*- mode: c++; coding: sjis; -*-
 * Time-stamp: <2005-08-03 19:00:25 tfuruka1>
 * $Id: printer.c,v 1.16 2005/08/03 10:09:20 tfuruka1 Exp $
 * $Name:  $
 *
 * uak2pŝ悤Ȃ́ṽv^֘A
 *
 * $Log: printer.c,v $
 * Revision 1.16  2005/08/03 10:09:20  tfuruka1
 * [Faceł悤ɂ܂B
 *
 * Revision 1.15  2005/05/10 16:06:02  tfuruka1
 * NameL[[haɒuȂǂӏɃRgLq܂B
 *
 * Revision 1.14  2005/05/08 13:02:04  tfuruka1
 * X-Face֘A̒ǉ
 *
 * Revision 1.13  2004/12/26 09:19:15  tfuruka1
 * sԍĂԂ, ܂Ԃꍇɐ܂Ԃsȍ~̐擪
 * ̈ʒusڂ̍sԍʒuƓɂȂ悤ɂ܂B
 *
 * Revision 1.12  2004/12/23 08:11:56  tfuruka1
 * VOC(H~oȂ)ɑΉ܂BƂ肠
 * AT[o̐ݒ݂̂łB
 *
 * Revision 1.11  2004/08/21 01:01:01  tfuruka1
 * eLXgɉāusԁvƁurAvLɂȂ悤ɂ܂B
 *
 * Revision 1.10  2004/08/16 14:23:25  tfuruka1
 * rAȂꍇC܂B
 *
 * Revision 1.9  2004/06/18 00:57:56  tfuruka1
 * sR[h̏Ĉ݂łB
 *
 * Revision 1.8  2004/01/19 05:35:54  tfuruka1
 * tHgݒł悤ɂ, tHgɊ֘A֐̃C^[
 * tFCXύX܂B
 *
 * Revision 1.7  2004/01/12 09:55:49  tfuruka1
 * ӒԂƒZӒԂɑΉ܂B
 *
 * Revision 1.6  2003/03/16 00:20:53  tfuruka1
 *  vr[̈ݒŔfȂڂ̂ŁACB
 *
 * Revision 1.5  2003/03/01 09:04:09  tfuruka1
 * {ȊO̒`̈F{fB̉e󂯂ꍇ
 * ̂CB
 *
 * Revision 1.4  2001/12/23 10:10:33  tfuruka1
 * vr[L̔f@ύXB
 * Copyright\󎚂Ȃ[hpӂB
 *
 * Revision 1.3  2001/12/18 12:58:41  tfuruka1
 * i̕𒴂ĕ󎚂Ă܂CB̖̃fob
 * OsړIŁAfobOp̃`FbN{bNXݒ̉ʂɒǉB
 *
 * Revision 1.2  2001/12/18 04:06:40  tfuruka1
 * vr[ɑΉ܂B
 *
 * Revision 1.1  2001/02/05 17:46:22  tfuruka1
 * Initial revision
 *
 */
// (replace-regexp "/\\*\\(.+\\)\\*/" "//\\1")
// (replace-regexp "[ \t]+$" "")

#include "ak2prs.h"
#include "ak2pr.h"

// v^̌ŗL
static int nPaperWidth, nPaperHeight;           // p̃TCY
static int nDPIW, nDPIH;                        // 𑜓x
static int nPaperMarginW, nPaperMarginH;        // sGA
static int nPageNo;                             // y[Wԍ
static int nBasePoint, nBaseLineK, nBaseLine;   // x[XC
static int nCurrentX, nCurrentY;                // ݂̍W
static int nStartX, nEndX;                      // ͈̔
static int nStartY, nEndY;                      // ͈̔
static int nLineNoOffset;                       // sԍItZbg
static int nCharWidth;                          // ꕶ̕
static BOOL bKeisen, bKanji;                    // ryъtO
static BOOL bPreviewed = FALSE;                 // T:vr[ς
// rR[h\
static LPTSTR szKeisen = {
    /* -------- 0 1 2 3 4 5 6 7 8 9 A B C D E F */
    /* 282x - */ ""
    /* 283X */ ""
    /* 284X */ ""
};

/* -------------------------------------------------------------------
 * 𑜓xnDpi̎̒valuesNZ֕ϊBvalue̒Pʂflg
 * Ŏw肷BCX_PT(|Cg), CX_CM(Z`[g), CX_MM(~[
 * g)woB
 * *-----------------------------------------------------------------*/
int ConvX2Dt(double value, int nDpi, int flg)
{
    switch (flg) {
    case CX_PT:
        return (int)(value * nDpi / 72.0);
    case CX_CM:
        return (int)(value * nDpi / 2.54);
    case CX_MM:
        return (int)(value * nDpi / 25.4);
    default:
        MessageBox(NULL, "ϊtOsł", "ConvX2Dt()",
                   MB_ICONSTOP | MB_SETFOREGROUND);
        return 0;
    }
}

/* -------------------------------------------------------------------
 * ConvdDt̋tsB
 * *-----------------------------------------------------------------*/
double ConvDt2X(int value, int nDpi, int flg)
{
    switch (flg) {
    case CX_PT:
        return value * 72.0 / nDpi;
    case CX_CM:
        return value * 2.54 / nDpi;
    case CX_MM:
        return value * 25.4 / nDpi;
    default:
        MessageBox(NULL, "ϊtOsł", "ConvDt2X()",
                   MB_ICONSTOP | MB_SETFOREGROUND);
        return 0;
    }
}

int GetPrtDpiW(void)
{
    return nDPIW;
}

int GetPrtDpiH(void)
{
    return nDPIH;
}

int GetPrtWd(void)
{
    return nPaperWidth;
}

int GetPrtHt(void)
{
    return nPaperHeight;
}

int GetPrtMgW(void)
{
    return nPaperMarginW;
}

int GetPrtMgH(void)
{
    return nPaperMarginH;
}

int GetPrtBasePoint(void)
{
    return nBasePoint;
}

int GetPrtCenter(int flg)
{
    int nCenter;

    if (flg & GPC_W) {
        nCenter = nPaperWidth / 2;
        if (!(flg & GPC_IM)) {
            nCenter -= nPaperMarginW;
        }
    } else {
        nCenter = nPaperHeight / 2;
        if (!(flg & GPC_IM)) {
            nCenter -= nPaperMarginH;
        }
    }
    return nCenter;
}

BOOL
SetupPrinter(
    HWND hWnd,                                  // nh
    HGLOBAL *lphDevNames,                       // foCXl[
    HGLOBAL *lphDevMode                         // foCX[h
    )
{
    PRINTDLG pd;                                // _CAO
    BOOL bRet = FALSE;

    EnterCriticalSection(&g_csCriticalSection);// bN
    DbgPrint(NULL, 'I', "bN");

    DbgPrint(NULL, 'I', "v^ݒJn");

    // []_CAO {bNX
    pd.lStructSize = sizeof(PRINTDLG);
    pd.hwndOwner = hWnd;
    pd.hDevMode = (HANDLE)*lphDevMode;
    pd.hDevNames = (HANDLE)*lphDevNames;
    pd.hDC = (HDC)NULL;
    pd.Flags = PD_PRINTSETUP;
    pd.nFromPage = 1;
    pd.nToPage = 1;
    pd.nMinPage = 0;
    pd.nMaxPage = 0;
    pd.nCopies = 1;
    pd.hInstance = (HANDLE)NULL;
    pd.lCustData = 0L;
    pd.lpfnPrintHook = (LPPRINTHOOKPROC)NULL;
    pd.lpfnSetupHook = (LPSETUPHOOKPROC)NULL;
    pd.lpPrintTemplateName = (LPSTR)NULL;
    pd.lpSetupTemplateName = (LPSTR)NULL;
    pd.hPrintTemplate = (HANDLE)NULL;
    pd.hSetupTemplate = (HANDLE)NULL;

    /* _CAO{bNX\ */
    if (!PrintDlg(&pd)) {                       // Cancelꍇ
        DbgPrint(NULL, 'W', "LZ{^܂");
        goto Exit;
    }

    *lphDevNames = pd.hDevNames;
    *lphDevMode = pd.hDevMode;

    SetDefaultPrtInfo();                        // foCX񏑂

    DbgPrint(NULL, 'I', "v^ݒI");

    bRet = TRUE;
 Exit:
    DbgPrint(NULL, 'I', "bN");
    LeaveCriticalSection(&g_csCriticalSection); // bN

    return bRet;
}

/* -------------------------------------------------------------------
 * v^̏ݒs
 * *-----------------------------------------------------------------*/
BOOL
BeginDocument(void)
{
    static DOCINFO di;
    TCHAR szBuf[512];
    HFONT hFont, hOldFont;
    SIZE Size;

    DbgPrint(NULL, 'B', "v^Jn");

    wsprintf(szBuf, "(^_^)%s T.Furukawa",
             !g_MailBox.PrtInfo.szFileName[0] ? "eXg" :
             (g_MailBox.PrtInfo.szTitle[0] ? g_MailBox.PrtInfo.szTitle :
              "e-mail?"));
    di.cbSize = sizeof(DOCINFO);
    di.lpszDocName = szBuf;
    di.lpszOutput = (LPTSTR)NULL;

    if (!g_MailBox.PrtInfo.bPreView) {
        // v^o͂̏ꍇ
        if (SP_ERROR == StartDoc(g_MailBox.hDC, &di)) {
            int nErr = GetLastError();
            DbgPrint(NULL, 'E', "%s",
                     GetLastErrorMessage(__FILE__ " StartDoc()", nErr));
            return FALSE;
        }
        nPaperWidth = GetDeviceCaps(g_MailBox.hDC, PHYSICALWIDTH);
        nPaperHeight = GetDeviceCaps(g_MailBox.hDC, PHYSICALHEIGHT);
        nPaperMarginW = GetDeviceCaps(g_MailBox.hDC, PHYSICALOFFSETX);
        nPaperMarginH = GetDeviceCaps(g_MailBox.hDC, PHYSICALOFFSETY);

        nDPIW = GetDeviceCaps(g_MailBox.hDC, LOGPIXELSX);
        nDPIH = GetDeviceCaps(g_MailBox.hDC, LOGPIXELSY);

    } else {
        // vr[̏ꍇ
        nPaperWidth = g_MailBox.PrevInfo.wd;
        nPaperHeight = g_MailBox.PrevInfo.ht;
        nPaperMarginW = g_MailBox.PrevInfo.xoff;
        nPaperMarginH = g_MailBox.PrevInfo.yoff;

        nDPIW = g_MailBox.PrevInfo.dpiW;
        nDPIH = g_MailBox.PrevInfo.dpiH;

        bPreviewed = FALSE;                     // vr[ɐݒ
    }

    DbgPrint(NULL, 'I', "foCX\n"
             "TCY  : %d~%ddot%f~%fcm\n"
             "}[W: %ddot(Left), %ddot(Top)%f, %fcm\n"
             "𑜓x  : %d~%ddpi",
             nPaperWidth, nPaperHeight,
             nPaperWidth * 2.54 / nDPIW, nPaperHeight * 2.54 / nDPIH,
             nPaperMarginW, nPaperMarginH,
             nPaperMarginW * 2.54 / nDPIW, nPaperMarginH * 2.54 / nDPIH,
             nDPIW, nDPIH);

    nCurrentX = nCurrentY = 0;
    nPageNo = 1;
    bKanji = FALSE;
    bKeisen = FALSE;

    // x[XCXLbv̏ݒs
    nBasePoint = ConvX2Dt(g_MailBox.PrtInfo.fFontSize, nDPIH, CX_PT);
    nBaseLineK = ConvX2Dt(g_MailBox.PrtInfo.fFontSize * 1.5, nDPIH, CX_PT);
    nBaseLine = ConvX2Dt(g_MailBox.PrtInfo.fFontSize * 1.2, nDPIH, CX_PT);

    // eLXg̃obN[h()
    SetBkMode(g_MailBox.hDC, TRANSPARENT);

    // sԍItZbǧvZ
    if (g_MailBox.PrtInfo.bNum) {
        hFont = CreatePrtFont(GetPrtBasePoint(), 800, FALSE,
                              FALSE, FALSE, &g_MailBox.PrtInfo.lfOF);
        hOldFont = SelectObject(g_MailBox.hDC, hFont);
        GetTextExtentPoint32(g_MailBox.hDC, "0000: ", 6, &Size);

        nLineNoOffset = Size.cx;
        DbgPrint(NULL, 'I', "LineNo Offset = %d", nLineNoOffset);

        SelectObject(g_MailBox.hDC, hOldFont);
        DeleteObject(hFont);
    } else {
        nLineNoOffset = 0;
    }

    // ꕶ̕vZ
    hFont = CreatePrtFont(GetPrtBasePoint(), 400, FALSE,
                          FALSE, FALSE, &g_MailBox.PrtInfo.lfTHF);
    hOldFont = SelectObject(g_MailBox.hDC, hFont);
    GetTextExtentPoint32(g_MailBox.hDC, "M", 1, &Size);

    nCharWidth = Size.cx;
    DbgPrint(NULL, 'I', "Character Width = %d", nCharWidth);

    SelectObject(g_MailBox.hDC, hOldFont);
    DeleteObject(hFont);

    DbgPrint(NULL, 'B', "v^");
    return TRUE;
}

HPEN
CreatePrtPen(
    UINT nStyle,                                // ỹX^C
    LONG nWidth,                                // 
    COLORREF crColor                            // F
    )
{
    LOGPEN lgpen;                               // _y

    lgpen.lopnStyle = nStyle;
    lgpen.lopnWidth.x = nWidth;
    lgpen.lopnColor = crColor;

    return CreatePenIndirect(&lgpen);
}

HFONT
CreatePrtFont(
    int nHeight,                                // tHg̍
    int nWeight,                                // tHg̑
    BOOL bItalic,                               // T: C^bN
    BOOL bUnderline,                            // T: 
    BOOL bStrikeOut,                            // T: ł
    LPLOGFONT lplft                             // LOGFONTev[g
    )
{
    LOGFONT lf;

    nHeight += (nHeight % 2);                   // K2̔{ɂ

    memcpy(&lf, lplft, sizeof(LOGFONT));
    lf.lfHeight = nHeight;
    lf.lfWidth = 0;
    lf.lfWeight = nWeight;
    lf.lfItalic = bItalic;
    lf.lfUnderline = bUnderline;
    lf.lfStrikeOut = bStrikeOut;

    return CreateFontIndirect(&lf);
}

/* -------------------------------------------------------------------
 * y[Wo͂Jn
 * *-----------------------------------------------------------------*/
BOOL
BeginPage(void)
{
    static int nLeft, nRight;
    time_t t;
    HPEN hPen, hOldPen;
    HBRUSH hBrush, hOldBrush;
    HFONT hFont, hOldFont;
    POINT pt[3];
    RECT rc;
    int nError, mod, i, nCenter;
    LPTSTR szErr = NULL;
    TCHAR szBuf[512];

    SetTextColor(g_MailBox.hDC, RGB(0, 0, 0));

    // nig݂̍ŏ̒iȊO(ԍ̒iȊO)͍̎W̍XVs
    if (0 != (mod = ((nPageNo - 1) % g_MailBox.PrtInfo.nNumOfUp))) {
        double fWidth = (double)(nRight - nLeft) / g_MailBox.PrtInfo.nNumOfUp;
        nStartX = (int)(nLeft + fWidth * mod);
        nEndX = (int)(nStartX + fWidth);
        nStartX += ConvX2Dt(5, nDPIW, CX_PT);
        nEndX -= ConvX2Dt(5, nDPIW, CX_PT);
        nPageNo++;
        goto Exit;
    }
    // ----------------------------------------------
    // ȉ͈ԍŏ̒ïJn̂ݎs܂
    // ----------------------------------------------
    if (!g_MailBox.PrtInfo.bPreView) {
        // vr[̏ꍇ͂̃ubN͍̏sȂ
        nError = StartPage(g_MailBox.hDC);
        if (nError <= 0) {
            DbgPrint(NULL, 'E', "%s",
                     GetLastErrorMessage("StartPage()", GetLastError()));

            return FALSE;
        }
    }

    rc.top = rc.left = 0;
    rc.right = nPaperWidth;
    rc.bottom = nPaperHeight;
    FillRect(g_MailBox.hDC, &rc, GetStockObject(WHITE_BRUSH));

    // Og̕`
    hPen = CreatePrtPen(PS_SOLID, (int)(nDPIW / 72.0 + 1), RGB(0, 0, 0));
    hBrush = CreateSolidBrush(RGB(255, 255, 255));
    hOldPen = SelectObject(g_MailBox.hDC, hPen);
    hOldBrush = SelectObject(g_MailBox.hDC, hBrush);

    if (((nPaperWidth > nPaperHeight)
         && !g_MailBox.PrtInfo.bShortBinding)   // u̒ӒԂ
        || (!(nPaperWidth > nPaperHeight)
         && g_MailBox.PrtInfo.bShortBinding)    // cu̒ZӒԂ
        ) {
        RoundRect(g_MailBox.hDC,
                  nStartX = nDPIW / 2 - nPaperMarginW,
                  nStartY = nDPIH - nPaperMarginH,
                  nEndX = nPaperWidth - nDPIW / 2 - nPaperMarginW,
                  nEndY = nPaperHeight - nDPIH / 2 - nPaperMarginH,
                  nDPIW / 4, nDPIH / 4);
    } else {                                      // cȕꍇ
        RoundRect(g_MailBox.hDC,
                  nStartX = nDPIW - nPaperMarginW,
                  nStartY = nDPIH / 2 - nPaperMarginH,
                  nEndX = nPaperWidth - nDPIW / 2 - nPaperMarginW,
                  nEndY = nPaperHeight - nDPIH / 2 - nPaperMarginH,
                  nDPIW / 4, nDPIH / 4);
    }

    // ^CgƖ{̎d؂
    nStartY += ConvX2Dt(20, nDPIH, CX_PT);
    pt[0].x = nLeft = nStartX;
    pt[0].y = pt[1].y = nStartY;
    pt[1].x = nRight = nEndX;
    Polyline(g_MailBox.hDC, &pt[0], 2);

    // y[W̎d؂`悷
    for (i = 1; i < g_MailBox.PrtInfo.nNumOfUp; i++) {
        double fWidth = (nRight - nLeft) / g_MailBox.PrtInfo.nNumOfUp * i;
        pt[0].x = pt[1].x = (int)(fWidth + nLeft);
        pt[0].y = nStartY;
        pt[1].y = nEndY;
        Polyline(g_MailBox.hDC, &pt[0], 2);
    }
    nEndX = (int)(nStartX + (nRight - nLeft) / g_MailBox.PrtInfo.nNumOfUp
                  - ConvX2Dt(5, nDPIW, CX_PT));
    nStartX += ConvX2Dt(5, nDPIW, CX_PT);
    nStartY += ConvX2Dt(5, nDPIH, CX_PT);
    nEndY -= ConvX2Dt(5, nDPIH, CX_PT);

    SelectObject(g_MailBox.hDC, hOldBrush);
    SelectObject(g_MailBox.hDC, hOldPen);
    DeleteObject(hPen);
    DeleteObject(hBrush);

    // Ԃʒu`悷
    hPen = CreatePrtPen(PS_SOLID, 1, RGB(0, 0, 0));
    hBrush = CreateSolidBrush(RGB(0, 0, 0));
    hOldPen = SelectObject(g_MailBox.hDC, hPen);
    hOldBrush = SelectObject(g_MailBox.hDC, hBrush);

    if (((nPaperWidth > nPaperHeight)
         && !g_MailBox.PrtInfo.bShortBinding)   // u̒ӒԂ
        || (!(nPaperWidth > nPaperHeight)
            && g_MailBox.PrtInfo.bShortBinding) // cu̒ZӒԂ
        ) {

        pt[0].x = nCenter = GetPrtCenter(GPC_W);
        pt[1].y = pt[2].y = ConvX2Dt(10, nDPIH, CX_PT);
        pt[0].y = 0;
        pt[1].x = pt[0].x + ConvX2Dt(5, nDPIW, CX_PT);
        pt[2].x = pt[0].x - ConvX2Dt(5, nDPIW, CX_PT);
    } else {                                    // cȕꍇ
        pt[0].x = 0;
        pt[1].x = pt[2].x = ConvX2Dt(10, nDPIW, CX_PT);
        pt[0].y = nCenter = GetPrtCenter(GPC_H);
        pt[1].y = pt[0].y + ConvX2Dt(5, nDPIH, CX_PT);
        pt[2].y = pt[0].y - ConvX2Dt(5, nDPIH, CX_PT);
    }
    Polygon(g_MailBox.hDC, &pt[0], 3);

    // 2 HOLE PUNCHI `悷BAۂ̐Ki(JIS?)͒m
    // ܂BŌv, ƌ̋8cm, ̒a5.5mm, p
    // ̒[猊̒_̋1cmƂĕ`悵Ă܂B
    if (((nPaperWidth > nPaperHeight)
         && !g_MailBox.PrtInfo.bShortBinding)   // u̒ӒԂ
        || (!(nPaperWidth > nPaperHeight)
            && g_MailBox.PrtInfo.bShortBinding) // cu̒ZӒԂ
        ){

        double fbtHole = ConvX2Dt(8, nDPIW, CX_CM);
        double f2rHoleW = ConvX2Dt(.55, nDPIW, CX_CM);
        double f2rHoleH = ConvX2Dt(.55, nDPIH, CX_CM);
        double fTopMg = ConvX2Dt(1, nDPIH, CX_CM) - nPaperMarginH;
        Arc(g_MailBox.hDC,
            (int)(nCenter - fbtHole / 2 - f2rHoleW / 2),
            (int)(fTopMg),
            (int)(nCenter - fbtHole / 2 + f2rHoleW / 2),
            (int)(fTopMg + f2rHoleH),
            (int)(nCenter - fbtHole / 2 + f2rHoleW / 2),
            (int)(fTopMg + f2rHoleH / 2),
            (int)(nCenter - fbtHole / 2 + f2rHoleW / 2),
            (int)(fTopMg + f2rHoleH / 2));
        Arc(g_MailBox.hDC,
            (int)(nCenter + fbtHole / 2 - f2rHoleW / 2),
            (int)(fTopMg),
            (int)(nCenter + fbtHole / 2 + f2rHoleW / 2),
            (int)(fTopMg  + f2rHoleH),
            (int)(nCenter + fbtHole / 2 + f2rHoleW / 2),
            (int)(fTopMg  + f2rHoleH / 2),
            (int)(nCenter + fbtHole / 2 + f2rHoleW / 2),
            (int)(fTopMg + f2rHoleH / 2));
    } else {
        double fbtHole = ConvX2Dt(8, nDPIH, CX_CM);
        double f2rHoleW = ConvX2Dt(.55, nDPIW, CX_CM);
        double f2rHoleH = ConvX2Dt(.55, nDPIH, CX_CM);
        double fLeftMg = ConvX2Dt(1, nDPIW, CX_CM) - nPaperMarginW;
        Arc(g_MailBox.hDC,
            (int)(fLeftMg),
            (int)(nCenter - fbtHole / 2 - f2rHoleH / 2),
            (int)(fLeftMg + f2rHoleW),
            (int)(nCenter - fbtHole / 2 + f2rHoleH / 2),
            (int)(fLeftMg + f2rHoleW),
            (int)(nCenter - fbtHole / 2),
            (int)(fLeftMg + f2rHoleW),
            (int)(nCenter - fbtHole / 2));
        Arc(g_MailBox.hDC,
            (int)(fLeftMg),
            (int)(nCenter + fbtHole / 2 - f2rHoleH / 2),
            (int)(fLeftMg + f2rHoleW),
            (int)(nCenter + fbtHole / 2 + f2rHoleH / 2),
            (int)(fLeftMg + f2rHoleW),
            (int)(nCenter + fbtHole / 2),
            (int)(fLeftMg + f2rHoleW),
            (int)(nCenter + fbtHole / 2));
    }

    SelectObject(g_MailBox.hDC, hOldBrush);
    SelectObject(g_MailBox.hDC, hOldPen);
    DeleteObject(hPen);
    DeleteObject(hBrush);

    // y[Wԍ̏o
    hFont = CreatePrtFont(ConvX2Dt(8, nDPIH, CX_PT), 400,
                          FALSE, FALSE, FALSE, &g_MailBox.PrtInfo.lfOPPF);
    hOldFont = SelectObject(g_MailBox.hDC, hFont);

    if (((nPaperWidth > nPaperHeight)
         && !g_MailBox.PrtInfo.bShortBinding)   // u̒ӒԂꍇ
        || (!(nPaperWidth > nPaperHeight)
            && g_MailBox.PrtInfo.bShortBinding) // cu̒ZӒԂ
        ){

        rc.left = nDPIW / 2 - nPaperMarginW;
    } else {                                      // cȕꍇ
        rc.left = nDPIW - nPaperMarginW;
    }
    rc.top = nPaperHeight - nDPIH / 2 - nPaperMarginH
        + ConvX2Dt(2, nDPIH, CX_PT);
    rc.right = nPaperWidth - nDPIW / 2 - nPaperMarginW;
    rc.bottom = rc.top + ConvX2Dt(10, nDPIH, CX_PT);

    t = 64;
    if (GetUserName(szBuf, &t)) {
        strcat(szBuf, " - ");
    } else {
        szBuf[0] = '\0';
    }

    t = time(NULL);
    sprintf(szBuf + strlen(szBuf), "Printout time: %s", ctime(&t));
    szBuf[strlen(szBuf) - 1] = '\0';
    strcat(szBuf, " - ");

    sprintf(szBuf + strlen(szBuf), "Page: %d",
            (nPageNo - 1) / g_MailBox.PrtInfo.nNumOfUp + 1);
    nPageNo++;

    DrawText(g_MailBox.hDC, szBuf, -1, &rc,
             DT_RIGHT | DT_VCENTER | DT_SINGLELINE);

    SelectObject(g_MailBox.hDC, hOldFont);
    DeleteObject(hFont);

    // Copyright\
    if (!g_MailBox.PrtInfo.bNoCopyright) {
        hFont = CreatePrtFont(ConvX2Dt(3, nDPIH, CX_PT), 400,
                              FALSE, FALSE, FALSE, &g_MailBox.PrtInfo.lfOPPF);
        hOldFont = SelectObject(g_MailBox.hDC, hFont);

        //  COPYRIGHT  Name aɕϊȂB{܂܂
        // tHggp\B
        DrawText(g_MailBox.hDC, COPYRIGHT, -1, &rc,
                 DT_LEFT | DT_VCENTER | DT_NOCLIP | DT_WORDBREAK);

        SelectObject(g_MailBox.hDC, hOldFont);
        DeleteObject(hFont);
    }

 Exit:
    // fobO[h̏ꍇ́AGAhׂ
    if (g_MailBox.PrtInfo.bDebug) {
        RECT rc;
        rc.left = nStartX;
        rc.right = nEndX;
        rc.top = nStartY;
        rc.bottom = nEndY;
        DrawRect(g_MailBox.hDC, &rc, RGB(0, 0, 255), PS_SOLID);
    }

    return TRUE;
}

/* -------------------------------------------------------------------
 * pr
 * *-----------------------------------------------------------------*/
BOOL EndPageDocument(void)
{
    HFONT hFont, hOldFont;
    RECT rc, rc2, rcBase;
    TCHAR szBuf[768];
    int nHt;

    // ^Cg̏o
    hFont = CreatePrtFont(ConvX2Dt(18, nDPIH, CX_PT), 700,
                          FALSE, FALSE, FALSE, &g_MailBox.PrtInfo.lfPPF);
    hOldFont = SelectObject(g_MailBox.hDC, hFont);
    if (((nPaperWidth > nPaperHeight)
          && !g_MailBox.PrtInfo.bShortBinding)  // u̒ӒԂꍇ
        || (!(nPaperWidth > nPaperHeight)
          && g_MailBox.PrtInfo.bShortBinding)   // cu̒ZӒԂ
        ) {

        rc.left = nDPIW / 2 - nPaperMarginW;
        rc.top = nDPIH - nPaperMarginH;
    } else {                                      // cȕꍇ
        rc.left = nDPIW - nPaperMarginW;
        rc.top = nDPIH / 2 - nPaperMarginH;
    }
    rc.bottom = rc.top + ConvX2Dt(20, nDPIH, CX_PT);
    rc.right = nPaperWidth - nDPIW / 2 - nPaperMarginW;

    memcpy(&rcBase, &rc, sizeof(RECT));

    rc.left += ConvX2Dt(10, nDPIW, CX_PT);
    rc.right -= ConvX2Dt(10, nDPIW, CX_PT);
    DrawText(g_MailBox.hDC, g_MailBox.PrtInfo.szTitle, -1, &rc,
             DT_NOPREFIX | DT_LEFT | DT_VCENTER | DT_SINGLELINE);

    SelectObject(g_MailBox.hDC, hOldFont);
    DeleteObject(hFont);

    // Ώۂ[̏ꍇ̂
    if (PT_MAIL == g_MailBox.PrtInfo.nType) {
        // FromƎM̕\
        sprintf(szBuf, "%s\r\n%s", g_MailBox.szFrom, g_MailBox.szDate);
        hFont = CreatePrtFont(ConvX2Dt(8, nDPIH, CX_PT), 800,
                              FALSE, FALSE, FALSE, &g_MailBox.PrtInfo.lfPPF);
        hOldFont = SelectObject(g_MailBox.hDC, hFont);

        memcpy(&rc2, &rc, sizeof(RECT));
        nHt = DrawText(g_MailBox.hDC, szBuf, -1, &rc2,
                       DT_NOPREFIX | DT_RIGHT | DT_WORDBREAK | DT_CALCRECT);
        rc.top += (ConvX2Dt(20, nDPIH, CX_PT) - nHt) / 2;
        rc.bottom = rc.top + nHt;
        DrawText(g_MailBox.hDC, szBuf, -1, &rc,
                 DT_NOPREFIX | DT_RIGHT | DT_WORDBREAK);

        // t@X̕\ƃbZ[WID̕\
        memcpy(&rc, &rcBase, sizeof(RECT));
        rc.top -= ConvX2Dt(18, nDPIH, CX_PT);
        rc.bottom = rc.top + ConvX2Dt(16, nDPIH, CX_PT);
        sprintf(szBuf, "%s\r\n%s",
                g_MailBox.szReference, g_MailBox.szMessageID);
        DrawText(g_MailBox.hDC, szBuf, -1, &rc,
                 DT_NOPREFIX | DT_RIGHT | DT_WORDBREAK);

        SelectObject(g_MailBox.hDC, hOldFont);
        DeleteObject(hFont);
    }

    // vr[̏ꍇŁAvr[ʂ\
    if (g_MailBox.PrtInfo.bPreView) {
        if (!bPreviewed) {
            PrintPreview(g_MailBox.hWnd, &g_MailBox.PrevInfo);
        }
        bPreviewed = TRUE;                      // vr[ς݂ɐݒ
        return FALSE;
    }
    if (0 >= EndPage(g_MailBox.hDC)) {
        int nErr = GetLastError();
        MessageBox(g_MailBox.hWnd, GetLastErrorMessage("EndPage()", nErr),
                   "EndPageDocument()", MB_ICONSTOP | MB_SETFOREGROUND);
        DbgPrint(NULL, 'E', "EndPageDocument(): %s",
                 GetLastErrorMessage("EndPage()", nErr));
        return FALSE;
    }
    return TRUE;
}

/* -------------------------------------------------------------------
 * hLg̈
 * *-----------------------------------------------------------------*/
BOOL
EndDocument(void)
{
    int nErr;

    EndPageDocument();
    if (g_MailBox.PrtInfo.bPreView) {
        return FALSE;
    }

    nErr = EndDoc(g_MailBox.hDC);
    if (nErr <= 0) {
        MessageBox(g_MailBox.hWnd, GetLastErrorMessage("EndDoc()", nErr),
                   TEXT("FinePrinter"), MB_ICONSTOP);
        DbgPrint(NULL, 'E', "FilePrinter(): %s",
                 GetLastErrorMessage("EndDoc()", nErr));
        return FALSE;
    }
    return TRUE;
}

/* -------------------------------------------------------------------
 * ꕶv^֏o͂B̊֐͊OĂяo邱Ƃ͖B
 * tHg͊ɑIĂKvB
 * *-----------------------------------------------------------------*/
static BOOL
PutcPrinter(
    LPTSTR szBuf,                               // o͕
    int cbString                                // o͕
    )
{
    SIZE Size;

    if ('\r' == *szBuf || '\n' == *szBuf) {
        nCurrentX = nStartX;
        if (bKeisen) {
            nCurrentY += nBasePoint;
        } else {
            nCurrentY += (bKanji ? nBaseLineK : nBaseLine);
        }
        bKanji = bKeisen = FALSE;
        return TRUE;
    }

    // 󎚂ʁA𒴂Ȃׂ
    GetTextExtentPoint32(g_MailBox.hDC, szBuf, cbString, &Size);
    if ((nCurrentX + Size.cx) > nEndX) {        // 𒴂Ă
        // VOC̏ꍇ́Aȍ~sς܂ŁAȂ
        // 悤ɂ
        if (g_MailBox.PrtInfo.nSingleLine) {
            // @Ȃ镝̕łAȍ~͈Ȃ悤ɕK
            // z悤ɂĂBႦ΁Av|[VitH
            // gōŏMoāǍAioꍇAM͈
            // łȂAi͈ł錻ۂ̂}~̂
            // ړIł
            nCurrentX = nEndX;
            return TRUE;
        }

        nCurrentX = nStartX + nLineNoOffset;
        if (bKeisen) {
            nCurrentY += nBasePoint;
        } else {
            nCurrentY += (bKanji ? nBaseLineK : nBaseLine);
        }
        bKanji = bKeisen = FALSE;

        // sʁAŌ̍s𒴂ꍇ́Ay[W
        if ((nCurrentY + Size.cy) > nEndY) {
            // Ō̒ȉꍇ͔r
            if (0 == ((nPageNo - 1) % g_MailBox.PrtInfo.nNumOfUp)) {
                if (!EndPageDocument()) {
                    return FALSE;
                }
            }
            if (!BeginPage()) {
                return FALSE;
            }
            nCurrentX = nStartX + nLineNoOffset;
            nCurrentY = nStartY;
            bKanji = bKeisen = FALSE;
        }
    }

    // s̒
    if (IsKanjiSJIS(*szBuf)) {
        TCHAR szTmp[4];
        memcpy(szTmp, szBuf, 2);
        szTmp[2] = '\0';
        if (strstr(szKeisen, szTmp)) {
            bKeisen = TRUE;
        }
        bKanji = TRUE;
    }
    switch (g_MailBox.PrtInfo.nBaseLine) {
    case IDC_R_JAPAN:
        bKanji = TRUE;
        break;
    case IDC_R_ENGLISH:
        bKanji = FALSE;
        break;
    case IDC_R_NOINTERLINE:
        bKeisen = TRUE;
        break;
    case IDC_R_AUTO:
    default:
        if (!g_MailBox.PrtInfo.bKeisen) {
            bKeisen = FALSE;
        }
        break;
    }

    // fobO[h̏ꍇ́Ả`ň͂
    if (g_MailBox.PrtInfo.bDebug) {
        RECT rc;
        rc.left = nCurrentX;
        rc.right = nCurrentX + Size.cx;
        rc.top = nCurrentY;
        rc.bottom = nCurrentY + Size.cy;
        DrawRect(g_MailBox.hDC, &rc, RGB(255, 0, 0), PS_SOLID);
    }
    TextOut(g_MailBox.hDC, nCurrentX, nCurrentY, szBuf, cbString);
    nCurrentX += Size.cx;

    return TRUE;
}

/* -------------------------------------------------------------------
 * v^֏o͂BtHg͊ɑIĂKvB
 * *-----------------------------------------------------------------*/
BOOL
PutsPrinter(LPTSTR szBuf)
{
    SIZE Size;
    TCHAR szTmp[4];
    int cbString = 1, i;

    // ԍŏ̈
    if (!nCurrentY) {
        if (!BeginPage()) {
            return FALSE;
        }
        nCurrentX = nStartX;
        nCurrentY = nStartY;
        bKanji = FALSE;
        bKeisen = FALSE;
    }

    // Ō̕CR or LF̏ꍇ͑ҔĂ
    szTmp[0] = '\0';
    if ('\n' == *(szBuf + strlen(szBuf) - 1) ||
        '\r' == *(szBuf + strlen(szBuf) - 1)) {
        szTmp[0] = '\n';
        *(szBuf + strlen(szBuf) - 1) = '\0';
    }

    // Z߂ďo͂ł邩ǂm߂
    GetTextExtentPoint32(g_MailBox.hDC, szBuf, strlen(szBuf), &Size);
    if ((nCurrentY + Size.cy) > nEndY) {        // ŏIC𒴂Ă
        // Ō̒ȉꍇ͔r
        if (0 == ((nPageNo - 1) % g_MailBox.PrtInfo.nNumOfUp)) {
            if (!EndPageDocument()) {
                return FALSE;
            }
        }
        if (!BeginPage()) {
            return FALSE;
        }
        nCurrentX = nStartX;
        nCurrentY = nStartY;
        bKanji = bKeisen = FALSE;
    }

    if ((nCurrentX + Size.cx) < nEndX) {
        // Z߂ďo͉\
        // fobO[h̏ꍇ́Ả`ň͂
        if (g_MailBox.PrtInfo.bDebug) {
            RECT rc;
            rc.left = nCurrentX;
            rc.right = nCurrentX + Size.cx;
            rc.top = nCurrentY;
            rc.bottom = nCurrentY + Size.cy;
            DrawRect(g_MailBox.hDC, &rc, RGB(0, 255, 0), PS_SOLID);
        }
        TextOut(g_MailBox.hDC, nCurrentX, nCurrentY, szBuf, strlen(szBuf));
        nCurrentX += Size.cx;

        // s̒
        for (i = 0; i < (int)strlen(szBuf); i++) {
            if (IsKanjiSJIS(*(LPBYTE)(szBuf + i))) {
                TCHAR szTmp[4];
                memcpy(szTmp, szBuf + i, 2);
                szTmp[2] = '\0';
                if (strstr(szKeisen, szTmp)) {
                    bKeisen = TRUE;
                }
                bKanji = TRUE;
                i++;
            }
        }
        switch (g_MailBox.PrtInfo.nBaseLine) {
        case IDC_R_JAPAN:
            bKanji = TRUE;
            break;
        case IDC_R_ENGLISH:
            bKanji = FALSE;
            break;
        case IDC_R_NOINTERLINE:
            bKeisen = TRUE;
            break;
        case IDC_R_AUTO:
        default:
            if (!g_MailBox.PrtInfo.bKeisen) {
                bKeisen = FALSE;
            }
            break;
        }

        if (szTmp[0]) {                         // s݂
            PutcPrinter(szTmp, 1);
        }
        return TRUE;
    }

    // ȉ͓Z߂ďo͂łȂ̂ł܂܂Əo͂鏈
    if (szTmp[0]) {
        strcat(szBuf, "\n");
    }

    for (; *szBuf; szBuf++) {
        szTmp[0] = *szBuf;
        cbString = 1;
        if (IsKanjiSJIS((BYTE)szTmp[0])) {
            szTmp[1] = *(szBuf + 1);
            szBuf++;
            cbString = 2;
        }
        if (!PutcPrinter(szTmp, cbString)) {
            return FALSE;
        }
    }
    return TRUE;
}

/* -------------------------------------------------------------------
 * lpszStrv^֏o͂BtHg͎w肳ꂽp[^ɍ쐬
 * B
 * *-----------------------------------------------------------------*/
BOOL
SetFontAndPrint(
    LPTSTR lpszStr,                             // o͕
    UINT lfHeight,                              // tHg̍
    UINT lfWeight,                              // tHg̃EGCg
    BOOL lfItalic,                              // T:C^bN
    BOOL lfUnderline,                           // T:
    BOOL lfStrikeout,                           // T:ł
    LPLOGFONT lplf                              // ev[g
    )
{
    HFONT hFont, hOldFont;
    BOOL bResult;

    hFont = CreatePrtFont(lfHeight, lfWeight, lfItalic,
                          lfUnderline, lfStrikeout, lplf);
    hOldFont = SelectObject(g_MailBox.hDC, hFont);

    bResult = PutsPrinter(lpszStr);

    SelectObject(g_MailBox.hDC, hOldFont);
    DeleteObject(hFont);

    return bResult;
}

/* -------------------------------------------------------------------
 * ``悷
 * *-----------------------------------------------------------------*/
void WINAPI
DrawRect(
    HDC hDC,                                    // foCXReLXg
    LPRECT lprc,                                // `W
    COLORREF rgb,                               // F
    int pnStyle                                 // ̃X^C
    )
{
    HPEN hPen, hPenOld;                         // y
	LOGPEN lgpen;                               // _y
    POINT pt[5];

    // y̍쐬
    lgpen.lopnStyle = pnStyle;                  // 
    lgpen.lopnWidth.x = 1;                      // 1
    lgpen.lopnColor = rgb;                      // F͍
    hPen = CreatePenIndirect(&lgpen);           // y̍쐬
    hPenOld = SelectObject(hDC, hPen);          // ݂̃yɐݒ

    pt[0].x = lprc->left, pt[0].y = lprc->top;
    pt[1].x = lprc->right - 1, pt[1].y = lprc->top;
    pt[2].x = lprc->right - 1, pt[2].y = lprc->bottom - 1;
    pt[3].x = lprc->left, pt[3].y = lprc->bottom - 1;
    pt[4].x = lprc->left, pt[4].y = lprc->top;

    Polyline(hDC, pt, 5);

    SelectObject(hDC, hPenOld);                 // yɖ߂
    DeleteObject(hPen);                         // y̍폜
}

/* -------------------------------------------------------------------
 * X-FACE`悷
 * *-----------------------------------------------------------------*/
VOID WINAPI
DrawXFace(LPXBM_INFO lpXbmInfo)
{
    //X-Face`悷BTCÝAOsɃTCYB
    DrawXBM(lpXbmInfo, g_MailBox.hDC, nCurrentX,
            nCurrentY - nBaseLine,
            nBaseLine * 3, nBaseLine * 3,
            RGB(0, 0, 0), RGB(255, 255, 255), SRCCOPY);
    nCurrentX += nBaseLine * 3;
}

/* -------------------------------------------------------------------
 * FACE`悷
 * *-----------------------------------------------------------------*/
VOID WINAPI
DrawFace(LPCTSTR lpszFileName)
{
    HDC hDCMem;
    HBITMAP hBM, hBMOld;
    BITMAP bm;

    hDCMem = CreateCompatibleDC(g_MailBox.hDC);
    if (!(hBM = LoadBitMapFile(g_MailBox.hDC, lpszFileName))) {
        DeleteDC(hDCMem);
        DbgPrint(NULL, 'E', "FACE: rbg}bvt@C̃[hs %s",
                 lpszFileName);
        return;
    }
    GetObject(hBM, sizeof(BITMAP), &bm);
    DbgPrint(NULL, 'I', "Face Size: %d~%d %x",
             bm.bmWidth, bm.bmHeight, bm.bmBits);

    hBMOld = SelectObject(hDCMem, hBM);    // Vrbg}bvݒ

    // rbg}bv]
    StretchBlt(g_MailBox.hDC, nCurrentX, nCurrentY - nBaseLine,
               nBaseLine * 3, nBaseLine * 3,
               hDCMem, 0, 0, bm.bmWidth, bm.bmHeight, SRCCOPY);

    SelectObject(hDCMem, hBMOld);              // Kv̂Ōɖ߂

    DeleteObject(hBM);                          // 폜
    DeleteDC(hDCMem);                           // 폜

    nCurrentX += nBaseLine * 3;
}
