/* -*- mode: c++; coding: sjis-dos; -*-
 * Time-stamp: <2004-06-18 09:32:45 tfuruka1>
 * $Id: dbg.c,v 1.3 2004/06/18 00:57:57 tfuruka1 Exp $
 * $Log: dbg.c,v $
 * Revision 1.3  2004/06/18 00:57:57  tfuruka1
 * sR[h̏Ĉ݂łB
 *
 * Revision 1.2  2001/08/19 04:55:59  tfuruka1
 * Ot@C̊i[pXtpXŎ悤ɂB
 *
 * Revision 1.1  2001/02/05 17:47:18  tfuruka1
 * Initial revision
 *
 * *-------------------------------------------------------------------
 * ̃t@Cł͎ɃfobOxɊւ֐`ĂB
 * *-------------------------------------------------------------------*/

// (replace-regexp "/\\*\\(.+\\)\\*/" "//\\1")
// (replace-regexp "[ \t]+$" "")

#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <sys/stat.h>
#include <math.h>

LPCSTR WINAPI GetLastErrorMessage(LPCSTR lpsz, DWORD dwErr);
LPCTSTR WINAPI GetMyDir(VOID);
// -----------------------------------------------------------------------
static BOOL bDumpIsNoDisplay = TRUE;            // _v̓t@C
// -----------------------------------------------------------------------

#define MAX_LOGFILE  (512 * 1024)               // ő働Ot@CTCY
#define MAX_LINE     1000                       // ő\s
#define MEM_SIZE     (8192 * 2)                 // i[obt@
#define IDC_LIST     200                        // LISTBOXID
#define FONT_H       13                         // tHg̍

#define COLOR_GRAY   RGB(128, 128, 128)         // OC
#define COLOR_LTGRAY RGB(192, 192, 192)         // CgOC
#define COLOR_WHITE  RGB(255, 255, 255)         // 
#define COLOR_BLACK  RGB(0, 0, 0)               // 

static WNDPROC lpWndProcOwn;                    // eEChẼvVW
static HWND hWndList = NULL;                    // List̃nh
static HFONT hFontN, hFontB, hFontI;            // tHg
static CHAR szLogName[MAX_PATH] = "\0";         // Ot@C
static CHAR szLogNameSave[MAX_PATH];            // Ot@C()

enum {IDM_CLEAR = 1100, IDM_TITLE, IDM_ZOOM, IDM_MINIMIZE,
      IDM_MOVE, IDM_SIZE, IDM_VIEWLOG, IDM_DELETELOG, IDM_NODUMP,
      DM_NUM_OF_MENU};

/*--------------------------------------------------------------------
 * eEChẼTuNXWM_DRAWITEM̏sB
 * *-------------------------------------------------------------------*/
static BOOL
DoDrawItem(LPDRAWITEMSTRUCT lpdis)
{
    LPTSTR lpszStr;                             // 擾p
    size_t nSize;                               // TCY擾p
    COLORREF crColor;                           // F
    HPEN hPen, hOldPen;                         // y
    LOGPEN lgpn;                                // _y
    POINT Point[2];                             // |Cg
    HFONT hFont, hOldFont;                      // tHg

    if (-1 == lpdis->itemID)                    // ڂȂ̂
        return TRUE;                            // Ȃ

    switch (lpdis->itemAction) {                // ACeANV
    case ODA_DRAWENTIRE:                        // Ŝ̏
        // 񒷂𓾂
        nSize = SendMessage(lpdis->hwndItem, LB_GETTEXTLEN, lpdis->itemID, 0);
        // Kvȃmۂ
        if (NULL == (lpszStr = malloc(nSize + 1))) {
            MessageBox(lpdis->hwndItem, "mۂɎs܂",
                       "Com - Dbgprt - DrawItem", MB_ICONSTOP);
            break;
        }
        // \镶𓾂
        SendMessage(lpdis->hwndItem, LB_GETTEXT, lpdis->itemID,
                    (LPARAM)lpszStr);
        // ̐Fݒ肷
        switch (*lpszStr) {
        case 'F':                               // WM_COPYDATÃtH[h
            hFont = hFontB, crColor = RGB(0, 0, 128); break;
        case 'C':                               // WM_COPYDATAM
            hFont = hFontB, crColor = RGB(0, 128, 64); break;
        case 'R':                               // Receive֌W
            hFont = hFontN, crColor = RGB(0, 128, 0); break;
        case 'r':                               // Receive֌W()
            hFont = hFontI, crColor = RGB(0, 128, 0); break;
        case 'S':                               // Send֌W
            hFont = hFontN, crColor = RGB(0, 0, 255); break;
        case 's':                               // Send֌W()
            hFont = hFontI, crColor = RGB(0, 0, 255); break;
        case 'W':                               // EH[jO
            hFont = hFontB, crColor = RGB(255, 0, 255); break;
        case 'E':                               // G[
            hFont = hFontB, crColor = RGB(255, 0, 0); break;
        case 'B':                               // 
            hFont = hFontB, crColor = RGB(0, 0, 0); break;
        case 'I': default:                      // ʏ햔̓ftHg
            hFont = hFontN; crColor = RGB(0, 0, 0); break;
        }
        SetTextColor(lpdis->hDC, crColor);
        SetBkMode(lpdis->hDC, TRANSPARENT);
        // `悷
        hOldFont = SelectObject(lpdis->hDC, hFont);
        DrawText(lpdis->hDC, lpszStr + 1, -1, &lpdis->rcItem,
                 DT_VCENTER	| DT_SINGLELINE | DT_EXPANDTABS | DT_NOPREFIX);
        SelectObject(lpdis->hDC, hOldFont);

        free(lpszStr);                          // ̊J

        /* break YĂ킯ł͂܂BIԂ𕜌
           , ȉ̏sĂ܂*/
    case ODA_SELECT:                            // I

        // gp̐ݒ
        lgpn.lopnStyle = PS_SOLID;              // 
        lgpn.lopnWidth.x = 1;                   // 

        // A_[C̍Wݒ肷
        Point[0].x = lpdis->rcItem.left;
        Point[1].x = lpdis->rcItem.right;
        Point[0].y = lpdis->rcItem.bottom - 1;
        Point[1].y = lpdis->rcItem.bottom - 1;
        if (ODS_SELECTED & lpdis->itemState) {  // IԂ̏ꍇ
            lgpn.lopnColor = COLOR_WHITE;       // 
        }
        else {                                  // IԂ̏ꍇ
            lgpn.lopnColor = COLOR_LTGRAY;      // wiF
        }
        hPen = CreatePenIndirect(&lgpn);        // y̍쐬
        hOldPen = SelectObject(lpdis->hDC, hPen); // y̑I

        Polyline(lpdis->hDC, &Point[0], 2);     // A_[C`

        SelectObject(lpdis->hDC, hOldPen);      // yɖ߂
        DeleteObject(hPen);                     // y폜

        // I[o[C̍Wݒ肷
        Point[0].x = lpdis->rcItem.left;
        Point[1].x = lpdis->rcItem.right;
        Point[0].y = lpdis->rcItem.top;
        Point[1].y = lpdis->rcItem.top;
        if (ODS_SELECTED & lpdis->itemState) {  // IԂ̏ꍇ
            lgpn.lopnColor = COLOR_GRAY;        // 
        }
        else {                                  // IԂ̏ꍇ
            lgpn.lopnColor = COLOR_LTGRAY;      // wiF
        }
        hPen = CreatePenIndirect(&lgpn);        // y̍쐬
        hOldPen = SelectObject(lpdis->hDC, hPen); // y̑I

        Polyline(lpdis->hDC, &Point[0], 2);     // I[o[C`

        SelectObject(lpdis->hDC, hOldPen);      // yɖ߂
        DeleteObject(hPen);                     // y폜
        return FALSE;
    }
    return TRUE;
}
/*--------------------------------------------------------------------
 * eEChẼTuNX
 * *-------------------------------------------------------------------*/
static  LRESULT CALLBACK
SubWindProcOwn(
    HWND hWnd,                                  // EBhEnh
    UINT uMsg,                                  // bZ[W
    WPARAM wParam,                              // p[^
    LPARAM lParam                               // p[^
    )
{
    long l;
    HMENU hMenu = GetSubMenu(GetMenu(hWnd), 0);

    switch (uMsg) {
    case WM_COMMAND:
        switch((int)(LOWORD(wParam))) {
        case IDM_DELETELOG:                     // O폜
            if (IDYES == MessageBox(hWnd, "Ot@C폜Ă"
                                    "Xł", "{?",
                                    MB_YESNO | MB_ICONQUESTION)) {
                unlink(szLogNameSave);
                unlink(szLogName);
            }
            return 0;
        case IDM_NODUMP:                        // ʂɃ_v\Ȃ
            bDumpIsNoDisplay = !bDumpIsNoDisplay;
            CheckMenuItem(hMenu, IDM_NODUMP,
                          bDumpIsNoDisplay ? MF_CHECKED : MF_UNCHECKED);
            return 0;
        case IDM_VIEWLOG:                       // O
            ShellExecute(hWnd, NULL, szLogName, NULL, NULL, SW_SHOW);
            return 0;
        case IDM_SIZE:                          // TCYύX
            SendMessage(hWnd, WM_SYSCOMMAND, SC_SIZE, 0);
            return 0;
        case IDM_MOVE:                          // ړ
            SendMessage(hWnd, WM_SYSCOMMAND, SC_MOVE, 0);
            return 0;
        case IDM_ZOOM:                          // ő剻
            SendMessage(hWnd, WM_SYSCOMMAND, SC_ZOOM, 0);
            return 0;
        case IDM_MINIMIZE:                      // ŏ
            SendMessage(hWnd, WM_SYSCOMMAND, SC_MINIMIZE, 0);
            return 0;
        case IDM_TITLE:                         // ^Cgo[̕\/
            if ((l = GetWindowLong(hWnd, GWL_STYLE)) & WS_CAPTION) {
                SetWindowLong(hWnd, GWL_STYLE, l & (~WS_CAPTION));
            }
            else {
                SetWindowLong(hWnd, GWL_STYLE, l | WS_CAPTION);
            }
            SetWindowPos(hWnd, NULL, 0, 0, 0, 0, SWP_NOMOVE |
                         SWP_NOSIZE | SWP_NOZORDER | SWP_DRAWFRAME);
            return 0;
        case IDM_CLEAR:                         // ʂ̃NA
            if (hWndList) {
                SendMessage(hWndList, LB_RESETCONTENT, 0, 0);
            }
            return 0;
        default:
            break;
        }
    case WM_CTLCOLORLISTBOX:                    // Xg{bNX̔wiF
        if ((HWND)lParam != hWndList) {         // ł͂Ȃ
            break;
        }
        return (LRESULT)GetStockObject(LTGRAY_BRUSH);
    case WM_DRAWITEM:                           // I[i[`
        if (IDC_LIST != (UINT)wParam) {         // LIST BOX ȊO
            break;                              // Ȃ
        }
        DoDrawItem((LPDRAWITEMSTRUCT)lParam);
        return TRUE;                            // [] See help
    case WM_MEASUREITEM:                        // I[i[`s
        if (IDC_LIST != (UINT)wParam) {         // LIST BOX ȊO
            break;                              // Ȃ
        }
        ((LPMEASUREITEMSTRUCT)lParam)->itemHeight = FONT_H + 2;
        return TRUE;                            // [] See help
    case WM_SIZE:                               // TCY
        if (hWndList) {
            SetWindowPos(hWndList, 0, 0, 0,
                         LOWORD(lParam), HIWORD(lParam), SWP_NOZORDER);
        }
        return 0;
    }
    // ẽEChEvVWR[
    return CallWindowProc(lpWndProcOwn, hWnd, uMsg, wParam, lParam);
}

/*--------------------------------------------------------------------
 * LISTBOX쐬
 * *-------------------------------------------------------------------*/
static HWND
CreateListBox(HWND hWnd)
{
    HWND hWndList;                              // EBhEnh
    RECT rc;
    LOGFONT lf = {-FONT_H, 0, 0, 0, 400, 0, 0, 0, SHIFTJIS_CHARSET,
                  3, 2, 1, 49, TEXT("lr SVbN")};
    double dummy;
    char *cdummy;

    dummy = strtod("10.1", &cdummy);

    // eEChẼEChEvVWtbN
    lpWndProcOwn = (WNDPROC)GetWindowLong(hWnd, GWL_WNDPROC);
    if (!lpWndProcOwn) {
        int nErr = GetLastError();
        MessageBox(hWnd,
                   GetLastErrorMessage("GetWindowLong(GWL_WNDPROC)", nErr),
                   "EChEvVW̃tbNɎs", MB_ICONSTOP);
    }
    SetWindowLong(hWnd, GWL_WNDPROC, (long)SubWindProcOwn);

    GetClientRect(hWnd, &rc);                   // NCAgTCY𓾂

    hWndList = CreateWindowEx(
        0, "LISTBOX", "(^_^)",
        WS_CHILD | WS_VISIBLE | LBS_DISABLENOSCROLL | LBS_HASSTRINGS |
        LBS_USETABSTOPS	| LBS_NOTIFY | LBS_NOINTEGRALHEIGHT | WS_VSCROLL |
        WS_HSCROLL | LBS_OWNERDRAWFIXED,
        0, 0, rc.right, rc.bottom,
        hWnd, (HMENU)IDC_LIST, GetWindowInstance(hWnd), NULL);

    if (!hWndList) {
        int nErr = GetLastError();
        MessageBox(hWnd, GetLastErrorMessage("CreateWindow", nErr),
                   "DbgPrint()->CreateListBox()", MB_ICONSTOP);
        return NULL;
    }

    /* ftHg̃tHgƃ_vɂȂׁCtHg
       ݒ肷*/
    hFontN = CreateFontIndirect(&lf);           // tHg쐬()
    lf.lfItalic = TRUE;
    hFontI = CreateFontIndirect(&lf);           // tHg쐬(It)
    lf.lfItalic = FALSE, lf.lfWeight = 700;
    hFontB = CreateFontIndirect(&lf);           // tHg쐬(Bf)
    SendMessage(hWndList, WM_SETFONT, (WPARAM)hFontN, MAKELPARAM(TRUE, 0));

    return hWndList;
}

/*--------------------------------------------------------------------
 * Ot@C̃TCỸ`FbNsCt@CTCY𒴂Ă
 * ́COt@Cl[B
 * *-------------------------------------------------------------------*/
static VOID
CheckLogFile(
    LPCSTR CurrentLog,                          // ݂̃Ot@C
    LPCSTR SaveLog                              // ۑt@C
    )
{
    struct _stat buffer;

    if (-1 == _stat(CurrentLog, &buffer)) {     // Ot@C̏
        return;                                 // ߂
    }

    if (MAX_LOGFILE < buffer.st_size) {
        unlink(SaveLog);
        rename(CurrentLog, SaveLog);
    }
}

/*--------------------------------------------------------------------
 * lpstrŎw肳ꂽɏ]ĕҏW\EBhE֕\
 * BprintfƓlłB\EBhE݂Ȃꍇ́C
 * hWnd֕\EBhECreateɕ\BnFlag̓bZ[W
 * ʂׂ̃CWP[^Ƃĕ\BnFlag 'N' 0x20`
 * 0x7ẻꂩ̃R[hwoB߂l͏ɕ\EChẼn
 * hłBACɏ]č쐬ꂽ16384
 * łȂ΂ȂȂBnFlag 'I', 'C', 'F', 'R', 'W', 'E', 'S', '
 * s', 'r' F܂BȊO'I'Ƃď܂B
 *
 * : \EChẼRg[ID200gp܂B]ăI[i
 * EChEłID=200̃Rg[͎gpł܂(ʏID100
 * gp܂̂ŁCԂ\͏Ȃł)BID=200
 * WM_CTLCOLORLISTBOX, WM_DRAWITEM, WM_MEASUREITEMy, WM_SIZEtb
 * N܂̂ŁC̃Cxg̓I[i[EChE֒ʒm܂B
 * *-------------------------------------------------------------------*/
HWND WINAPI
DbgPrint(
    HWND hWnd,                                  // EChEnh
    int nFlag,                                  // tO
    LPCSTR lpstr,                               // printfƓ
    ...                                         // 
    )
{
    static DWORD OldTickCount = 0;              // Oo͂ TickCount
    FILE *fp = NULL;                            // Ot@C|C^
    va_list args;                               // WJp
    char *szLine, *p1, *p2;                     // 񑀍p
    SYSTEMTIME t;                               // 
    DWORD NewTickCount, TickInterval;           // Oo͂̎
    SIZE Size;                                  // TCY擾p
    HDC hDC;                                    // foCXReLXg
    int i, j, nMaxStrWd;                        // ėp
    BOOL bNoDisplay = FALSE;                    // ʏo͖
    TCHAR szBuf[1024];                          // ėp

    if (!szLogName[0]) {
        // Ot@C擾
        if (!GetWindowText(hWnd, szBuf, MAX_PATH - 5)) {
            int nErr = GetLastError();
            TCHAR szHwnd[256];
            sprintf(szHwnd, "[hWnd=%d]EChEeLXg̎擾"
                    "s܂", hWnd);
            MessageBox(hWnd, GetLastErrorMessage("GetWindowText()", nErr),
                       szHwnd, MB_ICONSTOP);
            strcpy(szBuf, "hogehoge");
        }

        sprintf(szLogName, "%s/%d%s.log", GetMyDir(), 1, szBuf);
        sprintf(szLogNameSave, "%s/%d%s.log", GetMyDir(), 0, szBuf);

    }
    if (!hWndList) {
        HMENU hMenu = GetMenu(hWnd), hSubMenu;
        if (NULL == hMenu) {
            hMenu = CreateMenu();
            SetMenu(hWnd, hMenu);
        }
        hSubMenu = CreateMenu();

        AppendMenu(hSubMenu, 0, IDM_NODUMP, "_vʂɕ\Ȃ");
        AppendMenu(hSubMenu, 0, IDM_TITLE, "^Cgo[");
        AppendMenu(hSubMenu, 0, IDM_CLEAR, "ʏ");
        AppendMenu(hSubMenu, MF_SEPARATOR, IDM_CLEAR, NULL);
        AppendMenu(hSubMenu, 0, IDM_VIEWLOG, "O");
        AppendMenu(hSubMenu, 0, IDM_DELETELOG, "O폜");
        AppendMenu(hSubMenu, MF_SEPARATOR, IDM_CLEAR, NULL);
        AppendMenu(hSubMenu, 0, IDM_ZOOM, "ő剻");
        AppendMenu(hSubMenu, 0, IDM_MINIMIZE, "ŏ");
        AppendMenu(hSubMenu, 0, IDM_MOVE, "ړ");
        AppendMenu(hSubMenu, 0, IDM_SIZE, "TCYύX");

        CheckMenuItem(hSubMenu, IDM_NODUMP,
                      bDumpIsNoDisplay ? MF_CHECKED : MF_UNCHECKED);

        AppendMenu(hMenu,  MF_POPUP | MF_BYPOSITION, (UINT)hSubMenu,
                   "&Special");

        DrawMenuBar(hWnd);
        if(!(hWndList = CreateListBox(hWnd))){  // Xg{bNX̍쐬
            return NULL;                        // s͒߂
        }
    }

    if (!bNoDisplay) {
        // LISTBOX̍ős𒴂Ăꍇ͔폜
        if (MAX_LINE < SendMessage(hWndList, LB_GETCOUNT, 0, 0)) {
            ShowWindow(hWndList, SW_HIDE);
            for (i = 0; i < (MAX_LINE / 2); i++) {
                SendMessage(hWndList, LB_DELETESTRING, 0, 0);
            }
            ShowWindow(hWndList, SW_SHOW);
        }
    }

    if (NULL == (szLine = malloc(MEM_SIZE))) {  // ̊m
        MessageBox(hWnd, "mۂɎs܂",
                   "DbgPrint()", MB_SETFOREGROUND);
        return NULL;
    }

    // \bZ[WҏW
    if ((nFlag & 0xff) == 'N') {                // wb_̏ꍇ
        nFlag >>= 8;
        *szLine = (BYTE)nFlag;
        strcpy(szLine + 1, "\t");
        if (bDumpIsNoDisplay) {
            bNoDisplay = TRUE;                  // fBXvCo͖
        }
    }
    else {                                      // wb_L̏ꍇ
        ULONG hh, mm, ss, ms;                   // OƂ̎
        NewTickCount = GetTickCount();          // NĂ̎
        if (!OldTickCount) {                    // ߂ẴOo
            TickInterval = 0;                   // OƂ̎Ԃ0
        }
        else {
            TickInterval = NewTickCount - OldTickCount;
        }
        OldTickCount = NewTickCount;            // OƂ̎Ԃ𓾂
        hh = TickInterval / (3600 * 1000);
        mm = (TickInterval %= (3600 * 1000)) / (60 * 1000);
        ss = (TickInterval %= (60 * 1000)) / 1000;
        ms = TickInterval % 1000;
        GetLocalTime(&t);                       // ݓ̓ǂݍ
        sprintf(szLine, "%c[%d]%02d/%02d/%02d %02d:%02d:%02d.%03d"
                "(+%02d:%02d:%02d.%03d)[%c]: ",
                nFlag, GetCurrentThreadId(),
                t.wYear % 100, t.wMonth, t.wDay,
                t.wHour, t.wMinute, t.wSecond, t.wMilliseconds,
                hh, mm, ss, ms, nFlag);
    }

    // ɍĐ`
    va_start(args, lpstr);
    vsprintf(szLine + strlen(szLine), lpstr, args);
    va_end(args);

    CheckLogFile(szLogName, szLogNameSave);     // Ot@C̃TCY
    if (NULL == (fp = fopen(szLogName, "at"))) {
        MessageBox(hWnd, "Ot@C̃I[vɎs܂",
                   "DbgPrint()", MB_ICONSTOP);
    }
    // LISTBOX֕\
    p1 = szLine;
    while (p1) {
        p2 = strchr(p1, '\n');
        if (p2) {
            *p2 = '\0';
        }

        if (!bNoDisplay) {
            if (0 > SendMessage(hWndList, LB_ADDSTRING, 0, (LPARAM)p1)) {
                /*
                MessageBox(hWnd, "ListBoxւ̏o͂ŃG[܂",
                           "DbgPrint()", MB_SETFOREGROUND);
                           */
                break;
            }
        }
        if (fp) {                               // t@C|C^
            fprintf(fp, "%s\n", p1 + 1);        // Oo
        }
        if (p2) {
            *p2-- = '\t';
            *p2 = (BYTE)nFlag;
        }
        p1 = p2;
    }

    if (fp) {                                   // t@C|C^
        fclose(fp);                             // t@CN[Y
    }

    if (!bNoDisplay) {
        // ɍŏIs悤ɂ
        SendMessage(hWndList, LB_SETTOPINDEX,
                    SendMessage(hWndList, LB_GETCOUNT, 0, 0) - 1, 0);


        // łs̃hbg𓾂
        nMaxStrWd = 0;
        hDC = GetDC(hWndList);                  // ListBoxDC
        j = SendMessage(hWndList, LB_GETCOUNT, 0, 0);
        for (i = 0; i < j; i++) {
            SendMessage(hWndList, LB_GETTEXT, i, (LPARAM)szLine);
            GetTextExtentPoint32(hDC, szLine, strlen(szLine), &Size);
            if (nMaxStrWd < Size.cx) {
                nMaxStrWd = Size.cx;
            }
        }
        ReleaseDC(hWndList, hDC);               // DC̊J
        // Xg{bNX̕𒲐
        SendMessage(hWndList, LB_SETHORIZONTALEXTENT,
                    (WPARAM)nMaxStrWd + 16, 0);
    }

    free(szLine);                               // J
    return hWndList;
}

/*--------------------------------------------------------------------
 * lpStartuLenoCg16i_v\B\EBhE݂
 * Ȃꍇ́ChWnd֕\EBhECreateɕ\BlpszHead
 * ̓_v̑Oɕ\镶w肷BnFlag̈ӖDbgPrint
 * QƂ̎B
 * *-------------------------------------------------------------------*/
HWND WINAPI
DbgDump(
    HWND hWnd,                                  // nh
    int nFlag,                                  // tO
    LPCSTR lpszHead,                            // ^Cg
    LPBYTE lpStart,                             // JnAhX
    ULONG uLen                                  // _v
    )
{
    TCHAR szBuf[128], szBufc[20];               // Ɨp
    HWND hWndRet;                               // ߂l
    ULONG i;                                    // ėp
    UCHAR uc;                                   // ėp
    int nSameLine = 0;                          // O16oCgƓf[^

    // ^Cg\
    hWndRet = DbgPrint(hWnd, nFlag, "%s (Length=%d)", lpszHead, uLen);

    for (i = 0; i < ((uLen + 15) & ~15); i++) {
        if (0 == (i % 16)) {
            if (i) {
                // ̓eO16oCgƓꍇ͏o͂Ȃ
                if (i > 16 && 0 == memcmp(lpStart + i - 16,
                                          lpStart + i - 32, 16)) {
                    nSameLine++;
                }
                else {
                    if (nSameLine) {            // o͂ĂȂsL
                        DbgPrint(hWnd, 'N' + nFlag * 256,
                                     "\t\t==== SAME %d BYTE ====",
                                     nSameLine * 16);
                        nSameLine = 0;
                    }
                    DbgPrint(hWnd, 'N' + nFlag * 256, "%s",
                                 strcat(strcat(szBuf, szBufc), " |"));
                }
            }
            sprintf(szBuf, "%08x |", i & ~15);
            strcpy(szBufc, " | ");
        }
        if (i < uLen) {
            uc = *(lpStart + i);
            sprintf(szBuf + strlen(szBuf), " %02x", uc);
            if (0x20 > uc || 0x7e < uc) {
                uc = '.';
            }
            sprintf(szBufc + strlen(szBufc), "%c", uc);
        }
        else {
            strcat(szBuf, "   ");
            strcat(szBufc, " ");
        }
    }
    if (nSameLine) {                            // o͂ĂȂsL
        DbgPrint(hWnd, 'N' + nFlag * 256,
                     "\t\t==== SAME %d BYTE ====", nSameLine * 16);
    }
    DbgPrint(hWnd, 'N' + nFlag * 256,
                 "%s", strcat(strcat(szBuf, szBufc), " |"));

    return hWndRet;
}
