/* -*- mode: c++ -*-
 * $Id: nametag.c,v 1.2 2005/05/07 12:26:15 tfuruka1 Exp $
 * $Name:  $
 *
 * CVSNameL[[h̒u
 *
 * $Log: nametag.c,v $
 * Revision 1.2  2005/05/07 12:26:15  tfuruka1
 * tH[}bgύX܂B
 *
 * Revision 1.1  2005/05/07 12:19:50  tfuruka1
 * CVSNameL[[haɕϊ鏈Ă݂B
 *
 */
#include <windows.h>
#include <stdio.h>
#include <mbstring.h>

#define MAX_SIZE 1024

static struct {
    LPCTSTR lpszName;
    LPCTSTR lpszJapaneseName;
} repTable[] = {
    {"KOMA", "D:"},
    {"HIGASHI-OBUKE", "X:ЂԂ"},
    {"OBUKE", "X:Ԃ"},
    {"TAIRADATE", ":炾"},
    {"KITAMORI", "kX:"},
    {"MATSUO-HACHIMANTAI", ":܂͂܂񂽂"},
    {"APPI-KOGEN", "䍂:҂"},
    {"AKASAKATA", "ԍc:"},
    {"KOYANOHATA", "̔:̂͂"},
    {"ARAYASHIMMACHI", "rV:₵܂"},
    {"YOKOMA", ":悱"},
    {"TAYAMA", "cR:"},
    {"ANIHATA", "Z:ɂ͂"},
    {"YUZE-ONSEN", ":䂺񂹂"},
    {"HACHIMANTAI", ":͂܂񂽂"},
    {"RIKUCHU-OSATO", "嗢:肭イ"},
    {"KAZUNO-HANAWA", "pԗ:Â̂͂Ȃ"},
    {"SHIBAHARA", "ĕ:΂Ђ"},
    {"TOWADA-MINAMI", "\ac:Ƃ킾݂Ȃ"},
    {"SUEHIRO", "L:Ђ"},
    {"DOBUKAI", "y[:ǂԂ"},
    {"SAWAJIRI", "K:킶"},
    {"JUNISHO", "\:イɂ"},
    {"OTAKI-ONSEN", "ꉷ:񂹂"},
    {"OGITA", "c:"},
    {"HIGASHI-ODATE", ":Ђ"},
    {"ODATE", ":"},
    {NULL, NULL}
};

static LPCTSTR
NewFormat(
    LPCTSTR lpszStr,                            // ̕
    LPCTSTR lpszReplaceStart,                   // uJnʒu
    LPCTSTR lpszEndStart,                       // c̊Jnʒu
    LPCTSTR lpszReplaceStr                      // u
    )
{
    static TCHAR szReturn[MAX_SIZE];
    size_t len = lpszReplaceStart - lpszStr;

    strncpy(szReturn, lpszStr, MAX_SIZE);
    _snprintf(szReturn + len, MAX_SIZE - len,
              "%s%s", lpszReplaceStr, lpszEndStart);
    return szReturn;
}

/*
 * CVSNameL[[h܂񂾕aɕϊĕԋp܂B̕
 * ɂ͕ύX܂B
 */
LPCTSTR WINAPI
ReplaceNameTag(LPCTSTR lpszNameTag)
{
    int i;
    TCHAR szFrom[256];
    LPTSTR p;

    for (i = 0; repTable[i].lpszName; i++) {
        _snprintf(szFrom, 255, "$" "Name: %s" " $", repTable[i].lpszName);
        if (p = _mbsstr(lpszNameTag, szFrom)) {
            return NewFormat(lpszNameTag, p, p + strlen(szFrom),
                             repTable[i].lpszJapaneseName);
        }
        if (p = _mbsstr(lpszNameTag, repTable[i].lpszName)) {
            return NewFormat(lpszNameTag, p, p + strlen(repTable[i].lpszName),
                             repTable[i].lpszJapaneseName);
        }
    }
    return lpszNameTag;
}

#if 0            
int main(int argc, char *argv[])
{
    printf("%s\n", ReplaceNameTag(argv[1]));
}
#endif
