<?php
/*
  $Id: checkout_shipping.php,v 1.8 2009/04/14 23:51:23 ryu Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  
  modified for Koshoten.net2
  http://www.koshoten.net/
*/

  require('includes/application_top.php');
  require('includes/classes/http_client.php');
  
  if (defined("KN_CFG_ALLOW_CHECKOUT") && (KN_CFG_ALLOW_CHECKOUT == "false")) {
    tep_redirect(tep_href_link(FILENAME_DEFAULT));
  }

// ʰǤѤ
  if (KN_CFG_SHORT_CHECKOUT == 'true') {
    tep_redirect(tep_href_link(FILENAME_CHECKOUT_CONFIRMATION_SHORT, '', 'SSL'));
  }

// if the customer is not logged on, redirect them to the login page
  if (!tep_session_is_registered('customer_id')) {
    $navigation->set_snapshot();
    tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
  }

// if there is nothing in the customers cart, redirect them to the shopping cart page
  if ($cart->count_contents() < 1) {
    tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));
  }

// if no shipping destination address was selected, use the customers own address as default
  if (!tep_session_is_registered('sendto')) {
    tep_session_register('sendto');
    $sendto = $customer_default_address_id;
  } else {
// verify the selected shipping address
    $check_address_query = tep_db_query("select count(*) as total from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$customer_id . "' and address_book_id = '" . (int)$sendto . "'");
    $check_address = tep_db_fetch_array($check_address_query);

    if ($check_address['total'] != '1') {
      $sendto = $customer_default_address_id;
      if (tep_session_is_registered('shipping')) tep_session_unregister('shipping');
    }
  }

  require(DIR_WS_CLASSES . 'order.php');
  $order = new order;

// register a random ID in the session to check throughout the checkout procedure
// against alterations in the shopping cart contents
  if (!tep_session_is_registered('cartID')) tep_session_register('cartID');
  $cartID = $cart->cartID;

// if the order contains only virtual products, forward the customer to the billing page as
// a shipping address is not needed
  if ($order->content_type == 'virtual') {
    if (!tep_session_is_registered('shipping')) tep_session_register('shipping');
    $shipping = false;
    $sendto = false;
    tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
  }

  $total_weight = $cart->show_weight();
  $total_count = $cart->count_contents();

// load all enabled shipping modules
// koshoten.netѤ⥸塼Ȥɤ
  if (KN_CFG_USE_KN_MODULES == 'true') {
    require(DIR_WS_CLASSES . 'kn_shipping.php');
  } else {
    require(DIR_WS_CLASSES . 'shipping.php');
  }
  $shipping_modules = new shipping;

  if ( defined('MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING') && (MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING == 'true') ) {
    switch (MODULE_ORDER_TOTAL_SHIPPING_DESTINATION) {
      case 'national':
        if ($order->delivery['country_id'] == STORE_COUNTRY) $pass = true; break;
      case 'international':
        if ($order->delivery['country_id'] != STORE_COUNTRY) $pass = true; break;
      case 'both':
        $pass = true; break;
      default:
        $pass = false; break;
    }

    $free_shipping = false;
    if ( ($pass == true) && ($order->info['subtotal'] >= MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER) ) {
      $free_shipping = true;

      include(DIR_WS_LANGUAGES . $language . '/modules/order_total/ot_shipping.php');
    }
  } else {
    $free_shipping = false;
  }

// process the selected shipping method
  if ( isset($_POST['action']) && ($_POST['action'] == 'process') ) {
    if (!tep_session_is_registered('comments')) tep_session_register('comments');
    if (tep_not_null($_POST['comments_added'])) {
      $comments = tep_db_prepare_input($_POST['comments']);
    }

    if (!tep_session_is_registered('shipping')) tep_session_register('shipping');

    if ( (tep_count_modules(KN_CFG_MODULE_SHIPPING_INSTALLED) > 0) || ($free_shipping == true) ) {
      if ( (isset($_POST['shipping'])) && (strpos($_POST['shipping'], '_')) ) {
        $shipping = $_POST['shipping'];

        list($module, $method) = explode('_', $shipping);
        if ( is_object($$module) || ($shipping == 'free_free') ) {
          if ($shipping == 'free_free') {
            $quote[0]['methods'][0]['title'] = FREE_SHIPPING_TITLE;
            $quote[0]['methods'][0]['cost'] = '0';
          } else {
            $quote = $shipping_modules->quote($method, $module);
          }
          if (isset($quote['error'])) {
            tep_session_unregister('shipping');
          } else {
            if ( (isset($quote[0]['methods'][0]['title'])) && (isset($quote[0]['methods'][0]['cost'])) ) {
              $shipping = array('id' => $shipping,
                                'title' => (($free_shipping == true) ?  $quote[0]['methods'][0]['title'] : $quote[0]['module'] . ' (' . $quote[0]['methods'][0]['title'] . ')'),
                                'cost' => $quote[0]['methods'][0]['cost'],
                                'timespec' => $quote[0]['methods'][0]['timespec']  // add for Japanese update
                          );

              tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
            }
          }
        } else {
          tep_session_unregister('shipping');
        }
      }
    } else {
      $shipping = false;
                
      tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
    }    
  }

// get all available shipping quotes
  $quotes = $shipping_modules->quote();

// if no shipping method has been selected, automatically select the cheapest method.
// if the modules status was changed when none were available, to save on implementing
// a javascript force-selection method, also automatically select the cheapest shipping
// method if more than one module is now enabled
  if ( !tep_session_is_registered('shipping') || ( tep_session_is_registered('shipping') && ($shipping == false) && (tep_count_modules(KN_CFG_MODULE_SHIPPING_INSTALLED) > 1) ) ) $shipping = $shipping_modules->cheapest();

  require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_CHECKOUT_SHIPPING);

  $breadcrumb->add(NAVBAR_TITLE_1, tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
  $breadcrumb->add(NAVBAR_TITLE_2, tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>" /> 
<meta http-equiv="content-style-type" content="text/css" />
<title><?php echo TITLE; ?></title>
<base href="<?php echo (($request_type == 'SSL') ? HTTPS_SERVER : HTTP_SERVER) . DIR_WS_CATALOG; ?>" />
<link rel="stylesheet" type="text/css" href="general.css" media="screen,print" />
<?php 
  $customCSS = substr(FILENAME_CHECKOUT_SHIPPING, 0, strrpos(FILENAME_CHECKOUT_SHIPPING, '.')). ".css";
  if (file_exists($customCSS)){
    echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"$customCSS\" media=\"screen,print\" />";
  }
?>
<script language="javascript"><!--
var selected;

function selectRowEffect(object, buttonSelect) {
  if (!selected) {
    if (document.getElementById) {
      selected = document.getElementById('defaultSelected');
    } else {
      selected = document.all['defaultSelected'];
    }
  }

  if (selected) selected.className = 'checkoutModuleRow';
  object.className = 'checkoutModuleRowSelected';
  selected = object;

// one button is not an array
  if (document.checkout_shipping.shipping[0]) {
    document.checkout_shipping.shipping[buttonSelect].checked=true;
  } else {
    document.checkout_shipping.shipping.checked=true;
  }
}

function rowOverEffect(object) {
  if (object.className == 'checkoutModuleRow') object.className = 'checkoutModuleRowOver';
}

function rowOutEffect(object) {
  if (object.className == 'checkoutModuleRowOver') object.className = 'checkoutModuleRow';
}
//--></script>
</head>
<body>
<div id="container">
<!-- header -->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- /header -->
<hr />
<!-- contents -->
<div id="contents">
<!-- left_contents -->
<?php require(DIR_WS_INCLUDES . 'column_left.php'); ?>
<!-- /left_contents -->
<hr />
<!-- right_contents -->
<?php require(DIR_WS_INCLUDES . 'column_right.php'); ?>
<!-- /right_contents -->
<hr />
<!-- main_contents -->
<div id="mainContents">
<p class="hide"><a id="skipped" name="skipped" title="<?php echo TEXT_NAVISKIPPED; ?>"><?php echo TEXT_NAVISKIPPED; ?></a></p> 
<h2 class="pageHeading"><?php echo HEADING_TITLE; ?></h2>
<?php echo tep_draw_form('checkout_shipping', tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL')) . tep_draw_hidden_field('action', 'process') . "\n"; ?>
<div id="checkout">
<h3><?php echo TABLE_HEADING_SHIPPING_ADDRESS; ?></h3>
<p><?php echo TEXT_CHOOSE_SHIPPING_DESTINATION; ?></p>
<p class="addressLabel"><?php echo tep_address_label($customer_id, $sendto, true, ' ', '<br />'); ?></p>
<p class="changeAddress"><?php echo '<a href="' . tep_href_link(FILENAME_CHECKOUT_SHIPPING_ADDRESS, '', 'SSL') . '">' . tep_image_button('button_change_address.gif', IMAGE_BUTTON_CHANGE_ADDRESS) . '</a>'; ?></p>
<?php
  if (tep_count_modules(KN_CFG_MODULE_SHIPPING_INSTALLED) > 0) {
?>
<h3><?php echo TABLE_HEADING_SHIPPING_METHOD; ?></h3>
<?php
    if (sizeof($quotes) > 1) {
      echo '<p>' . TEXT_CHOOSE_SHIPPING_METHOD . "</p>\n";
    } elseif ($free_shipping == false) {
      echo '<p>' .  TEXT_ENTER_SHIPPING_INFORMATION . "</p>\n";
    }

    if ($free_shipping == true) {
?>
<table class="moduleTable">
<tr>
<td><?php echo FREE_SHIPPING_TITLE; ?></td>
</tr>
<tr id="defaultSelected" class="checkoutModuleRowSelected" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="selectRowEffect(this, 0)">
<td><?php echo sprintf(FREE_SHIPPING_DESCRIPTION, $currencies->format(MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER)) . tep_draw_hidden_field('shipping', 'free_free'); ?></td>
</tr>
</table>
<?php
    } else {
?>
<table class="moduleTable">
<?php
      $radio_buttons = 0;
      for ($i=0, $n=sizeof($quotes); $i<$n; $i++) {
?>
<tr class="checkoutModuleRowFields">
<th class="title" colspan="3"><?php echo $quotes[$i]['module']; ?>&nbsp;<?php echo $quotes[$i]['icon']; ?></th>
</tr>
<?php
        if (isset($quotes[$i]['error'])) {
?>
<tr class="checkoutModuleRowFields">
<td class="error" colspan="3"><?php echo $quotes[$i]['error']; ?></td>
</tr>
<?php
        } else {
          for ($j=0, $n2=sizeof($quotes[$i]['methods']); $j<$n2; $j++) {
// set the radio button to be checked if it is the method chosen
            $checked = (($quotes[$i]['id'] . '_' . $quotes[$i]['methods'][$j]['id'] == $shipping['id']) ? true : false);

            if ( ($quotes[$i]['id'] . '_' . $quotes[$i]['methods'][$j]['id'] == $shipping['id']) || (tep_count_modules(KN_CFG_MODULE_SHIPPING_INSTALLED) == (int)1) ) {
              echo '<tr id="defaultSelected" class="checkoutModuleRowSelected" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="selectRowEffect(this, ' . $radio_buttons . ')">' . "\n";
            } else {
              echo '<tr class="checkoutModuleRow" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="selectRowEffect(this, ' . $radio_buttons . ')">' . "\n";
            }

            if ( ($n > 1) || ($n2 > 1) ) {
              echo '<td class="select">' . tep_draw_radio_field('shipping', $quotes[$i]['id'] . '_' . $quotes[$i]['methods'][$j]['id'], $checked) . "</td>\n";
              echo '<td class="method">' . $quotes[$i]['methods'][$j]['title'].'&nbsp;&nbsp;'.$quotes[$i]['methods'][$j]['option'] . "</td>\n";
              echo '<td class="cost">' . $currencies->format(tep_add_tax($quotes[$i]['methods'][$j]['cost'], $quotes[$i]['tax'])) . "</td>\n";
            } else {
              echo '<td class="select">&nbsp;' . "</td>\n";
              echo '<td class="method">' . $quotes[$i]['methods'][$j]['title'].'&nbsp;&nbsp;'.$quotes[$i]['methods'][$j]['option'] . "</td>\n";
              echo '<td class="cost">' . $currencies->format(tep_add_tax($quotes[$i]['methods'][$j]['cost'], $quotes[$i]['tax'])) . tep_draw_hidden_field('shipping', $quotes[$i]['id'] . '_' . $quotes[$i]['methods'][$j]['id']) . "</td>\n";
            }
            echo "</tr>\n";

            $radio_buttons++;
          }
        }
      }
    }
?>
</table>
<?php
  }
?>
<h3><?php echo TABLE_HEADING_COMMENTS; ?></h3>
<p><?php echo tep_draw_textarea_field('comments', 'soft', '60', '5') . tep_draw_hidden_field('comments_added', 'YES'); ?></p>
<div class="buttonLine">
<p class="checkoutTitle"><?php echo TITLE_CONTINUE_CHECKOUT_PROCEDURE; ?></p>
<p class="checkoutText"><?php echo TEXT_CONTINUE_CHECKOUT_PROCEDURE; ?></p>
<p class="buttonRight"><?php echo tep_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE); ?></p>
</div>
<ul id="checkoutBar">
<li class="current">
<?php echo tep_image(DIR_WS_IMAGES . 'checkout_bullet.gif'); ?>
<p><?php echo CHECKOUT_BAR_DELIVERY; ?></p>
</li>
<li class="to"><p><?php echo CHECKOUT_BAR_PAYMENT; ?></p></li>
<li class="to"><p><?php echo CHECKOUT_BAR_CONFIRMATION; ?></p></li>
<li class="to"><p><?php echo CHECKOUT_BAR_FINISHED; ?></p></li>
</ul>
<?php
  $shop_info_query = tep_db_query("select shop_info_title, shop_info_value, allow_tags from " . TABLE_SHOP_INFO . " where shop_info_key = 'SHOP_INFO_SHIPPING'");
  $shop_info = tep_db_fetch_array($shop_info_query);
  if (isset($shop_info['shop_info_value']) && tep_not_null($shop_info['shop_info_value'])) {
    echo '<h3>' . HEADING_ORDER_NOTES . "</h3>\n";
    echo '<p>';
    if ($shop_info['allow_tags']) {
      echo $shop_info['shop_info_value'];
    } else {
      echo nl2br(htmlspecialchars($shop_info['shop_info_value']));
    }
    echo "</p>\n";
  }
 ?>
</div>
</form>
</div>
<!-- /main_contents -->
</div>
<!-- /contents -->
<hr />
<!-- footer -->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- /footer -->
</div>
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
