<?php
/*
  $Id: account_history.php,v 1.8 2009/04/14 23:51:23 ryu Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  
  modified for Koshoten.net2
  http://www.koshoten.net/
*/

  require('includes/application_top.php');

  if (defined("KN_CFG_ALLOW_CHECKOUT") && (KN_CFG_ALLOW_CHECKOUT == "false")) {
    tep_redirect(tep_href_link(FILENAME_DEFAULT));
  }

  if (!tep_session_is_registered('customer_id')) {
    $navigation->set_snapshot();
    tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
  }

  require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_ACCOUNT_HISTORY);

  $breadcrumb->add(NAVBAR_TITLE_1, tep_href_link(FILENAME_ACCOUNT, '', 'SSL'));
  $breadcrumb->add(NAVBAR_TITLE_2, tep_href_link(FILENAME_ACCOUNT_HISTORY, '', 'SSL'));
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>" /> 
<meta http-equiv="content-style-type" content="text/css" />
<title><?php echo TITLE; ?></title>
<base href="<?php echo (($request_type == 'SSL') ? HTTPS_SERVER : HTTP_SERVER) . DIR_WS_CATALOG; ?>" />
<link rel="stylesheet" type="text/css" href="general.css" media="screen,print" />
<?php 
  $customCSS = substr(FILENAME_ACCOUNT_HISTORY, 0, strrpos(FILENAME_ACCOUNT_HISTORY, '.')). ".css";
  if (file_exists($customCSS)){
    echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"$customCSS\" media=\"screen,print\" />";
  }
?>
</head>
<body>
<div id="container">
<!-- header -->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- /header -->
<hr />
<!-- contents -->
<div id="contents">
<!-- left_contents -->
<?php require(DIR_WS_INCLUDES . 'column_left.php'); ?>
<!-- /left_contents -->
<hr />
<!-- right_contents -->
<?php require(DIR_WS_INCLUDES . 'column_right.php'); ?>
<!-- /right_contents -->
<hr />
<!-- main_contents -->
<div id="mainContents">
<p class="hide"><a id="skipped" name="skipped" title="<?php echo TEXT_NAVISKIPPED; ?>"><?php echo TEXT_NAVISKIPPED; ?></a></p> 
<h2 class="pageHeading"><?php echo HEADING_TITLE; ?></h2>
<div id="accountHistory">
<?php
  $history_query_raw = "select o.orders_id, o.date_purchased, o.delivery_name, ot.text as order_total, s.orders_status_name from " . TABLE_ORDERS . " o left join " . TABLE_ORDERS_TOTAL . " ot on (o.orders_id = ot.orders_id) left join " . TABLE_ORDERS_STATUS . " s on (o.orders_status = s.orders_status_id and s.language_id = '" . (int)$languages_id . "') where o.customers_id = '" . (int)$customer_id . "' and ot.class = 'ot_total' order by orders_id DESC";
  $history_split = new splitPageResults($_GET['page'], MAX_DISPLAY_ORDER_HISTORY, $history_query_raw, $history_numrows);
  $history_query = tep_db_query($history_query_raw);

  if (tep_db_num_rows($history_query)) {
    while ($history = tep_db_fetch_array($history_query)) {
      $products_query = tep_db_query("select count(*) as count from " . TABLE_ORDERS_PRODUCTS . " where orders_id = '" . $history['orders_id'] . "'");
      $products = tep_db_fetch_array($products_query);

      $contentbox_header = '<div class="contentBoxHeader">' . "\n";
      $contentbox_header .= '<p class="leftBox">' . TEXT_ORDER_NUMBER . ' ' . $history['orders_id'] . '</p>' . "\n";
      if (KN_CFG_USE_ORDER_HISTORY == 'true') {
        $contentbox_header .= '<p class="rightBox">' . TEXT_ORDER_STATUS . ' ' . $history['orders_status_name'] . '</p>' . "\n";
      }
      $contentbox_header .= '</div>' . "\n";
      echo $contentbox_header;

      $orders_list = '<table border="0" class="contentBoxContent">' . "\n" .
                        '<tr>' . "\n" .
                        '<th>' . TEXT_ORDER_DATE . '</th>' . "\n" . 
                        '<td>' . tep_date_long($history['date_purchased']) . '</td>' . "\n" . 
                        '<th>' . TEXT_ORDER_PRODUCTS . '</th>' . "\n" . 
                        '<td>' . $products['count'] . '</td>' . "\n" .
                        '<td rowspan="2"><a href="' . tep_href_link(FILENAME_ACCOUNT_HISTORY_INFO, 'page=' . $_GET['page'] . '&order_id=' . $history['orders_id'], 'SSL') . '">' . TEXT_VIEW_ORDER . '</a></td>' . "\n" .
                        '</tr>' . "\n" .
                        '<tr>' . "\n" .
                        '<th>' . TEXT_ORDER_SHIPPED_TO . '</th>' . "\n" . 
                        '<td>' . tep_output_string_protected($history['delivery_name']) . '</td>' . "\n" . 
                        '<th>' . TEXT_ORDER_COST . '</th>' . "\n" . 
                        '<td>' . strip_tags($history['order_total']) . '</td>' . "\n" .
                        '</tr>' . "\n" .
                        '</table>' . "\n";
      echo $orders_list;
    }
    echo '<div class="listLink">' . "\n";
    echo '<p class="listCount">' . $history_split->display_count($history_numrows, MAX_DISPLAY_ORDER_HISTORY, $_GET['page'], TEXT_DISPLAY_NUMBER_OF_ORDERS) . "</p>\n";
    echo '<p class="listPrevNext">' . TEXT_RESULT_PAGE;
    echo $history_split->display_links($history_numrows, MAX_DISPLAY_ORDER_HISTORY, MAX_DISPLAY_PAGE_LINKS, $_GET['page'], tep_get_all_get_params(array('page', 'info', 'x', 'y')));
    echo "</p>\n";
    echo "</div>\n";
  } else {
    echo '<p class="noData">' . TEXT_NO_PURCHASES . "</p>\n";
  }
?>
<div class="buttonLine">
<p class="buttonLeft"><?php echo '<a href="' . tep_href_link(FILENAME_ACCOUNT, '', 'SSL') . '">' . tep_image_button('button_back.gif', IMAGE_BUTTON_BACK) . '</a>'; ?></p>
</div>
</div>
</div>
<!-- /main_contents -->
</div>
<!-- /contents -->
<hr />
<!-- footer -->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- /footer -->
</div>
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
