var fs = require('fs');
var ipp = require('ipp');

fs.readFile('Test.pdf', function(err, pdf) {
	if (err) {
		throw err;
	}

	var printer = ipp.Printer('http://raspberrypi.local:631/printers/EPSON_EP-802A');
	var msg = {
		'operation-attributes-tag': {
			'requesting-user-name': 'anonymous',
			'job-name': 'test',
			'document-format': 'application/pdf'
		},
		data: new Buffer(pdf, 'binary')
	};
	printer.execute('Print-Job', msg, function(err, res) {
		console.log(res);
	});
});

