<?php
/**
 * Validator.
 * @package magic.core
 * @subpackage tool.validate
 */
/**
 * 簡易バリデータクラスです.
 * @package magic.core
 * @subpackage tool.validate
 * @author T.Okumura
 * @version 1.0.0
 * @final
 */
final class Validator {
    /**
     * コンストラクタ.
     */
    private function __construct() {
    }
    /**
     * 文字列が空かどうかをチェックします.
     * <p>
     * このファンクションは、先頭と終端をtrimしてチェックします。<br/>
     * つまり、半角スペース一つはFALSEです。
     * </p>
     * @param string $value チェックする文字列
     * @return bool 空文字でないと判断した場合はTRUE
     * @static
     */
    public static function required($value) {
        return strlen(trim($value)) > 0;
    }
    /**
     * メールアドレスかどうかをチェックします.
     * <p>
     * このファンクションは、簡易的なチェックを提供します。<br/>
     * 厳密にチェックする必要があるなら、アプリケーション側で提供してください。
     * </p>
     * @param string $value チェックする文字列
     * @return bool メールアドレスと判断した場合はTRUE
     * @static
     */
    public static function isMailAddress($value) {
        return preg_match('/^[*+!.&#$|\'\\%\/0-9a-z^_`{}=?~:-]+@([0-9a-z-]+\.)+[0-9a-z]{2,}$/i', $value);
    }
    /**
     * 文字列が半角英数字のみで構成されているかどうかをチェックします.
     * @param string $value チェックする文字列
     * @return bool 半角英数字のみで構成されている場合はTRUE
     * @static
     */
    public static function isAlphanumeric($value) {
        return preg_match('/^[a-zA-Z0-9]+$/', $value);
    }
    /**
     * 16進の色指定文字列として有効かどうかをチェックします.
     * <p>
     * 先頭の#記号は、あってもなくても構いません。<br/>
     * 000000～FFFFFFの範囲を有効と判断します。
     * </p>
     * @param string $value チェックする文字列
     * @return bool 000000～FFFFFFの範囲ならTRUE
     */
    public static function isHexColor($value) {
        return preg_match('/^#?[a-fA-F0-9]{6}$/', $value);
    }
}
// EOF.