<?php
/**
 * MagicException.
 * @package magic.core
 * @subpackage internal.exception
 */
/**
 * フレームワークの実行時エラーです.
 * <p>
 * このエラーがスローされた場合は、フォルダ構成やファイルの有無、
 * 各種設定を見直してください。
 * </p>
 * @package magic.core
 * @subpackage internal.exception
 * @author T.Okumura
 * @version 1.0.0
 * @final
 */
final class MagicException extends Exception {
    /**
     * コンストラクタ.
     * @param string $message エラーメッセージ
     */
    public function __construct($message) {
        parent::__construct($message);
    }
    /**
     * エラー内容を表示します.
     * @return string エラー内容
     */
    public function message() {
        $message = '<strong>system error</strong>';
        $message .= '<p>' . $this->message . '</p>';
        return $message;
    }
}
// EOF.