<?php
/**
 * LocaleProvider.
 * @package magic.core
 * @subpackage helper.message
 */
/**
 * ローカライゼーションを提供するクラスです.
 * <p>
 * メッセージのローカライゼーションを提供します。<br/>
 * ロケールを固定化する事もできます。
 * </p>
 * @package magic.core
 * @subpackage helper.message
 * @author T.Okumura
 * @version 1.0.0
 * @final
 */
final class LocaleProvider {
    /**
     * 現在のロケール.
     * @staticvar string
     */
    private static $_locale = NULL;
    /**
     * コンストラクタ.
     */
    private function __construct() {
    }
    /**
     * デフォルトのロケールを指定します.
     * <p>
     * ここでロケールを指定しておくと、ブラウザのロケールに左右されず、
     * 常に同じロケールが返されます。
     * </p>
     * @param string $locale ロケール(jp、enなど)
     * @static
     */
    public static function setDefaultLocale($locale) {
        self::$_locale = $locale;
    }
    /**
     * 現在のロケールを取得します.
     * <p>
     * デフォルトのロケールを設定した場合にはその値、
     * そうでなければブラウザから取得したロケールを返します。<br/>
     * アプリケーション側でページの言語を出し分けたい場合などで使用する事ができます。
     * </p>
     * @return string ロケール(jp、enなど)
     * @static
     */
    public static function getLocale() {
        if (is_null(self::$_locale)) {
            if (!self::$_locale = substr(ServerUtil::get('HTTP_ACCEPT_LANGUAGE'), 0, 2)) {
                self::$_locale = '';
            }
        }
        return self::$_locale;
    }
}
// EOF.