<?php
/**
 * ActionError.
 * @package magic.core
 * @subpackage helper.action
 */
/**
 * Actionクラスで発生したエラーを保持するクラスです.
 * <p>
 * このクラスは自動的に利用できます。
 * このクラスはフレームワークによってViewクラスに引き継がれ、
 * errorという名前のキーで自動的にレスポンスに設定され、extractされます。<br/>
 * HTMLファイル側で＜?=$error＞とする事で、この内容が表示されます。
 * </p>
 * @package magic.core
 * @subpackage helper.action
 * @author T.Okumura
 * @version 1.0.0
 * @final
 */
final class ActionError {
    /**
     * エラーメッセージを保持します.
     * @var string
     */
    private $_error = NULL;
    /**
     * コンストラクタ.
     */
    public function __construct() {
    }
    /**
     * エラーメッセージを追加します.
     * <p>
     * これは単純に＜br/＞で結合される事に注意してください。<br/>
     * もっと複雑な処理をしたければ、専用のクラスを作成して
     * アプリケーション側で実装してください。
     * </p>
     * @param string $error エラーメッセージ
     */
    public function add($error) {
        $this->_error .= is_null($this->_error) ? $error : '<br />' . $error;
    }
    /**
     * エラーメッセージを取得します.
     * @return string エラーメッセージ
     */
    public function get() {
        return $this->_error;
    }
}
// EOF.