<?php
/**
 * DataSourceConfigure.
 * @package magic.core
 * @subpackage config
 */
/**
 * データソースの設定用インターフェイスです.
 * <p>
 * データベースの接続には、PDOが使用されます。<br/>
 * アプリケーションでデータベースを使用する場合は、
 * 適切な実装クラスを作成してください。
 * </p>
 * @package magic.core
 * @subpackage config
 * @author T.Okumura
 * @version 1.0.0
 */
interface DataSourceConfigure {
    /**
     * DSNを取得します.
     * @return string DSN
     */
    function getDsn();
    /**
     * 接続ユーザー名を取得します.
     * @return string 接続ユーザー名
     */
    function getUserName();
    /**
     * 接続パスワードを取得します.
     * @return string 接続パスワード
     */
    function getPassword();
    /**
     * 接続のオプションを取得します.
     * @return array 接続オプション
     */
    function getOptions();
}
// EOF.