<?php
final class IndexView extends View {
    /**
     * (non-PHPdoc)
     * @see View::preRender()
     */
    protected function preRender() {
        $contents = file_get_contents(WEB . 'pc' . DIRECTORY_SEPARATOR . 'tpl' . DIRECTORY_SEPARATOR . 'tournament.tpl');
        $part = file_get_contents(
                WEB . 'pc' . DIRECTORY_SEPARATOR . 'tpl' . DIRECTORY_SEPARATOR . 'tournament_part.tpl');
        $tpl = '';
        foreach (array_chunk($this->response->get('tournaments'), 4) as $value) {
            $buff = '';
            foreach ($value as &$row) {
                if (empty($row['main_image'])) {
                    $row['main_image'] = 'no_image.jpg';
                }
                $buff .= GenerateUtil::staticCreate($part, $row);
            }
            $tpl .= GenerateUtil::staticCreate($contents, array('part' => $buff));
        }
        $this->response->set('tournament_tpl', $tpl);
        $contents = file_get_contents(WEB . 'pc' . DIRECTORY_SEPARATOR . 'tpl' . DIRECTORY_SEPARATOR . 'winner.tpl');
        $part = file_get_contents(WEB . 'pc' . DIRECTORY_SEPARATOR . 'tpl' . DIRECTORY_SEPARATOR . 'winner_part.tpl');
        $tpl = '';
        foreach (array_chunk($this->response->get('winner'), 4) as $value) {
            $buff = '';
            foreach ($value as &$row) {
                $buff .= GenerateUtil::staticCreate($part, $row);
            }
            $tpl .= GenerateUtil::staticCreate($contents, array('part' => $buff));
        }
        $this->response->set('winner_tpl', $tpl);
        $contents = file_get_contents(WEB . 'pc' . DIRECTORY_SEPARATOR . 'tpl' . DIRECTORY_SEPARATOR . 'entries.tpl');
        $part = file_get_contents(WEB . 'pc' . DIRECTORY_SEPARATOR . 'tpl' . DIRECTORY_SEPARATOR . 'entries_part.tpl');
        $tpl = '';
        foreach (array_chunk($this->response->get('entries'), 4) as $value) {
            $buff = '';
            foreach ($value as &$row) {
                if (empty($row['main_image'])) {
                    $row['main_image'] = 'no_image.jpg';
                }
                $row['rest'] = $row['entry_num'] - $row['entry_no'];
                $buff .= GenerateUtil::staticCreate($part, $row);
            }
            $tpl .= GenerateUtil::staticCreate($contents, array('part' => $buff));
        }
        $this->response->set('entries_tpl', $tpl);
    }
}
// EOF.
