<?php
final class MailUtil {
    private function __construct() {
    }
    public static function getSmtp() {
        $smtp = new SmtpMailer();
        $smtp->setHeloHost(self::getMailDomain());
        $smtp
                ->setSmtpParameters(MailConfig::SMTP_HOST, MailConfig::SMTP_PORT, MailConfig::SMTP_USER,
                        MailConfig::SMTP_PASS);
        $smtp->setPopParameters(MailConfig::POP_HOST, MailConfig::POP_PORT, MailConfig::POP_USER, MailConfig::POP_PASS);
        return $smtp;
    }
    public static function getTextFooter() {
        $footer = '◆◇◆◇◆◇◆◇◆◇' . "\r\n";
        $footer .= self::getFromName() . "\r\n";
        $footer .= self::getHttpDomain() . "\r\n";
        $footer .= '◆◇◆◇◆◇◆◇◆◇' . "\r\n";
        return $footer;
    }
    public static function getHtmlFooter() {
        $footer = '◆◇◆◇◆◇◆◇◆◇<br />';
        $footer .= self::getFromName() . '<br />';
        $footer .= self::getHttpDomain() . '<br />';
        $footer .= '◆◇◆◇◆◇◆◇◆◇<br />';
        return $footer;
    }
    public static function getHttpDomain() {
        // return 'http://tournament.jp/';
        return 'http://localhost/';
    }
    public static function getMailDomain() {
        return 'tournament.jp';
    }
    public static function getFromAddress() {
        return 'support@' . self::getMailDomain();
    }
    public static function getFromName() {
        return '何でも甲子園事務局';
    }
}
// EOF.