<?php
final class WinnerDao extends Dao {
    public function __construct() {
    }
    public function selectEntry($uno, $tno, $eno) {
        $stmt = " select entry_image, nickname, comment";
        $stmt .= "   from tr_entry";
        $stmt .= "  where user_no = ?";
        $stmt .= "    and tournament_no = ?";
        $stmt .= "    and entry_no = ?";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($uno, $tno, $eno));
        return $res->fetch(PDO::FETCH_ASSOC);
    }
    public function replaceWinner($image, $nickname) {
        $stmt = " select win_count";
        $stmt .= "  from tr_winner";
        $stmt .= " where entry_image = ?";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($image));
        $count = $res->fetchColumn();
        $count = $count ? $count + 1 : 1;
        $res->closeCursor();
        $stmt = " replace into tr_winner";
        $stmt .= " values (?, ?, ?)";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($image, $nickname, $count));
    }
}
// EOF.