<?php
final class RegisterDao extends Dao {
    public function __construct() {
    }
    public function checkOneTimeKey($uniqueId) {
        $stmt = " select mail_address";
        $stmt .= "  from tr_pre_register";
        $stmt .= " where unique_id = ?";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($uniqueId));
        return $res->fetchColumn();
    }
    public function checkLimitDateTime($mailAddress) {
        $stmt = " select mail_address";
        $stmt .= "  from tr_pre_register";
        $stmt .= " where mail_address = ?";
        $stmt .= "   and limit_date_time >= now()";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($mailAddress));
        return $res->fetchColumn();
    }
    public function deletePreRegister($mailAddress) {
        $stmt = " delete from tr_pre_register";
        $stmt .= " where mail_address = ?";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($mailAddress));
    }
    public function insertUser($mailAddress, $password, $nickname) {
        $stmt = "  insert into ms_user(mail_address, password, nickname, register_date_time)";
        $stmt .= " values (?, md5(?), ?, now())";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($mailAddress, $password, $nickname));
    }
}
// EOF.