<?php
final class KanriDao extends AppDao {
    public function __construct() {
    }
    public function selectTournament() {
        $stmt = " select user_no,";
        $stmt .= "       tournament_no,";
        $stmt .= "       tournament_name,";
        $stmt .= "       main_image,";
        $stmt .= "       entry_num,";
        $stmt .= "       apply_flag";
        $stmt .= "  from ms_tournament";
        $stmt .= " order by apply_flag, apply_date_time desc";
        $res = $this->pdo->prepare($stmt);
        $res->execute();
        return $res->fetchAll(PDO::FETCH_ASSOC);
    }
    public function deleteTournament($userNo, $tournamentNo) {
        $stmt = " delete from ms_tournament";
        $stmt .= " where user_no = ?";
        $stmt .= "   and tournament_no = ?";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($userNo, $tournamentNo));
        if ($count = $res->rowCount()) {
            $res->closeCursor();
            $stmt = " delete from tr_entry";
            $stmt .= " where user_no = ?";
            $stmt .= "   and tournament_no = ?";
            $res = $this->pdo->prepare($stmt);
            $res->execute(array($userNo, $tournamentNo));
            $res->closeCursor();
            $stmt = " delete from tr_start";
            $stmt .= " where user_no = ?";
            $stmt .= "   and tournament_no = ?";
            $res = $this->pdo->prepare($stmt);
            $res->execute(array($userNo, $tournamentNo));
        }
        return $count;
    }
    public function updateTournament($userNo, $tournamentNo) {
        $stmt = " update ms_tournament";
        $stmt .= "   set apply_flag = 1,";
        $stmt .= "       apply_date_time = now()";
        $stmt .= " where user_no = ?";
        $stmt .= "   and tournament_no = ?";
        $stmt .= "   and apply_flag = 0";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($userNo, $tournamentNo));
        return $res->rowCount();
    }
    public function selectImage($userNo, $tournamentNo) {
        $stmt = " select main_image";
        $stmt .= "  from ms_tournament";
        $stmt .= " where user_no = ?";
        $stmt .= "   and tournament_no = ?";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($userNo, $tournamentNo));
        return $res->fetchColumn();
    }
}
// EOF.