<?php
final class EntryListDao extends AppDao {
    public function __construct() {
    }
    public function selectEntries($uno, $tno) {
        $stmt = " select entry_no,";
        $stmt .= "       nickname,";
        $stmt .= "       entry_image,";
        $stmt .= "       comment";
        $stmt .= "  from tr_entry";
        $stmt .= " where user_no = ?";
        $stmt .= "   and tournament_no = ?";
        $stmt .= " order by entry_no";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($uno, $tno));
        return $res->fetchAll(PDO::FETCH_ASSOC);
    }
    public function selectTournament($uno, $tno) {
        $stmt = " select case start_flag when 1 then '開催中' else '受付中' end as status";
        $stmt .= "  from ms_tournament";
        $stmt .= " where user_no = ?";
        $stmt .= "   and tournament_no = ?";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($uno, $tno));
        return $res->fetchColumn();
    }
}
// EOF.