<?php
final class EntryDao extends Dao {
    public function __construct() {
    }
    public function selectEntry($uno, $tno) {
        $stmt = " select ifnull(max(entry_no) + 1, 1)";
        $stmt .= "  from tr_entry";
        $stmt .= " where user_no = ?";
        $stmt .= "   and tournament_no = ?";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($uno, $tno));
        return $res->fetchColumn();
    }
    public function insertEntry($uno, $tno, $entryNo, $nickname, $entryImage, $original, $comment) {
        $stmt = "  insert into tr_entry";
        $stmt .= " values (?, ?, ?, ?, ?, ?, ?)";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($uno, $tno, $entryNo, $nickname, $entryImage, $original, $comment));
    }
    public function selectTournament($uno, $tno) {
        $stmt = " select entry_num";
        $stmt .= "  from ms_tournament";
        $stmt .= " where user_no = ?";
        $stmt .= "   and tournament_no = ?";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($uno, $tno));
        return $res->fetchColumn();
    }
    public function updateTournament($uno, $tno) {
        $stmt = " update ms_tournament";
        $stmt .= "   set start_flag = 1,";
        $stmt .= "       start_date_time = now()";
        $stmt .= " where user_no = ?";
        $stmt .= "   and tournament_no = ?";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($uno, $tno));
        return $res->rowCount();
    }
}
// EOF.