<?php
final class MobilePathConfigure implements PathConfigure {
    public function __construct() {
    }
    /**
     * (non-PHPdoc)
     * @see PathConfigure::getActionSuffix()
     */
    public function getActionSuffix() {
        return 'Action';
    }
    /**
     * (non-PHPdoc)
     * @see PathConfigure::getActionPath()
     */
    public function getActionPath() {
        return APP . 'action' . DIRECTORY_SEPARATOR . 'mobile' . DIRECTORY_SEPARATOR;
    }
    /**
     * (non-PHPdoc)
     * @see PathConfigure::getDaoSuffix()
     */
    public function getDaoSuffix() {
        return 'Dao';
    }
    /**
     * (non-PHPdoc)
     * @see PathConfigure::getDaoPath()
     */
    public function getDaoPath() {
        return APP . 'dao' . DIRECTORY_SEPARATOR . 'mobile' . DIRECTORY_SEPARATOR;
    }
    /**
     * (non-PHPdoc)
     * @see PathConfigure::getDtoSuffix()
     */
    public function getDtoSuffix() {
        return 'Dto';
    }
    /**
     * (non-PHPdoc)
     * @see PathConfigure::getDtoPath()
     */
    public function getDtoPath() {
        return APP . 'dto' . DIRECTORY_SEPARATOR . 'mobile' . DIRECTORY_SEPARATOR;
    }
    /**
     * (non-PHPdoc)
     * @see PathConfigure::getViewSuffix()
     */
    public function getViewSuffix() {
        return 'View';
    }
    /**
     * (non-PHPdoc)
     * @see PathConfigure::getViewPath()
     */
    public function getViewPath() {
        return APP . 'view' . DIRECTORY_SEPARATOR . 'mobile' . DIRECTORY_SEPARATOR;
    }
    /**
     * (non-PHPdoc)
     * @see PathConfigure::getHtmlSuffix()
     */
    public function getHtmlSuffix() {
        return 'html';
    }
    /**
     * (non-PHPdoc)
     * @see PathConfigure::getHtmlPath()
     */
    public function getHtmlPath() {
        return WEB . 'mobile' . DIRECTORY_SEPARATOR . 'html' . DIRECTORY_SEPARATOR;
    }
    /**
     * (non-PHPdoc)
     * @see PathConfigure::getDefaultMessageFileName()
     */
    public function getDefaultMessageFileName() {
        return 'Message';
    }
    /**
     * (non-PHPdoc)
     * @see PathConfigure::getMessagePath()
     */
    public function getMessagePath() {
        return APP . 'message' . DIRECTORY_SEPARATOR;
    }
}
// EOF.