<?php
class AppAction extends Action {
    public function __construct() {
    }
    /**
     * (non-PHPdoc)
     * @see Action::intializeAction()
     */
    protected function intializeAction() {
        if ($sessionId = $this->request->get('koshien')) {
            $this->session->setSessionId($sessionId);
        }
        $this->session->start();
        $this->response->noCache();
    }
    /**
     * (non-PHPdoc)
     * @see Action::intializeMethod()
     */
    protected final function intializeMethod() {
        if (!($uniqueId = $this->flash->get('uid')) || !($userNo = $this->flash->get('uno'))) {
            return new Redirect('errors/show/access');
        }
        if (!$userNo = $this->dao->checkUser($userNo, $uniqueId)) {
            return new Redirect('errors/show/access');
        }
        $this->flash->set('uno', $userNo);
        $this->flash->set('uid', $uniqueId);
        $this->dto->setUserNo($userNo);
        return NULL;
    }
}
// EOF.