<?php
final class RegisterAction extends Action {
    /**
     * @var RegisterDao
     */
    protected $dao = NULL;
    /**
     * @var RegisterDto
     */
    protected $dto = NULL;
    /**
     * @return RegisterDto
     */
    public function getDto() {
        return $this->dto;
    }
    public function __construct() {
    }
    public function index() {
        if (!$mailAddress = $this->dao->checkOneTimeKey($this->dto->getUid())) {
            return new Redirect('errors/show/access');
        }
        if (!$this->dao->checkLimitDateTime($mailAddress)) {
            $this->dao->deletePreRegister($mailAddress);
            return new Redirect('errors/show/limit');
        }
        return new Forward();
    }
    public function apply() {
        if (!$mailAddress = $this->dao->checkOneTimeKey($this->dto->getUid())) {
            return new Redirect('errors/show/access');
        }
        if (!$this->_isVvalid()) {
            return new Forward();
        }
        $this->dao->insertUser($mailAddress, $this->dto->getPassword(), $this->dto->getNickname());
        $this->dao->deletePreRegister($mailAddress);
        return new Redirect('complete/show/register');
    }
    private function _isVvalid() {
        $valid = TRUE;
        if (!Validator::required($this->dto->getNickname())) {
            $this->error->add(MessageBehavior::getMessage('ERR004', 'NICKNAME'));
            $valid = FALSE;
        }
        if (!Validator::required($this->dto->getPassword())) {
            $this->error->add(MessageBehavior::getMessage('ERR004', 'PASSWORD'));
            $valid = FALSE;
        }
        return $valid;
    }
}
// EOF.