<?php
final class MainAction extends AppAction {
    /**
     * @var MainDao
     */
    protected $dao = NULL;
    /**
     * @var MainDto
     */
    protected $dto = NULL;
    public function __construct() {
    }
    /**
     * @return MainDto
     */
    public function getDto() {
        return $this->dto;
    }
    public function index() {
        $this->dto->setTournaments($this->dao->selectTournament($this->dto->getUserNo()));
        return new SessionForward();
    }
    public function logout() {
        $this->session->clear();
        return new Redirect();
    }
    public function create() {
        if (!Validator::required($this->dto->getTournamentName())) {
            $this->error->add(MessageBehavior::getMessage('ERR004', 'TOURNAMENT_NAME'));
        } else {
            $this->file->setInputName('main_image');
            $dest = '';
            $name = '';
            if ($this->file->getSize() != 0) {
                if (!StringUtil::endWith($this->file->getType(), 'jpeg')) {
                    $this->error->add(MessageBehavior::getMessage('ERR005', array('UPLOAD_FILE', 'JPEG')));
                } elseif ($this->file->getSize() > 512000) {
                    $this->error->add(MessageBehavior::getMessage('ERR005', array('UPLOAD_FILE', 'U_500KB')));
                } else {
                    $path = WEB . 'resource' . DIRECTORY_SEPARATOR;
                    $dest = md5_file($this->file->getTmpName()) . '_' . date('Ymd_His') . '.jpg';
                    move_uploaded_file($this->file->getTmpName(), $path . $dest);
                    $name = $this->file->getName();
                }
            }
            $this->dao
                    ->insertTournament($this->dto->getUserNo(), $this->dto->getTournamentName(), $dest, $name,
                            $this->dto->getEntryNum());
        }
        return $this->index();
    }
    public function modify() {
        $path = WEB . 'resource' . DIRECTORY_SEPARATOR;
        if ($this->dto->getSubmit() == '削除') {
            if ($this->dao->deleteTournament($this->dto->getUserNo(), $this->dto->getTournamentNo()) == 0) {
                $this->error->add(MessageBehavior::getMessage('ERR006', array('MODIFY_TOURNAMENT', 'REASON_MANAGER')));
            } else {
                if ($image = $this->dao->selectImage($this->dto->getUserNo(), $this->dto->getTournamentNo())) {
                    if (file_exists($path . $image)) {
                        unlink($path . $image);
                    }
                }
            }
        } elseif ($this->dto->getSubmit() == '更新') {
            $dest = '';
            $name = '';
            $this->file->setInputName('main_image');
            if ($this->file->getSize() != 0) {
                if (!StringUtil::endWith($this->file->getType(), 'jpeg')) {
                    $this->error->add(MessageBehavior::getMessage('ERR005', array('UPLOAD_FILE', 'JPEG')));
                } elseif ($this->file->getSize() > 512000) {
                    $this->error->add(MessageBehavior::getMessage('ERR005', array('UPLOAD_FILE', 'U_500KB')));
                } else {
                    $dest = md5_file($this->file->getTmpName()) . '_' . date('Ymd_His') . '.jpg';
                    $name = $this->file->getName();
                    if ($this->dao
                            ->updateTournament($dest, $name, $this->dto->getUserNo(), $this->dto->getTournamentNo())
                            == 0) {
                        $this->error
                                ->add(
                                        MessageBehavior::getMessage('ERR006',
                                                array('MODIFY_TOURNAMENT', 'REASON_MANAGER')));
                    } else {
                        if ($image = $this->dao->selectImage($this->dto->getUserNo(), $this->dto->getTournamentNo())) {
                            if (file_exists($path . $image)) {
                                unlink($path . $image);
                            }
                        }
                        move_uploaded_file($this->file->getTmpName(), $path . $dest);
                    }
                }
            }
        }
        return $this->index();
    }
}
// EOF.